/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.tools.OpenFileHandler;
import com.swimap.iview.templates.print.tools.TXTSaveImpl;
import com.swimap.iview.templates.print.tools.TablePDFGenerator;
import com.swimap.iview.templates.print.tools.UnsupportedPDFHeaderException;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;

public class PDFSaveImpl
extends TXTSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(PDFSaveImpl.class, "IVIEW");
    private TablePDFGenerator pdfGenerator;
    private FormatCalculator parentFormatCalculator;

    public PDFSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator.getPdfFormatCalculator());
        this.parentFormatCalculator = formatCalculator;
    }

    @Override
    public String getCurrentFileName() {
        String string = "";
        if (null != this.pdfGenerator) {
            string = this.pdfGenerator.getCurrentSavingFileName();
        }
        return string;
    }

    public void write(String string) {
        try {
            this.pdfGenerator = new TablePDFGenerator(string, this.formatCalculator, this.parentFormatCalculator, this);
        }
        catch (UnsupportedPDFHeaderException unsupportedPDFHeaderException) {
            logger.trace(unsupportedPDFHeaderException);
        }
        this.performPDFWrite();
    }

    public void writePDFDocument(String string) throws UnsupportedPDFHeaderException {
        this.pdfGenerator = new TablePDFGenerator(string, this.formatCalculator, this.parentFormatCalculator, this);
        this.performPDFWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPDFWrite() {
        try {
            this.pdfGenerator.writeTitleInfo();
            this.pdfGenerator.writeExtraInformations();
            if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
                this.pdfGenerator.writeTotalRecords();
            }
            this.pdfGenerator.writeTableHeaders();
            this.pdfGenerator.writeTableDatas();
            if (this.parentFormatCalculator.getTotleRecordsPosition()) {
                this.pdfGenerator.writeTotalRecords();
            }
        }
        finally {
            this.pdfGenerator.save();
        }
    }

    public boolean showOpenFileDialog() {
        String[] stringArray = this.getCsvXlsorPdfFileNames();
        if (Os.getOs() instanceof Windows && stringArray.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            OpenFileHandler.openXlsOrTXTFile(this.parentFrame, stringArray);
            return true;
        }
        return false;
    }

    public void showFileSaveSuccessInfo(String string) {
        String[] stringArray = this.getCsvXlsorPdfFileNames();
        if (null != stringArray && stringArray.length > 0 && this.formatCalculator.isOpenFileEnabled() && (!this.parentFormatCalculator.getDeleteFileFlag() || FrameworkCommandProcessor.getInstance().isLoggingOut())) {
            this.pdfGenerator.showFileSaveSuccessInfo(string, stringArray.length);
        }
    }

    public void showMutiFilesInfo(String string) {
        if (!this.parentFormatCalculator.getDeleteFileFlag() || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            this.pdfGenerator.showMutiFilesInfos(string);
        }
    }

    public String getMultiFileNames() {
        return this.pdfGenerator.getMultiFileNamesInfo();
    }

    public boolean isMultipleFilesSaved() {
        return this.pdfGenerator.isInMultipleFiles();
    }
}

