/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.tools.AppendStartListener;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiTablePrintImpl
extends PrintableTool {
    private static final int GAP = 50;
    private TablePrintImpl[] printImpls = null;
    private int incompletePages = 0;
    private Map incompletePageMap = new HashMap(10);
    private Set printedPageSet = new HashSet(10);
    private boolean[] appendStartEventFired = null;
    private int lastPrintedImpl = 0;

    public MultiTablePrintImpl(TablePrintImpl[] tablePrintImplArray) {
        this.printImpls = tablePrintImplArray;
        this.appendStartEventFired = new boolean[tablePrintImplArray.length];
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 || n > this.getPageCount() - 1) {
            return 1;
        }
        if (this.getHeaderError()) {
            return 1;
        }
        if (n > 0 && !this.printedPageSet.contains(n - 1)) {
            Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
            this.print(graphics2D, pageFormat, n - 1);
            graphics2D.dispose();
        }
        this.printedPageSet.add(n);
        int n2 = 0;
        for (int i = 0; i < this.printImpls.length; ++i) {
            int n3 = n2 + this.printImpls[i].getPageCount();
            int n4 = 0;
            Object v = this.incompletePageMap.get(i);
            if (v instanceof Integer) {
                n4 = (Integer)v;
            }
            if (n3 > n + n4) {
                int n5 = 0;
                this.checkAndFireAppendStart(i);
                this.lastPrintedImpl = i;
                n5 = this.printImpls[i].print(graphics, pageFormat, n - n2 + n4);
                int n6 = this.printImpls[i].getEndY() + 50;
                boolean bl = this.printImpls[i].getPageCount() == n - n2 + n4 + 1;
                boolean bl2 = i < this.printImpls.length - 1;
                boolean bl3 = false;
                if (bl2) {
                    bl3 = this.conditionHeightCheck(i + 1, pageFormat, n6);
                }
                while (bl && bl2 && bl3) {
                    n2 += this.printImpls[i].getPageCount();
                    this.printImpls[++i].setStartY(n6);
                    this.printImpls[i].getFormatCalculator().setStartY(n6);
                    if (!this.incompletePageMap.containsKey(i - 1)) {
                        this.incompletePageMap.put(i - 1, this.incompletePages);
                    }
                    if (!this.incompletePageMap.containsKey(i)) {
                        ++this.incompletePages;
                        this.incompletePageMap.put(i, this.incompletePages);
                    }
                    this.checkAndFireAppendStart(i);
                    this.lastPrintedImpl = i;
                    n5 = this.printImpls[i].print(graphics, pageFormat, 0);
                    if (this.printImpls[i].getFormatCalculator().getSummaryPageCount() == 1) {
                        this.printImpls[i].getFormatCalculator().setStartY(0);
                    }
                    this.printImpls[i].setStartY(0);
                    n6 = this.printImpls[i].getEndY() + 50;
                    v = this.incompletePageMap.get(i);
                    if (v instanceof Integer) {
                        n4 = (Integer)v;
                    }
                    bl = this.printImpls[i].getPageCount() == n - n2 + n4 + 1;
                    bl2 = i < this.printImpls.length - 1;
                    if (!bl2) continue;
                    bl3 = this.conditionHeightCheck(i + 1, pageFormat, n6);
                }
                if (bl && bl2 && !bl3 && !this.incompletePageMap.containsKey(i + 1)) {
                    int n7 = 0;
                    v = this.incompletePageMap.get(i);
                    if (v instanceof Integer) {
                        n7 = (Integer)v;
                    }
                    this.incompletePageMap.put(i + 1, n7);
                }
                return n5;
            }
            n2 += this.printImpls[i].getPageCount();
        }
        return 1;
    }

    private boolean conditionHeightCheck(int n, PageFormat pageFormat, int n2) {
        this.printImpls[n].getFormatCalculator().checkAndInitWidths(pageFormat);
        this.printImpls[n].getFormatCalculator().setPageFormat(pageFormat);
        boolean bl = pageFormat.getImageableHeight() > (double)(n2 + this.printImpls[n].getFormatCalculator().getDataAboveHeightForPrint());
        return bl;
    }

    @Override
    protected void drawPage(Graphics2D graphics2D, PageFormat pageFormat, int n) {
    }

    @Override
    public int getPageCount() {
        int n = 0;
        for (int i = 0; i < this.printImpls.length; ++i) {
            n += this.printImpls[i].getPageCount();
        }
        return n - this.incompletePages;
    }

    private void checkAndFireAppendStart(final int n) {
        if (!this.appendStartEventFired[n]) {
            this.appendStartEventFired[n] = true;
            new Thread(){

                @Override
                public void run() {
                    MultiTablePrintImpl.this.printImpls[n].getFormatCalculator().fireCanStartAppend();
                }
            }.start();
        }
    }

    public void setForceAppendOver() {
        FormatCalculator formatCalculator = null;
        for (int i = 0; i < this.printImpls.length; ++i) {
            formatCalculator = this.printImpls[i].getFormatCalculator();
            formatCalculator.setForceAppendOver();
        }
    }

    public void reset(PageFormat pageFormat, boolean bl) {
        for (int i = 0; i < this.printImpls.length; ++i) {
            this.printImpls[i].reset();
        }
        if (bl) {
            this.printImpls[0].getFormatCalculator().setPageFormatWithCompute(pageFormat);
        }
        this.incompletePageMap.clear();
        this.incompletePages = 0;
        this.appendStartEventFired = new boolean[this.printImpls.length];
    }

    public boolean getIsNeedSleep() {
        return this.printImpls[0].getIsNeedSleep();
    }

    public void setIsNeedSleep(boolean bl) {
        for (int i = 0; i < this.printImpls.length; ++i) {
            this.printImpls[i].setIsNeedSleep(bl);
        }
    }

    public boolean getHeaderError() {
        return this.printImpls[0].getFormatCalculator().getHeaderError();
    }

    public boolean hasNextPage() {
        return this.printImpls[this.lastPrintedImpl].getPageCount() > 1 || this.printImpls.length - 1 > this.lastPrintedImpl;
    }

    public void addAppendStartListener(AppendStartListener appendStartListener) {
        for (int i = 0; i < this.printImpls.length; ++i) {
            this.printImpls[i].getFormatCalculator().addAppendStartListener(appendStartListener);
        }
    }
}

