/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.AbstractSaveImpl;
import com.swimap.iview.templates.print.tools.OpenFileHandler;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.jni.Solaris;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class HTMLSaveImpl
extends AbstractSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(HTMLSaveImpl.class, "IVIEW");
    private StringBuffer buff = new StringBuffer(35);
    private String fileName = null;
    private boolean isCloseStream = false;
    private static final int ONE_SECOND = 1000;
    private static final int MARAIN = 50;
    private int filesCount = 1;
    private String[] fileNames = null;
    private int currentFileNo = 1;
    private int filenameEx = 1;
    private static final String LINE_SPEARATOR = System.getProperty("line.separator");
    private String titleSize = "h1";
    private int writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
    private boolean isWriteTotalCount = false;
    private String saveEncoding = null;

    public void setTitleSizeToH2() {
        this.titleSize = "h2";
    }

    public void setSaveEncoding(String string) {
        this.saveEncoding = string;
    }

    public boolean isCloseStream() {
        return this.isCloseStream;
    }

    @Override
    public void setCloseStream(boolean bl) {
        this.isCloseStream = bl;
    }

    @Override
    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public boolean isFiles() {
        this.calculatorFiles(this.formatCalculator.getTotalRowCount());
        return this.fileNames.length > 1;
    }

    public HTMLSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator);
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        if (!this.formatCalculator.getTotleRecordsPosition()) {
            if (this.formatCalculator.getTotalRecordCount() != -1) {
                this.writeTotalCount = this.formatCalculator.getTotalRecordCount();
            }
            this.writeTotalRecords(bufferedWriter, this.writeTotalCount);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        StringBuffer stringBuffer = new StringBuffer(5);
        if (this.getFormatCalculator().isFixColWidthForHtml()) {
            bufferedWriter.write("<TABLE BORDER=\"2\" CELLSPACING=\"0\" CELLPADDING=\"5\"    WIDTH=\"" + (dimension.width - 50) + "\"" + "rules = \"all\" style = \"table-layout:word-wrap:break-word;\"" + ">");
        } else {
            bufferedWriter.write("<TABLE BORDER=\"2\" CELLSPACING=\"0\" CELLPADDING=\"5\"    WIDTH=\"" + this.formatCalculator.getHtmlPerColWidth() * this.formatCalculator.getRrintColCount() + "\"" + "rules = \"all\" style = \"table-layout:fixed;word-wrap:break-word;\"" + ">");
            for (int i = 0; i < this.formatCalculator.getRrintColCount(); ++i) {
                bufferedWriter.write(LINE_SPEARATOR);
                bufferedWriter.write("<col style=\"width:" + this.formatCalculator.getHtmlPerColWidth() + "\" />");
            }
        }
        bufferedWriter.write(stringBuffer.toString());
        bufferedWriter.write(LINE_SPEARATOR);
        if (!this.formatCalculator.isNormalSave()) {
            this.writeHeader(bufferedWriter);
        }
        this.writeData(bufferedWriter);
    }

    private void writeFileEndInfo(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("</TABLE>");
        if (this.isWriteTotalCount && this.formatCalculator.getTotleRecordsPosition()) {
            bufferedWriter.write("<BR>");
            if (this.formatCalculator.getTotalRecordCount() != -1) {
                this.writeTotalCount = this.formatCalculator.getTotalRecordCount();
            }
            this.writeTotalRecords(bufferedWriter, this.writeTotalCount);
        }
        bufferedWriter.write("<BR>");
        bufferedWriter.write("<BR>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</BODY>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</HTML>");
        bufferedWriter.write(LINE_SPEARATOR);
    }

    private void writeFileBeginInfo(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<HTML>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("<HEAD>");
        bufferedWriter.write(LINE_SPEARATOR);
        this.writeMetaTag(bufferedWriter);
        bufferedWriter.write("<TITLE>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</TITLE>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</HEAD>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("<BODY>");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<TABLE BORDER=\"2\" CELLSPACING=\"0\" CELLPADDING=\"5\"    WIDTH=\"");
        if (this.formatCalculator.isFixColWidthForHtml()) {
            stringBuffer.append(Integer.toString(dimension.width - 50));
        } else {
            stringBuffer.append(Integer.toString(this.formatCalculator.getHtmlPerColWidth() * this.formatCalculator.getRrintColCount()));
        }
        stringBuffer.append("\" ");
        stringBuffer.append("rules = \"all\" style = \"table-layout:word-wrap:break-word;\">");
        bufferedWriter.write(stringBuffer.toString());
        if (!this.formatCalculator.isFixColWidthForHtml()) {
            for (int i = 0; i < this.formatCalculator.getRrintColCount(); ++i) {
                bufferedWriter.write(LINE_SPEARATOR);
                bufferedWriter.write("<col style=\"width:" + this.formatCalculator.getHtmlPerColWidth() + "\" />");
            }
        }
        bufferedWriter.write(LINE_SPEARATOR);
    }

    private void writeMetaTag(BufferedWriter bufferedWriter) throws IOException {
        String string = null;
        string = null == this.saveEncoding ? ResourceUtil.CLIENT_ENCODING : this.saveEncoding;
        bufferedWriter.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=" + string + "\">");
        bufferedWriter.write(LINE_SPEARATOR);
    }

    @Override
    public void writeTitle(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<HTML>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("<HEAD>");
        bufferedWriter.write(LINE_SPEARATOR);
        this.writeMetaTag(bufferedWriter);
        bufferedWriter.write("<TITLE>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</TITLE>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("</HEAD>");
        bufferedWriter.write(LINE_SPEARATOR);
        bufferedWriter.write("<BODY>");
        bufferedWriter.write("<" + this.titleSize + " align=\"center\">");
        bufferedWriter.write(this.formatCalculator.getTitle());
        bufferedWriter.write("</" + this.titleSize + "><BR>");
    }

    @Override
    public void writeTotalExtraInfo(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write("<HTML>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("<HEAD>");
        bufferedWriter.write("\r\n");
        this.writeMetaTag(bufferedWriter);
        bufferedWriter.write("<TITLE>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("</TITLE>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("</HEAD>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("<BODY>");
        bufferedWriter.write("<h1 align=\"center\">");
        bufferedWriter.write(string);
        bufferedWriter.write("</h1><BR>");
        bufferedWriter.write("<pre>");
        bufferedWriter.write("<center>");
        bufferedWriter.write(PrintSupportor.res.getString("saveTime"));
        bufferedWriter.write(this.formatCalculator.getTime());
        bufferedWriter.write("       ");
        bufferedWriter.write(PrintSupportor.res.getString("userName"));
        bufferedWriter.write(this.formatCalculator.getUserName());
        bufferedWriter.write("</center>");
        bufferedWriter.write("</pre>");
        bufferedWriter.write("<BR>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("</BODY>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("</HTML>");
        bufferedWriter.write("\r\n");
    }

    @Override
    public void writeExtraInfo(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<pre>");
        bufferedWriter.write("<center>");
        bufferedWriter.write(PrintSupportor.res.getString("saveTime"));
        bufferedWriter.write(this.formatCalculator.getTime());
        bufferedWriter.write("   ");
        bufferedWriter.write(PrintSupportor.res.getString("userName"));
        bufferedWriter.write(this.formatCalculator.getUserName());
        bufferedWriter.write("</center>");
        bufferedWriter.write("</pre>");
        bufferedWriter.write("<BR>");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.covertSymbol(this.formatCalculator.getSummary())));
        if (this.formatCalculator.getSummary() != null && !"".equals(this.formatCalculator.getSummary().trim())) {
            this.writeSummary(bufferedReader, bufferedWriter);
        }
        bufferedWriter.write(LINE_SPEARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSummary(BufferedReader bufferedReader, BufferedWriter bufferedWriter) {
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string);
                bufferedWriter.write(LINE_SPEARATOR);
                bufferedWriter.write("<BR>");
            }
            bufferedWriter.write("<BR>");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    private void writeHeader(BufferedWriter bufferedWriter) throws IOException {
        int n;
        bufferedWriter.write("<TR>");
        bufferedWriter.write(LINE_SPEARATOR);
        String[] stringArray = this.formatCalculator.getTableHeaders();
        double d = 0.0;
        if (this.formatCalculator.isFixColWidthForHtml()) {
            int n2 = this.formatCalculator.getColumnWidths().length;
            for (n = 0; n < n2; ++n) {
                d += (double)this.formatCalculator.getColumnWidths()[n];
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (this.formatCalculator.isFixColWidthForHtml()) {
                String string = (int)((double)this.formatCalculator.getColumnWidths()[n] / d * 100.0) + "%";
                bufferedWriter.write("<TD  ALIGN=\"CENTER\" width = \" " + string + "\">");
            } else {
                bufferedWriter.write("<TD  ALIGN=\"CENTER\">");
            }
            bufferedWriter.write(LINE_SPEARATOR);
            bufferedWriter.write(stringArray[n]);
            bufferedWriter.write(LINE_SPEARATOR);
            bufferedWriter.write("<BR>");
            bufferedWriter.write("</TD>");
            bufferedWriter.write(LINE_SPEARATOR);
        }
        bufferedWriter.write("</TR>");
        bufferedWriter.write(LINE_SPEARATOR);
    }

    private void writeData(BufferedWriter bufferedWriter) throws IOException {
        StringBuffer stringBuffer = null;
        int n = 0;
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt(); ++i) {
            this.buff.delete(0, this.buff.length());
            this.buff.append("<TR>");
            this.buff.append(LINE_SPEARATOR);
            int n2 = -1;
            LinkedList linkedList = null;
            Iterator iterator = null;
            LinkedList linkedList2 = null;
            Iterator iterator2 = null;
            String string = null;
            while (!this.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
                    this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
                    if (this.isCloseStream()) {
                        this.isWriteTotalCount = true;
                        this.writeFileEndInfo(bufferedWriter);
                        bufferedWriter.close();
                    }
                    if (!this.formatCalculator.getDeleteFileFlag()) {
                        this.showMutiFilesInfo();
                    }
                    return;
                }
                n2 = i;
                if (n2 >= 0 && n2 < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n2);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.isOver()) {
                this.writeTotalCount = i;
                this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
                if (this.isCloseStream()) {
                    this.isWriteTotalCount = true;
                    this.writeFileEndInfo(bufferedWriter);
                    bufferedWriter.close();
                }
                if (!this.formatCalculator.getDeleteFileFlag()) {
                    this.showMutiFilesInfo();
                }
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n2);
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.buff.append("<TD ALIGN=\"LEFT\">");
                this.buff.append(LINE_SPEARATOR);
                linkedList2 = (LinkedList)iterator.next();
                if (linkedList2.size() == 0) {
                    this.buff.append("-");
                    this.buff.append(LINE_SPEARATOR);
                    this.buff.append("<BR>");
                } else {
                    iterator2 = linkedList2.iterator();
                    while (iterator2.hasNext()) {
                        string = this.covertSymbol((String)iterator2.next());
                        this.buff.append(string);
                        this.buff.append(LINE_SPEARATOR);
                        this.buff.append("<BR>");
                    }
                }
                this.buff.append("</TD>");
                this.buff.append(LINE_SPEARATOR);
            }
            this.buff.append("</TR>");
            this.buff.append(LINE_SPEARATOR);
            bufferedWriter.write(this.buff.toString());
            bufferedWriter.flush();
            this.formatCalculator.setLastPrintedRowIndex(i);
            ++n;
            if (i + 1 < this.formatCalculator.getMaxRecordsCountPerFile() * this.currentFileNo - this.lastFileRecordCount || i == this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt() - 1) continue;
            this.writeFileEndInfo(bufferedWriter);
            ++this.currentFileNo;
            bufferedWriter.close();
            int n3 = this.fileName.toLowerCase().lastIndexOf(".htm");
            String string2 = this.fileName.substring(0, n3) + "@" + this.filenameEx + ".html";
            ++this.filenameEx;
            stringBuffer = new StringBuffer(20);
            while (new File(CommonUtil.getAbsolutePath(string2)).exists()) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(this.fileName.substring(0, n3));
                stringBuffer.append("@");
                stringBuffer.append(this.filenameEx);
                stringBuffer.append(".html");
                string2 = stringBuffer.toString();
                ++this.filenameEx;
            }
            this.fileNames[this.currentFileNo - 1] = string2;
            this.mergeFileNames(this.fileNames);
            OutputStreamWriter outputStreamWriter = null;
            FileOutputStream fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(string2));
            if (null != this.saveEncoding && Charset.isSupported(this.saveEncoding)) {
                if (this.saveEncoding.equalsIgnoreCase("UTF-8")) {
                    this.writeBOM(fileOutputStream);
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.saveEncoding);
            } else {
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.setLastStream(bufferedWriter);
            n = 0;
            this.writeFileBeginInfo(bufferedWriter);
            this.writeHeader(bufferedWriter);
        }
        this.writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
        this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
        this.lastFileRecordCount = n;
        this.isWriteTotalCount = true;
        this.writeFileEndInfo(bufferedWriter);
        if (this.isCloseStream()) {
            bufferedWriter.close();
        }
        if (!this.formatCalculator.getDeleteFileFlag()) {
            this.showMutiFilesInfo();
        }
    }

    private void showMutiFilesInfo() {
        if (!this.showMultiFileInfo || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            return;
        }
        String[] stringArray = this.getCsvXlsorPdfFileNames();
        if (Os.getOs() instanceof Windows && stringArray.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            OpenFileHandler.openXlsOrTXTFile(this.parentFrame, stringArray);
        } else if (stringArray != null && stringArray.length > 0) {
            this.displaySaveInfo();
        }
    }

    private void displaySaveInfo() {
        int n = 0;
        for (int i = 0; i < this.fileNames.length; ++i) {
            if (this.fileNames[i] == null || this.fileNames[i].length() <= 0) continue;
            ++n;
        }
        if (n < 2 && Os.getOs() instanceof Solaris && !this.formatCalculator.isOpenFileEnabled()) {
            return;
        }
        if (n < 2 && Os.getOs() instanceof Windows) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.fileNames.length > 1) {
            stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("fileName"));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.fileNames[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.fileNames[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        final String string = stringBuffer.toString();
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                String string2 = PrintSupportor.res.getString("fileNamesInfo");
                if (n2 == 1) {
                    string2 = PrintSupportor.res.getString("fileSaveInfo");
                }
                JFrame jFrame = null;
                jFrame = HTMLSaveImpl.this.parentFrame != null ? HTMLSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (jFrame instanceof JFrame || jFrame == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)jFrame, PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else if (jFrame instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)((Object)jFrame)), PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else {
                    logger.trace("In HTMLSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    private String covertSymbol(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll(" ", "&nbsp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("&nbsp;", "&nbsp;<wbr />");
        return string2;
    }

    private void calculatorFiles(int n) {
        if ((n += this.lastFileRecordCount) > this.formatCalculator.getMaxRecordsCountPerFile()) {
            this.filesCount = n % this.formatCalculator.getMaxRecordsCountPerFile() == 0 ? n / this.formatCalculator.getMaxRecordsCountPerFile() : n / this.formatCalculator.getMaxRecordsCountPerFile() + 1;
            this.fileNames = new String[this.filesCount];
            this.fileNames[0] = this.fileName;
        } else {
            this.fileNames = new String[]{this.fileName};
        }
        this.mergeFileNames(this.fileNames);
    }

    public String getCurrentFileName() {
        String string = this.fileName;
        try {
            string = this.fileNames[this.currentFileNo - 1];
        }
        catch (Exception exception) {
            string = this.fileName;
        }
        if (string == null || string.length() == 0) {
            string = this.fileName;
        }
        return string;
    }

    void writeBOM(FileOutputStream fileOutputStream) {
        byte[] byArray = new byte[]{-17, -69, -65};
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            logger.trace("Exception while Writing BOM" + iOException.getMessage());
        }
    }
}

