/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.sun.java.help.impl.JHelpPrintHandler;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.print.PrintServiceUI;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ResourceBundle;
import javax.help.JHelp;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;

public class HTMLPrintHandler
extends JHelpPrintHandler {
    private static IviewLogger logger = IviewLogger.getLogger(HTMLPrintHandler.class, "IVIEW");
    public static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    private JFrame mainFrame = null;
    private static JHelp help = new JHelp();
    private static final int MM_TO_MICRON = 1000;
    private static final int DEFAULT_X_COORDINATE = 100;
    private static final int DEFAULT_Y_COORDINATE = 100;

    public HTMLPrintHandler() {
        super(help);
    }

    public void print(URL[] uRLArray, JFrame jFrame) {
        this.mainFrame = jFrame;
        if (this.isEnabled()) {
            this.startPrint(uRLArray);
        }
    }

    private void startPrint(URL[] uRLArray) {
        Object object;
        int n;
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        Object object2 = null;
        try {
            object2 = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(HTMLPrintHandler.this.mainFrame, res.getString("ZeroPrinter"));
                }
            });
            return;
        }
        int n2 = n = ((PrintService[])object2).length;
        for (int i = 0; i < n2; ++i) {
            if (object2[i].getClass().toString().indexOf("sun.print.Win32PrintService") == -1) continue;
            try {
                Class<?> clazz = object2[i].getClass();
                try {
                    object = clazz.getDeclaredMethod("getPort", null);
                    ((Method)object).setAccessible(true);
                    ((Method)object).invoke((Object)object2[i], (Object[])null);
                }
                catch (Exception exception) {
                    logger.trace("PrintSupportor:No getPort() method");
                }
                object = clazz.getDeclaredField("port");
                ((Field)object).setAccessible(true);
                if (!((Field)object).get(object2[i]).equals("Microsoft Document Imaging Writer Port:") && !"Microsoft Office Document Image Writer".equals(object2[i].getName())) continue;
                object2[i] = null;
                --n;
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        int n3 = n - 1;
        object = new PrintService[n];
        int n4 = 0;
        for (int i = 0; i < ((PrintService[])object2).length; ++i) {
            if (object2[i] == null) continue;
            object[n4] = object2[i];
            if (((Object)object2[i]).equals(printService)) {
                n3 = n4;
            }
            ++n4;
        }
        object2 = object;
        if (((PrintService[])object2).length == 0) {
            logger.trace("printSupportor || printServices.length == 0");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(HTMLPrintHandler.this.mainFrame, res.getString("ZeroPrinter"));
                }
            });
            return;
        }
        if (null != PrintSupportor.printRequestAttributeSet) {
            Attribute[] attributeArray = PrintSupportor.printRequestAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                hashPrintRequestAttributeSet.add(attributeArray[i]);
            }
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService printService2 = null;
        try {
            printService2 = PrintServiceUI.printDialog(null, 100, 100, object2, object2[n3], sERVICE_FORMATTED, hashPrintRequestAttributeSet, this.mainFrame);
            if (printService2 == null) {
                return;
            }
            printerJob.setPrintService(printService2);
            this.modifyPageFormat(hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(HTMLPrintHandler.this.mainFrame, res.getString("ZeroPrinter"));
                }
            });
            return;
        }
        new PrintThread(uRLArray, printerJob, hashPrintRequestAttributeSet).start();
    }

    private void modifyPageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet instanceof HashPrintRequestAttributeSet) {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = (HashPrintRequestAttributeSet)printRequestAttributeSet;
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)hashPrintRequestAttributeSet.get(MediaPrintableArea.class);
            int n = 1;
            float f = mediaPrintableArea.getX(n);
            float f2 = mediaPrintableArea.getY(n);
            float f3 = mediaPrintableArea.getWidth(n);
            float f4 = mediaPrintableArea.getHeight(n);
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            paper.setImageableArea((double)(f / 1000.0f) * 2.8346456692913384, (double)(f2 / 1000.0f) * 2.8346456692913384, (double)(f3 / 1000.0f) * 2.8346456692913384, (double)(f4 / 1000.0f) * 2.8346456692913384);
            pageFormat.setPaper(paper);
            this.setPageFormat(pageFormat);
        }
    }

    private class PrintThread
    extends Thread {
        private URL[] urls;
        private PrinterJob printerJob = null;

        PrintThread(URL[] uRLArray, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
            this.urls = uRLArray;
            this.printerJob = printerJob;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.printerJob == null) {
                return;
            }
            JEditorPane jEditorPane = new JEditorPane(){

                @Override
                public EditorKit getEditorKitForContentType(String string) {
                    EditorKit editorKit = 1.createEditorKitForContentType(string);
                    if (editorKit == null) {
                        editorKit = super.getEditorKitForContentType(string);
                    }
                    return editorKit;
                }
            };
            jEditorPane.setDoubleBuffered(false);
            jEditorPane.setEditable(false);
            jEditorPane.setDropTarget(null);
            JHFrame jHFrame = new JHFrame();
            jHFrame.setContentPane(jEditorPane);
            try {
                this.printerJob.setPageable((Pageable)new JHelpPrintHandler.JHPageable((JHelpPrintHandler)HTMLPrintHandler.this, jEditorPane, this.urls, (PageFormat)HTMLPrintHandler.this.getPageFormat().clone()));
            }
            catch (Exception exception) {
                HTMLPrintHandler.processException((Exception)exception);
            }
            try {
                this.printerJob.print();
            }
            catch (Exception exception) {
                HTMLPrintHandler.processException((Exception)exception);
            }
            jHFrame.dispose();
            help = new JHelp();
        }
    }

    private class JHFrame
    extends JFrame {
        private JHFrame() {
        }

        @Override
        public void addNotify() {
            this.getRootPane().addNotify();
        }

        @Override
        public void validate() {
            this.validateTree();
        }

        @Override
        public Graphics getGraphics() {
            return help.getGraphics();
        }
    }
}

