/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.tools.TXTSaveImpl;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.CommonUtil;
import java.io.File;
import java.io.IOException;

public abstract class ExcelSaveImpl
extends TXTSaveImpl {
    protected String fileName = null;
    protected String[] fileNames = null;
    protected int currentFileNo = 1;
    protected int totalWorkbook = 0;
    protected String userEncoding = null;

    public ExcelSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator);
    }

    public abstract void writeInit(String var1, TablePrintable[] var2) throws Exception;

    public void setUserEncoding(String string) {
        this.userEncoding = string;
    }

    @Override
    public String getCurrentFileName() {
        String string = this.fileName;
        if (this.fileNames != null && this.currentFileNo - 1 < this.fileNames.length) {
            string = this.fileNames[this.currentFileNo - 1];
        }
        if (string == null || string.length() == 0) {
            string = this.fileName;
        }
        return string;
    }

    protected void calculatorFiles(int n) {
        int n2 = this.formatCalculator.getMaxRecordsCountPerFile();
        if (n > n2) {
            File file = new File(CommonUtil.getAbsolutePath(this.fileName));
            if (file.exists()) {
                file.delete();
            }
            this.totalWorkbook = this.calculateWorkbooks(n, n2);
            this.totalWorkbook = this.calculateWorkbooks(n += this.totalWorkbook, n2);
            this.fileNames = new String[this.totalWorkbook];
            this.fileNames[0] = this.fileName;
        } else {
            this.fileNames = new String[]{this.fileName};
        }
        this.setCsvXlsorPdfFileNames(this.fileNames);
    }

    private int calculateWorkbooks(int n, int n2) {
        if (n % n2 == 0) {
            return n / n2;
        }
        return n / n2 + 1;
    }

    protected boolean isCommaExit(String string) {
        return -1 != string.indexOf(44);
    }

    protected boolean isDecimal(String string) {
        try {
            Integer.parseInt(string);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public abstract void writeTitle() throws Exception;

    public abstract void writeTitle(String var1) throws Exception;

    public abstract void writeExtraInfo() throws Exception;

    public abstract void write() throws Exception;

    public abstract void write(boolean var1) throws Exception;

    public abstract void associatePreSaveImplInfo(ExcelSaveImpl var1);

    public abstract void closeCurrentStream() throws IOException;
}

