/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.OpenFileHandler;
import com.swimap.iview.templates.print.tools.TXTSaveImpl;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IViewStringBuffer;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CSVSaveImpl
extends TXTSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(CSVSaveImpl.class, "IVIEW");
    private static final char TXT_SEPARATOR_CHAR = ',';
    private static final String QUOTATION_MARK = "\"";
    private static final String DOUBLE_QUOTATION_MARKS = "\"\"";
    private static final int ONE_SECOND = 1000;
    private static final int EXTRA_INFO_ROWS = 10;
    private String fileName = null;
    private int filesCount = 1;
    private String[] fileNames = null;
    private int currentFileNo = 1;
    private int filenameEx = 1;
    private boolean isCloseStream = false;
    private FormatCalculator parentFormatCalculator = null;
    private StringBuffer tempBufForData = new StringBuffer(40);
    private boolean multiFiles = false;
    private int writeTotalCount = 0;
    private BufferedWriter _out = null;
    private String saveEncoding = null;

    public CSVSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator.getCsvFormatCalculator());
        this.parentFormatCalculator = formatCalculator;
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
    }

    @Override
    public void writeTitle(BufferedWriter bufferedWriter) throws IOException {
        if (this.multiFiles) {
            bufferedWriter.write(FormatCalculator.LINE_CHANGER);
            bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        }
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(QUOTATION_MARK);
        this.tempBufForData.append(this.formatCalculator.getTitle().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        this.tempBufForData.append(QUOTATION_MARK);
        bufferedWriter.write(this.tempBufForData.toString());
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
    }

    @Override
    public void writeTotalExtraInfo(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(QUOTATION_MARK + string.replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS).replaceAll("\r\n", "\n") + QUOTATION_MARK);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        bufferedWriter.write(QUOTATION_MARK + stringBuffer.toString().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS) + QUOTATION_MARK);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        StringBuffer stringBuffer2 = new StringBuffer(PrintSupportor.res.getString("userName").trim());
        stringBuffer2.append(this.formatCalculator.getUserName().trim().replaceAll("\r\n", "\n"));
        bufferedWriter.write(QUOTATION_MARK + stringBuffer2.toString().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS) + QUOTATION_MARK);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
    }

    @Override
    public void writeExtraInfo(BufferedWriter bufferedWriter) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(QUOTATION_MARK);
        this.tempBufForData.append(stringBuffer.toString().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        this.tempBufForData.append(QUOTATION_MARK);
        bufferedWriter.write(this.tempBufForData.toString());
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        StringBuffer stringBuffer2 = new StringBuffer(PrintSupportor.res.getString("userName").trim());
        stringBuffer2.append(this.formatCalculator.getUserName().trim());
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(QUOTATION_MARK);
        this.tempBufForData.append(stringBuffer2.toString().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        this.tempBufForData.append(QUOTATION_MARK);
        bufferedWriter.write(this.tempBufForData.toString());
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(QUOTATION_MARK);
        this.tempBufForData.append(this.formatCalculator.getSummary().replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        this.tempBufForData.append(QUOTATION_MARK);
        bufferedWriter.write(this.tempBufForData.toString());
        bufferedWriter.write(System.getProperty("line.separator"));
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        this._out = bufferedWriter;
        this._out.write(FormatCalculator.LINE_CHANGER);
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader(this._out);
            }
            this.writeData(this._out);
            this._out.write(FormatCalculator.LINE_CHANGER);
        }
        if (this.parentFormatCalculator.getTotalRecordCount() != -1) {
            this.writeTotalCount = this.parentFormatCalculator.getTotalRecordCount();
        }
        if (this.parentFormatCalculator.isTotalRecordVisible()) {
            this.writeTotalRecords(this._out, this.writeTotalCount);
            this._out.write(FormatCalculator.LINE_CHANGER);
            this._out.write(FormatCalculator.LINE_CHANGER);
        }
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader(this._out);
            }
            this.writeData(this._out);
        }
        if (this.isCloseStream()) {
            bufferedWriter.close();
            this._out.close();
        }
    }

    @Override
    protected void writeTotalRecords(BufferedWriter bufferedWriter, int n) throws IOException {
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(QUOTATION_MARK);
        this.tempBufForData.append(PrintSupportor.res.getString("Total").replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        bufferedWriter.write(this.tempBufForData.toString());
        bufferedWriter.write(NumberFormatUtil.getFormatNumber(n));
        this.tempBufForData.delete(0, this.tempBufForData.length());
        this.tempBufForData.append(' ');
        if (this.formatCalculator.getTotalRowsCount() > 1) {
            this.tempBufForData.append(PrintSupportor.res.getString("Records").replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        } else {
            this.tempBufForData.append(PrintSupportor.res.getString("Record").replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS));
        }
        this.tempBufForData.append(QUOTATION_MARK);
        bufferedWriter.write(this.tempBufForData.toString());
    }

    @Override
    protected void writeHeader(BufferedWriter bufferedWriter) throws IOException {
        int[] nArray = this.formatCalculator.getTxtColumnWidths();
        String[] stringArray = this.formatCalculator.getTableHeaders();
        String string = null;
        for (int i = 0; i < nArray.length; ++i) {
            string = stringArray[i];
            string = string.replaceAll("\n", "");
            string = string.replaceAll("\r", "");
            string = string.replaceAll(QUOTATION_MARK, DOUBLE_QUOTATION_MARKS);
            this.tempBufForData.delete(0, this.tempBufForData.length());
            string = this.tempBufForData.append(QUOTATION_MARK).append(string).append(QUOTATION_MARK).toString();
            bufferedWriter.write(string);
            if (i == nArray.length - 1) continue;
            bufferedWriter.write(44);
        }
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
    }

    @Override
    protected void writeData(BufferedWriter bufferedWriter) throws IOException {
        IViewStringBuffer iViewStringBuffer = new IViewStringBuffer();
        int n = 11;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            n -= 2;
        }
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = this.formatCalculator.getMaxRecordsCountPerFile() - n - this.lastFileRecordCount;
        int n4 = this.formatCalculator.getTableHeaders().length;
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt(); ++i) {
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            LinkedList linkedList = null;
            Iterator iterator = null;
            LinkedList<String> linkedList2 = null;
            LinkedList linkedList32 = null;
            String string = null;
            while (!this.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
                    this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                    if (!this.parentFormatCalculator.getTotleRecordsPosition() && this.isCloseStream) {
                        bufferedWriter.close();
                    }
                    if (!this.parentFormatCalculator.getDeleteFileFlag()) {
                        this.showMutiFilesInfo();
                    }
                    return;
                }
                n5 = i;
                if (n5 >= 0 && n5 < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n5);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.isOver()) {
                this.writeTotalCount = i;
                this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                if (!this.parentFormatCalculator.getTotleRecordsPosition() && this.isCloseStream) {
                    bufferedWriter.close();
                }
                if (!this.parentFormatCalculator.getDeleteFileFlag()) {
                    this.showMutiFilesInfo();
                }
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n5);
            n6 = 0;
            for (LinkedList linkedList32 : linkedList) {
                if (n6 >= linkedList32.size()) continue;
                n6 = linkedList32.size();
            }
            for (int j = 0; j < n6; ++j) {
                iterator = linkedList.iterator();
                iViewStringBuffer.delete(0, iViewStringBuffer.length());
                for (n7 = 0; n7 < n4; ++n7) {
                    try {
                        linkedList2 = (LinkedList<String>)iterator.next();
                    }
                    catch (Exception exception) {
                        logger.trace("Should contain column index: " + n7 + ". Total column size is " + n4);
                        logger.trace(exception.getMessage(), exception);
                        linkedList2 = new LinkedList<String>();
                        linkedList2.add("-");
                    }
                    if (j < linkedList2.size()) {
                        string = (String)linkedList2.get(j);
                        iViewStringBuffer.append(string);
                    }
                    if (n7 == this.formatCalculator.getColumnWidths().length - 1) continue;
                    iViewStringBuffer.append(',');
                }
                iViewStringBuffer.append(FormatCalculator.LINE_CHANGER);
                bufferedWriter.write(iViewStringBuffer.getValue(), 0, iViewStringBuffer.length());
                bufferedWriter.flush();
            }
            this.formatCalculator.setLastPrintedRowIndex(i);
            ++n2;
            if (i < n3 || i == this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt() - 1) continue;
            n3 = i + this.formatCalculator.getMaxRecordsCountPerFile() - 1;
            ++this.currentFileNo;
            bufferedWriter.close();
            String string2 = this.fileName.substring(0, this.fileName.length() - 4) + "@" + this.filenameEx + ".csv";
            ++this.filenameEx;
            stringBuffer = new StringBuffer();
            while (new File(CommonUtil.getAbsolutePath(string2)).exists()) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(this.fileName.substring(0, this.fileName.length() - 4));
                stringBuffer.append("@");
                stringBuffer.append(Integer.toString(this.filenameEx));
                stringBuffer.append(".csv");
                string2 = stringBuffer.toString();
                ++this.filenameEx;
            }
            this.fileNames[this.currentFileNo - 1] = string2;
            this.mergeFileNames(this.fileNames);
            OutputStreamWriter outputStreamWriter = null;
            FileOutputStream fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(string2));
            if (null != this.saveEncoding && Charset.isSupported(this.saveEncoding)) {
                logger.trace("--XX-- encoding used" + this.saveEncoding + " tempFileName " + string2);
                if (this.saveEncoding.equalsIgnoreCase("UTF-8")) {
                    this.writeBOM(fileOutputStream);
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.saveEncoding);
            } else {
                logger.trace("--XX-- encoding not used  tempFileName " + string2);
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            this._out = bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.setLastStream(bufferedWriter);
            n2 = 0;
            if (this.parentFormatCalculator.isNormalSave()) continue;
            this.writeHeader(bufferedWriter);
        }
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
        this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
        this.lastFileRecordCount = n2;
        if (!this.parentFormatCalculator.getTotleRecordsPosition() && this.isCloseStream) {
            bufferedWriter.close();
        }
        if (!this.parentFormatCalculator.getDeleteFileFlag()) {
            this.showMutiFilesInfo();
        }
    }

    private void showMutiFilesInfo() {
        if (!this.showMultiFileInfo || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            return;
        }
        String[] stringArray = this.getCsvXlsorPdfFileNames();
        if (stringArray.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            OpenFileHandler.openXlsOrTXTFile(this.parentFrame, stringArray);
            return;
        }
        if (stringArray.length > 1) {
            this.displaySaveInfo();
        }
    }

    private void displaySaveInfo() {
        int n = 0;
        for (int i = 0; i < this.fileNames.length; ++i) {
            if (this.fileNames[i] == null || this.fileNames[i].length() <= 0) continue;
            ++n;
        }
        if (n < 2) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        stringBuffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.fileNames[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.fileNames[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        final String string = stringBuffer.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                JFrame jFrame = null;
                jFrame = CSVSaveImpl.this.parentFrame != null ? CSVSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (jFrame instanceof JFrame || jFrame == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)jFrame, PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string);
                } else if (jFrame instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)((Object)jFrame)), PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string);
                } else {
                    logger.trace("In CSVSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    private void calculatorFiles(int n) {
        if ((n += this.lastFileRecordCount) > this.formatCalculator.getMaxRecordsCountPerFile()) {
            this.filesCount = n % this.formatCalculator.getMaxRecordsCountPerFile() == 0 ? n / this.formatCalculator.getMaxRecordsCountPerFile() : n / this.formatCalculator.getMaxRecordsCountPerFile() + 1;
            this.filesCount = (n += this.filesCount) % this.formatCalculator.getMaxRecordsCountPerFile() == 0 ? n / this.formatCalculator.getMaxRecordsCountPerFile() : n / this.formatCalculator.getMaxRecordsCountPerFile() + 1;
            this.fileNames = new String[this.filesCount];
            this.fileNames[0] = this.fileName;
        } else {
            this.fileNames = new String[]{this.fileName};
        }
        this.mergeFileNames(this.fileNames);
    }

    @Override
    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public boolean isFiles() {
        int n = this.formatCalculator.getTotalRowCount() + 10;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            n -= 2;
        }
        this.calculatorFiles(n);
        return this.fileNames.length > 1;
    }

    @Override
    public boolean isCloseStream() {
        return this.isCloseStream;
    }

    @Override
    public void setCloseStream(boolean bl) {
        this.isCloseStream = bl;
    }

    @Override
    public String getCurrentFileName() {
        String string = this.fileName;
        if (this.fileNames != null && this.currentFileNo - 1 < this.fileNames.length) {
            string = this.fileNames[this.currentFileNo - 1];
        }
        if (string == null || string.length() == 0) {
            string = this.fileName;
        }
        return string;
    }

    @Override
    public void setMultiFiles(boolean bl) {
        this.multiFiles = bl;
    }

    @Override
    public boolean isMultiFiles() {
        return this.multiFiles;
    }

    @Override
    public void setSaveEncoding(String string) {
        this.saveEncoding = string;
    }
}

