/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.templates.print.FileSavingable;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SavePrintable;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

public abstract class AbstractSaveImpl
implements FileSavingable,
SavePrintable {
    private static IviewLogger logger = IviewLogger.getLogger(AbstractSaveImpl.class, "IVIEW");
    protected FormatCalculator formatCalculator;
    protected boolean bOver = false;
    protected static final String fileSeqNumSeparator = "@";
    protected Window parentFrame = null;
    protected BufferedWriter lastStream = null;
    protected int lastFileRecordCount = 0;
    protected boolean showMultiFileInfo = true;
    private String[] csvXlsorPdfFileNames = null;

    public AbstractSaveImpl(FormatCalculator formatCalculator) {
        this.formatCalculator = formatCalculator;
        logger.trace("iView - Print - Save - init AbstractSaveImpl");
    }

    @Override
    public boolean isOver() {
        return this.bOver;
    }

    @Override
    public void setDataOver(boolean bl) {
        this.bOver = bl;
    }

    @Override
    public FormatCalculator getFormatCalculator() {
        return this.formatCalculator;
    }

    public void setFileName(String string) {
    }

    protected void writeTotalRecords(BufferedWriter bufferedWriter, int n) throws IOException {
        if (!this.formatCalculator.isTotalRecordVisible()) {
            return;
        }
        bufferedWriter.write(PrintSupportor.res.getString("Total"));
        bufferedWriter.write(NumberFormatUtil.getFormatNumber(n));
        if (n > 1) {
            bufferedWriter.write(' ' + PrintSupportor.res.getString("Records"));
        } else {
            bufferedWriter.write(' ' + PrintSupportor.res.getString("Record"));
        }
    }

    public boolean isFiles() {
        return false;
    }

    public void setParentFrame(Window window) {
        this.parentFrame = window;
    }

    public void setLastStream(BufferedWriter bufferedWriter) {
        this.lastStream = bufferedWriter;
    }

    public BufferedWriter getLastStream() {
        return this.lastStream;
    }

    protected void mergeFileNames(String[] stringArray) {
        String[] stringArray2 = this.getCsvXlsorPdfFileNames();
        if (null == stringArray2) {
            this.setCsvXlsorPdfFileNames(stringArray);
        } else {
            Vector<String> vector = new Vector<String>(Arrays.asList(stringArray2));
            vector.removeAll(Arrays.asList(stringArray));
            vector.addAll(Arrays.asList(stringArray));
            vector.removeAll(Arrays.asList(new String[]{null}));
            Collections.sort(vector);
            stringArray2 = vector.toArray(new String[0]);
            this.setCsvXlsorPdfFileNames(stringArray2);
        }
    }

    public int getLastFileRecordCount() {
        return this.lastFileRecordCount;
    }

    public void setLastFileRecordCount(int n) {
        this.lastFileRecordCount = n;
    }

    public void setShowMultiFileInfo(boolean bl) {
        this.showMultiFileInfo = bl;
    }

    public void setCsvXlsorPdfFileNames(String[] stringArray) {
        this.csvXlsorPdfFileNames = stringArray;
    }

    public String[] getCsvXlsorPdfFileNames() {
        return this.csvXlsorPdfFileNames;
    }

    public void setCloseStream(boolean bl) {
    }

    @Override
    public abstract void write(BufferedWriter var1) throws IOException;

    public void writeTotalExtraInfo(BufferedWriter bufferedWriter, String string) throws IOException {
    }

    @Override
    public abstract void writeTitle(BufferedWriter var1) throws IOException;

    @Override
    public abstract void writeExtraInfo(BufferedWriter var1) throws IOException;
}

