/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.IDataModel;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.util.ProgressHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Window;
import java.awt.print.PrinterException;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SaveTask
implements Runnable {
    private static IviewLogger logger = IviewLogger.getLogger(SaveTask.class, "IVIEW");
    private boolean isOn = false;
    private String title = null;
    private int startRow = 0;
    private String fileName = null;
    private String fileType = null;
    private String userName = null;
    private String summary = null;
    private TablePrintable tablePrintable = null;
    private SaveAndPrintParameters saveAndPrintParameters = null;
    private Component parent = null;
    private static final int MAX_REC_COUNT_PERFILE = 20000;
    private int maxRecordsCountPerFile = 20000;
    private boolean isSuccess = true;
    private IDataModel dataModel = null;
    private ProgressHandler handler = ProgressHandler.getInstance();
    private JProgressBar progressBar = null;
    private int dataWidth = 0;
    String userEncoding = null;

    public SaveTask(IDataModel iDataModel, String string, String string2, String string3, String string4, String string5, Component component, int n) {
        this.dataModel = iDataModel;
        this.title = string;
        this.summary = string3;
        this.fileName = string4;
        this.fileType = string5;
        this.userName = string2;
        this.parent = component;
        this.dataWidth = n;
    }

    public boolean startTask() {
        if (this.isOn) {
            return true;
        }
        Vector vector = new Vector(2);
        int n = this.dataModel.getTotalCount();
        this.tablePrintable = this.getSaveAndPrintParameters().createTablePrintable(new String[]{""}, vector, n, true, this.dataWidth);
        this.tablePrintable.setNormalSave(true);
        this.tablePrintable.setTotalRecordCountVisibilty(false);
        this.tablePrintable.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        if (null != this.fileType && 0 != this.fileType.length()) {
            this.isOn = PrintSupportor.saveToFileNoCheck(FrameworkUtilities.getMainFrame(), this.fileName, this.tablePrintable, this.fileType, this.userEncoding);
        }
        if (!this.isOn || n <= 0) {
            return false;
        }
        this.createProgressDialog(this.parent);
        Thread thread = new Thread(this);
        thread.start();
        this.handler.showProgress();
        return this.isSuccess;
    }

    @Override
    public void run() {
        this.isOn = true;
        this.isSuccess = true;
        int n = this.dataModel.getPageSize();
        int n2 = this.dataModel.getTotalCount();
        Vector vector = null;
        int n3 = this.startRow / n;
        int n4 = (n2 - 1) / n;
        this.progressBar.setStringPainted(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(0);
        Collection<String> collection = null;
        int n5 = 0;
        int n6 = 0;
        for (int i = n3; i <= n4 && this.isOn && !this.tablePrintable.isOver(); ++i) {
            block8: {
                n5 = i == n3 ? this.startRow : i * n;
                n6 = i == n4 ? n2 - n5 : n;
                logger.debug("The rows queried: " + n5 + " to: " + (n5 + n6 - 1));
                vector = this.dataModel.getData(n5, n6);
                collection = this.getVisibleData(vector);
                if (collection == null) {
                    if (this.tablePrintable != null) {
                        this.tablePrintable.setDataOver(true);
                    }
                    this.isOn = false;
                    this.isSuccess = false;
                    if (this.tablePrintable != null) {
                        this.tablePrintable.setDeleteFileFlag(true);
                    }
                } else {
                    try {
                        final int n7 = collection.size();
                        this.tablePrintable.append(collection, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SaveTask.this.progressBar.setValue(SaveTask.this.progressBar.getValue() + n7);
                            }
                        });
                    }
                    catch (PrinterException printerException) {
                        logger.trace(printerException.getMessage(), printerException);
                        this.isOn = false;
                        this.isSuccess = false;
                        if (this.tablePrintable == null) break block8;
                        this.tablePrintable.setDeleteFileFlag(true);
                    }
                }
            }
            if (null != vector) {
                vector.clear();
                vector = null;
            }
            if (null == collection) continue;
            collection.clear();
            collection = null;
        }
        this.cancelTask();
    }

    public void cancelTask() {
        if (this.tablePrintable != null && !this.isSuccess) {
            this.tablePrintable.setDataOver(true);
        }
        this.tablePrintable = null;
        this.isOn = false;
        this.handler.removeProgress(this.progressBar);
    }

    public SaveAndPrintParameters getSaveAndPrintParameters() {
        if (this.saveAndPrintParameters == null) {
            SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this.dataModel, this.title, this.userName, this.summary, this.fileName, this.parent, this.dataWidth);
            saveAndPrintParameters.setUserEncoding(this.userEncoding);
            return saveAndPrintParameters;
        }
        return this.saveAndPrintParameters;
    }

    public void setSaveAndPrintParameters(SaveAndPrintParameters saveAndPrintParameters) {
        this.saveAndPrintParameters = saveAndPrintParameters;
    }

    private void createProgressDialog(Component component) {
        Window window = null;
        if (null != component && (window = SwingUtilities.windowForComponent(component)) == null && component instanceof Window) {
            window = (Window)component;
        }
        IStop iStop = new IStop(){

            @Override
            public void stop() {
                SaveTask.this.isSuccess = false;
                if (SaveTask.this.tablePrintable != null) {
                    SaveTask.this.tablePrintable.setDeleteFileFlag(true);
                    SaveTask.this.tablePrintable.setSaveCanceled(true);
                }
                SaveTask.this.cancelTask();
            }
        };
        this.handler.setProcess(window);
        this.progressBar = new JProgressBar();
        this.handler.addProgress(this.progressBar, iStop);
    }

    private Collection<String> getVisibleData(Collection collection) {
        if (null == collection) {
            return null;
        }
        Vector<String> vector = new Vector<String>(collection.size());
        for (Object e : collection) {
            if (null == e) continue;
            Vector<String> vector2 = new Vector<String>(1);
            vector2.add(e.toString());
            vector.add((String)((Object)vector2));
        }
        return vector;
    }

    public String getUserEncoding() {
        return this.userEncoding;
    }

    public void setUserEncoding(String string) {
        this.userEncoding = string;
    }
}

