/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.templates.print.FileChooserData;
import com.swimap.iview.templates.print.IDataModel;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.SaveTask;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.io.File;

public class SaveAndPrintUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(SaveAndPrintUtilities.class, "IVIEW");
    private static final int DEFAULT_WIDTH = 300;
    private static final int INIT_CAPACITY = 16;

    public static void save(IDataModel iDataModel, String string, String string2, String string3, String string4, Component component) {
        SaveAndPrintUtilities.save(iDataModel, string, string2, string3, string4, component, 300);
    }

    public static void save(IDataModel iDataModel, String string, String string2, String string3, String string4, Component component, int n) {
        SaveAndPrintUtilities.save(iDataModel, string, string2, string3, string4, component, 300, null);
    }

    public static void save(IDataModel iDataModel, String string, String string2, String string3, String string4, Component component, int n, String string5) {
        if (null == iDataModel || null == string4 || string4.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (iDataModel.getPageSize() <= 0) {
            logger.trace("Wrong page size");
            return;
        }
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(iDataModel, string, string2, string3, string4, component, n);
        saveAndPrintParameters.setUserEncoding(string5);
        SaveTask saveTask = saveAndPrintParameters.initSaveTask();
        saveTask.startTask();
    }

    public static String displaySaveFileChooser(Component component, String string) {
        FileChooserData fileChooserData = SaveAndPrintUtilities.displaySaveFileChooser(component, string, false);
        if (null != fileChooserData) {
            return fileChooserData.getFilePath();
        }
        return null;
    }

    public static FileChooserData displaySaveFileChooser(Component component, String string, boolean bl) {
        FileChooserData fileChooserData = null;
        String string2 = null;
        String string3 = "";
        if (!(string.toLowerCase().endsWith(".txt") || string.toLowerCase().endsWith(".pdf") || string.toLowerCase().endsWith(".html") || string.toLowerCase().endsWith(".xlsx") || string.toLowerCase().endsWith(".xls") || string.toLowerCase().endsWith(".csv"))) {
            string2 = System.getProperty("user.dir");
        } else {
            int n = string.lastIndexOf(System.getProperty("file.separator"));
            if (n < string.length()) {
                string3 = string.substring(n + 1);
            }
            if (n > 0) {
                string2 = string.substring(0, n);
            }
            if (null == string2 || !new File(string2).isDirectory()) {
                string2 = System.getProperty("user.dir");
            }
        }
        SaveFileChooser saveFileChooser = new SaveFileChooser(string2, true, true);
        saveFileChooser.setEncodingEnabled(bl);
        saveFileChooser.setAcceptAllFileFilterUsed(false);
        saveFileChooser.addChoosableFileFilter(FileChooser.TXT_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.HTML_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.CSV_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.XLSX_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.XLS_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.PDF_FILECHOOSERFILTER);
        saveFileChooser.getTextField(saveFileChooser).setText(string3);
        if (saveFileChooser.showSaveDialog(component) != 0) {
            return fileChooserData;
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(saveFileChooser.getSelectedFile().getPath());
        if (null != stringBuffer && 0 != stringBuffer.length()) {
            FileChooserFilter fileChooserFilter = (FileChooserFilter)saveFileChooser.getFileFilter();
            String string4 = (String)fileChooserFilter.getAllFilters().get(0);
            string4 = '.' + string4;
            String string5 = stringBuffer.toString().toLowerCase();
            if (!string5.endsWith(string4)) {
                stringBuffer.append(string4);
            }
            fileChooserData = new FileChooserData(stringBuffer.toString(), saveFileChooser.getUserEncoding());
            return fileChooserData;
        }
        return fileChooserData;
    }
}

