/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SaveAndPrintFile;
import com.swimap.iview.templates.pagedtable.PagedTable;
import com.swimap.iview.templates.pagedtable.SaveAndPrintInmTableTask;
import com.swimap.iview.templates.pagingtree.client.IPrintSaveData;
import com.swimap.iview.templates.pagingtree.client.PagingTree;
import com.swimap.iview.templates.pagingtree.client.SaveAndPrintTreeTask;
import com.swimap.iview.templates.print.IDataModel;
import com.swimap.iview.templates.print.SaveTask;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JTable;

public class SaveAndPrintParameters {
    private final Component _parent;
    private final String _title;
    private int _startRow;
    private int _endRow;
    private int[] _rows = new int[0];
    private final String _userName;
    private final String _summary;
    private String _fileName;
    private boolean _isAbsolutePath;
    private String _fileType = null;
    private JTable _table = null;
    private SaveAndPrintInmTableTask _pagedTableTask = null;
    private boolean _totleRecordsPosition = false;
    private boolean hasSetTotleRecordsPosition = false;
    private boolean _hasDtdHeader = false;
    private boolean _txtSnapLeft = false;
    private int[] _tableHeadersProperty = null;
    private int totalRecordCount = -1;
    private PropertyChangeListener[] printablePropChangeListeners = null;
    private PrintRequestAttributeSet printRequestAttributeSet = null;
    private boolean _isNonContiguousSave = false;
    private int htmlPerColWidth = 0;
    private IDataModel dataModel = null;
    private int dataWidth = 0;
    private PagingTree _tree = null;
    private SaveAndPrintTreeTask _pagingTreeTask = null;
    private IPrintSaveData printSaveData = null;
    String userEncoding = null;

    public SaveAndPrintParameters(ExtendedTable extendedTable, Component component, int n, int n2, String string, String string2, String string3, String string4) {
        if (n >= 0 && n2 >= n && n2 < extendedTable.getRowCount()) {
            this._rows = new int[n2 - n + 1];
            for (int i = 0; i < this._rows.length; ++i) {
                this._rows[i] = n++;
            }
        }
        this._table = extendedTable;
        this._parent = component;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
    }

    public SaveAndPrintParameters(ExtendedTable extendedTable, Component component, int[] nArray, String string, String string2, String string3, String string4) {
        this._table = extendedTable;
        this._parent = component;
        this._rows = nArray;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
    }

    public SaveAndPrintParameters(PagedTable pagedTable, Component component, int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this._table = pagedTable;
        this._parent = component;
        this._startRow = n;
        this._endRow = n2;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
        this._isAbsolutePath = bl;
    }

    public SaveAndPrintParameters(PagedTable pagedTable, Component component, int[] nArray, String string, String string2, String string3, String string4, boolean bl) {
        if (null == nArray) {
            throw new IllegalArgumentException("rows argument cannot be null");
        }
        this._table = pagedTable;
        this._parent = component;
        this._startRow = 0;
        this._endRow = 0;
        this._rows = nArray;
        this._isNonContiguousSave = true;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
        this._isAbsolutePath = bl;
    }

    public SaveAndPrintParameters(IDataModel iDataModel, String string, String string2, String string3, String string4, Component component, int n) {
        this.dataModel = iDataModel;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
        this._parent = component;
        this.dataWidth = n;
    }

    public SaveAndPrintParameters(PagingTree pagingTree, Component component, int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this._tree = pagingTree;
        this._parent = component;
        this._startRow = n;
        this._endRow = n2;
        this._title = string == null ? "" : string;
        this._userName = string2 == null ? "" : string2;
        this._summary = string3 == null ? "" : string3;
        this._fileName = string4;
        this._isAbsolutePath = bl;
    }

    public SaveAndPrintFile initExtSaveTask() {
        if (!(this._table instanceof ExtendedTable)) {
            return null;
        }
        ExtendedTable extendedTable = (ExtendedTable)this._table;
        SaveAndPrintFile saveAndPrintFile = null;
        if (this.initFilePath(this._parent, this._fileName, this._isAbsolutePath)) {
            saveAndPrintFile = new SaveAndPrintFile(extendedTable, this._parent, this._rows, this._title, this._userName, this._summary, this._fileName, this._fileType);
            saveAndPrintFile.setSaveAndPrintParameters(this);
            return saveAndPrintFile;
        }
        return null;
    }

    public SaveAndPrintInmTableTask initPagSaveTask() {
        if (!(this._table instanceof PagedTable)) {
            return null;
        }
        PagedTable pagedTable = null;
        pagedTable = (PagedTable)this._table;
        SaveAndPrintInmTableTask saveAndPrintInmTableTask = null;
        --this._startRow;
        if (this._startRow > this._endRow) {
            return null;
        }
        if (this._isNonContiguousSave && this._rows.length == 0) {
            return null;
        }
        if (this._pagedTableTask != null && this._pagedTableTask.isOn) {
            this._pagedTableTask.cancel_exception();
            return null;
        }
        if (this.initFilePath(this._parent, this._fileName, this._isAbsolutePath)) {
            saveAndPrintInmTableTask = this._isNonContiguousSave ? new SaveAndPrintInmTableTask(this._parent, this._title, this._rows, this._fileName, this._fileType, this._userName, pagedTable, this._summary, 2) : new SaveAndPrintInmTableTask(this._parent, this._title, this._startRow, this._endRow, this._fileName, this._fileType, this._userName, pagedTable, this._summary, 2);
            saveAndPrintInmTableTask.setUserEncoding(this.getUserEncoding());
            saveAndPrintInmTableTask.setSaveAndPrintParameters(this);
            return saveAndPrintInmTableTask;
        }
        return null;
    }

    public void enableAbsolutePath(boolean bl) {
        this._isAbsolutePath = bl;
    }

    public SaveAndPrintFile initExtPrintTask() {
        if (!(this._table instanceof ExtendedTable)) {
            return null;
        }
        ExtendedTable extendedTable = (ExtendedTable)this._table;
        SaveAndPrintFile saveAndPrintFile = new SaveAndPrintFile(extendedTable, this._parent, this._rows, this._title, this._userName, this._summary, this._fileName, this._fileType);
        saveAndPrintFile.setSaveAndPrintParameters(this);
        return saveAndPrintFile;
    }

    public SaveAndPrintInmTableTask initPagPrintTask() {
        if (!(this._table instanceof PagedTable)) {
            return null;
        }
        PagedTable pagedTable = (PagedTable)this._table;
        SaveAndPrintInmTableTask saveAndPrintInmTableTask = null;
        --this._startRow;
        if (this._startRow > this._endRow) {
            return null;
        }
        if (this._pagedTableTask != null && this._pagedTableTask.isOn) {
            this._pagedTableTask.cancel_exception();
            return null;
        }
        saveAndPrintInmTableTask = new SaveAndPrintInmTableTask(this._parent, this._title, this._startRow, this._endRow, this._fileName, this._fileType, this._userName, pagedTable, this._summary, 1);
        saveAndPrintInmTableTask.setSaveAndPrintParameters(this);
        return saveAndPrintInmTableTask;
    }

    public SaveAndPrintTreeTask initTreePrintTask() {
        if (this._tree == null) {
            return null;
        }
        SaveAndPrintTreeTask saveAndPrintTreeTask = null;
        if (this._pagingTreeTask != null && this._pagingTreeTask.isOn()) {
            this._pagingTreeTask.stopTask();
            return null;
        }
        saveAndPrintTreeTask = new SaveAndPrintTreeTask(this._parent, this._title, this._startRow, this._endRow, this._fileName, this._fileType, this._userName, this._tree, this._summary, 1);
        if (null != this.printSaveData) {
            saveAndPrintTreeTask.setPagingTreeData(this.printSaveData);
        }
        saveAndPrintTreeTask.setSaveAndPrintParameters(this);
        return saveAndPrintTreeTask;
    }

    public SaveAndPrintTreeTask initTreeSaveTask() {
        if (this._tree == null) {
            return null;
        }
        SaveAndPrintTreeTask saveAndPrintTreeTask = null;
        if (this._pagingTreeTask != null && this._pagingTreeTask.isOn()) {
            this._pagingTreeTask.stopTask();
            return null;
        }
        if (this.initFilePath(this._parent, this._fileName, this._isAbsolutePath)) {
            saveAndPrintTreeTask = new SaveAndPrintTreeTask(this._parent, this._title, this._startRow, this._endRow, this._fileName, this._fileType, this._userName, this._tree, this._summary, 2);
            if (null != this.printSaveData) {
                saveAndPrintTreeTask.setPagingTreeData(this.printSaveData);
            }
            saveAndPrintTreeTask.setSaveAndPrintParameters(this);
            return saveAndPrintTreeTask;
        }
        return null;
    }

    public boolean initFilePath(Component component, String string, boolean bl) {
        if (bl) {
            this._fileName = string;
            this._fileType = this.getFileNameEnd(string);
            return true;
        }
        return this.preSave(component, string);
    }

    public TablePrintable createTablePrintable(String[] stringArray, Collection collection, int n, boolean bl) {
        Object object;
        int[] nArray = null;
        if (null != this._table) {
            if (this._table instanceof PagedTable && !bl) {
                object = (PagedTable)this._table;
                nArray = ((PagedTable)object).getPrintPreviewColumnWidths();
            } else if (this._table instanceof ExtendedTable && !bl) {
                object = (ExtendedTable)this._table;
                nArray = ((ExtendedTable)object).getPrintPreviewColumnWidths();
            }
        }
        if (null != this._tree) {
            nArray = this._tree.getColumnWidths();
        }
        object = new TablePrintable(this._title, this._userName, this._summary, stringArray, nArray, collection, n, bl);
        ((TablePrintable)object).setTotalRecordCount(this.totalRecordCount);
        ((TablePrintable)object).setTotleRecordsPosition(this._totleRecordsPosition);
        ((TablePrintable)object).setTxtSnapLeft(this._txtSnapLeft);
        ((TablePrintable)object).setHasDtdHeader(this._hasDtdHeader);
        ((TablePrintable)object).setTableHeadersProperty(this.getTableHeadersProperty());
        if (this.printablePropChangeListeners != null && this.printablePropChangeListeners.length != 0) {
            for (int i = 0; i < this.printablePropChangeListeners.length; ++i) {
                ((TablePrintable)object).addPropertyChangeListener(this.printablePropChangeListeners[i]);
            }
        }
        return object;
    }

    public JTable getTable() {
        return this._table;
    }

    public void setTotleRecordsPosition(boolean bl) {
        this._totleRecordsPosition = bl;
        this.hasSetTotleRecordsPosition = true;
    }

    public boolean hasSetTotleRecordsPosition() {
        return this.hasSetTotleRecordsPosition;
    }

    public void setHasDtdHeader(boolean bl) {
        this._hasDtdHeader = bl;
    }

    public void setTxtSnapLeft(boolean bl) {
        this._txtSnapLeft = bl;
    }

    public void setTableHeadersProperty(int[] nArray) {
        int[] nArray2 = new int[this._table.getModel().getColumnCount()];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray2.length, nArray.length));
        this._tableHeadersProperty = nArray2;
    }

    public int[] getTableHeadersProperty() {
        if (this._tableHeadersProperty == null || this._tableHeadersProperty.length == 0) {
            return null;
        }
        int n = this._table.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this._table.convertColumnIndexToModel(i);
            nArray[i] = this._tableHeadersProperty[n2];
        }
        return nArray;
    }

    public void setPrintablePropChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        this.printablePropChangeListeners = propertyChangeListenerArray;
    }

    private boolean preSave(Component component, String string) {
        SaveFileChooser saveFileChooser = this.createSaveFileChooser(string);
        int n = saveFileChooser.showSaveDialog(component);
        if (n != 0) {
            return false;
        }
        this.userEncoding = saveFileChooser.getUserEncoding();
        String string2 = saveFileChooser.getSelectedFile().getPath();
        if (null != string2 && 0 != string2.length()) {
            FileChooserFilter fileChooserFilter = (FileChooserFilter)saveFileChooser.getFileFilter();
            String string3 = (String)fileChooserFilter.getAllFilters().get(0);
            string3 = '.' + string3;
            String string4 = string2.toLowerCase();
            if (!string4.endsWith(string3)) {
                string2 = string2 + string3;
            }
            this._fileName = string2;
            this._fileType = this.getFileNameEnd(string2);
            if (null != this._table && this._table.getRowCount() > 0) {
                return true;
            }
            if (null != this._tree && this._tree.initPrint() > 0) {
                return true;
            }
            File file = new File(CommonUtil.getAbsolutePath(string2));
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            return false;
        }
        return false;
    }

    private SaveFileChooser createSaveFileChooser(String string) {
        String string2 = System.getProperty("user.dir");
        string2 = string2 + System.getProperty("file.separator");
        String string3 = CommonUtil.getDefaultSavePath();
        if (null != string3 && !"".equals(string3)) {
            string2 = string3;
        }
        SaveFileChooser saveFileChooser = new SaveFileChooser(string2, true);
        saveFileChooser.setEncodingEnabled(true);
        saveFileChooser.setAcceptAllFileFilterUsed(false);
        saveFileChooser.addChoosableFileFilter(FileChooser.TXT_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.HTML_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.CSV_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.PDF_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.XLSX_FILECHOOSERFILTER);
        saveFileChooser.addChoosableFileFilter(FileChooser.XLS_FILECHOOSERFILTER);
        saveFileChooser.getTextField(saveFileChooser).setText(string);
        return saveFileChooser;
    }

    private String getFileNameEnd(String string) {
        String string2 = "csv";
        if (string.toLowerCase().endsWith(".txt")) {
            string2 = "txt";
        } else if (string.toLowerCase().endsWith(".html")) {
            string2 = "html";
        } else if (string.toLowerCase().endsWith(".xls")) {
            string2 = "xls";
        } else if (string.toLowerCase().endsWith(".xlsx")) {
            string2 = "xlsx";
        } else if (string.toLowerCase().endsWith(".pdf")) {
            string2 = "pdf";
        }
        return string2;
    }

    public void setTotalRecordCount(int n) {
        this.totalRecordCount = n;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        this.printRequestAttributeSet = printRequestAttributeSet;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    public void setHtmlPerColWidth(int n) {
        this.htmlPerColWidth = n;
    }

    public int getHtmlPerColWidth() {
        return this.htmlPerColWidth;
    }

    public SaveTask initSaveTask() {
        SaveTask saveTask = null;
        this._fileType = this.getFileNameEnd(this._fileName);
        saveTask = new SaveTask(this.dataModel, this._title, this._userName, this._summary, this._fileName, this._fileType, this._parent, this.dataWidth);
        saveTask.setSaveAndPrintParameters(this);
        saveTask.setUserEncoding(this.userEncoding);
        return saveTask;
    }

    public TablePrintable createTablePrintable(String[] stringArray, Collection collection, int n, boolean bl, int n2) {
        int[] nArray = new int[]{n2};
        TablePrintable tablePrintable = new TablePrintable(this._title, this._userName, this._summary, stringArray, nArray, collection, n, bl);
        tablePrintable.setTotalRecordCount(this.totalRecordCount);
        tablePrintable.setTotleRecordsPosition(this._totleRecordsPosition);
        return tablePrintable;
    }

    public void setPagingTreeData(IPrintSaveData iPrintSaveData) {
        this.printSaveData = iPrintSaveData;
    }

    public String getUserEncoding() {
        return this.userEncoding;
    }

    public void setUserEncoding(String string) {
        this.userEncoding = string;
    }
}

