/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.format.FormatException;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;

public abstract class PrintableTool
implements Printable,
Cloneable {
    private static IviewLogger logger = IviewLogger.getLogger(PrintableTool.class, "IVIEW");
    protected static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    protected static final Graphics2D standardGraphics = new BufferedImage(10, 10, 2).createGraphics();
    private static boolean isSetScale;
    private static final int FONT_SIZE = 12;
    private static final Font TABLE_PRINT_FONT;
    protected static Font headFont;
    private boolean dataOver = false;
    protected String title = null;
    protected String userName = null;
    protected boolean headInfoEnabled = false;
    protected boolean areaBoxEnabled = false;
    protected static final String blank = "  ";
    protected static int headfactor;
    public static final int MIN_IMAGEABLE_WIDTH = 30;
    private static final double LINE2D_X = 36.0;
    private static final double LINE2D_Y = 20.0;
    protected String printTimeText = null;
    protected int startY = 0;
    protected int startYbackup = 0;
    protected int endY = 0;

    public PrintableTool() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            this.printTimeText = TimeDateFormatUtil.getFormatDateTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(16) / 1000, gregorianCalendar.get(15) / 1000);
        }
        catch (FormatException formatException) {
            this.printTimeText = gregorianCalendar.getTime().toString();
            logger.trace(formatException.getMessage(), formatException);
        }
    }

    public PrintableTool(String string, String string2) {
        this.title = string;
        this.userName = string2;
        this.headInfoEnabled = true;
        headFont = TABLE_PRINT_FONT;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            this.printTimeText = TimeDateFormatUtil.getFormatDateTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(16) / 1000, gregorianCalendar.get(15) / 1000);
        }
        catch (FormatException formatException) {
            this.printTimeText = gregorianCalendar.getTime().toString();
            logger.trace(formatException.getMessage(), formatException);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 || n >= this.getPageCount(pageFormat) || this.isDataOver()) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        graphics2D.translate(d, d2);
        this.drawCropMarks(graphics2D, pageFormat);
        if (this.headInfoEnabled) {
            this.drawHeadInfo(graphics2D, pageFormat, n);
        }
        if (this.areaBoxEnabled) {
            this.drawAreaBox(graphics2D, pageFormat, n);
        }
        this.drawPage(graphics2D, pageFormat, n);
        graphics2D.translate(-d, -d2);
        if (this.isDataOver()) {
            return 1;
        }
        return 0;
    }

    public boolean isDataOver() {
        return this.dataOver;
    }

    public void setDataOver(boolean bl) {
        this.dataOver = bl;
    }

    public boolean isHeadInfoEnabled() {
        return this.headInfoEnabled;
    }

    public void setHeadInfoEnabled(boolean bl) {
        this.headInfoEnabled = bl;
    }

    public boolean isAreaBoxEnabled() {
        return this.areaBoxEnabled;
    }

    public void setAreaBoxEnabled(boolean bl) {
        this.areaBoxEnabled = bl;
    }

    public abstract int getPageCount();

    public int getPageCount(PageFormat pageFormat) {
        return this.getPageCount();
    }

    protected abstract void drawPage(Graphics2D var1, PageFormat var2, int var3);

    protected void drawHeadInfo(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4 = PrintableTool.getFontHeight(headFont);
        int n5 = PrintableTool.getFontDescent(headFont);
        int n6 = (int)pageFormat.getImageableWidth();
        if (n6 < 30) {
            logger.trace("don't drawHeadInfo. reason:ImageTableWidth can't be less MIN_IMAGEABLE_WIDTH");
            headfactor = 0;
            return;
        }
        graphics2D.setFont(headFont);
        this.title = this.title == null || this.title.length() == 0 ? "(untitled)" : this.title;
        this.userName = this.userName == null || this.userName.length() == 0 ? "(unknown user)" : this.userName;
        graphics2D.setPaint(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(headFont);
        int n7 = 0;
        int n8 = 0;
        if (n3 < n6) {
            ++n8;
            n7 = (n6 - n3) / 2;
            graphics2D.drawString(this.title, n7, n4 - n5 + 3 + this.startY);
        } else {
            int n9;
            int n10 = 0;
            for (n3 = fontMetrics.stringWidth(this.title); n3 >= n6; n3 -= fontMetrics.stringWidth(this.title.substring(n10, n9 + n10))) {
                n9 = 0;
                while (n9 + n10 < this.title.length() && fontMetrics.stringWidth(this.title.substring(n10, n9 + n10)) < n6) {
                    ++n9;
                }
                while (n9 + n10 <= this.title.length() && fontMetrics.stringWidth(this.title.substring(n10, n9 + n10)) >= n6) {
                    --n9;
                }
                n7 = (n6 - fontMetrics.stringWidth(this.title.substring(n10, n9 + n10))) / 2;
                graphics2D.drawString(this.title.substring(n10, n9 + n10), n7, n4 * ++n8 - n5 + 3 + this.startY);
                n10 = n9 + n10;
            }
            if (this.title.substring(n10).length() > 0) {
                n7 = (n6 - fontMetrics.stringWidth(this.title.substring(n10))) / 2;
                graphics2D.drawString(this.title.substring(n10), n7, n4 * ++n8 - n5 + 3 + this.startY);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(res.getString("printTime"));
        stringBuffer.append(this.printTimeText);
        stringBuffer.append("    ");
        stringBuffer.append(res.getString("userName"));
        stringBuffer.append(this.userName);
        stringBuffer.append(blank + res.getString("currentPage"));
        stringBuffer.append(n + 1);
        String string = stringBuffer.toString();
        int n11 = 0;
        if (n2 < n6) {
            headfactor = n8 + 1;
            n11 = (n6 - n2) / 2;
            graphics2D.draw(new Rectangle2D.Double(0.0, this.startY, n6, this.getHeadHeight()));
            graphics2D.drawString(string, n11, n4 * (n8 + 1) - n5 + 3 + this.startY);
        } else {
            int n12;
            int n13 = 0;
            for (n2 = fontMetrics.stringWidth(string); n2 >= n6; n2 -= fontMetrics.stringWidth(string.substring(n13, n12 + n13))) {
                n12 = 0;
                while (fontMetrics.stringWidth(string.substring(n13, n12 + n13)) < n6) {
                    ++n12;
                }
                while (fontMetrics.stringWidth(string.substring(n13, n12 + n13)) > n6) {
                    --n12;
                }
                n11 = (n6 - fontMetrics.stringWidth(string.substring(n13, n12 + n13))) / 2;
                graphics2D.drawString(string.substring(n13, n12 + n13), n11, n4 * ++n8 - n5 + 3 + this.startY);
                n13 = n12 + n13;
            }
            if (string.substring(n13).length() > 0) {
                n11 = (n6 - fontMetrics.stringWidth(string.substring(n13))) / 2;
                graphics2D.drawString(string.substring(n13), n11, n4 * ++n8 - n5 + 3 + this.startY);
            }
            headfactor = n8;
            graphics2D.draw(new Rectangle2D.Double(0.0, this.startY, n6, this.getHeadHeight()));
        }
    }

    protected void drawAreaBox(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, d, d2));
    }

    protected int getHeadHeight() {
        if (this.headInfoEnabled) {
            return PrintableTool.getFontHeight(headFont) * headfactor + 6;
        }
        return 0;
    }

    public static int getHeadHeight(boolean bl) {
        if (bl) {
            return PrintableTool.getFontHeight(headFont) * headfactor + 6;
        }
        return 0;
    }

    protected static int getCharsWidth(char[] cArray, int n, int n2, Font font) {
        FontMetrics fontMetrics = standardGraphics.getFontMetrics(font);
        int n3 = fontMetrics.charsWidth(cArray, n, n2);
        return n3;
    }

    protected static int getTextWidth(String string, Font font) {
        FontMetrics fontMetrics = standardGraphics.getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    protected static int getFontHeight(Font font) {
        FontMetrics fontMetrics = standardGraphics.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    protected static int getFontDescent(Font font) {
        FontMetrics fontMetrics = standardGraphics.getFontMetrics(font);
        return fontMetrics.getDescent();
    }

    public Object clone() {
        PrintableTool printableTool = null;
        try {
            printableTool = (PrintableTool)super.clone();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return printableTool;
    }

    public void setScale(double d) {
        if (isSetScale) {
            standardGraphics.scale(d, d);
            isSetScale = false;
        }
    }

    private void drawCropMarks(Graphics2D graphics2D, PageFormat pageFormat) {
        double d = 36.0;
        double d2 = 20.0;
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics2D.setPaint(Color.black);
        graphics2D.draw(new Line2D.Double(-d2, -d2, -d2, d - d2));
        graphics2D.draw(new Line2D.Double(-d2, -d2, d - d2, -d2));
        graphics2D.draw(new Line2D.Double(d3 + d2, -d2, d3 + d2, d - d2));
        graphics2D.draw(new Line2D.Double(d3 + d2, -d2, d3 - d + d2, -d2));
        graphics2D.draw(new Line2D.Double(-d2, d4 + d2, -d2, d4 - d + d2));
        graphics2D.draw(new Line2D.Double(-d2, d4 + d2, d - d2, d4 + d2));
        graphics2D.draw(new Line2D.Double(d3 + d2, d4 + d2, d3 + d2, d4 - d + d2));
        graphics2D.draw(new Line2D.Double(d3 + d2, d4 + d2, d3 - d + d2, d4 + d2));
    }

    public String getTitle() {
        return this.title;
    }

    public void setStartY(int n) {
        if (n != 0) {
            this.startYbackup = n;
        }
        this.startY = n;
    }

    public int getEndY() {
        return this.endY;
    }

    static {
        standardGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        isSetScale = true;
        headFont = TABLE_PRINT_FONT = new Font("Dialog", 1, 12);
        headfactor = 2;
    }
}

