/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.tools.MultiTablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.SwingUtilities;

final class PrintThread
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(PrintThread.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    private Window mainFrame = null;
    private PrinterJob printerJob = null;
    private PrintRequestAttributeSet attributeSet = null;
    private PrintableTool printImp = null;

    PrintThread(Window window, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
        this.mainFrame = window;
        this.printerJob = printerJob;
        this.attributeSet = printRequestAttributeSet;
    }

    PrintThread(Window window, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, Object object) {
        this.mainFrame = window;
        this.printerJob = printerJob;
        this.attributeSet = printRequestAttributeSet;
        if (object instanceof Printable && object instanceof PrintableTool) {
            this.printImp = (PrintableTool)object;
        }
    }

    @Override
    public void run() {
        try {
            this.printerJob.print(this.attributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            if (this.printImp instanceof TablePrintImpl) {
                FormatCalculator formatCalculator = ((TablePrintImpl)this.printImp).getFormatCalculator();
                formatCalculator.setForceAppendOver();
            } else if (this.printImp instanceof MultiTablePrintImpl) {
                ((MultiTablePrintImpl)this.printImp).setForceAppendOver();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(PrintThread.this.mainFrame, res.getString("PrintExit"), res.getString("Error"), 0);
                }
            });
        }
        if (this.printImp != null) {
            this.printImp.setDataOver(true);
        }
    }
}

