/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.FileSavingThread;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PageableTool;
import com.swimap.iview.templates.print.PreviewDialog;
import com.swimap.iview.templates.print.PrintPreviewPanel;
import com.swimap.iview.templates.print.PrintServiceUI;
import com.swimap.iview.templates.print.PrintThread;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.ScriptObject;
import com.swimap.iview.templates.print.ScriptObjectFactory;
import com.swimap.iview.templates.print.tools.HTMLPrintHandler;
import com.swimap.iview.templates.print.tools.MultiTablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.print.tools.XLSSaveImpl;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileLockTool;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sun.print.ServiceDialog;

public class PrintSupportor {
    private static IviewLogger logger = IviewLogger.getLogger(PrintSupportor.class, "IVIEW");
    public static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    public static PrintRequestAttributeSet printRequestAttributeSet = null;
    protected static PageFormat pageFormat = null;
    protected static PreviewDialog previewDialog = null;
    public static final String PRINTSERVICE_CLASSNAME = "sun.print.Win32PrintService";
    public static final String OFFICE2003_PRINTER_PORT = "Microsoft Document Imaging Writer Port:";
    public static final String OFFICE2003_PRINTER_NAME = "Microsoft Office Document Image Writer";
    public static final double MM_TO_PAPER_UNITS = 2.8346456692913384;
    private static final String LINE_SEPARATOR_N = "\n";
    private static final double SCREEN_SCALE = 0.7348484848485;
    protected static double screenScale = 0.7348484848485;
    private static final double INCH_TO_PARER_UNITS = 72.0;
    private static final double MARGIN_COUNT = 2.0;
    private static final double A4_WIDTH_TO_MM = 210.0;
    private static final double A4_HEIGHT_TO_MM = 297.0;
    private static final int ASCII_VALUE = 127;
    private static final int POINT_X = 100;
    private static final int POINT_Y = 100;
    private static String[] csvOrXlsFileNames = null;
    private static boolean pageSetupCancelPressed = false;
    protected static JDialog parentFrame = null;
    private static boolean done = false;

    public static String[] getCsvOrXlsFileNames() {
        return csvOrXlsFileNames;
    }

    public static void setCsvOrXlsFileNames(String[] stringArray) {
        csvOrXlsFileNames = stringArray;
    }

    public static void preview(JFrame jFrame, TablePrintable tablePrintable, int n) {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        PrintSupportor.preview(jFrame, tablePrintable, n, pageFormat, printRequestAttributeSet);
    }

    public static void preview(JFrame jFrame, TablePrintable tablePrintable, int n, PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        if (pageFormat == null && (pageFormat = PrintSupportor.pageFormat) == null) {
            PrintSupportor.pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
            pageFormat = PrintSupportor.pageFormat;
        }
        TablePrintImpl tablePrintImpl = null;
        if (null != tablePrintable) {
            tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
            tablePrintable.setImplRef(tablePrintImpl);
            tablePrintImpl.getFormatCalculator().setPageFormatWithCompute(pageFormat);
        }
        PrintSupportor.preview(jFrame, tablePrintImpl, n, pageFormat, printRequestAttributeSet);
    }

    public static void preview(JFrame jFrame, TablePrintable[] tablePrintableArray, int n, PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        PageFormat pageFormat2 = pageFormat;
        if (pageFormat2 == null && (pageFormat2 = PrintSupportor.pageFormat) == null) {
            PrintSupportor.pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
            pageFormat2 = PrintSupportor.pageFormat;
        }
        if (null == tablePrintableArray || tablePrintableArray.length == 0) {
            throw new IllegalArgumentException("The tablePrintables parameter cannot be null and length cannot be 0");
        }
        TablePrintImpl[] tablePrintImplArray = new TablePrintImpl[tablePrintableArray.length];
        TablePrintable tablePrintable = null;
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            tablePrintable = tablePrintableArray[i];
            if (null == tablePrintable) {
                throw new IllegalArgumentException("The parameter tablePrintables contains a null value at" + i);
            }
            tablePrintImplArray[i] = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
            tablePrintable.setImplRef(tablePrintImplArray[i]);
        }
        tablePrintImplArray[0].getFormatCalculator().setPageFormatWithCompute(pageFormat2);
        MultiTablePrintImpl multiTablePrintImpl = new MultiTablePrintImpl(tablePrintImplArray);
        PrintSupportor.preview(jFrame, multiTablePrintImpl, n, pageFormat2, printRequestAttributeSet);
    }

    private static void changePageFormat() {
        Paper paper = new Paper();
        paper.setSize(595.275590551181, 841.8897637795275);
        paper.setImageableArea(72.0, 72.0, 451.27559055118104, 697.8897637795275);
        pageFormat.setPaper(paper);
    }

    public static void preview(JFrame jFrame, Printable printable, int n) {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        PrintSupportor.preview(jFrame, printable, n, pageFormat, printRequestAttributeSet);
    }

    public static void preview(JFrame jFrame, Printable object, int n, PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        Object object2;
        if (!(object instanceof PrintableTool) && n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageCount can't be negative:" + n);
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        if (pageFormat == null && (pageFormat = PrintSupportor.pageFormat) == null) {
            PrintSupportor.pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
            pageFormat = PrintSupportor.pageFormat;
        }
        if (object instanceof PrintableTool) {
            object2 = (PrintableTool)object;
            object2 = (PrintableTool)((PrintableTool)object2).clone();
            ((PrintableTool)object2).setScale(screenScale);
            object = object2;
            n = ((PrintableTool)object).getPageCount();
        }
        object2 = new PageableTool();
        ((PageableTool)object2).append((Printable)object, pageFormat == PrintSupportor.pageFormat ? PrintSupportor.getPageFormat() : pageFormat, n);
        PrintSupportor.preview(jFrame, (Pageable)object2, printRequestAttributeSet);
    }

    public static void preview(JFrame jFrame, Pageable pageable) {
        if (pageable.getNumberOfPages() < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageable.getNumberOfPages() can't be negative" + pageable.getNumberOfPages());
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        PrintSupportor.preview(jFrame, pageable, printRequestAttributeSet);
    }

    private static void preview(JFrame jFrame, Pageable pageable, PrintRequestAttributeSet printRequestAttributeSet) {
        Window window = PrintSupportor.getParentFrame(jFrame);
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        if (!PrintSupportor.isPageFormatValid()) {
            return;
        }
        if (null == pageable || pageable.getNumberOfPages() == 0) {
            if (null != pageable && pageable.getPrintable(0) instanceof TablePrintImpl) {
                TablePrintImpl tablePrintImpl = (TablePrintImpl)pageable.getPrintable(0);
                if (tablePrintImpl.getFormatCalculator() != null && !tablePrintImpl.getFormatCalculator().getHeaderError()) {
                    OptionPane.showMessageDialog(window, res.getString("EmptyPage"), res.getString("Error"), 0);
                    return;
                }
            } else {
                OptionPane.showMessageDialog(window, res.getString("EmptyPage"), res.getString("Error"), 0);
                return;
            }
        }
        if (previewDialog != null && previewDialog.isVisible()) {
            previewDialog.closeWindow();
        }
        if (window instanceof JFrame || null == window) {
            previewDialog = new PreviewDialog((JFrame)window, pageable, printRequestAttributeSet);
        } else if (window instanceof JDialog) {
            previewDialog = new PreviewDialog((JDialog)window, pageable, printRequestAttributeSet);
        } else {
            logger.trace("PrintSupportor-preview-Only JDialog and JFrame are supported");
            return;
        }
        previewDialog.setVisible(true);
    }

    public static void printFile(final JFrame jFrame, String string) {
        ScriptObject scriptObject = null;
        try {
            scriptObject = ScriptObjectFactory.getScriptObject(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(jFrame, res.getString("checkFileValid"));
                }
            });
            return;
        }
        DocFlavor docFlavor = scriptObject.getDocFlavor();
        Object object = scriptObject.getPrintData();
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        PrintSupportor.print((Window)jFrame, object, docFlavor, printRequestAttributeSet);
    }

    public static JPanel getPreviewPanel(JFrame jFrame, Pageable pageable) {
        if (pageable.getNumberOfPages() < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageable.getNumberOfPages() can't be negative" + pageable.getNumberOfPages());
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        if (!PrintSupportor.isPageFormatValid()) {
            return null;
        }
        if (pageable.getNumberOfPages() == 0) {
            OptionPane.showMessageDialog(jFrame, res.getString("EmptyPage"), res.getString("Error"), 0);
            return null;
        }
        if (previewDialog != null && previewDialog.isVisible()) {
            previewDialog.closeWindow();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        previewDialog = new PreviewDialog(jFrame, pageable, printRequestAttributeSet);
        return previewDialog.getPrintPreviewPanel();
    }

    public static JButton getPreviewPanelCloseBut(JPanel jPanel) {
        if (jPanel instanceof PrintPreviewPanel) {
            return ((PrintPreviewPanel)jPanel).getCloseButton();
        }
        return null;
    }

    public static JPanel getPreviewPanel(JFrame jFrame, Printable object, int n) {
        Object object2;
        if (!(object instanceof PrintableTool) && n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageCount can't be negative" + n);
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        if (object instanceof PrintableTool) {
            object2 = (PrintableTool)object;
            object2 = (PrintableTool)((PrintableTool)object2).clone();
            ((PrintableTool)object2).setScale(screenScale);
            object = object2;
            n = ((PrintableTool)object).getPageCount();
        }
        object2 = new PageableTool();
        ((PageableTool)object2).append((Printable)object, PrintSupportor.getPageFormat(), n);
        return PrintSupportor.getPreviewPanel(jFrame, (Pageable)object2);
    }

    public static JPanel getPreviewPanel(JFrame jFrame, TablePrintable tablePrintable, int n) {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        TablePrintImpl tablePrintImpl = null;
        if (null != tablePrintable) {
            tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
            tablePrintable.setImplRef(tablePrintImpl);
            tablePrintImpl.getFormatCalculator().setPageFormatWithCompute(pageFormat);
        }
        return PrintSupportor.getPreviewPanel(jFrame, tablePrintImpl, n);
    }

    public static boolean saveToFile(JFrame jFrame, String string, TablePrintable tablePrintable, String string2) {
        if (!PrintSupportor.isFileVaild(jFrame, string, string2)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(jFrame, string, tablePrintable, string2.toLowerCase());
    }

    public static boolean saveToFile(JFrame jFrame, String string, TablePrintable tablePrintable, String string2, String string3) {
        if (!PrintSupportor.isFileVaild(jFrame, string, string2)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(jFrame, string, tablePrintable, string2.toLowerCase(), string3);
    }

    public static boolean saveToFileNoCheck(JFrame jFrame, String string, TablePrintable tablePrintable, String string2) {
        Thread thread = PrintSupportor.createThread(jFrame, string, tablePrintable, string2);
        if (null == thread) {
            return false;
        }
        thread.start();
        return true;
    }

    public static boolean saveToFileNoCheck(JFrame jFrame, String string, TablePrintable tablePrintable, String string2, String string3) {
        Thread thread = PrintSupportor.createThread(jFrame, string, tablePrintable, string2);
        if (null == thread) {
            return false;
        }
        ((FileSavingThread)thread).setCustomEncoding(string3);
        thread.start();
        return true;
    }

    private static Thread createThread(JFrame jFrame, String string, TablePrintable tablePrintable, String string2) {
        if (tablePrintable == null) {
            return null;
        }
        FileLockTool fileLockTool = FileLockTool.getInstance();
        fileLockTool.setParentComponent(PrintSupportor.getParentFrame());
        int n = fileLockTool.checkFileState(string);
        if (n == 1) {
            return null;
        }
        Window window = PrintSupportor.getParentFrame(jFrame);
        tablePrintable.getFormatCalculator().setFileType(string2);
        FileSavingThread fileSavingThread = new FileSavingThread(window, string, tablePrintable, string2);
        return fileSavingThread;
    }

    public static boolean saveToFile(JFrame jFrame, String string, TablePrintable[] tablePrintableArray, String string2) {
        if (!PrintSupportor.isFileVaild(jFrame, string, string2)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(jFrame, string, tablePrintableArray, string2.toLowerCase());
    }

    public static boolean saveToFile(JFrame jFrame, String string, TablePrintable[] tablePrintableArray, String string2, String string3) {
        if (!PrintSupportor.isFileVaild(jFrame, string, string2)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(jFrame, string, tablePrintableArray, string2.toLowerCase(), string3);
    }

    public static boolean saveToFileNoCheck(JFrame jFrame, String string, TablePrintable[] tablePrintableArray, String string2) {
        Thread thread = PrintSupportor.createFileSavingThread(jFrame, string, tablePrintableArray, string2);
        if (null == thread) {
            return false;
        }
        thread.start();
        return true;
    }

    private static Thread createFileSavingThread(JFrame jFrame, String string, TablePrintable[] tablePrintableArray, String string2) {
        FileLockTool fileLockTool = FileLockTool.getInstance();
        fileLockTool.setParentComponent(PrintSupportor.getParentFrame());
        int n = fileLockTool.checkFileState(string);
        if (n == 1) {
            return null;
        }
        Window window = PrintSupportor.getParentFrame(jFrame);
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            tablePrintableArray[i].getFormatCalculator().setFileType(string2);
        }
        FileSavingThread fileSavingThread = new FileSavingThread(window, string, tablePrintableArray, string2);
        return fileSavingThread;
    }

    public static boolean saveToFileNoCheck(JFrame jFrame, String string, TablePrintable[] tablePrintableArray, String string2, String string3) {
        FileLockTool fileLockTool = FileLockTool.getInstance();
        fileLockTool.setParentComponent(PrintSupportor.getParentFrame());
        int n = fileLockTool.checkFileState(string);
        if (n == 1) {
            return false;
        }
        Window window = PrintSupportor.getParentFrame(jFrame);
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            tablePrintableArray[i].getFormatCalculator().setFileType(string2);
        }
        FileSavingThread fileSavingThread = new FileSavingThread(window, string, tablePrintableArray, string2);
        fileSavingThread.setCustomEncoding(string3);
        fileSavingThread.start();
        return true;
    }

    public static boolean saveXLStoTemplate(JFrame jFrame, String string, String string2, int n, TablePrintable tablePrintable) {
        if (!PrintSupportor.isFileVaild(jFrame, string2, "xls")) {
            return false;
        }
        File file = new File(string);
        if (!file.exists() || !string.endsWith("xls")) {
            logger.trace("Template file doesnot exist, no data saved in the specified location");
            return false;
        }
        FileLockTool fileLockTool = FileLockTool.getInstance();
        fileLockTool.setParentComponent(PrintSupportor.getParentFrame());
        int n2 = fileLockTool.checkFileState(string2);
        if (n2 == 1) {
            logger.trace("File already locked by other application");
            return false;
        }
        Window window = PrintSupportor.getParentFrame(jFrame);
        tablePrintable.getFormatCalculator().setFileType("xls");
        FileSavingThread fileSavingThread = new FileSavingThread(window, string2, tablePrintable, "xls");
        XLSSaveImpl xLSSaveImpl = (XLSSaveImpl)tablePrintable.getImplRef();
        xLSSaveImpl.setSheetIndex(n);
        xLSSaveImpl.setTemplateFile(string);
        fileSavingThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileVaild(JFrame jFrame, String string, String string2) {
        Window window = PrintSupportor.getParentFrame(jFrame);
        String string3 = string.toLowerCase();
        String string4 = string2 = string2 == null ? "" : string2;
        if ("html".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".html") && !string3.endsWith(".htm")) {
                string = new StringBuffer(string).append(".html").toString();
            }
        } else if ("txt".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".txt")) {
                string = new StringBuffer(string).append(".txt").toString();
            }
        } else if ("csv".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".csv")) {
                string = new StringBuffer(string).append(".csv").toString();
            }
        } else if ("xml".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".xml")) {
                string = new StringBuffer(string).append(".xml").toString();
            }
        } else if ("xls".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".xls")) {
                string = new StringBuffer(string).append(".xls").toString();
            }
        } else if ("pdf".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".pdf")) {
                string = new StringBuffer(string).append(".pdf").toString();
            }
        } else if ("xlsx".equalsIgnoreCase(string2)) {
            if (!string3.endsWith(".xlsx")) {
                string = new StringBuffer(string).append(".xlsx").toString();
            }
        } else {
            OptionPane.showMessageDialog(window, res.getString("FILE_TYPE_NOT_HTML_TXT"), res.getString("Error"), 0);
            return false;
        }
        if (!PrintSupportor.isFileNameValid(string)) {
            OptionPane.showMessageDialog(window, res.getString("FILENAME_ERROR"), res.getString("Error"), 0);
            return false;
        }
        File file = new File(CommonUtil.getAbsolutePath(string));
        if (file.exists()) {
            if (file.canWrite()) {
                int n = OptionPane.showConfirmDialog(window, res.getString("coverFile"), res.getString("confirmTitle"), 0);
                if (n != 0) {
                    return false;
                }
            } else {
                OptionPane.showMessageDialog(window, res.getString("readOnly"), res.getString("Error"), 0);
                return false;
            }
            if (1 == FileLockTool.getInstance().checkFileState(string)) {
                return false;
            }
        }
        BufferedWriter bufferedWriter = null;
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdir();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            OptionPane.showMessageDialog(window, res.getString("SAVE_EXIT"), res.getString("Error"), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                    boolean bl = file.delete();
                    if (!bl) {
                        logger.trace("file deletion failed" + file.getName());
                    }
                    file = null;
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }
        return true;
    }

    public static void setupPage() {
        if (!PrintSupportor.existPrinters()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(PrintSupportor.getParentFrame(), res.getString("ZeroPrinter"));
                }
            });
        } else {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            FrameworkUtilities.getMainFrame().setAlwaysOnTop(true);
            FrameworkUtilities.getMainFrame().setAlwaysOnTop(false);
            PageFormat pageFormat = printerJob.pageDialog(hashPrintRequestAttributeSet);
            if (pageFormat != null) {
                PrintSupportor.pageFormat = pageFormat;
                printRequestAttributeSet = hashPrintRequestAttributeSet;
            } else if (PrintSupportor.pageFormat == null) {
                PrintSupportor.pageFormat = new PageFormat();
                printRequestAttributeSet = new HashPrintRequestAttributeSet();
                printRequestAttributeSet.add(MediaSizeName.ISO_A4);
                PrintSupportor.changePageFormat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageFormat setupPage(PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet == null) {
            throw new IllegalArgumentException("printRequestAttributeSet can not be null");
        }
        if (!PrintSupportor.existPrinters()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(PrintSupportor.getParentFrame(), res.getString("ZeroPrinter"));
                }
            });
            return null;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob == null) {
            return null;
        }
        FrameworkUtilities.getMainFrame().setAlwaysOnTop(true);
        FrameworkUtilities.getMainFrame().setAlwaysOnTop(false);
        PageFormat pageFormat = null;
        done = false;
        PrintSupportor.setPrintHelp();
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), true);
        try {
            pageFormat = printerJob.pageDialog(printRequestAttributeSet);
        }
        finally {
            done = true;
        }
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), false);
        if (pageFormat != null) {
            PrintSupportor.pageFormat = pageFormat;
            PrintSupportor.printRequestAttributeSet = printRequestAttributeSet;
            pageSetupCancelPressed = false;
        } else if (PrintSupportor.pageFormat == null) {
            PrintSupportor.pageFormat = new PageFormat();
            PrintSupportor.printRequestAttributeSet = new HashPrintRequestAttributeSet();
            PrintSupportor.printRequestAttributeSet.add(MediaSizeName.ISO_A4);
            PrintSupportor.changePageFormat();
        }
        if (pageFormat == null) {
            pageSetupCancelPressed = true;
        }
        return PrintSupportor.pageFormat;
    }

    static boolean isCancelPressedOnPageSetup() {
        return pageSetupCancelPressed;
    }

    public static boolean print(JFrame jFrame, Printable printable, int n) {
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        return PrintSupportor.print(jFrame, printable, n, printRequestAttributeSet);
    }

    public static boolean print(JFrame jFrame, Printable printable, int n, PrintRequestAttributeSet printRequestAttributeSet) {
        if (!(printable instanceof PrintableTool) && n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageCount can't be negative" + n);
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        PageableTool pageableTool = new PageableTool();
        pageableTool.append(printable, PrintSupportor.getPageFormat(), n);
        return PrintSupportor.print(jFrame, pageableTool, printRequestAttributeSet);
    }

    public static boolean print(JFrame jFrame, TablePrintable tablePrintable, int n) {
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        return PrintSupportor.print(jFrame, tablePrintable, n, printRequestAttributeSet);
    }

    public static boolean print(JFrame jFrame, TablePrintable tablePrintable, int n, PrintRequestAttributeSet printRequestAttributeSet) {
        TablePrintImpl tablePrintImpl = null;
        if (null != tablePrintable) {
            tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
            tablePrintable.setImplRef(tablePrintImpl);
        }
        return PrintSupportor.print(jFrame, tablePrintImpl, n, printRequestAttributeSet);
    }

    public static boolean print(JFrame jFrame, TablePrintable[] tablePrintableArray, int n, PrintRequestAttributeSet printRequestAttributeSet) {
        if (null == tablePrintableArray) {
            throw new IllegalArgumentException("tablePrintables argument cannot be null.");
        }
        TablePrintImpl[] tablePrintImplArray = new TablePrintImpl[tablePrintableArray.length];
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            if (null == tablePrintableArray[i]) {
                throw new IllegalArgumentException("Values in tablePrintables array cannot be null.");
            }
            TablePrintImpl tablePrintImpl = new TablePrintImpl(false, tablePrintableArray[i].getFormatCalculator());
            tablePrintableArray[i].setImplRef(tablePrintImpl);
            tablePrintImplArray[i] = tablePrintImpl;
        }
        MultiTablePrintImpl multiTablePrintImpl = new MultiTablePrintImpl(tablePrintImplArray);
        return PrintSupportor.print(jFrame, multiTablePrintImpl, n, printRequestAttributeSet);
    }

    public static boolean print(JFrame jFrame, Pageable pageable) {
        if (pageable.getNumberOfPages() < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("pageable.getNumberOfPages() can't be negative" + pageable.getNumberOfPages());
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
            throw illegalArgumentException;
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        return PrintSupportor.print(jFrame, pageable, printRequestAttributeSet);
    }

    static boolean print(JFrame jFrame, Pageable pageable, PrintRequestAttributeSet printRequestAttributeSet) {
        final Window window = PrintSupportor.getParentFrame(jFrame);
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        int n = 0;
        if (null != pageable) {
            n = pageable.getNumberOfPages();
        }
        if (n == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(window, res.getString("EmptyPage"), res.getString("Error"), 0);
                }
            });
            return false;
        }
        return PrintSupportor.print((Window)jFrame, pageable, sERVICE_FORMATTED, printRequestAttributeSet);
    }

    static boolean print(Window window, Object object, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) {
        Object object2;
        Printable printable;
        int n;
        Object object3;
        Object object4;
        final Window window2 = PrintSupportor.getParentFrame(window);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        Object object5 = null;
        try {
            object5 = PrintServiceLookup.lookupPrintServices(docFlavor, hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(window2, res.getString("ZeroPrinter"));
                }
            });
            return false;
        }
        int n2 = ((PrintService[])object5).length;
        for (int i = 0; i < ((PrintService[])object5).length; ++i) {
            if (object5[i].getClass().toString().indexOf(PRINTSERVICE_CLASSNAME) == -1) continue;
            try {
                Class<?> clazz = object5[i].getClass();
                try {
                    object4 = clazz.getDeclaredMethod("getPort", null);
                    ((Method)object4).setAccessible(true);
                    ((Method)object4).invoke((Object)object5[i], (Object[])null);
                }
                catch (Exception exception) {
                    logger.trace("PrintSupportor:No getPort() method");
                }
                object4 = clazz.getDeclaredField("port");
                ((Field)object4).setAccessible(true);
                if (!((Field)object4).get(object5[i]).equals(OFFICE2003_PRINTER_PORT) && !OFFICE2003_PRINTER_NAME.equals(object5[i].getName())) continue;
                object5[i] = null;
                --n2;
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        int n3 = n2 - 1;
        object4 = new PrintService[n2];
        int n4 = 0;
        for (int i = 0; i < ((PrintService[])object5).length; ++i) {
            if (object5[i] == null) continue;
            object4[n4] = object5[i];
            if (((Object)object5[i]).equals(printService)) {
                n3 = n4;
            }
            ++n4;
        }
        object5 = object4;
        if (((PrintService[])object5).length == 0) {
            logger.trace("printSupportor || printServices.length == 0");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(window2, res.getString("ZeroPrinter"));
                }
            });
            return false;
        }
        if (printRequestAttributeSet == null) {
            if (PrintSupportor.printRequestAttributeSet == null) {
                PrintSupportor.printRequestAttributeSet = new HashPrintRequestAttributeSet();
                PrintSupportor.printRequestAttributeSet.add(MediaSizeName.ISO_A4);
            }
            object3 = PrintSupportor.printRequestAttributeSet.toArray();
            for (n = 0; n < ((Attribute[])object3).length; ++n) {
                hashPrintRequestAttributeSet.add(object3[n]);
            }
        } else {
            object3 = printRequestAttributeSet.toArray();
            for (n = 0; n < ((Attribute[])object3).length; ++n) {
                hashPrintRequestAttributeSet.add(object3[n]);
            }
        }
        object3 = PrinterJob.getPrinterJob();
        PrintService printService2 = null;
        try {
            printService2 = PrintServiceUI.printDialog(null, 100, 100, object5, object5[n3], docFlavor, hashPrintRequestAttributeSet, window2);
            if (printService2 == null) {
                return false;
            }
            ((PrinterJob)object3).setPrintService(printService2);
            PrintSupportor.modifyAttributeSet(hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPane.showMessageDialog(window2, res.getString("ZeroPrinter"));
                }
            });
            return false;
        }
        if (previewDialog != null && previewDialog.isVisible()) {
            previewDialog.closeWindow();
        }
        if ((printable = ((PageableTool)object).getPrintable(0)) instanceof Printable) {
            if (printable instanceof TablePrintImpl) {
                object2 = (TablePrintImpl)printable;
                ((TablePrintImpl)object2).reset();
            } else if (printable instanceof MultiTablePrintImpl) {
                object2 = (MultiTablePrintImpl)printable;
                ((MultiTablePrintImpl)object2).reset(null, false);
            }
            ((PrinterJob)object3).setPrintable(printable, PrintSupportor.getPageFormat());
        }
        object2 = new PrintThread(window2, (PrinterJob)object3, hashPrintRequestAttributeSet, printable);
        ((Thread)object2).start();
        return true;
    }

    public static PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
            PrintSupportor.changePageFormat();
        }
        return (PageFormat)pageFormat.clone();
    }

    public static PrintRequestAttributeSet getPrintRequestAttributeSet() {
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        }
        return printRequestAttributeSet;
    }

    private static boolean isPageFormatValid() {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        int n = (int)pageFormat.getImageableWidth();
        int n2 = (int)pageFormat.getImageableHeight();
        return n != 0 && n2 != 0;
    }

    public static boolean isFileNameValid(String string) {
        if (null == string) {
            return false;
        }
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        int n2 = string.lastIndexOf(".");
        if (n2 >= 0) {
            String string2 = string.substring(n + 1, n2);
            if (string2.length() == 0) {
                return false;
            }
            if (string2.indexOf(".") != string2.lastIndexOf(".")) {
                return false;
            }
            char[] cArray = string2.toCharArray();
            if (cArray[0] == '.' || cArray[string2.length() - 1] == '.') {
                return false;
            }
            int n3 = string2.length();
            for (int i = 0; i < n3; ++i) {
                if (cArray[i] <= 'z' && cArray[i] >= 'a' || cArray[i] <= 'Z' && cArray[i] >= 'A' || cArray[i] <= '9' && cArray[i] >= '0' || cArray[i] == '_' || cArray[i] == '.' || cArray[i] == ' ' || cArray[i] >= '\u007f') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void modifyAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet instanceof HashPrintRequestAttributeSet) {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = (HashPrintRequestAttributeSet)printRequestAttributeSet;
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)hashPrintRequestAttributeSet.get(MediaPrintableArea.class);
            int n = 1;
            float f = mediaPrintableArea.getX(n);
            float f2 = mediaPrintableArea.getY(n);
            float f3 = mediaPrintableArea.getWidth(n);
            float f4 = mediaPrintableArea.getHeight(n);
            MediaPrintableArea mediaPrintableArea2 = new MediaPrintableArea(f, f2, f3, f4, n);
            hashPrintRequestAttributeSet.remove(mediaPrintableArea);
            hashPrintRequestAttributeSet.add(mediaPrintableArea2);
        }
    }

    public static boolean existPrinters() {
        logger.trace("look up printservice.");
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = null;
        try {
            printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        int n = printServiceArray.length;
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (printServiceArray[i].getClass().toString().indexOf(PRINTSERVICE_CLASSNAME) == -1) continue;
            try {
                Class<?> clazz = printServiceArray[i].getClass();
                Field field = clazz.getDeclaredField("port");
                field.setAccessible(true);
                if (!OFFICE2003_PRINTER_PORT.equals(field.get(printServiceArray[i])) && !OFFICE2003_PRINTER_NAME.equals(printServiceArray[i].getName())) continue;
                printServiceArray[i] = null;
                --n;
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        if (n <= 0) {
            logger.trace("There is no printer.");
            return false;
        }
        return true;
    }

    public static void print(URL uRL, JFrame jFrame) {
        PrintSupportor.print(new URL[]{uRL}, jFrame);
    }

    public static void print(URL[] uRLArray, JFrame jFrame) {
        try {
            HTMLPrintHandler hTMLPrintHandler = new HTMLPrintHandler();
            hTMLPrintHandler.print(uRLArray, jFrame);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static void closePreviewDialog(FormatCalculator formatCalculator) {
        try {
            FormatCalculator formatCalculator2;
            Printable printable;
            if (previewDialog != null && previewDialog.isVisible() && previewDialog.getPageable() != null && (printable = previewDialog.getPageable().getPrintable(0)) instanceof TablePrintImpl && (formatCalculator2 = ((TablePrintImpl)printable).getFormatCalculator()).equals(formatCalculator)) {
                previewDialog.closeWindow();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static Window getParentFrame() {
        if (parentFrame == null) {
            return FrameworkUtilities.getMainFrame();
        }
        return parentFrame;
    }

    private static Window getParentFrame(Window window) {
        Window window2 = window;
        if (window == null && parentFrame != null) {
            window2 = parentFrame;
        }
        return window2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileAccessabilty(final JFrame jFrame, String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = string;
            final String string3 = MessageFormat.format(res.getString("errorFile"), string2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = OptionPane.separateStringWith(string3, PrintSupportor.LINE_SEPARATOR_N).toString();
                    OptionPane.showErrorDialog(jFrame, string);
                }
            });
            logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("Failed to close the stream for file =" + string);
                }
            }
        }
        return true;
    }

    private static void setPrintHelp() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Window[] windowArray = null;
                block2: while (!done) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.trace(interruptedException);
                    }
                    windowArray = Window.getWindows();
                    if (null == windowArray || windowArray.length == 0) {
                        return;
                    }
                    for (Window window : windowArray) {
                        if (!(window instanceof ServiceDialog) || !window.isVisible()) continue;
                        HelpManager.getInstance().enableHelpKey(((ServiceDialog)window).getRootPane(), "iVIEW.Print");
                        continue block2;
                    }
                }
            }
        });
        thread.start();
    }
}

