/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.swing.JDialog;
import javax.swing.JFrame;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;

public class PrintServiceUI {
    private static IviewLogger logger = IviewLogger.getLogger(PrintServiceUI.class, "IVIEW");
    public static PrintRequestAttributeSet newas;

    public static PrintService printDialog(GraphicsConfiguration graphicsConfiguration, int n, int n2, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, Window window) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            throw new IllegalArgumentException("services must be valid");
        }
        if (printRequestAttributeSet == null) {
            throw new IllegalArgumentException("attributes must be valid");
        }
        int n3 = -1;
        if (printService != null) {
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!((Object)printService).equals(printServiceArray[i])) continue;
                n3 = i;
                break;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("services must contain default Service");
            }
        } else {
            n3 = 0;
        }
        window = window != null ? window : FrameworkUtilities.getMainFrame();
        ServiceDialog serviceDialog = null;
        if (window instanceof JFrame || window == null) {
            serviceDialog = new ServiceDialog(graphicsConfiguration, n, n2, printServiceArray, n3, docFlavor, printRequestAttributeSet, (Frame)((JFrame)window));
        } else if (window instanceof JDialog) {
            serviceDialog = new ServiceDialog(graphicsConfiguration, n, n2, printServiceArray, n3, docFlavor, printRequestAttributeSet, (Dialog)((JDialog)window));
        } else {
            logger.trace("PrintServiceUI-Only JFrame and Jdiaolg are supported");
            return null;
        }
        ScreenToolKit.centerLocateToScreen(serviceDialog);
        HelpManager.getInstance().enableHelpKey(serviceDialog.getRootPane(), "iVIEW.Print");
        serviceDialog.show();
        if (serviceDialog.getStatus() == 1) {
            Class<SunAlternateMedia> clazz;
            newas = serviceDialog.getAttributes();
            Class<Destination> clazz2 = Destination.class;
            if (printRequestAttributeSet.containsKey(clazz2) && !newas.containsKey(clazz2)) {
                printRequestAttributeSet.remove(clazz2);
            }
            if (printRequestAttributeSet.containsKey(clazz = SunAlternateMedia.class) && !newas.containsKey(clazz)) {
                printRequestAttributeSet.remove(clazz);
            }
            printRequestAttributeSet.addAll(newas);
            Class<Fidelity> clazz3 = Fidelity.class;
            Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(clazz3);
            if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
                PrintServiceUI.removeUnsupportedAttributes(serviceDialog.getPrintService(), docFlavor, printRequestAttributeSet);
            }
        }
        return serviceDialog.getPrintService();
    }

    private static void removeUnsupportedAttributes(PrintService printService, DocFlavor docFlavor, AttributeSet attributeSet) {
        AttributeSet attributeSet2 = printService.getUnsupportedAttributes(docFlavor, attributeSet);
        if (null == attributeSet2) {
            return;
        }
        Attribute[] attributeArray = attributeSet2.toArray();
        Class<? extends Attribute> clazz = null;
        Attribute attribute = null;
        for (Attribute attribute2 : attributeArray) {
            clazz = attribute2.getCategory();
            if (printService.isAttributeCategorySupported(clazz)) {
                attribute = (Attribute)printService.getDefaultAttributeValue(clazz);
                if (attribute != null) {
                    attributeSet.add(attribute);
                    continue;
                }
                attributeSet.remove(clazz);
                continue;
            }
            attributeSet.remove(clazz);
        }
    }
}

