/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.templates.print.PreviewDialog;
import com.swimap.iview.templates.print.tools.MultiTablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

final class PreviewPanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(PreviewDialog.class, "IVIEW");
    private Pageable pageable = null;
    private int currentPage = 0;
    private static final double HALF_UNIT = 0.5;
    private static final double DEFAULT_SCALE = 0.6;
    private double scale = 0.6;
    private JScrollPane jScrollPane = null;

    PreviewPanel(Pageable pageable) {
        this.pageable = pageable;
        Color color = new Color(128, 128, 128);
        this.setBackground(color);
    }

    public JScrollPane getScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            JViewport jViewport = this.jScrollPane.getViewport();
            jViewport.add(this);
        }
        return this.jScrollPane;
    }

    public void setScale(double d) {
        this.scale = d >= 0.0 ? d : 1.0;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        PageFormat pageFormat = null;
        try {
            pageFormat = this.pageable.getPageFormat(this.currentPage);
        }
        catch (Exception exception) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = pageFormat.getWidth();
        double d4 = pageFormat.getHeight();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        d = 0.5 * (d5 - this.scale * d3);
        d2 = 0.5 * (d6 - this.scale * d4);
        graphics2D.translate(d, d2);
        graphics2D.scale(this.scale, this.scale);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d3, d4);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(double_);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(double_);
        Printable printable = this.pageable.getPrintable(this.currentPage);
        if (printable instanceof TablePrintImpl) {
            try {
                boolean bl = ((TablePrintImpl)printable).getIsNeedSleep();
                ((TablePrintImpl)printable).setIsNeedSleep(false);
                printable.print(graphics2D, pageFormat, this.currentPage);
                ((TablePrintImpl)printable).setIsNeedSleep(bl);
            }
            catch (PrinterException printerException) {
                logger.trace(printerException.getMessage(), printerException);
                graphics2D.draw(new Line2D.Double(0.0, 0.0, d3, d4));
                graphics2D.draw(new Line2D.Double(0.0, d3, 0.0, d4));
            }
        } else if (printable instanceof MultiTablePrintImpl) {
            try {
                boolean bl = ((MultiTablePrintImpl)printable).getIsNeedSleep();
                ((MultiTablePrintImpl)printable).setIsNeedSleep(false);
                printable.print(graphics2D, pageFormat, this.currentPage);
                ((MultiTablePrintImpl)printable).setIsNeedSleep(bl);
            }
            catch (PrinterException printerException) {
                logger.trace(printerException);
                graphics2D.draw(new Line2D.Double(0.0, 0.0, d3, d4));
                graphics2D.draw(new Line2D.Double(0.0, d3, 0.0, d4));
            }
        } else {
            try {
                printable.print(graphics2D, pageFormat, this.currentPage);
            }
            catch (PrinterException printerException) {
                logger.trace(printerException.getMessage(), printerException);
                graphics2D.draw(new Line2D.Double(0.0, 0.0, d3, d4));
                graphics2D.draw(new Line2D.Double(0.0, d3, 0.0, d4));
            }
        }
        graphics2D.scale(1.0 / this.scale, 1.0 / this.scale);
        graphics2D.translate(-d, -d2);
        this.setPreferredSize(new Dimension((int)(d3 * this.scale), (int)(d4 * this.scale)));
        this.revalidate();
    }

    public void flipPage(int n) {
        int n2 = this.currentPage + n;
        if (0 <= n2 && n2 < this.pageable.getNumberOfPages()) {
            this.currentPage = n2;
            this.repaint();
        }
    }

    public boolean hasNext() {
        return this.currentPage != this.pageable.getNumberOfPages() - 1;
    }

    public boolean hasPrevious() {
        return this.currentPage != 0;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void resetPreview(Pageable pageable) {
        this.pageable = pageable;
        this.currentPage = 0;
    }
}

