/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PageableTool;
import com.swimap.iview.templates.print.PreViewDataInfo;
import com.swimap.iview.templates.print.PreViewDataSource;
import com.swimap.iview.templates.print.PreViewFormatCalculator;
import com.swimap.iview.templates.print.PreviewPanel;
import com.swimap.iview.templates.print.PrintPreviewPanel;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.tools.AppendStartListener;
import com.swimap.iview.templates.print.tools.MultiTablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

final class PreviewDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(PreviewDialog.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    private Window parentFrame = null;
    private PreviewPanel previewPanel = null;
    private JLabel pageInfo = new JLabel();
    private JButton nextButton = new JButton();
    private JButton previousButton = new JButton();
    private JButton zoomOutButton = new JButton();
    private JButton zoomInButton = new JButton();
    private JButton printButton = new JButton();
    private JButton pageSetupButton = new JButton();
    private JButton closeButton = new JButton();
    private Pageable pageable = null;
    private static Pageable bmPageable = null;
    private transient ActionListener nextActionListener = new NextActionListener();
    private transient ActionListener previousActionListener = new PreviousActionListener();
    private transient ActionListener printActionListener = new PrintActionListener();
    private transient ActionListener pageSetupActionListener = new PageSetupActionListener();
    private transient ActionListener zoomOutActionListener = new ZoomOutActionListener();
    private transient ActionListener zoomInActionListener = new ZoomInActionListener();
    private transient ActionListener closeActionListener = new CloseActionListener();
    private transient WindowListener windowListener = new PrintPreviewWindowListener();
    private static final int WIDTH = 800;
    private static final int HEIGHT = 590;
    private static final int BTN_HEIGHT = 21;
    private static final int BTN_WIDTH = 100;
    private PrintRequestAttributeSet printRequestAttributeSet = null;
    private static final int MAX_ZOOM_COUNT = 15;
    private static final int MIN_ZOOM_COUNT = 0;
    private PrintPreviewPanel printPreviewPanel = new PrintPreviewPanel();
    private static final int PAGEINFOR_MAX_LENGTH = 240;
    private int zoomCount = 2;
    private boolean isRun = false;
    private PreViewDataSource dataSource = null;
    private FormatCalculator formatCalculator = null;
    private static final int ROW_COUNT = 100;
    private static final double STEP_VALUE = 0.2;
    private static final int MIN_HEIGHT = 120;

    PreviewDialog(JFrame jFrame, Pageable pageable, PrintRequestAttributeSet printRequestAttributeSet) {
        super(jFrame, res.getString("Print_Preview"), true);
        this.printRequestAttributeSet = printRequestAttributeSet;
        this.parentFrame = jFrame;
        this.pageable = pageable;
        bmPageable = pageable;
        this.init();
    }

    PreviewDialog(JDialog jDialog, Pageable pageable, PrintRequestAttributeSet printRequestAttributeSet) {
        super(jDialog, res.getString("Print_Preview"), true);
        this.printRequestAttributeSet = printRequestAttributeSet;
        this.parentFrame = jDialog;
        this.pageable = pageable;
        bmPageable = pageable;
        this.init();
    }

    private void init() {
        HelpManager.getInstance().enableHelpKey(this.getRootPane(), "iVIEW.topo.preview");
        this.initDataSource();
        this.addWindowListener(this.windowListener);
        this.printPreviewPanel.setLayout(new BorderLayout());
        this.previewPanel = new PreviewPanel(this.pageable);
        this.previewPanel.setName("PreviewDialog_previewPanel");
        this.printPreviewPanel.add((Component)this.previewPanel.getScrollPane(), "Center");
        this.printPreviewPanel.add((Component)this.getControlPanel(), "North");
        this.printPreviewPanel.add((Component)this.getPageInfoPanel(), "South");
        this.printPreviewPanel.setCloseButton(this.closeButton);
        this.setSize(800, 590);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.printPreviewPanel, "Center");
        this.setResizable(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (PreviewDialog.this.getSize().width < 800) {
                    PreviewDialog.this.setSize(800, PreviewDialog.this.getHeight());
                }
                if (PreviewDialog.this.getSize().height < 120) {
                    PreviewDialog.this.setSize(PreviewDialog.this.getWidth(), 120);
                }
            }
        });
        Printable printable = this.pageable.getPrintable(0);
        if (printable instanceof MultiTablePrintImpl) {
            ((MultiTablePrintImpl)printable).addAppendStartListener(new NextButtonUpdateListener());
        }
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    private void initDataSource() {
        if (this.pageable.getPrintable(0) instanceof TablePrintImpl) {
            this.formatCalculator = ((TablePrintImpl)this.pageable.getPrintable(0)).getFormatCalculator();
            if (this.formatCalculator instanceof PreViewFormatCalculator) {
                this.dataSource = ((PreViewFormatCalculator)this.formatCalculator).getPreViewDataSource();
                if (!this.computeNextData(-1, (PreViewFormatCalculator)this.formatCalculator)) {
                    this.nextButton.setEnabled(false);
                    this.previousButton.setEnabled(false);
                }
            }
        }
    }

    public JPanel getPrintPreviewPanel() {
        return this.printPreviewPanel;
    }

    public JPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public final JPanel getControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 5, 5));
        String string = res.getString("previous");
        this.previousButton.setText(string);
        this.previousButton.setName("PreviewDialog_previousButton");
        this.previousButton.addActionListener(this.previousActionListener);
        this.previousButton.setMnemonic('P');
        jPanel2.add(this.previousButton);
        String string2 = res.getString("next");
        this.nextButton.setText(string2);
        this.nextButton.setName("PreviewDialog_nextButton");
        this.nextButton.addActionListener(this.nextActionListener);
        this.nextButton.setMnemonic('N');
        jPanel2.add(this.nextButton);
        this.zoomInButton.setText(res.getString("ZoomIn"));
        this.zoomInButton.addActionListener(this.zoomInActionListener);
        this.zoomInButton.setMnemonic('I');
        this.zoomInButton.setName("PreviewDialog_zoomInButton");
        jPanel2.add(this.zoomInButton);
        this.zoomOutButton.setText(res.getString("ZoomOut"));
        this.zoomOutButton.setMargin(new Insets(this.zoomOutButton.getMargin().top, 2, this.zoomOutButton.getMargin().bottom, 2));
        this.zoomOutButton.addActionListener(this.zoomOutActionListener);
        this.zoomOutButton.setMnemonic('O');
        this.zoomOutButton.setName("PreviewDialog_zoomOutButton");
        jPanel2.add(this.zoomOutButton);
        String string3 = res.getString("print");
        this.printButton.setText(string3);
        this.printButton.setName("PreviewDialog_printButton");
        this.printButton.addActionListener(this.printActionListener);
        this.printButton.setMnemonic('R');
        jPanel2.add(this.printButton);
        this.pageSetupButton.setText(res.getString("PageSetup"));
        this.pageSetupButton.setName("PreviewDialog_pageSetupButton");
        this.pageSetupButton.addActionListener(this.pageSetupActionListener);
        this.pageSetupButton.setMnemonic('S');
        jPanel2.add(this.pageSetupButton);
        String string4 = res.getString("close");
        this.closeButton.setText(string4);
        this.closeButton.setName("PreviewDialog_closeButton");
        this.closeButton.addActionListener(this.closeActionListener);
        ScreenToolKit.setDefaultButtons(null, this.closeButton);
        jPanel2.add(this.closeButton);
        Dimension dimension = new Dimension(100, 21);
        this.nextButton.setPreferredSize(dimension);
        this.previousButton.setPreferredSize(dimension);
        this.printButton.setPreferredSize(dimension);
        this.pageSetupButton.setPreferredSize(dimension);
        this.zoomOutButton.setPreferredSize(dimension);
        this.zoomInButton.setPreferredSize(dimension);
        this.closeButton.setPreferredSize(dimension);
        Insets insets = this.pageSetupButton.getInsets();
        this.pageSetupButton.setMargin(new Insets(insets.top, Math.max(0, insets.left - 12), insets.bottom, Math.max(0, insets.right - 12)));
        if (!this.previewPanel.hasNext()) {
            this.nextButton.setEnabled(false);
        }
        if (!this.previewPanel.hasPrevious()) {
            this.previousButton.setEnabled(false);
        }
        Printable printable = this.pageable.getPrintable(0);
        if (null != this.formatCalculator && this.formatCalculator.getHeaderError() || printable instanceof MultiTablePrintImpl && ((MultiTablePrintImpl)printable).getHeaderError()) {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            this.printButton.setEnabled(false);
        }
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel getPageInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        String string = this.getLabelText();
        this.pageInfo.setText(string);
        this.pageInfo.setName("PreviewDialog_pageInfo");
        this.pageInfo.setForeground(Color.black);
        jPanel.add((Component)this.pageInfo, "West");
        return jPanel;
    }

    final void closeWindow() {
        this.nextButton.removeActionListener(this.nextActionListener);
        this.previousButton.removeActionListener(this.previousActionListener);
        this.printButton.removeActionListener(this.printActionListener);
        this.pageSetupButton.removeActionListener(this.pageSetupActionListener);
        this.closeButton.removeActionListener(this.closeActionListener);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.closeButton.unregisterKeyboardAction(keyStroke);
        this.removeWindowListener(this.windowListener);
        this.nextActionListener = null;
        this.previousActionListener = null;
        this.printActionListener = null;
        this.closeActionListener = null;
        this.windowListener = null;
        this.setVisible(false);
        this.dispose();
    }

    private String getLabelText() {
        if (this.dataSource != null || this.pageable.getPrintable(0) instanceof MultiTablePrintImpl) {
            return "  " + res.getString("curPage") + String.valueOf(this.previewPanel.getCurrentPage() + 1);
        }
        String string = MessageFormat.format("  " + res.getString("PagesInfor"), String.valueOf(this.pageable.getNumberOfPages()), String.valueOf(this.previewPanel.getCurrentPage() + 1));
        int n = 0;
        FontMetrics fontMetrics = this.pageInfo.getFontMetrics(this.pageInfo.getFont());
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if ((n += fontMetrics.charWidth(string.charAt(i))) < 240) continue;
            this.pageInfo.setToolTipText(string);
            return string.substring(0, i - 1) + "...";
        }
        return string;
    }

    private void nextPage() {
        int n = this.formatCalculator.getPageHashMapIndex(this.previewPanel.getCurrentPage());
        HashMap hashMap = this.formatCalculator.getTablePageHashMap();
        if (!this.computeNextData(n, (PreViewFormatCalculator)this.formatCalculator)) {
            this.nextButton.setEnabled(false);
            return;
        }
        int n2 = this.formatCalculator.getOnlySummaryPageCount();
        if ((this.previewPanel.getCurrentPage() + 1 - n2) % this.formatCalculator.pageCountHTable.size() != 0 || hashMap.containsKey(n + 1)) {
            this.previewPanel.flipPage(1);
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            if (!this.previewPanel.hasNext()) {
                this.nextButton.setEnabled(false);
            }
            if (!this.previewPanel.hasPrevious()) {
                this.previousButton.setEnabled(false);
            }
            String string = this.getLabelText();
            this.pageInfo.setText(string);
        } else {
            this.nextButton.setEnabled(false);
        }
    }

    private boolean computeNextData(int n, PreViewFormatCalculator preViewFormatCalculator) {
        HashMap hashMap = preViewFormatCalculator.getTablePageHashMap();
        boolean bl = true;
        try {
            while (!hashMap.containsKey(n + 2) && preViewFormatCalculator.getEndRow() + 1 < preViewFormatCalculator.getRowCount() && bl) {
                PreViewDataInfo preViewDataInfo = new PreViewDataInfo();
                int n2 = preViewFormatCalculator.getEndRow() + 1 + 100 > preViewFormatCalculator.getRowCount() ? preViewFormatCalculator.getRowCount() - preViewFormatCalculator.getEndRow() - 1 : 100;
                Collection collection = new LinkedList();
                try {
                    collection = this.dataSource.getPreviewPageData(preViewFormatCalculator.getEndRow() + 1, n2);
                }
                catch (PreViewDataSource.ServerBreak serverBreak) {
                    bl = false;
                }
                preViewDataInfo.setSRowOfTable(preViewFormatCalculator.getEndRow() + 1);
                preViewDataInfo.setERowOfTable(preViewFormatCalculator.getEndRow() + n2);
                preViewFormatCalculator.setPreViewDataInfo(preViewDataInfo);
                preViewFormatCalculator.setEndRow(preViewFormatCalculator.getEndRow() + n2);
                if (collection != null) {
                    preViewFormatCalculator.addPreviewData(collection, n + 1, true);
                }
                if (!preViewFormatCalculator.getHeaderError()) continue;
                bl = false;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.trace("Print -- Excption in calculateRowHeight of preview caluculate. The DB's collection is break, throw this exception when analyse the data");
            return false;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        if (n == -1 && preViewFormatCalculator.getBufRowCount() == 0 && !preViewFormatCalculator.getHeaderError()) {
            this.enableButtons(false);
        }
        return true;
    }

    private void enableButtons(boolean bl) {
        this.nextButton.setEnabled(bl);
        this.previousButton.setEnabled(bl);
        this.zoomOutButton.setEnabled(bl);
        this.zoomInButton.setEnabled(bl);
        this.printButton.setEnabled(bl);
        this.pageSetupButton.setEnabled(bl);
    }

    private void previousPage() {
        int n = this.formatCalculator.getPageHashMapIndex(this.previewPanel.getCurrentPage());
        HashMap hashMap = this.formatCalculator.getTablePageHashMap();
        if (!this.computePreviousData(n, (PreViewFormatCalculator)this.formatCalculator)) {
            this.previousButton.setEnabled(false);
            return;
        }
        if (this.previewPanel.getCurrentPage() % this.formatCalculator.pageCountHTable.size() != 0 || hashMap.containsKey(n - 1)) {
            if (((PreViewFormatCalculator)this.formatCalculator).update && (n == 1 || n == ((PreViewFormatCalculator)this.formatCalculator).getStartPage() + 1) && this.previewPanel.getCurrentPage() % this.formatCalculator.pageCountHTable.size() == 0) {
                ((PreViewFormatCalculator)this.formatCalculator).clear();
                if (!this.computeNextData(-1, (PreViewFormatCalculator)this.formatCalculator)) {
                    this.nextButton.setEnabled(false);
                    return;
                }
                ((PreViewFormatCalculator)this.formatCalculator).update = false;
                this.previewPanel.flipPage(-this.previewPanel.getCurrentPage());
                this.repaint();
                String string = this.getLabelText();
                this.pageInfo.setText(string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPane.showMessageDialog(PrintSupportor.getParentFrame(), res.getString("updatePreview"));
                    }
                });
            } else {
                this.previewPanel.flipPage(-1);
                String string = this.getLabelText();
                this.pageInfo.setText(string);
            }
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            if (!this.previewPanel.hasNext()) {
                this.nextButton.setEnabled(false);
            }
            if (!this.previewPanel.hasPrevious()) {
                this.previousButton.setEnabled(false);
            }
        } else {
            this.nextButton.setEnabled(false);
        }
    }

    private boolean computePreviousData(int n, PreViewFormatCalculator preViewFormatCalculator) {
        HashMap hashMap = preViewFormatCalculator.getTablePageHashMap();
        try {
            while (!hashMap.containsKey(n - 2) && preViewFormatCalculator.getStartRow() > 0) {
                PreViewDataInfo preViewDataInfo = new PreViewDataInfo();
                int n2 = preViewFormatCalculator.getStartRow() - 100 < 0 ? preViewFormatCalculator.getStartRow() : 100;
                preViewFormatCalculator.setStartRow(preViewFormatCalculator.getStartRow() - n2);
                preViewDataInfo.setSRowOfTable(preViewFormatCalculator.getStartRow());
                preViewDataInfo.setERowOfTable(preViewFormatCalculator.getStartRow() + n2 - 1);
                preViewFormatCalculator.setPreViewDataInfo(preViewDataInfo);
                Collection collection = this.dataSource.getPreviewPageData(preViewFormatCalculator.getStartRow(), n2);
                if (collection == null) continue;
                preViewFormatCalculator.addPreviewData(collection, n - 1, false);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private class PrintPreviewWindowListener
    extends WindowAdapter {
        private PrintPreviewWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PreviewDialog.this.closeWindow();
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewDialog.this.closeWindow();
        }
    }

    private class PageSetupActionListener
    implements ActionListener {
        private PageSetupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (null == PreviewDialog.this.printRequestAttributeSet) {
                PreviewDialog.this.printRequestAttributeSet = PrintSupportor.getPrintRequestAttributeSet();
            }
            PageFormat pageFormat = PrintSupportor.setupPage(PreviewDialog.this.printRequestAttributeSet);
            if (PrintSupportor.isCancelPressedOnPageSetup() || null == pageFormat) {
                return;
            }
            Pageable pageable = this.getPageableAfterPageSetup(pageFormat);
            this.resetPreview(pageable);
        }

        private Pageable getPageableAfterPageSetup(PageFormat pageFormat) {
            Printable printable = PreviewDialog.this.pageable.getPrintable(0);
            PageableTool pageableTool = new PageableTool();
            int n = bmPageable.getNumberOfPages();
            if (printable instanceof PrintableTool) {
                Object object;
                if (printable instanceof TablePrintImpl) {
                    object = ((TablePrintImpl)printable).getFormatCalculator();
                    ((TablePrintImpl)printable).reset();
                    if (object instanceof PreViewFormatCalculator) {
                        ((PreViewFormatCalculator)object).clear();
                    }
                    ((FormatCalculator)object).setPageFormatWithCompute(pageFormat);
                    if (((FormatCalculator)object).getHeaderError() && !(object instanceof PreViewFormatCalculator)) {
                        PreviewDialog.this.nextButton.setEnabled(false);
                    }
                } else if (printable instanceof MultiTablePrintImpl) {
                    object = (MultiTablePrintImpl)printable;
                    ((MultiTablePrintImpl)object).reset(pageFormat, true);
                }
                object = (PrintableTool)printable;
                n = ((PrintableTool)object).getPageCount();
                printable = (PrintableTool)((PrintableTool)object).clone();
            }
            pageableTool.append(printable, PrintSupportor.getPageFormat(), n);
            return pageableTool;
        }

        private void resetPreview(Pageable pageable) {
            ((PreviewPanel)PreviewDialog.this.getPreviewPanel()).resetPreview(pageable);
            PreviewDialog.this.pageable = pageable;
            PreviewDialog.this.initDataSource();
            PreviewDialog.this.getPrintPreviewPanel().repaint();
            String string = PreviewDialog.this.getLabelText();
            PreviewDialog.this.pageInfo.setText(string);
            PreviewDialog.this.printButton.setEnabled(true);
            Printable printable = pageable.getPrintable(0);
            if (null != PreviewDialog.this.formatCalculator && PreviewDialog.this.formatCalculator.getHeaderError() || printable instanceof MultiTablePrintImpl && ((MultiTablePrintImpl)printable).getHeaderError()) {
                PreviewDialog.this.nextButton.setEnabled(false);
                PreviewDialog.this.previousButton.setEnabled(false);
                PreviewDialog.this.printButton.setEnabled(false);
                return;
            }
            PreviewDialog.this.nextButton.setEnabled(PreviewDialog.this.previewPanel.hasNext());
            PreviewDialog.this.previousButton.setEnabled(PreviewDialog.this.previewPanel.hasPrevious());
        }
    }

    private class PrintActionListener
    implements ActionListener {
        private PrintActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = PrintSupportor.parentFrame;
            if (PreviewDialog.this.dataSource != null) {
                PreviewDialog.this.dataSource.print();
                PrintSupportor.parentFrame = jDialog;
                return;
            }
            if (PreviewDialog.this.isRun) {
                return;
            }
            PreviewDialog.this.isRun = true;
            try {
                PageableTool pageableTool = new PageableTool();
                Printable printable = PreviewDialog.this.pageable.getPrintable(0);
                PageFormat pageFormat = PreviewDialog.this.pageable.getPageFormat(0);
                this.append(pageableTool, printable, pageFormat, PreviewDialog.this.pageable.getNumberOfPages());
                if (PreviewDialog.this.parentFrame instanceof JFrame || PreviewDialog.this.parentFrame == null) {
                    PrintSupportor.print((JFrame)PreviewDialog.this.parentFrame, pageableTool, PreviewDialog.this.printRequestAttributeSet);
                } else if (PreviewDialog.this.parentFrame instanceof JDialog) {
                    PrintSupportor.print(null, pageableTool, PreviewDialog.this.printRequestAttributeSet);
                }
                PrintSupportor.parentFrame = jDialog;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            finally {
                PreviewDialog.this.isRun = false;
            }
        }

        private void append(PageableTool pageableTool, Printable printable, PageFormat pageFormat, int n) {
            if (printable instanceof PrintableTool) {
                PrintableTool printableTool = (PrintableTool)printable;
                PrintableTool printableTool2 = (PrintableTool)printableTool.clone();
                pageableTool.append(printableTool2, pageFormat, n);
            } else {
                pageableTool.append(printable, pageFormat, n);
            }
        }
    }

    private class ZoomInActionListener
    implements ActionListener {
        private ZoomInActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewDialog.this.previewPanel.setScale(PreviewDialog.this.previewPanel.getScale() + 0.2);
            PreviewDialog.this.zoomCount++;
            if (PreviewDialog.this.zoomCount >= 15) {
                PreviewDialog.this.zoomInButton.setEnabled(false);
            }
            PreviewDialog.this.zoomOutButton.setEnabled(true);
            PreviewDialog.this.previewPanel.repaint();
        }
    }

    private class ZoomOutActionListener
    implements ActionListener {
        private ZoomOutActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewDialog.this.previewPanel.setScale(PreviewDialog.this.previewPanel.getScale() - 0.2);
            PreviewDialog.this.zoomCount--;
            if (PreviewDialog.this.zoomCount <= 0) {
                PreviewDialog.this.zoomOutButton.setEnabled(false);
            }
            PreviewDialog.this.zoomInButton.setEnabled(true);
            PreviewDialog.this.previewPanel.repaint();
        }
    }

    private class PreviousActionListener
    implements ActionListener {
        private PreviousActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PreviewDialog.this.dataSource != null) {
                PreviewDialog.this.previousPage();
                return;
            }
            PreviewDialog.this.previewPanel.flipPage(-1);
            if (!PreviewDialog.this.previewPanel.hasPrevious()) {
                PreviewDialog.this.previousButton.setEnabled(false);
            }
            PreviewDialog.this.nextButton.setEnabled(true);
            String string = PreviewDialog.this.getLabelText();
            PreviewDialog.this.pageInfo.setText(string);
        }
    }

    private class NextActionListener
    implements ActionListener {
        private NextActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PreviewDialog.this.dataSource != null) {
                PreviewDialog.this.nextPage();
                return;
            }
            PreviewDialog.this.previewPanel.flipPage(1);
            if (!PreviewDialog.this.previewPanel.hasNext()) {
                PreviewDialog.this.nextButton.setEnabled(false);
            }
            PreviewDialog.this.previousButton.setEnabled(true);
            String string = PreviewDialog.this.getLabelText();
            PreviewDialog.this.pageInfo.setText(string);
        }
    }

    private class NextButtonUpdateListener
    implements AppendStartListener {
        private NextButtonUpdateListener() {
        }

        @Override
        public void canStartAppend() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Printable printable = PreviewDialog.this.pageable.getPrintable(0);
                    if (printable instanceof MultiTablePrintImpl) {
                        if (((MultiTablePrintImpl)printable).hasNextPage()) {
                            PreviewDialog.this.nextButton.setEnabled(true);
                        } else {
                            PreviewDialog.this.nextButton.setEnabled(false);
                        }
                    }
                }
            });
        }
    }
}

