/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.templates.print.PrintableTool;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.LinkedList;

public class PageableTool
implements Pageable {
    private LinkedList bookPageLinkedList = new LinkedList();

    @Override
    public int getNumberOfPages() {
        int n = 0;
        Iterator iterator = this.bookPageLinkedList.iterator();
        BookPage bookPage = null;
        while (iterator.hasNext()) {
            bookPage = (BookPage)iterator.next();
            n += bookPage.getPageCount();
        }
        return n;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        BookPage bookPage = this.getBookPage(n);
        return bookPage.getPageFormat();
    }

    @Override
    public Printable getPrintable(int n) {
        BookPage bookPage = this.getBookPage(n);
        return bookPage.getPrintable();
    }

    public void append(Printable printable, PageFormat pageFormat, int n) {
        BookPage bookPage = new BookPage(printable, pageFormat, n);
        this.bookPageLinkedList.add(bookPage);
    }

    private BookPage getBookPage(int n) {
        int n2 = this.getNumberOfPages();
        if (n < 0) {
            n = 0;
        } else if (n >= n2) {
            n = n2 - 1;
        }
        BookPage bookPage = null;
        int n3 = 0;
        Iterator iterator = this.bookPageLinkedList.iterator();
        while (iterator.hasNext() && n >= (n3 += (bookPage = (BookPage)iterator.next()).getPageCount())) {
        }
        return bookPage;
    }

    private static class BookPage {
        private Printable printable = null;
        private PageFormat pageFormat = null;
        private int pageCount = 0;

        BookPage(Printable printable, PageFormat pageFormat, int n) {
            this.printable = printable;
            this.pageFormat = pageFormat;
            this.pageCount = null == printable ? 0 : n;
        }

        final Printable getPrintable() {
            return this.printable;
        }

        final PageFormat getPageFormat() {
            return this.pageFormat;
        }

        final int getPageCount() {
            if (this.printable instanceof PrintableTool) {
                PrintableTool printableTool = (PrintableTool)this.printable;
                return printableTool.getPageCount();
            }
            return this.pageCount;
        }
    }
}

