/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.tools.AppendStartListener;
import com.swimap.iview.templates.print.tools.RealTimePrintControler;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.format.FormatException;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Font;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class FormatCalculator {
    private static IviewLogger logger = IviewLogger.getLogger(FormatCalculator.class, "IVIEW");
    public static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    public static final String LINE_CHANGER = System.getProperty("line.separator");
    public static final Font TABLE_HEADER_FONT = new Font("Dialog", 1, 12);
    public static final Font DATA_FONT = new Font("Dialog", 0, 8);
    private Font dataFont = DATA_FONT;
    public static final char TXT_SEPARATOR_CHAR = '|';
    public static final int MAX_PAGE_COUNT = 500000;
    public static final int ROW_DIVIDER_HEIGHT = 3;
    public static final int COLUMN_DIVIDER_WIDTH = 2;
    public static final int MARGIN_WIDTH = 2;
    public static final int MIN_IMAGEABLE_WIDTH = 30;
    public static final int MIN_IMAGEABLE_HEIGHT = 100;
    public static final int MIN_COLUMN_WIDTH = 30;
    public static final int MIN_COLUMN_WIDTH_SAVE = 15;
    private static final int MAX_CHAR_COUNT_PERLINE = 4000;
    private static final int ASCII_VALUE = 127;
    private static final int STEP_DELTA = 20;
    static final int LINKEDLIST_MAX_LENGTH = 500;
    private static final int ONE_SECOND = 1000;
    public static final String LINE_SPEARATOR_N = "\n";
    public static final String LINE_SPEARATOR_R = "\r";
    private static final String LIST_SEPARATOR = "\n\r";
    String[] tableHeaders = null;
    private String title = null;
    private String userName = null;
    private String summary = null;
    private Collection sourceData = null;
    private ArrayList summaryLineList = null;
    int summaryPageCount = 0;
    int onlySummaryPageCount = 0;
    int totalRowCount = 0;
    boolean hasIncTotalRowCount = false;
    private final Object lock = new Object();
    public static final boolean UP = false;
    public static final boolean DOWN = true;
    boolean totleRecordsPosition = false;
    private int[] columnWidths = null;
    private boolean isSave = true;
    private boolean isHtml = false;
    private boolean bRealTimePrint = false;
    private ArrayList sourceDataArrayList = null;
    private boolean bSourceDataComputed = false;
    private boolean isWidthCustomized = false;
    private volatile List analyzedRowLinkedList = Collections.synchronizedList(new LinkedList());
    int splittedRows = 0;
    int splittedRowsBackup = 0;
    private List extraRowIndices = new ArrayList(10);
    private int lastPrintedRowIndex = 0;
    private int startingY = 0;
    private boolean computeOver = false;
    HashMap tablePageHashMap = new HashMap(20);
    private LinkedList analyzedTableHeaderLinkedList = new LinkedList();
    private LinkedList analyzedTableHeaderData = new LinkedList();
    PageFormat pageFormat = null;
    private volatile int totalRemovedRowCount = 0;
    private CSVFormatCalculator csvFormatCalculator = null;
    private PDFFormatCalculator pdfFormatCalculator = null;
    private XLSFormatCalculator xlsFormatCalculator = null;
    private TablePrintable tablePrintable = null;
    private boolean isOrdinaryTable = true;
    private volatile int adjustInt = 0;
    boolean inAppending = false;
    public Hashtable pageCountHTable = new Hashtable(20);
    boolean isFirstComputeFinish = false;
    private String totalTitle = "";
    private boolean isFixColWidthForHtml = false;
    private int maxColumnWidth = 0;
    boolean printCountInNewPage = false;
    private static final int DEFAULT_RECORDSCOUNT_PERFILE = 20000;
    private static final int DEFAULT_RECORDSCOUNT_PERFILE_XLSX = 500000;
    private static final int MAX_XLS_RECORDSCOUNT_PERFILE = 65536;
    private static final int MAX_XLSX_RECORDSCOUNT_PERFILE = 500000;
    private static final int MIN_RECORDSCOUNT_PERFILE = 1000;
    private int maxRecordsCountPerFile = 20000;
    private String fileType = null;
    private int[] tableHeadersProperty = null;
    private int totalRecordCount = -1;
    private boolean deleteFile = false;
    private RealTimePrintControler realTimePrintControler = null;
    private boolean isAppendOver = false;
    private boolean isFormatingInProgress = false;
    protected boolean headerError = false;
    public static final int DEFAULT_HTML_COLWIDTH = 200;
    private int htmlPerColWidth = 200;
    int countSplitRows = 0;
    int countSplitRowsBackup = 0;
    private EventListenerList appendStartListeners = new EventListenerList();
    protected int startY = 0;
    private boolean showTotalRecord = true;
    private boolean normalSave = false;
    private boolean isOpenFileEnable = false;
    private boolean isMultiFileEnable = true;
    private XLSXFormatCalculator xlsXFormatCalculator;

    public void setRealTimePrintControler(RealTimePrintControler realTimePrintControler) {
        this.realTimePrintControler = realTimePrintControler;
    }

    public RealTimePrintControler getRealTimePrintControler() {
        return this.realTimePrintControler;
    }

    public void setRealTimePageIndex(int n) {
        this.realTimePrintControler.setRealTimePageIndex(n);
    }

    public int getRealTimePageIndex() {
        if (this.realTimePrintControler != null) {
            return this.realTimePrintControler.getRealTimePageIndex();
        }
        return -1;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public int getMaxRecordsCountPerFile() {
        return this.maxRecordsCountPerFile;
    }

    public FormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl, boolean bl2, int[] nArray2) {
        this(string, string2, string3, stringArray, nArray, collection, n, bl, bl2);
        this.setTableHeadersProperty(nArray2);
    }

    public int[] getTableHeadersProperty() {
        return this.tableHeadersProperty;
    }

    public void setTableHeadersProperty(int[] nArray) {
        if (nArray != null) {
            this.tableHeadersProperty = new int[this.tableHeaders.length];
            System.arraycopy(nArray, 0, this.tableHeadersProperty, 0, nArray.length > this.tableHeaders.length ? this.tableHeaders.length : nArray.length);
        }
    }

    public void setMaxRecordsCountPerFile(int n) {
        if (n < 1000) {
            return;
        }
        this.maxRecordsCountPerFile = null != this.fileType && this.fileType.equals("xls") && n > 65536 ? 65536 : (null != this.fileType && this.fileType.equals("xlsx") && n > 500000 ? 500000 : n);
    }

    public FormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("_tableHeaders is null");
        }
        this.title = string == null ? "" : string;
        this.userName = string2 == null ? "" : string2;
        this.summary = string3 == null ? "" : string3;
        this.tableHeaders = stringArray;
        this.columnWidths = nArray;
        this.totalRowCount = n;
        this.isSave = bl;
        this.sourceData = collection;
        if (this.columnWidths != null) {
            this.isFixColWidthForHtml = true;
            this.isWidthCustomized = true;
        }
        this.initSourceDataArrayList();
        logger.trace("Save total row count is: " + this.totalRowCount);
    }

    public FormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl, boolean bl2) {
        this(string, string2, string3, stringArray, nArray, collection, n, bl);
        this.isOrdinaryTable = bl2;
    }

    public void init() {
        if (this.isSave) {
            this.pageFormat = new PageFormat();
            this.checkAndInitWidths(this.pageFormat);
        }
        if (this.pageFormat != null && !this.bSourceDataComputed) {
            this.computePageCount(this.sourceDataArrayList, this.pageFormat);
            this.bSourceDataComputed = true;
        }
    }

    private void initSourceDataArrayList() {
        if (this.sourceData == null || this.sourceData.size() <= 0) {
            return;
        }
        this.sourceDataArrayList = new ArrayList(this.sourceData.size());
        Iterator iterator = this.sourceData.iterator();
        Collection collection = null;
        ArrayList arrayList = null;
        Iterator iterator2 = null;
        while (iterator.hasNext()) {
            collection = (Collection)iterator.next();
            arrayList = new ArrayList(collection.size());
            iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
            this.sourceDataArrayList.add(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Collection collection) throws PrinterException {
        if (this.isAppendOver) {
            logger.trace("Business module has already called setAppendOver(),Appending data is not successful");
            return;
        }
        this.isFormatingInProgress = true;
        int n = 0;
        try {
            while (!(this.analyzedRowLinkedList.size() <= 500 && this.pageFormat != null && this.bSourceDataComputed || this.tablePrintable.isOver())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
                logger.trace("append ---- waitingTime = " + ++n);
                logger.trace("append ---- lastPrintedRowIndex = " + this.lastPrintedRowIndex);
                logger.trace("append ---- analyzedRowLinkedList.size()  = " + this.analyzedRowLinkedList.size());
                Object object = this.lock;
                synchronized (object) {
                    this.removePrintedData();
                }
            }
            this.inAppending = true;
            this.splittedRowsBackup += this.splittedRows;
            this.splittedRows = 0;
            this.computePageCount(collection, this.pageFormat);
        }
        finally {
            this.isFormatingInProgress = false;
        }
    }

    private void removePrintedData() {
        logger.trace("lastPrintedRowIndex(begin) = " + this.lastPrintedRowIndex);
        logger.trace("totalRemovedRowCount(begin) = " + this.totalRemovedRowCount);
        if (this.lastPrintedRowIndex <= this.totalRemovedRowCount) {
            return;
        }
        int n = this.lastPrintedRowIndex - this.totalRemovedRowCount;
        Iterator iterator = this.analyzedRowLinkedList.iterator();
        for (int i = 0; i <= n; ++i) {
            iterator.next();
            iterator.remove();
        }
        this.totalRemovedRowCount += n + 1;
        logger.trace("totalRemovedRowCount(end) = " + this.totalRemovedRowCount);
        logger.trace("analyzedRowLinkedList.size()(end)  = " + this.analyzedRowLinkedList.size());
    }

    final void initColumnWidths(PageFormat pageFormat) {
        this.columnWidths = new int[this.tableHeaders.length];
        if (this.isSave) {
            this.maxColumnWidth = 4000 / this.tableHeaders.length - 6;
            int n = 0;
            for (int i = 0; i < this.tableHeaders.length; ++i) {
                if (this.fileType != null && "txt".equals(this.fileType)) {
                    this.tableHeaders[i] = this.computeString(this.tableHeaders[i], true);
                }
                this.columnWidths[i] = (n = this.getHeadWidth(this.tableHeaders[i])) >= 15 ? n : 15;
            }
        } else {
            if (pageFormat.getImageableWidth() < 30.0) {
                logger.trace("PRINT_ERROR:ImageTableWidth can't be less MIN_IMAGEABLE_WIDTH");
                for (int i = 0; i < this.columnWidths.length; ++i) {
                    this.columnWidths[i] = 0;
                }
                return;
            }
            int n = 0;
            for (int i = 0; i < this.tableHeaders.length; ++i) {
                n = (int)(pageFormat.getImageableWidth() / (double)this.tableHeaders.length);
                this.columnWidths[i] = n > 30 ? n : 30;
            }
        }
    }

    final void adjustColumnWidths(PageFormat pageFormat) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            if ((double)this.columnWidths[i] > pageFormat.getImageableWidth()) {
                this.columnWidths[i] = (int)pageFormat.getImageableWidth();
            }
            if (this.columnWidths[i] < 30) {
                this.columnWidths[i] = 30;
            }
            ++n3;
            if ((n2 += this.columnWidths[i]) > (int)pageFormat.getImageableWidth() && i < this.columnWidths.length) {
                this.pageCountHTable.put(Integer.toString(n), Integer.toString(n3 - 1));
                ++n;
                n2 = this.columnWidths[i];
                n3 = 1;
            }
            if (i != this.columnWidths.length - 1 || n2 > (int)pageFormat.getImageableWidth()) continue;
            this.pageCountHTable.put(Integer.toString(n), Integer.toString(n3));
        }
    }

    final boolean checkColumnWidths() {
        if (this.columnWidths == null || this.columnWidths.length != this.tableHeaders.length) {
            return false;
        }
        if (this.isSave) {
            int n = this.columnWidths.length;
            for (int i = 0; i < n; ++i) {
                if (this.columnWidths[i] >= 15) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.columnWidths.length; ++i) {
                if (this.columnWidths[i] >= 30) continue;
                this.columnWidths[i] = 30;
            }
        }
        return true;
    }

    private int getHeadWidth(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SPEARATOR_N);
        String string2 = "";
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n2 = FormatCalculator.getTxtTextWidth(string2);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private String computeString(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SPEARATOR_N);
        String string2 = "";
        int n2 = 0;
        LinkedList linkedList = null;
        StringTokenizer stringTokenizer2 = null;
        String string3 = "";
        StringBuffer stringBuffer2 = null;
        Iterator iterator = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n2 = FormatCalculator.getTxtTextWidth(string2);
            if (n2 > this.maxColumnWidth) {
                linkedList = new LinkedList();
                stringTokenizer2 = new StringTokenizer(string2 = string2.replaceAll(LINE_SPEARATOR_R, ""), " ", true);
                if (stringTokenizer2.hasMoreElements()) {
                    string3 = stringTokenizer2.nextToken();
                    this.analyzeCellDataForBlank(stringTokenizer2, string3, linkedList, this.maxColumnWidth, bl);
                }
                stringBuffer2 = new StringBuffer("");
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    stringBuffer2.append(iterator.next().toString());
                    stringBuffer2.append(LINE_SPEARATOR_N);
                }
                n = stringBuffer2.toString().length() - 1;
                if (n < 0) {
                    n = 0;
                }
                string2 = stringBuffer2.toString().substring(0, n);
            }
            stringBuffer.append(string2);
            stringBuffer.append(LINE_SPEARATOR_N);
        }
        n = stringBuffer.toString().length() - 1;
        if (n < 0) {
            n = 0;
        }
        string = stringBuffer.toString().substring(0, n);
        return string;
    }

    synchronized void computePageCount(Collection collection, PageFormat pageFormat) {
        this.headerError = false;
        if (this.totleRecordsPosition && !this.isSave && !this.inAppending && this.isTotalRecordVisible()) {
            ++this.totalRowCount;
            this.hasIncTotalRowCount = true;
        }
        this.checkAndInitWidths(pageFormat);
        if (!this.isFirstComputeFinish && !this.isSave) {
            this.isFirstComputeFinish = true;
            this.adjustColumnWidths(pageFormat);
        }
        if (collection == null) {
            if (this.getAnalyzedRowCount() + this.adjustInt == this.totalRowCount) {
                this.computeOver = true;
            }
            return;
        }
        int n = collection.size();
        if (this.getAnalyzedRowCount() + n > this.totalRowCount) {
            n = this.totalRowCount - this.getAnalyzedRowCount();
        }
        if (this.checkForHeaderError()) {
            return;
        }
        this.analyzeData(this.analyzedRowLinkedList, collection, n);
        if (!this.isSave && n > 0) {
            int n2;
            int n3 = this.tablePageHashMap.size();
            int n4 = n2 = this.getTotleRecordsPosition() && !this.isSave && this.isTotalRecordVisible() ? this.getAnalyzedRowCount() - n - this.splittedRows - 1 : this.getAnalyzedRowCount() - n - this.splittedRows;
            if (this.isPrintOnLastPage(n3, this.startingY, pageFormat, n2)) {
                --n3;
            } else {
                this.startingY = 0;
            }
            this.computePage(n3, n2, pageFormat);
        }
        if (this.getAnalyzedRowCount() + this.adjustInt == this.totalRowCount) {
            this.computeOver = true;
        }
        this.checkForHeaderError();
    }

    public void checkAndInitWidths(PageFormat pageFormat) {
        if (!this.checkColumnWidths()) {
            this.initColumnWidths(pageFormat);
        }
    }

    final void analyzeData(Collection collection, Collection collection2, int n) {
        Iterator iterator = collection2.iterator();
        LinkedList linkedList = null;
        Collection collection3 = null;
        int n2 = 0;
        Iterator iterator2 = null;
        LinkedList<String> linkedList2 = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            collection3 = (Collection)iterator.next();
            linkedList = new LinkedList();
            n2 = 0;
            iterator2 = collection3.iterator();
            linkedList2 = null;
            while (iterator2.hasNext()) {
                linkedList2 = new LinkedList<String>();
                object = iterator2.next();
                if (object != null) {
                    string = object.toString();
                    if ("".equals(string)) {
                        string = "-";
                    }
                } else {
                    string = "-";
                }
                if (this.isHtml) {
                    linkedList2.add(string);
                } else {
                    this.analyzeCellData(string, linkedList2, n2, false);
                }
                linkedList.add(linkedList2);
                ++n2;
            }
            if (this.isSave) {
                collection.add(linkedList);
                continue;
            }
            object = this.splitLargeCells(linkedList);
            int n3 = ((LinkedList)object).size();
            for (int j = 0; j < n3; ++j) {
                collection.add(((LinkedList)object).get(j));
                if (j <= 0) continue;
                this.extraRowIndices.add(collection.size() - 1);
            }
        }
        this.totalRowCount += this.splittedRows;
        this.countSplitRows = this.splittedRows;
        this.countSplitRowsBackup = this.splittedRowsBackup;
    }

    private LinkedList splitLargeCells(LinkedList linkedList) {
        int n;
        LinkedList linkedList2 = new LinkedList();
        int n2 = this.tableHeaders.length;
        int n3 = (int)this.pageFormat.getImageableHeight() - this.getDataAboveHeightForPrint();
        int n4 = this.getMaxLineCountPerPage(n3);
        LinkedList linkedList3 = null;
        if (n4 <= 0) {
            if (!this.headerError) {
                logger.trace("In splitLargeCells headerError occured");
            }
            this.headerError = true;
            linkedList2.add(linkedList);
            return linkedList2;
        }
        int n5 = ((LinkedList)linkedList.get(0)).size();
        for (n = 1; n < n2; ++n) {
            linkedList3 = (LinkedList)linkedList.get(n);
            if (linkedList3.size() <= n5) continue;
            n5 = linkedList3.size();
        }
        if (n4 >= n5) {
            linkedList2.add(linkedList);
            return linkedList2;
        }
        n = 0;
        n = n5 % n4 == 0 ? n5 / n4 : n5 / n4 + 1;
        this.splittedRows = this.splittedRows + n - 1;
        for (int i = 0; i < n; ++i) {
            LinkedList linkedList4 = new LinkedList();
            for (int j = 0; j < n2; ++j) {
                LinkedList linkedList5 = new LinkedList();
                linkedList3 = (LinkedList)linkedList.get(j);
                int n6 = linkedList3.size();
                if (n6 > (i + 1) * n4) {
                    linkedList5.addAll(linkedList3.subList(i * n4, (i + 1) * n4));
                } else if (n6 <= (i + 1) * n4 && n6 > i * n4) {
                    linkedList5.addAll(linkedList3.subList(i * n4, n6));
                } else {
                    linkedList5.add("");
                }
                linkedList4.add(linkedList5);
            }
            linkedList2.add(linkedList4);
        }
        return linkedList2;
    }

    public int getExtraRowsAfterSplit() {
        return this.countSplitRows + this.countSplitRowsBackup;
    }

    public List getExtraRowIndices() {
        return this.extraRowIndices;
    }

    private int getMaxLineCountPerPage(int n) {
        int n2 = (n - 6) / PrintableTool.getFontHeight(this.dataFont);
        return n2;
    }

    private boolean isPrintOnLastPage(int n, int n2, PageFormat pageFormat, int n3) {
        boolean bl = false;
        int n4 = (int)pageFormat.getImageableHeight() - this.getDataAboveHeightForPrint();
        int n5 = this.calculateRowHeight(n3, n4);
        if (n > 0 && n2 > 0 && n2 + n5 <= n4) {
            bl = true;
        }
        return bl;
    }

    public void setAdjustInt(int n) {
        this.adjustInt += n;
        logger.trace("Save adjust value is: " + this.adjustInt);
    }

    public int setAppendOver(int n) {
        if (!this.isAppendOver) {
            while (this.isFormatingInProgress || this.pageFormat == null && !this.isAppendOver) {
                try {
                    Thread.sleep(1000L);
                    logger.trace("Waiting... for Condition PageFormat" + this.pageFormat + "isFormatInProgress" + this.isFormatingInProgress);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace("setAppendOver" + interruptedException);
                }
            }
            this.isAppendOver = true;
            logger.trace("Analyzed Row Count: " + this.getAnalyzedRowCount());
            logger.trace("Total Row Count : " + this.totalRowCount);
            logger.trace("GetAdjustInt Value from FormatCalculator" + n);
            int n2 = this.totalRowCount - this.getAnalyzedRowCount() - n;
            this.setAdjustInt(n2 + n);
            this.computeOver = true;
            return n2;
        }
        logger.trace("Format Calculator: User has already called setAppendOver() API");
        return 0;
    }

    public void setForceAppendOver() {
        logger.trace("The setForceAppendOver method is called");
        this.isAppendOver = true;
    }

    public int getAdjustInt() {
        return this.adjustInt;
    }

    protected void analyzeCellData(String string, LinkedList linkedList, int n, boolean bl) {
        int n2 = this.columnWidths[n];
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        String string3 = "";
        if (!this.isSave && n2 == 0) {
            logger.trace("PRINT_ERROR:textCapacityWidth can't be 0");
            linkedList.add("");
            return;
        }
        stringTokenizer = new StringTokenizer(string, LIST_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string2, " ", true);
            string3 = "";
            if (!stringTokenizer2.hasMoreElements()) continue;
            string3 = stringTokenizer2.nextToken();
            this.analyzeCellDataForBlank(stringTokenizer2, string3, linkedList, n2, bl);
        }
    }

    private void analyzeCellDataForBlank(StringTokenizer stringTokenizer, String charSequence, LinkedList linkedList, int n, boolean bl) {
        try {
            boolean bl2 = true;
            while (bl2) {
                CharSequence charSequence2;
                String string;
                if (null == charSequence) {
                    return;
                }
                if (this.isExceedColumnWidth((String)charSequence, n, bl)) {
                    string = this.analyzeCellDataForSingleStr((String)charSequence, linkedList, n, bl);
                    if (stringTokenizer.hasMoreElements()) {
                        charSequence2 = new StringBuffer(20);
                        charSequence = ((StringBuffer)charSequence2).append(string).append(stringTokenizer.nextToken()).toString();
                        continue;
                    }
                    if (string.length() > 0) {
                        linkedList.add(string);
                    }
                    return;
                }
                if (stringTokenizer.hasMoreElements()) {
                    string = stringTokenizer.nextToken();
                    if (this.isExceedColumnWidth(string, n, bl)) {
                        linkedList.add(charSequence);
                        charSequence2 = this.analyzeCellDataForSingleStr(string, linkedList, n, bl);
                        if (stringTokenizer.hasMoreElements()) {
                            StringBuffer stringBuffer = new StringBuffer(20);
                            charSequence = stringBuffer.append((String)charSequence2).append(stringTokenizer.nextToken()).toString();
                            continue;
                        }
                        if (((String)charSequence2).length() <= 0) continue;
                        linkedList.add(charSequence2);
                        bl2 = false;
                        continue;
                    }
                    charSequence2 = new StringBuffer((String)charSequence).append(string).toString();
                    if (this.isExceedColumnWidth((String)charSequence2, n, bl)) {
                        linkedList.add(charSequence);
                        charSequence = string;
                        continue;
                    }
                    charSequence = charSequence2;
                    continue;
                }
                linkedList.add(charSequence);
                bl2 = false;
            }
        }
        catch (Exception exception) {
            logger.trace("Exception while saving the file as TXT :" + exception);
        }
    }

    private String analyzeCellDataForSingleStr(String string, LinkedList linkedList, int n, boolean bl) {
        if (this.isSave) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = this.trimString(string, n, arrayList);
            int n3 = arrayList.size();
            String string2 = "";
            if (n3 > 0) {
                if (n2 > 0) {
                    string2 = (String)arrayList.remove(n3 - 1);
                }
                linkedList.addAll(arrayList);
            }
            return string2;
        }
        char[] cArray = string.toCharArray();
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        while ((n5 = cArray.length - n4) > 0) {
            Font font = null;
            font = bl ? TABLE_HEADER_FONT : this.dataFont;
            while (PrintableTool.getCharsWidth(cArray, n4, n5, font) > n - 6) {
                --n5;
            }
            string3 = new String(cArray, n4, n5).trim();
            if (cArray.length - (n4 += n5) <= 0) {
                if (this.isSubColumnWidth(string3, n, bl)) {
                    return string3;
                }
                linkedList.add(string3);
                continue;
            }
            linkedList.add(string3);
        }
        return "";
    }

    private boolean isExceedColumnWidth(String string, int n, boolean bl) {
        if (this.isSave) {
            return FormatCalculator.getTxtTextWidth(string) > n;
        }
        if (bl) {
            return PrintableTool.getTextWidth(string, TABLE_HEADER_FONT) > n - 6;
        }
        return PrintableTool.getTextWidth(string, this.dataFont) > n - 6;
    }

    private boolean isSubColumnWidth(String string, int n, boolean bl) {
        if (this.isSave) {
            return FormatCalculator.getTxtTextWidth(string) < n;
        }
        if (bl) {
            return PrintableTool.getTextWidth(string, TABLE_HEADER_FONT) < n;
        }
        return PrintableTool.getTextWidth(string, this.dataFont) < n;
    }

    public boolean getPrintCountInNewPage() {
        return this.printCountInNewPage;
    }

    private void computePage(int n, int n2, PageFormat pageFormat) {
        Integer n3;
        Integer n4;
        int n5;
        while (Math.max(n, this.getRealTimePageIndex() - 1) < this.getSummaryPageCount() - 1) {
            this.tablePageHashMap.put(n, 0);
            ++n;
            ++this.onlySummaryPageCount;
        }
        if (this.realTimePrintControler != null && !this.realTimePrintControler.isBFirst()) {
            this.startingY = 0;
        } else if (n == this.getSummaryPageCount() - 1) {
            this.startingY += this.getSummaryHeight();
            n5 = this.getSummaryLastPrintingY() + PrintableTool.getFontHeight(TABLE_HEADER_FONT) * 2 - PrintableTool.getFontDescent(TABLE_HEADER_FONT);
            if (n5 > (int)pageFormat.getImageableHeight() - 10) {
                this.tablePageHashMap.put(n, 0);
                ++n;
                ++this.onlySummaryPageCount;
                this.startingY = 0;
                this.printCountInNewPage = true;
            }
        }
        if (this.getSummaryPageCount() == 0 && n == 0) {
            this.startingY += this.startY;
        }
        n5 = (int)pageFormat.getImageableHeight() - this.getDataAboveHeightForPrint();
        if (n2 == this.getAnalyzedRowCount() - 1 && this.getTotleRecordsPosition() && !this.isSave && this.isTotalRecordVisible()) {
            n5 = (int)pageFormat.getImageableHeight();
        }
        int n6 = n2;
        int n7 = this.calculateRowHeight(n2, n5);
        boolean bl = this.getAnalyzedRowCount() + this.adjustInt == this.totalRowCount;
        int n8 = this.getAnalyzedRowCount();
        if (this.getTotleRecordsPosition() && !this.isSave && !bl && this.isTotalRecordVisible()) {
            n8 = this.getAnalyzedRowCount() - 1;
        }
        while (this.startingY + n7 <= n5) {
            this.startingY += n7;
            if (++n2 == n8) break;
            n7 = this.calculateRowHeight(n2, n5);
            if (this.startingY + n7 <= n5) continue;
            this.startingY = 0;
            break;
        }
        int n9 = n2 - n6;
        boolean bl2 = false;
        if (n9 == 0) {
            if (this.startingY + n7 > n5) {
                if (n == this.getSummaryPageCount() - 1) {
                    this.tablePageHashMap.put(n, 0);
                    ++this.onlySummaryPageCount;
                    this.startingY = 0;
                } else if (this.startY != 0) {
                    this.startingY = 0;
                }
            }
            bl2 = true;
        }
        if ((n4 = (Integer)this.tablePageHashMap.get(n3 = Integer.valueOf(n))) != null) {
            n9 += n4.intValue();
        }
        this.tablePageHashMap.put(n3, n9);
        if (n2 == n8 || bl2 && n > this.summaryPageCount) {
            return;
        }
        this.computePage(n + 1, n2, pageFormat);
    }

    final int getSummaryHeight() {
        return this.getSummaryLastPrintingY() - this.calculateHeadRowCount(this.getHeadInfoEnabled()) - 10;
    }

    private boolean getHeadInfoEnabled() {
        if (this.realTimePrintControler != null) {
            return this.realTimePrintControler.getHeadInfoEnabled();
        }
        return true;
    }

    public final int getDataAboveHeightForPrint() {
        int n = 0;
        n = this.getTotleRecordsPosition() && !this.isSave && this.isTotalRecordVisible() || this.realTimePrintControler != null ? this.getTableHeaderHeight() : PrintableTool.getFontHeight(TABLE_HEADER_FONT) * 3 + this.getTableHeaderHeight();
        int n2 = this.calculateHeadRowCount(this.getHeadInfoEnabled()) + 10 + n;
        return n2;
    }

    public int calculateRowHeight(int n, int n2) {
        int n3;
        if (n == this.getAnalyzedRowCount() - 1 && this.getTotleRecordsPosition() && !this.isSave && this.isTotalRecordVisible()) {
            return PrintableTool.getFontHeight(TABLE_HEADER_FONT) * 2;
        }
        LinkedList linkedList = this.getAnalyzedRowLinkList(n);
        int n4 = this.tableHeaders.length;
        if (n4 == 0) {
            return 6;
        }
        LinkedList linkedList2 = (LinkedList)linkedList.get(0);
        LinkedList linkedList3 = null;
        for (n3 = 1; n3 < n4; ++n3) {
            linkedList3 = (LinkedList)linkedList.get(n3);
            if (linkedList3.size() <= linkedList2.size()) continue;
            linkedList2 = linkedList3;
        }
        n3 = linkedList2.size();
        int n5 = PrintableTool.getFontHeight(this.dataFont) * n3 + 6;
        return n5;
    }

    public LinkedList getAnalyzeHeadData() {
        if (this.analyzedTableHeaderData.size() == 0) {
            LinkedList linkedList = null;
            for (int i = 0; i < this.getTableHeaders().length; ++i) {
                linkedList = new LinkedList();
                this.analyzeCellData(this.getTableHeaders()[i], linkedList, i, LINE_SPEARATOR_N);
                this.analyzedTableHeaderData.add(linkedList);
            }
        }
        return this.analyzedTableHeaderData;
    }

    protected void analyzeCellData(String string, LinkedList linkedList, int n, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if ((string3 = string3.replaceAll(LINE_SPEARATOR_R, " ")).length() <= 0) continue;
            linkedList.add(string3);
        }
    }

    public int getTableHeaderHeight() {
        if (this.analyzedTableHeaderLinkedList.size() == 0) {
            LinkedList linkedList = null;
            for (int i = 0; i < this.tableHeaders.length; ++i) {
                linkedList = new LinkedList();
                this.analyzeCellData(this.getTableHeaders()[i], linkedList, i, true);
                this.analyzedTableHeaderLinkedList.add(linkedList);
            }
        }
        int n = 1;
        Iterator iterator = this.analyzedTableHeaderLinkedList.iterator();
        LinkedList linkedList = null;
        while (iterator.hasNext()) {
            linkedList = (LinkedList)iterator.next();
            if (n >= linkedList.size()) continue;
            n = linkedList.size();
        }
        int n2 = n * PrintableTool.getFontHeight(TABLE_HEADER_FONT) + 6;
        return n2;
    }

    public int getLastPageRowCount() {
        int n = this.getPageCount() == 500000 ? this.getPageCount() : this.tablePageHashMap.size();
        Object v = this.tablePageHashMap.get(n - 1);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    public int getTotalRowsCount() {
        if (this.isOrdinaryTable) {
            return this.totalRowCount;
        }
        return this.tableHeaders.length - 1;
    }

    public boolean getIsOrdinaryTable() {
        return this.isOrdinaryTable;
    }

    public int[] getTxtColumnWidths() {
        return this.columnWidths;
    }

    private int getTxtOneLineCharCount() {
        int n = 0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            n += this.columnWidths[i];
        }
        return n;
    }

    public String getTxtSeparatorLine() {
        int n = 8;
        int n2 = this.getTxtOneLineCharCount();
        n2 += this.tableHeaders.length * n + 1;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            n2 += n - this.columnWidths[i] % n;
        }
        StringBuffer stringBuffer = new StringBuffer(150);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static String getTxtBlackText(int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int getTxtTextWidth(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= '\u007f') continue;
            ++n;
        }
        return n;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = null;
        try {
            string = TimeDateFormatUtil.getFormatDateTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(16) / 1000, gregorianCalendar.get(15) / 1000);
        }
        catch (FormatException formatException) {
            logger.trace(formatException.getMessage(), formatException);
        }
        return string;
    }

    public String[] getTableHeaders() {
        return this.tableHeaders;
    }

    public int getRrintColCount() {
        return this.tableHeaders.length;
    }

    public String getUserName() {
        return this.userName;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public int getAnalyzedRowCount() {
        if (this.getTotleRecordsPosition() && !this.isSave && this.isTotalRecordVisible()) {
            return this.analyzedRowLinkedList.size() + this.totalRemovedRowCount + 1;
        }
        return this.analyzedRowLinkedList.size() + this.totalRemovedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getAnalyzedRowLinkList(int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = n - this.totalRemovedRowCount;
            if (n2 >= this.analyzedRowLinkedList.size()) {
                logger.trace(" realRowIndex = " + n);
                logger.trace("totalRemovedRowCount = " + this.totalRemovedRowCount);
            }
            return (LinkedList)this.analyzedRowLinkedList.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getAndDeleteAnalyzedRowLinkList(int n) {
        Object object = this.lock;
        synchronized (object) {
            ++this.totalRemovedRowCount;
            return (LinkedList)this.analyzedRowLinkedList.remove(0);
        }
    }

    public int getLastPrintedRowIndex() {
        return this.lastPrintedRowIndex;
    }

    public void setTablePrintable(TablePrintable tablePrintable) {
        this.tablePrintable = tablePrintable;
    }

    public void setLastPrintedRowIndex(int n) {
        this.lastPrintedRowIndex = n;
    }

    public HashMap getTablePageHashMap() {
        return this.tablePageHashMap;
    }

    public boolean isComputeOver() {
        return this.computeOver;
    }

    boolean isSave() {
        return this.isSave;
    }

    public int getPageCount() {
        int n = 0;
        if (!this.isComputeOver()) {
            n = 500000;
        } else {
            Object v = this.tablePageHashMap.get(this.tablePageHashMap.size() - 1);
            int n2 = v == null ? 0 : (Integer)v;
            n = this.pageCountHTable.size() > 1 && this.getTotleRecordsPosition() && n2 == 1 && this.isTotalRecordVisible() ? (this.getTablePageHashMap().size() - 1 - this.onlySummaryPageCount) * this.pageCountHTable.size() + 1 + this.onlySummaryPageCount : (this.getTablePageHashMap().size() - this.onlySummaryPageCount) * this.pageCountHTable.size() + this.onlySummaryPageCount;
        }
        return n;
    }

    public int getPageHashMapIndex(int n) {
        int n2 = n;
        if (this.pageCountHTable.size() > 1 && n >= this.onlySummaryPageCount) {
            n2 = (n - this.onlySummaryPageCount) / this.pageCountHTable.size() + this.onlySummaryPageCount;
        }
        return n2;
    }

    public int getMaxPageCount() {
        return (this.getTablePageHashMap().size() - this.onlySummaryPageCount) * this.pageCountHTable.size() + this.onlySummaryPageCount;
    }

    public LinkedList getAnalyzedTableHeaderLinkedList() {
        return this.analyzedTableHeaderLinkedList;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageFormatWithCompute(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.isFormatingInProgress = true;
        try {
            this.calculateSummary();
            if (!this.bSourceDataComputed) {
                this.inAppending = false;
                this.computePageCount(this.sourceDataArrayList, pageFormat);
                this.bSourceDataComputed = true;
            }
        }
        finally {
            this.isFormatingInProgress = false;
        }
    }

    private int calculateHeadRowCount(boolean bl) {
        int n;
        int n2;
        if (!bl || this.pageFormat == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = (int)this.pageFormat.getImageableWidth();
        String string = this.title == null || this.title.length() == 0 ? "(untitled)" : this.title;
        int n5 = 0;
        if (n2 < n4) {
            ++n5;
        } else {
            int n6;
            int n7 = 0;
            for (n2 = PrintableTool.getTextWidth(string, TABLE_HEADER_FONT); n2 >= n4; n2 -= PrintableTool.getTextWidth(string.substring(n7, n6 + n7), TABLE_HEADER_FONT)) {
                n6 = 0;
                while (n6 + n7 < string.length() && PrintableTool.getTextWidth(string.substring(n7, n6 + n7), TABLE_HEADER_FONT) < n4) {
                    ++n6;
                }
                while (n6 + n7 <= string.length() && PrintableTool.getTextWidth(string.substring(n7, n6 + n7), TABLE_HEADER_FONT) >= n4) {
                    --n6;
                }
                ++n5;
                n7 = n6 + n7;
            }
            if (string.substring(n7).length() > 0) {
                ++n5;
            }
        }
        StringBuffer stringBuffer = new StringBuffer("printTime");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string2 = null;
        try {
            string2 = TimeDateFormatUtil.getFormatDateTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(16) / 1000, gregorianCalendar.get(15) / 1000);
        }
        catch (FormatException formatException) {
            logger.trace(formatException.getMessage(), formatException);
        }
        stringBuffer.append(string2);
        stringBuffer.append("    ");
        stringBuffer.append("userName");
        stringBuffer.append(this.userName);
        stringBuffer.append("    currentPage");
        int n8 = this.getPageCount();
        if (n8 == 500000) {
            n8 = 0;
        }
        stringBuffer.append(n8);
        String string3 = stringBuffer.toString();
        if (n < n4) {
            n3 = n5 + 1;
        } else {
            int n9;
            int n10 = 0;
            for (n = PrintableTool.getTextWidth(string3, TABLE_HEADER_FONT); n >= n4; n -= PrintableTool.getTextWidth(string3.substring(n10, n9 + n10), TABLE_HEADER_FONT)) {
                n9 = 0;
                while (PrintableTool.getTextWidth(string3.substring(n10, n9 + n10), TABLE_HEADER_FONT) < n4) {
                    ++n9;
                }
                while (PrintableTool.getTextWidth(string3.substring(n10, n9 + n10), TABLE_HEADER_FONT) > n4) {
                    --n9;
                }
                ++n5;
                n10 = n9 + n10;
            }
            if (string3.substring(n10).length() > 0) {
                ++n5;
            }
            n3 = n5;
        }
        if (n3 == 0) {
            n3 = 2;
        }
        return PrintableTool.getFontHeight(TABLE_HEADER_FONT) * n3 + 6;
    }

    public ArrayList getSourceDataArrayList() {
        return this.sourceDataArrayList;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    private void calculateSummary() {
        if ((int)this.pageFormat.getImageableWidth() >= 30) {
            if (this.summary.length() > 0) {
                this.getSummaryLines();
                this.calculateSummaryPageCount();
            }
        } else {
            logger.trace("don't calculateSummary. reason:ImageTableWidth can't be less MIN_IMAGEABLE_WIDTH");
        }
    }

    private void calculateLine(BufferedReader bufferedReader) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        int n = 20;
        int n2 = (int)this.pageFormat.getImageableWidth() - 4 - 10;
        char[] cArray = null;
        int n3 = 0;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (this.isSave) {
                linkedList.add(string);
                continue;
            }
            cArray = string.toCharArray();
            n3 = 0;
            while (PrintableTool.getCharsWidth(cArray, n3, cArray.length - n3, this.dataFont) > n2) {
                if (n > cArray.length - n3) {
                    n = cArray.length - n3;
                }
                while (PrintableTool.getCharsWidth(cArray, n3, n, this.dataFont) < n2) {
                    ++n;
                }
                while (PrintableTool.getCharsWidth(cArray, n3, n, this.dataFont) > n2) {
                    --n;
                }
                string2 = new String(cArray, n3, n);
                linkedList.add(string2);
                n3 += n;
            }
            if (cArray.length - n3 <= 0) continue;
            linkedList.add(new String(cArray, n3, cArray.length - n3));
        }
        this.summaryLineList = new ArrayList(linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSummaryLines() {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.summary));
        try {
            this.calculateLine(bufferedReader);
        }
        catch (IOException iOException) {
            logger.trace("IO Error : Can not read summary text");
        }
        finally {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        String[] stringArray = new String[this.summaryLineList.size()];
        int n = 0;
        Iterator iterator = this.summaryLineList.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    private void calculateSummaryPageCount() {
        int n;
        int n2 = ((int)this.pageFormat.getImageableHeight() - this.calculateHeadRowCount(this.getHeadInfoEnabled())) / PrintableTool.getFontHeight(this.dataFont) - 1;
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        if (this.startY != 0) {
            n3 = this.startY / PrintableTool.getFontHeight(this.dataFont);
        }
        this.summaryPageCount = ((n = this.summaryLineList.size()) + n3) % n2 == 0 ? (n + n3) / n2 : (n + n3) / n2 + 1;
    }

    public int getSummaryLastPrintingY() {
        int n = PrintableTool.getFontHeight(this.dataFont);
        int n2 = (int)this.pageFormat.getImageableHeight();
        int n3 = (n2 - this.calculateHeadRowCount(this.getHeadInfoEnabled())) / n - 1;
        int n4 = this.summaryPageCount - 1;
        int n5 = n3 * n4;
        int n6 = this.summaryLineList.size() - n5;
        double d = this.calculateHeadRowCount(this.getHeadInfoEnabled()) + n + n * n6;
        return (int)d + this.startY;
    }

    public CSVFormatCalculator getCsvFormatCalculator() {
        if (this.csvFormatCalculator == null) {
            this.csvFormatCalculator = new CSVFormatCalculator(this.title, this.userName, this.summary, this.tableHeaders, this.columnWidths, this.sourceData, this.totalRowCount, this.isOrdinaryTable);
            this.csvFormatCalculator.setTablePrintable(this.tablePrintable);
            this.csvFormatCalculator.setFileType("csv");
            this.csvFormatCalculator.setMaxRecordsCountPerFile(this.getMaxRecordsCountPerFile());
            this.csvFormatCalculator.setTotalTitle(this.getTotalTitle());
            this.csvFormatCalculator.setOpenFileEnable(this.isOpenFileEnable);
        }
        return this.csvFormatCalculator;
    }

    public PDFFormatCalculator getPdfFormatCalculator() {
        if (this.pdfFormatCalculator == null) {
            this.pdfFormatCalculator = new PDFFormatCalculator(this.title, this.userName, this.summary, this.tableHeaders, this.columnWidths, this.sourceData, this.totalRowCount, this.isOrdinaryTable);
            this.pdfFormatCalculator.setTotleRecordsPosition(this.getTotleRecordsPosition());
            this.pdfFormatCalculator.setTablePrintable(this.tablePrintable);
            this.pdfFormatCalculator.setFileType("pdf");
            this.pdfFormatCalculator.setTotalTitle(this.getTotalTitle());
            this.pdfFormatCalculator.setMaxRecordsCountPerFile(this.getMaxRecordsCountPerFile());
            this.pdfFormatCalculator.setOpenFileEnable(this.isOpenFileEnable);
        }
        return this.pdfFormatCalculator;
    }

    public XLSFormatCalculator getXLSFormatCalculator() {
        if (this.xlsFormatCalculator == null) {
            this.xlsFormatCalculator = new XLSFormatCalculator(this.title, this.userName, this.summary, this.tableHeaders, this.columnWidths, this.sourceData, this.totalRowCount, this.isOrdinaryTable);
            this.xlsFormatCalculator.setTablePrintable(this.tablePrintable);
            this.xlsFormatCalculator.setFileType("xls");
            this.xlsFormatCalculator.setMaxRecordsCountPerFile(this.getMaxRecordsCountPerFile());
            this.xlsFormatCalculator.setOpenFileEnable(this.isOpenFileEnable);
        }
        return this.xlsFormatCalculator;
    }

    public XLSXFormatCalculator getXLSXFormatCalculator() {
        if (this.xlsXFormatCalculator == null) {
            this.xlsXFormatCalculator = new XLSXFormatCalculator(this.title, this.userName, this.summary, this.tableHeaders, this.columnWidths, this.sourceData, this.totalRowCount, this.isOrdinaryTable);
            this.xlsXFormatCalculator.setTablePrintable(this.tablePrintable);
            this.xlsXFormatCalculator.setFileType("xlsx");
            this.xlsXFormatCalculator.setMaxRecordsCountPerFile(this.getMaxRecordsCountPerFile());
            this.xlsXFormatCalculator.setOpenFileEnable(this.isOpenFileEnable);
        }
        return this.xlsXFormatCalculator;
    }

    public void setBRealTimePrint(boolean bl) {
        this.bRealTimePrint = bl;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getSummaryPageCount() {
        return this.summaryPageCount;
    }

    public int getOnlySummaryPageCount() {
        return this.onlySummaryPageCount;
    }

    public ArrayList getSummaryLineList() {
        return this.summaryLineList;
    }

    public void setIsHtml(boolean bl) {
        this.isHtml = bl;
    }

    public boolean isBRealTimePrint() {
        return this.bRealTimePrint;
    }

    public void reset() {
        this.bSourceDataComputed = false;
        this.isFirstComputeFinish = false;
        if (!this.isWidthCustomized) {
            this.columnWidths = null;
        }
        this.analyzedRowLinkedList.clear();
        this.countSplitRows = 0;
        this.countSplitRowsBackup = 0;
        this.totalRowCount -= this.splittedRows;
        this.splittedRows = 0;
        this.extraRowIndices.clear();
        this.totalRemovedRowCount = 0;
        this.lastPrintedRowIndex = -1;
        this.startingY = 0;
        this.computeOver = false;
        this.pageCountHTable.clear();
        this.tablePageHashMap.clear();
        this.onlySummaryPageCount = 0;
        this.analyzedTableHeaderLinkedList.clear();
        this.pageFormat = null;
        this.isAppendOver = false;
        this.isFormatingInProgress = false;
        this.printCountInNewPage = false;
        if (this.hasIncTotalRowCount) {
            --this.totalRowCount;
            this.hasIncTotalRowCount = false;
        }
    }

    public void setTotalTitle(String string) {
        this.totalTitle = string;
    }

    public String getTotalTitle() {
        return this.totalTitle;
    }

    public boolean isFixColWidthForHtml() {
        return this.isFixColWidthForHtml;
    }

    public void setTotleRecordsPosition(boolean bl) {
        this.totleRecordsPosition = bl;
    }

    public boolean getTotleRecordsPosition() {
        return this.totleRecordsPosition;
    }

    public void setTotalRecordCount(int n) {
        this.totalRecordCount = n;
    }

    public int getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public void setDeleteFileFlag(boolean bl) {
        this.deleteFile = bl;
    }

    public boolean getDeleteFileFlag() {
        return this.deleteFile;
    }

    public void setDataFont(Font font) {
        this.dataFont = font;
    }

    public Font getDataFont() {
        return this.dataFont;
    }

    public boolean getHeaderError() {
        return this.headerError;
    }

    protected void resetForHeaderError() {
        PageFormat pageFormat = this.pageFormat;
        this.reset();
        this.pageFormat = pageFormat;
        this.isAppendOver = true;
    }

    public void setHtmlPerColWidth(int n) {
        this.htmlPerColWidth = n;
    }

    public int getHtmlPerColWidth() {
        return this.htmlPerColWidth;
    }

    protected boolean checkForHeaderError() {
        boolean bl = this.headerError = this.headerError || this.pageFormat.getImageableWidth() < 30.0;
        if (this.headerError) {
            logger.trace("headerError found in " + this.getClass());
            this.resetForHeaderError();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Window window = PrintSupportor.getParentFrame();
                    OptionPane.showMessageDialog(window, res.getString("headerError"));
                }
            });
            this.computeOver = true;
        }
        return this.headerError;
    }

    public void setStartY(int n) {
        this.startY = n;
    }

    public void addAppendStartListener(AppendStartListener appendStartListener) {
        this.appendStartListeners.add(AppendStartListener.class, appendStartListener);
    }

    public void removeAppendStartListener(AppendStartListener appendStartListener) {
        this.appendStartListeners.remove(AppendStartListener.class, appendStartListener);
    }

    public void fireCanStartAppend() {
        Object[] objectArray = this.appendStartListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != AppendStartListener.class) continue;
            ((AppendStartListener)objectArray[i + 1]).canStartAppend();
        }
    }

    public void setTotalRecordCountVisibilty(boolean bl) {
        this.showTotalRecord = bl;
    }

    public boolean isTotalRecordVisible() {
        return this.showTotalRecord;
    }

    public void setNormalSave(boolean bl) {
        this.normalSave = bl;
    }

    public boolean isNormalSave() {
        return this.normalSave;
    }

    public void setOpenFileEnable(boolean bl) {
        this.isOpenFileEnable = bl;
    }

    public boolean isOpenFileEnabled() {
        return this.isOpenFileEnable;
    }

    private int trimString(String string, int n, List<String> list) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            n2 = cArray[i] > '\u007f' ? (n2 += 2) : ++n2;
            if (n2 == n) {
                stringBuffer.append(cArray[i]);
                n2 = 0;
                list.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            if (n2 > n) {
                list.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(cArray[i]);
                n2 = 0;
                if (cArray[i] > '\u007f') {
                    n2 += 2;
                    continue;
                }
                ++n2;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        list.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        return n2;
    }

    private class XLSXFormatCalculator
    extends FormatCalculator {
        public XLSXFormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl) {
            super(string, string2, string3, stringArray, nArray, collection, n, bl);
            FormatCalculator.this.maxRecordsCountPerFile = 500000;
        }

        @Override
        protected void analyzeCellData(String string, LinkedList linkedList, int n, boolean bl) {
            linkedList.add(string.replaceAll("\r\n", FormatCalculator.LINE_SPEARATOR_N));
        }
    }

    private class XLSFormatCalculator
    extends FormatCalculator {
        public XLSFormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl) {
            super(string, string2, string3, stringArray, nArray, collection, n, true, bl);
        }

        @Override
        protected void analyzeCellData(String string, LinkedList linkedList, int n, boolean bl) {
            linkedList.add(string.replaceAll("\r\n", FormatCalculator.LINE_SPEARATOR_N));
        }
    }

    private class PDFFormatCalculator
    extends FormatCalculator {
        PDFFormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl) {
            super(string, string2, string3, stringArray, nArray, collection, n, true, bl);
        }

        @Override
        protected void analyzeCellData(String string, LinkedList linkedList, int n, boolean bl) {
            linkedList.add(string);
        }
    }

    private class CSVFormatCalculator
    extends FormatCalculator {
        public CSVFormatCalculator(String string, String string2, String string3, String[] stringArray, int[] nArray, Collection collection, int n, boolean bl) {
            super(string, string2, string3, stringArray, nArray, collection, n, true, bl);
        }

        @Override
        protected void analyzeCellData(String string, LinkedList linkedList, int n, boolean bl) {
            if (string.indexOf(44) == -1 && string.indexOf(13) == -1 && string.indexOf(10) == -1 && string.indexOf(34) == -1) {
                linkedList.add(string);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append("\"");
            if (string.indexOf(34) == -1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string.replaceAll("\"", "\"\""));
            }
            stringBuffer.append("\"");
            linkedList.add(stringBuffer.toString());
        }
    }
}

