/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.FileSavingable;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SavePrintable;
import com.swimap.iview.templates.print.tools.AbstractSaveImpl;
import com.swimap.iview.templates.print.tools.CSVSaveImpl;
import com.swimap.iview.templates.print.tools.ExcelSaveImpl;
import com.swimap.iview.templates.print.tools.HTMLSaveImpl;
import com.swimap.iview.templates.print.tools.PDFSaveImpl;
import com.swimap.iview.templates.print.tools.TXTSaveImpl;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.print.tools.UnsupportedPDFHeaderException;
import com.swimap.iview.templates.print.tools.XLSSaveImpl;
import com.swimap.iview.templates.print.tools.XLSXSaveImpl;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

final class FileSavingThread
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(FileSavingThread.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    private Window mainFrame = null;
    private String fileName = null;
    private TablePrintable[] tablePrintables = null;
    private String fileType = null;
    private BufferedWriter out = null;
    private Writer writer = null;
    private int length = 1;
    private boolean hasDtdHeader = false;
    private boolean txtSnapLeft = false;
    private static final String LINE_SEPARATOR_N = "\n";
    private String customEncoding = null;

    protected FileSavingThread(Window window, String string, TablePrintable tablePrintable, String string2) {
        this(window, string, new TablePrintable[]{tablePrintable}, string2);
    }

    protected FileSavingThread(Window window, String string, TablePrintable[] tablePrintableArray, String string2) {
        this.mainFrame = window;
        this.fileName = string;
        this.tablePrintables = tablePrintableArray;
        this.fileType = string2;
        this.initImpl();
    }

    private void initImpl() {
        this.length = this.tablePrintables.length;
        AbstractSaveImpl abstractSaveImpl = null;
        for (int i = 0; i < this.length; ++i) {
            if ("html".equals(this.fileType)) {
                abstractSaveImpl = new HTMLSaveImpl(this.tablePrintables[i].getFormatCalculator());
            } else if ("txt".equals(this.fileType)) {
                abstractSaveImpl = new TXTSaveImpl(this.tablePrintables[i].getFormatCalculator());
                if (this.tablePrintables[i].isTxtSnapLeft()) {
                    ((TXTSaveImpl)abstractSaveImpl).setTxtSnapLeft(this.tablePrintables[i].isTxtSnapLeft());
                }
            } else if ("csv".equals(this.fileType)) {
                abstractSaveImpl = new CSVSaveImpl(this.tablePrintables[i].getFormatCalculator());
            } else if ("xls".equals(this.fileType)) {
                abstractSaveImpl = new XLSSaveImpl(this.tablePrintables[i].getFormatCalculator());
            } else if ("xlsx".equals(this.fileType)) {
                abstractSaveImpl = new XLSXSaveImpl(this.tablePrintables[i].getFormatCalculator());
            } else if ("pdf".equals(this.fileType)) {
                abstractSaveImpl = new PDFSaveImpl(this.tablePrintables[i].getFormatCalculator());
            }
            if (abstractSaveImpl instanceof AbstractSaveImpl) {
                ((AbstractSaveImpl)abstractSaveImpl).setParentFrame(this.mainFrame);
            }
            this.tablePrintables[i].setImplRef(abstractSaveImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.length > 1 && ("xls".equals(this.fileType) || "xlsx".equals(this.fileType))) {
                this.saveMultiTableXLSFile();
            } else if ("xls".equals(this.fileType) || "xlsx".equals(this.fileType) || "pdf".equals(this.fileType)) {
                this.saveSinlgeXLSorPDF();
            } else {
                this.saveTXTorHTMLorCSVorXML();
            }
            if (null != this.tablePrintables && 0 < this.tablePrintables.length) {
                SavePrintable savePrintable = this.tablePrintables[0].getImplRef();
                savePrintable.setDataOver(true);
            }
        }
        finally {
            for (int i = 0; i < this.tablePrintables.length; ++i) {
                this.tablePrintables[i].setSaveProcessCompleteWithCleanUp(true);
            }
        }
    }

    private void closeFileStream() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void affterSaveProcess() {
        boolean bl = false;
        for (int i = 0; i < this.tablePrintables.length; ++i) {
            if (!this.tablePrintables[i].getDeleteFileFlag()) continue;
            bl = true;
            break;
        }
        if (bl) {
            logger.trace("start delete file");
            String[] stringArray = this.getFileNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.deleteSavedFile(stringArray[i]);
            }
        }
    }

    private void deleteSavedFile(String string) {
        File file = new File(CommonUtil.getAbsolutePath(string));
        boolean bl = false;
        if (file.exists() && file.isFile()) {
            bl = file.delete();
        }
        logger.trace("deletedFileName:" + string);
        if (!bl) {
            logger.debug("Delete file failed!");
        } else {
            logger.debug("Delete file success!");
        }
    }

    private void setSaveState(String string) {
        for (int i = 0; i < this.tablePrintables.length; ++i) {
            if (this.tablePrintables[i].getSaveCanceled() && !string.equals("save canceled")) continue;
            this.tablePrintables[i].setSaveState(string);
        }
    }

    public void setHasDtdHeader(boolean bl) {
        this.hasDtdHeader = bl;
    }

    public boolean isHasDtdHeader() {
        return this.hasDtdHeader;
    }

    public void setTxtSnapLeft(boolean bl) {
        this.txtSnapLeft = bl;
    }

    public boolean isTxtSnapLeft() {
        return this.txtSnapLeft;
    }

    private void saveAccomplished() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.tablePrintables.length; ++n) {
            if (!this.tablePrintables[n].getSaveCanceled()) continue;
            bl = true;
            break;
        }
        n = this.getFilesCount(this.getFileNames());
        if (bl) {
            this.setSaveState("save canceled");
        } else if (n == 1) {
            this.setSaveState("save in one file");
        } else if (n > 1) {
            this.setSaveState("save in some files");
        }
    }

    private int getFilesCount(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            ++n;
        }
        return n;
    }

    private String[] getFileNames() {
        String[] stringArray = new String[]{};
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        AbstractSaveImpl abstractSaveImpl = null;
        for (int i = 0; i < this.tablePrintables.length; ++i) {
            if (this.tablePrintables[i].getImplRef() instanceof AbstractSaveImpl) {
                abstractSaveImpl = (AbstractSaveImpl)this.tablePrintables[i].getImplRef();
                stringArray2 = abstractSaveImpl.getCsvXlsorPdfFileNames();
            }
            if (null == stringArray2) continue;
            stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public String getCustomEncoding() {
        return this.customEncoding;
    }

    public void setCustomEncoding(String string) {
        if (null == string) {
            return;
        }
        this.customEncoding = SaveFileChooser.ENCODING_KEY_VALUE_MAP.get(string);
        if (null == this.customEncoding && Charset.isSupported(string)) {
            this.customEncoding = string;
        }
        if (null != this.customEncoding) {
            try {
                Charset charset = Charset.forName(this.customEncoding);
                this.customEncoding = charset.name();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                logger.trace("Charset is not supported. customEncoding: " + this.customEncoding);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                logger.trace("Illegal Charset Name. customEncoding: " + this.customEncoding);
            }
        }
    }

    private void saveMultiTableXLSFile() {
        ExcelSaveImpl excelSaveImpl = null;
        try {
            ExcelSaveImpl excelSaveImpl2 = (ExcelSaveImpl)this.tablePrintables[0].getImplRef();
            excelSaveImpl2.writeInit(this.fileName, this.tablePrintables);
            ExcelSaveImpl excelSaveImpl3 = null;
            for (int i = 0; i < this.length; ++i) {
                excelSaveImpl = (ExcelSaveImpl)this.tablePrintables[i].getImplRef();
                if (i > 0) {
                    excelSaveImpl3 = (ExcelSaveImpl)this.tablePrintables[i - 1].getImplRef();
                    excelSaveImpl.associatePreSaveImplInfo(excelSaveImpl3);
                }
                if (i == 0) {
                    excelSaveImpl.writeExtraInfo();
                }
                excelSaveImpl.writeTitle();
                excelSaveImpl.write(i == this.length - 1);
            }
            this.saveAccomplished();
            this.affterSaveProcess();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            for (int i = 0; i < this.length; ++i) {
                this.tablePrintables[i].getImplRef().setDataOver(true);
            }
            this.setSaveState("save unsuccessfully");
            String string = "";
            if (null != excelSaveImpl) {
                string = excelSaveImpl.getCurrentFileName();
            }
            Object[] objectArray = new Object[]{string};
            final String string2 = MessageFormat.format(res.getString("errorFile"), objectArray);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringBuffer stringBuffer = OptionPane.separateStringWith(string2, FileSavingThread.LINE_SEPARATOR_N);
                    OptionPane.showErrorDialog(FileSavingThread.this.mainFrame, stringBuffer);
                }
            });
        }
    }

    private void saveSinlgeXLSorPDF() {
        int n;
        ExcelSaveImpl excelSaveImpl = null;
        PDFSaveImpl pDFSaveImpl = null;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.fileName;
        int n2 = 1;
        File file = null;
        for (n = 0; n < this.length; ++n) {
            try {
                if ("xls".equals(this.fileType) || "xlsx".equals(this.fileType)) {
                    excelSaveImpl = (ExcelSaveImpl)this.tablePrintables[n].getImplRef();
                    excelSaveImpl.writeTitle(this.fileName);
                    if (n == 0) {
                        excelSaveImpl.writeExtraInfo();
                    }
                    excelSaveImpl.write();
                } else {
                    if (n > 0) {
                        String string2 = ".pdf";
                        do {
                            this.fileName = string.substring(0, string.length() - string2.length());
                            this.fileName = this.fileName + "@table" + ++n2 + string2;
                        } while ((file = new File(this.fileName)).exists());
                    }
                    pDFSaveImpl = (PDFSaveImpl)this.tablePrintables[n].getImplRef();
                    pDFSaveImpl.writePDFDocument(this.fileName);
                    stringBuffer.append(pDFSaveImpl.getMultiFileNames());
                }
                this.saveAccomplished();
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                String string3 = "";
                if ("xls".equals(this.fileType) || "xlsx".equals(this.fileType)) {
                    excelSaveImpl.setDataOver(true);
                    this.setSaveState("save unsuccessfully");
                    try {
                        excelSaveImpl.closeCurrentStream();
                    }
                    catch (IOException iOException) {
                        logger.trace("Exception while closing stream = " + iOException);
                    }
                    string3 = excelSaveImpl.getCurrentFileName();
                    this.deleteSavedFile(string3);
                    this.showErrorMessage(string3);
                    break;
                }
                pDFSaveImpl.setDataOver(true);
                this.setSaveState("save unsuccessfully");
                string3 = pDFSaveImpl.getCurrentFileName();
                Object object = ReflectionUtilities.getFieldByObject(pDFSaveImpl, "pdfGenerator");
                Object object2 = null;
                if (null != object) {
                    object2 = ReflectionUtilities.getFieldByObject(object, "lockStream");
                }
                if (null != object2) {
                    try {
                        ((FileOutputStream)object2).close();
                    }
                    catch (Exception exception2) {
                        logger.trace("Exception while closing stream = " + exception2);
                    }
                }
                if (exception instanceof UnsupportedPDFHeaderException) {
                    for (int i = 0; i < this.tablePrintables.length; ++i) {
                        this.tablePrintables[i].setDeleteFileFlag(true);
                    }
                    this.showPdfErrorMessage();
                    this.affterSaveProcess();
                    return;
                }
                this.deleteSavedFile(string3);
                this.showErrorMessage(string3);
                return;
            }
        }
        if ("pdf".equals(this.fileType) && null != pDFSaveImpl) {
            n = 0;
            for (int i = 0; i < this.tablePrintables.length; ++i) {
                if (!this.tablePrintables[i].getFormatCalculator().getDeleteFileFlag()) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                this.affterSaveProcess();
                return;
            }
            if (pDFSaveImpl.showOpenFileDialog()) {
                return;
            }
            if (this.length > 1 || this.length == 1 && pDFSaveImpl.isMultipleFilesSaved()) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                stringBuffer.append(PrintSupportor.res.getString("fullStop"));
                pDFSaveImpl.showMutiFilesInfo(stringBuffer.toString());
            } else {
                pDFSaveImpl.showFileSaveSuccessInfo(stringBuffer.toString());
            }
        }
        this.affterSaveProcess();
    }

    private void saveTXTorHTMLorCSVorXML() {
        Object object;
        try {
            if (this.fileType.equals("html") || this.fileType.equals("xml")) {
                this.customEncoding = "UTF-8";
            }
            object = new FileOutputStream(CommonUtil.getAbsolutePath(this.fileName));
            if (null != this.customEncoding && Charset.isSupported(this.customEncoding)) {
                if (this.customEncoding.equalsIgnoreCase("UTF-8")) {
                    this.writeBOM((FileOutputStream)object);
                }
                this.writer = new OutputStreamWriter((OutputStream)object, this.customEncoding);
            } else {
                this.writer = new OutputStreamWriter((OutputStream)object);
            }
            this.out = new BufferedWriter(this.writer);
            try {
                FileLock fileLock = ((FileOutputStream)object).getChannel().tryLock();
                if (null == fileLock || !fileLock.isValid()) {
                    this.showLockFailedMessage();
                    return;
                }
                logger.trace("The file locked for saving:" + this.fileName);
            }
            catch (Exception exception) {
                logger.trace("In FileSaving Thread, exception while locking:" + exception);
                this.showLockFailedMessage();
                return;
            }
        }
        catch (Exception exception) {
            this.setSaveState("save unsuccessfully");
            String string = this.fileName;
            this.showErrorMessage(string);
            logger.trace(exception.getMessage(), exception);
            return;
        }
        if ("xml".equals(this.fileType)) {
            this.saveXMLFile();
            return;
        }
        object = null;
        for (int i = 0; i < this.tablePrintables.length; ++i) {
            try {
                Object object2;
                object = (FileSavingable)((Object)this.tablePrintables[i].getImplRef());
                ((AbstractSaveImpl)object).setCloseStream(i == this.tablePrintables.length - 1);
                ((AbstractSaveImpl)object).setFileName(this.fileName);
                if (i > 0) {
                    object2 = (FileSavingable)((Object)this.tablePrintables[i - 1].getImplRef());
                    int n = ((AbstractSaveImpl)object2).getLastFileRecordCount();
                    ((AbstractSaveImpl)object).setLastFileRecordCount(n);
                    String[] stringArray = ((AbstractSaveImpl)object2).getCsvXlsorPdfFileNames();
                    ((AbstractSaveImpl)object).setCsvXlsorPdfFileNames(stringArray);
                }
                ((AbstractSaveImpl)object).isFiles();
                if ("html".equals(this.fileType)) {
                    ((HTMLSaveImpl)object).setSaveEncoding(this.getCustomEncoding());
                }
                if (i == 0 && this.tablePrintables.length > 1) {
                    if (object instanceof AbstractSaveImpl) {
                        object2 = ((AbstractSaveImpl)object).getFormatCalculator().getTotalTitle();
                        ((AbstractSaveImpl)object).writeTotalExtraInfo(this.out, (String)object2);
                    }
                } else if (object instanceof TXTSaveImpl && !((TXTSaveImpl)object).isMultiFiles()) {
                    object2 = (TXTSaveImpl)object;
                    ((TXTSaveImpl)object2).setMultiFiles(true);
                    ((TXTSaveImpl)object2).setSaveEncoding(this.customEncoding);
                }
                if ("html".equals(this.fileType) && this.tablePrintables.length > 1) {
                    ((HTMLSaveImpl)object).setTitleSizeToH2();
                }
                object.writeTitle(this.out);
                if (i == 0 && this.tablePrintables.length == 1) {
                    object.writeExtraInfo(this.out);
                }
                if (i != this.tablePrintables.length - 1) {
                    ((AbstractSaveImpl)object).setShowMultiFileInfo(false);
                }
                ((AbstractSaveImpl)object).setLastStream(this.out);
                object.write(this.out);
                this.saveAccomplished();
                this.out = ((AbstractSaveImpl)object).getLastStream();
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                ((SavePrintable)object).setDataOver(true);
                this.setSaveState("save unsuccessfully");
                String string = this.fileName;
                if (object instanceof CSVSaveImpl) {
                    string = ((CSVSaveImpl)object).getCurrentFileName();
                }
                this.showErrorMessage(string);
                break;
            }
        }
        try {
            this.out.close();
            this.affterSaveProcess();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.closeFileStream();
            this.affterSaveProcess();
        }
    }

    private void saveXMLFile() {
        Collection[] collectionArray = new Collection[this.length];
        ArrayList<String[]> arrayList = new ArrayList<String[]>(this.length);
        String[] stringArray = new String[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.tablePrintables[i].getFormatCalculator().init();
            collectionArray[i] = this.tablePrintables[i].getFormatCalculator().getSourceDataArrayList();
            arrayList.add(this.tablePrintables[i].getFormatCalculator().getTableHeaders());
            stringArray[i] = this.tablePrintables[i].getFormatCalculator().getTitle();
        }
        try {
            this.setHasDtdHeader(this.tablePrintables[0].isHasDtdHeader());
            CommStyleInfo commStyleInfo = new CommStyleInfo();
            commStyleInfo.setEncoding(this.getCustomEncoding());
            CommStyleManager.getInstance().saveDataToXML(commStyleInfo, collectionArray, arrayList, stringArray, this.out, this.isHasDtdHeader());
            this.out.close();
            this.setSaveState("save in one file");
            this.affterSaveProcess();
            return;
        }
        catch (Exception exception) {
            this.setSaveState("save unsuccessfully");
            for (int i = 0; i < this.length; ++i) {
                this.tablePrintables[i].setDeleteFileFlag(true);
            }
            String string = this.fileName;
            this.showErrorMessage(string);
            logger.trace(exception.getMessage(), exception);
            this.affterSaveProcess();
            return;
        }
    }

    private void showLockFailedMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), res.getString("FileLocked"));
            }
        });
        for (int i = 0; i < this.length; ++i) {
            this.tablePrintables[i].setDataOver(true);
        }
        this.setSaveState("save unsuccessfully");
    }

    private void showErrorMessage(String string) {
        final String string2 = MessageFormat.format(res.getString("errorFile"), string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuffer stringBuffer = OptionPane.separateStringWith(string2, FileSavingThread.LINE_SEPARATOR_N);
                OptionPane.showErrorDialog(FileSavingThread.this.mainFrame, stringBuffer);
            }
        });
    }

    private void showPdfErrorMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPane.showMessageDialog(FileSavingThread.this.mainFrame, res.getString("pdfSaveError"));
            }
        });
    }

    private void writeBOM(FileOutputStream fileOutputStream) {
        byte[] byArray = new byte[]{-17, -69, -65};
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            logger.trace("Exception while Writing BOM" + iOException.getMessage());
        }
    }
}

