/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.persistencecombobox;

import com.swimap.iview.templates.utils.MultiRowToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class stepComboBox
extends JComboBox {
    private FontMetrics fm = this.getFontMetrics(this.getFont());
    protected int maxItemWidth = 0;
    protected Container cframe = null;
    private ExDefaultComboBoxModel mydataModel = null;
    private JButton button = null;
    private boolean hasDefaultValue = false;
    private int defaultValueIndex = -1;
    private static final int OFFSET = 16;
    private static final int INCREASE_HEIGHT = 16;

    public stepComboBox() {
        this.setcframe(this.getParent());
        this.setUI(this.createUI());
        this.setName("stepComboBox");
    }

    public stepComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.setcframe(this.getParent());
        this.initComboBox();
    }

    public stepComboBox(Object[] objectArray) {
        super(objectArray);
        this.setcframe(this.getParent());
        this.resetMaxItemWidth(objectArray);
        this.initComboBox();
    }

    public stepComboBox(Object[] objectArray, Container container) {
        super(objectArray);
        this.setcframe(container);
        this.resetMaxItemWidth(objectArray);
        this.initComboBox();
    }

    public stepComboBox(Vector vector) {
        super(vector);
        this.setcframe(this.getParent());
        this.resetMaxItemWidth(vector.toArray());
        this.initComboBox();
    }

    public stepComboBox(Vector vector, Container container) {
        super(vector);
        this.setcframe(container);
        this.resetMaxItemWidth(vector.toArray());
        this.initComboBox();
    }

    public stepComboBox(Container container) {
        this.setcframe(container);
        this.initComboBox();
    }

    private void initComboBox() {
        this.setUI(this.createUI());
        this.setEditable(true);
        ((JTextField)this.getEditor().getEditorComponent()).setEditable(false);
        ((JTextField)this.getEditor().getEditorComponent()).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    stepComboBox.this.showMypopup();
                }
            }
        });
        ((JTextField)this.getEditor().getEditorComponent()).addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JTextField)stepComboBox.this.getEditor().getEditorComponent()).setBackground(new Color(52, 97, 139));
                ((JTextField)stepComboBox.this.getEditor().getEditorComponent()).setForeground(Color.white);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                stepComboBox.this.setEditorBg();
            }
        });
        ((JTextField)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                stepComboBox.this.setEditorBg();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                stepComboBox.this.setEditorBg();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        ((JTextField)this.getEditor().getEditorComponent()).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                stepComboBox.this.selectWithKeyChar(keyEvent.getKeyChar());
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stepComboBox.this.showMypopup();
            }
        });
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    stepComboBox.this.showMypopup();
                }
            }
        });
        this.setName("stepComboBox");
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        ((JTextField)this.getEditor().getEditorComponent()).setName(string + "_TextField");
        this.button.setName(string + "button");
    }

    @Override
    public void showPopup() {
        this.setEditorBg();
        this.setPopupVisible(true);
    }

    private void setEditorBg() {
        if (this.getSelectedIndex() == this.getDefaultValueIndex() && this.getDefaultValueIndex() != -1) {
            ((JTextField)this.getEditor().getEditorComponent()).setBackground(new Color(182, 182, 182));
            ((JTextField)this.getEditor().getEditorComponent()).setForeground(Color.black);
        } else {
            ((JTextField)this.getEditor().getEditorComponent()).setBackground(new Color(227, 232, 233));
            ((JTextField)this.getEditor().getEditorComponent()).setForeground(Color.black);
        }
    }

    private void showMypopup() {
        if (this.isPopupVisible()) {
            this.hidePopup();
        } else {
            this.showPopup();
        }
    }

    public void addItem(Object object) {
        if (this.getItemCount() < 1) {
            this.maxItemWidth = 0;
        }
        if (object == null) {
            return;
        }
        int n = this.fm.charsWidth(object.toString().toCharArray(), 0, object.toString().length()) + 16;
        if (n > this.maxItemWidth) {
            this.maxItemWidth = n;
        }
        super.addItem(object);
    }

    public void insertItemAt(Object object, int n) {
        if (object == null) {
            return;
        }
        int n2 = this.fm.charsWidth(object.toString().toCharArray(), 0, object.toString().length()) + 16;
        if (n2 > this.maxItemWidth) {
            this.maxItemWidth = n2;
        }
        super.insertItemAt(object, n);
    }

    @Override
    public void removeAllItems() {
        this.maxItemWidth = 0;
        if (this.mydataModel != null) {
            this.mydataModel.removeAllObjects();
            if (!this.isEditable()) {
                this.setSelectedItem(null);
            }
        } else {
            super.removeAllItems();
        }
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        super.setModel(comboBoxModel);
        if (this.fm != null) {
            this.resetMaxItemWidth(comboBoxModel);
        }
    }

    private void resetMaxItemWidth(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].toString().length() <= objectArray[n].toString().length()) continue;
            n = i;
        }
        this.maxItemWidth = this.fm.charsWidth(objectArray[n].toString().toCharArray(), 0, objectArray[n].toString().length()) + 16;
    }

    private void resetMaxItemWidth(ComboBoxModel comboBoxModel) {
        int n = comboBoxModel.getSize();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (comboBoxModel.getElementAt(i).toString().length() <= comboBoxModel.getElementAt(n2).toString().length()) continue;
            n2 = i;
        }
        this.maxItemWidth = this.fm.charsWidth(comboBoxModel.getElementAt(n2).toString().toCharArray(), 0, comboBoxModel.getElementAt(n2).toString().length()) + 16;
    }

    public void setItems(Object[] objectArray) {
        this.mydataModel = new ExDefaultComboBoxModel(objectArray);
        this.setModel((ComboBoxModel)this.mydataModel);
        this.resetMaxItemWidth(objectArray);
    }

    public int getmaxItemWidth() {
        return this.maxItemWidth;
    }

    public void setmaxItemWidth(int n) {
        this.maxItemWidth = n;
    }

    public Container getcframe() {
        return this.cframe;
    }

    public void setcframe(Container container) {
        this.cframe = container == null ? this.getParent() : container;
    }

    public void setDefaultValue(int n) {
        this.defaultValueIndex = n;
        this.setSelectedIndex(n);
    }

    public int getDefaultValueIndex() {
        return this.defaultValueIndex;
    }

    public void setDefaultValue(String string) {
    }

    public void setHasDefaultValue(boolean bl) {
        this.hasDefaultValue = bl;
    }

    public boolean getHasDefaultValue() {
        return this.hasDefaultValue;
    }

    public boolean isValidValue() {
        return true;
    }

    public void showErrorMessage() {
    }

    private ComboBoxUI createUI() {
        if (UIManager.getLookAndFeel().getName().indexOf("Metal") > -1) {
            return new SteppedMetalComboBoxUI();
        }
        return new SteppedComboBoxUI();
    }

    @Override
    protected JComboBox.KeySelectionManager createDefaultKeySelectionManager() {
        return new KeySelectionManagerEX();
    }

    private final class SteppedMetalComboBoxUI
    extends MetalComboBoxUI {
        private SteppedMetalComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            SteppedComboPupop steppedComboPupop = new SteppedComboPupop(this.comboBox);
            steppedComboPupop.getAccessibleContext().setAccessibleParent(this.comboBox);
            steppedComboPupop.setName("SteppedMetalComboBoxUI_popup");
            return steppedComboPupop;
        }

        @Override
        protected JButton createArrowButton() {
            stepComboBox.this.button = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox){

                @Override
                public JToolTip createToolTip() {
                    MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
                    multiRowToolTip.setComponent(this);
                    return multiRowToolTip;
                }
            };
            stepComboBox.this.button.setName("stepComboBox_button0");
            stepComboBox.this.button.setMargin(new Insets(0, 1, 1, 3));
            return stepComboBox.this.button;
        }
    }

    private final class SteppedComboPupop
    extends BasicComboPopup {
        public SteppedComboPupop(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        protected JScrollPane createScroller() {
            return new JScrollPane(this.list, 20, 30);
        }

        @Override
        protected KeyListener createKeyListener() {
            return new myInvocationKeyListener();
        }

        @Override
        public void show() {
            Serializable serializable;
            boolean bl = true;
            Dimension dimension = new Dimension();
            int n = ((stepComboBox)this.comboBox).getmaxItemWidth();
            int n2 = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
            if (n < ((stepComboBox)this.comboBox).getSize().width) {
                n = ((stepComboBox)this.comboBox).getSize().width;
            } else {
                serializable = ((stepComboBox)this.comboBox).getcframe();
                if (serializable != null) {
                    Dimension dimension2 = new Dimension(0, 0);
                    if (serializable instanceof JComponent) {
                        ((JComponent)serializable).getSize(dimension2);
                    } else {
                        dimension2 = ((Component)serializable).getSize();
                    }
                    int n3 = dimension2.width - (((stepComboBox)this.comboBox).getLocationOnScreen().x - ((Component)serializable).getLocationOnScreen().x);
                    int n4 = dimension2.width - n3 + ((stepComboBox)this.comboBox).getWidth();
                    if (n > n3) {
                        if (n < n4) {
                            bl = false;
                        } else if (n3 > n4) {
                            n = n3;
                            n2 += 16;
                        } else {
                            n = n4;
                            n2 += 16;
                            bl = false;
                        }
                    }
                }
            }
            dimension.setSize(n, n2);
            serializable = null;
            serializable = bl ? this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height) : this.computePopupBounds(this.comboBox.getBounds().width - dimension.width, this.comboBox.getBounds().height, dimension.width, dimension.height);
            this.adjustPopupHeight((Rectangle)serializable);
            this.scroller.setMaximumSize(((Rectangle)serializable).getSize());
            this.scroller.setPreferredSize(((Rectangle)serializable).getSize());
            this.scroller.setMinimumSize(((Rectangle)serializable).getSize());
            this.list.invalidate();
            int n5 = this.comboBox.getSelectedIndex();
            if (n5 == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(n5);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            Insets insets = this.getInsets();
            this.setPopupSize(new Dimension(((stepComboBox)this.comboBox).getSize().width, ((Rectangle)serializable).height + insets.bottom + insets.top));
            this.show(this.comboBox, ((Rectangle)serializable).x, ((Rectangle)serializable).y);
        }

        private void adjustPopupHeight(Rectangle rectangle) {
            int n = this.list.getModel().getSize();
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            Object e = null;
            Component component = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                e = this.list.getModel().getElementAt(i);
                component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
                Dimension dimension = component.getPreferredSize();
                if (n2 >= dimension.width) continue;
                n2 = dimension.width;
            }
            if (n2 > this.comboBox.getSize().width) {
                rectangle.height += 16;
            }
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = null;
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            boolean bl = this.inModalDialog();
            Container container = null;
            for (Container container2 = ((stepComboBox)this.comboBox).getParent(); container2 != null && !((container = container2) instanceof JApplet); container2 = container2.getParent()) {
            }
            Point point = null;
            Dimension dimension = null;
            rectangle = new Rectangle();
            if (container != null) {
                dimension = container.getSize();
                point = container.getLocationOnScreen();
            } else {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle = new Rectangle();
                point = new Point(0, 0);
            }
            SwingUtilities.convertPointFromScreen(point, this.comboBox);
            rectangle.x = point.x;
            rectangle.y = point.y;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height - 40;
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
                return rectangle2;
            }
            Rectangle rectangle3 = new Rectangle(rectangle2.x, -rectangle2.height, rectangle2.width, rectangle2.height);
            if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle3)) {
                return rectangle3;
            }
            if (bl) {
                SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle3);
                if (rectangle2.height > rectangle3.height) {
                    return rectangle2;
                }
                return rectangle3;
            }
            return rectangle3;
        }

        private Dialog getDialog() {
            Container container = null;
            for (container = this.comboBox.getParent(); container != null && !(container instanceof Dialog) && !(container instanceof Window); container = container.getParent()) {
            }
            if (container instanceof Dialog) {
                return (Dialog)container;
            }
            return null;
        }

        private boolean inModalDialog() {
            return this.getDialog() != null;
        }

        public class myInvocationKeyListener
        extends KeyAdapter {
            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        }
    }

    private final class SteppedComboBoxUI
    extends BasicComboBoxUI {
        private SteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            SteppedComboPupop steppedComboPupop = new SteppedComboPupop(this.comboBox);
            steppedComboPupop.getAccessibleContext().setAccessibleParent(this.comboBox);
            steppedComboPupop.setName("SteppedComboBoxUI_popup");
            return steppedComboPupop;
        }

        @Override
        protected JButton createArrowButton() {
            stepComboBox.this.button = new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight")){

                @Override
                public JToolTip createToolTip() {
                    MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
                    multiRowToolTip.setComponent(this);
                    return multiRowToolTip;
                }
            };
            stepComboBox.this.button.setName("StepComboBox_button1");
            return stepComboBox.this.button;
        }
    }

    private final class KeySelectionManagerEX
    implements JComboBox.KeySelectionManager,
    Serializable {
        private long beginTime = 0L;
        private static final long SPACH_TIME = 3000L;
        private long nextTime = 0L;
        private StringBuffer keyString = new StringBuffer(16);

        private KeySelectionManagerEX() {
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            int n;
            this.beginTime = this.nextTime;
            this.nextTime = System.currentTimeMillis();
            if (!Character.isDefined(c)) {
                return -1;
            }
            if (this.nextTime - this.beginTime > 3000L) {
                this.keyString.delete(0, this.keyString.length());
                this.keyString.append(c);
            } else {
                this.keyString.append(c);
            }
            int n2 = comboBoxModel.getSize();
            int n3 = stepComboBox.this.getSelectedIndex();
            String string = null;
            Object object = null;
            for (n = 0; n < n2; ++n) {
                object = comboBoxModel.getElementAt(n);
                if (object == null || object.toString() == null || (string = object.toString().toLowerCase()).length() <= 0 || !string.startsWith(this.keyString.toString().toLowerCase())) continue;
                return n;
            }
            if (this.keyString.toString().length() > 1) {
                for (n = ++n3; n < n2; ++n) {
                    object = comboBoxModel.getElementAt(n);
                    if (object == null || object.toString() == null || (string = object.toString().toLowerCase()).length() <= 0 || string.charAt(0) != Character.toLowerCase(c)) continue;
                    this.keyString.delete(0, this.keyString.length());
                    this.keyString.append(c);
                    return n;
                }
                for (n = 0; n < n3; ++n) {
                    object = comboBoxModel.getElementAt(n);
                    if (object == null || object.toString() == null || (string = object.toString().toLowerCase()).length() <= 0 || string.charAt(0) != Character.toLowerCase(c)) continue;
                    this.keyString.delete(0, this.keyString.length());
                    this.keyString.append(c);
                    return n;
                }
            }
            return -1;
        }
    }

    private final class ExDefaultComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    Serializable {
        private Vector objects = new Vector(10);
        private Object selectedObject = null;

        public ExDefaultComboBoxModel() {
        }

        public ExDefaultComboBoxModel(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.objects.addElement(objectArray[i]);
            }
        }

        public ExDefaultComboBoxModel(Vector vector) {
            this.objects.addAll(vector);
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.elementAt(n);
            }
            return null;
        }

        public int getIndexOf(Object object) {
            return this.objects.indexOf(object);
        }

        private void removeAllObjects() {
            int n = 0;
            int n2 = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.fireIntervalRemoved(this, n, n2);
        }
    }
}

