/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.persistencecombobox;

import com.swimap.iview.templates.persistencecombobox.DefaultPersistenceHandler;
import com.swimap.iview.templates.persistencecombobox.PersistenceComboxModel;
import com.swimap.iview.templates.persistencecombobox.PersistenceHandlerInterface;
import com.swimap.iview.templates.persistencecombobox.stepComboBox;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class PersistenceCombox
extends stepComboBox {
    private static IviewLogger logger = IviewLogger.getLogger(PersistenceCombox.class, "IVIEW");
    private PersistenceComboxModel model = new PersistenceComboxModel();
    private transient PersistenceHandlerInterface persistenceHandler = new DefaultPersistenceHandler();
    private Object persistenceLoaction = "";

    public PersistenceCombox(Object object) {
        this.setPersistenceLoaction(object);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void jbInit() {
        this.setEditable(false);
        this.setBounds(new Rectangle(121, 18, 221, 21));
    }

    public void storeInfo() throws Exception {
        if (this.persistenceHandler == null) {
            this.persistenceHandler = new DefaultPersistenceHandler();
        }
        int n = this.getItemCount();
        ArrayList arrayList = new ArrayList(16);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getItemAt(i));
        }
        this.model.setInforList(arrayList);
        this.persistenceHandler.savePersistenceInformation(this.model, this.persistenceLoaction);
    }

    public void loadInfo() throws Exception {
        if (this.persistenceHandler == null) {
            this.persistenceHandler = new DefaultPersistenceHandler();
        }
        this.model = (PersistenceComboxModel)this.persistenceHandler.loadPersistenceInformation(this.persistenceLoaction);
        try {
            if (this.model == null) {
                this.model = new PersistenceComboxModel();
                return;
            }
            this.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(this.model.getInforList().toArray()));
            this.setSelectedIndex(this.model.getSelectedIndex());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public String getSelectInfo() {
        Object[] objectArray = this.getSelectedObjects();
        if (null == objectArray || objectArray.length < 1) {
            return null;
        }
        return objectArray[0].toString();
    }

    public void setSelectInfo(String string) {
        this.model.addItem(string);
        this.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(this.model.getInforList().toArray()));
    }

    public PersistenceHandlerInterface getPersistenceHandler() {
        return this.persistenceHandler;
    }

    public void setPersistenceHandler(PersistenceHandlerInterface persistenceHandlerInterface) {
        this.persistenceHandler = persistenceHandlerInterface;
    }

    public Object getPersistenceLoaction() {
        return this.persistenceLoaction;
    }

    public void setPersistenceLoaction(Object object) {
        this.persistenceLoaction = object;
    }
}

