/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.persistencecombobox;

import com.swimap.iview.templates.persistencecombobox.PersistenceHandlerInterface;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DefaultPersistenceHandler
implements PersistenceHandlerInterface {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultPersistenceHandler.class, "IVIEW");
    private FileInputStream fileInput = null;
    private ObjectInputStream objectInput = null;
    private FileOutputStream fileOutput = null;
    private ObjectOutputStream objectOutput = null;

    @Override
    public synchronized Object loadPersistenceInformation(Object object) throws Exception {
        try {
            if (object == null) {
                logger.trace("log_client->Statistic->DefaultPersistenceHandler->location is null!");
                return null;
            }
            File file = null;
            file = new File(CommonUtil.getAbsolutePath(object.toString()));
            return this.loadObject(file);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    public synchronized void savePersistenceInformation(Object object, Object object2) throws Exception {
        File file = null;
        file = new File(CommonUtil.getAbsolutePath(object2.toString()));
        this.saveObject(object, file);
    }

    private void saveObject(Object object, File file) throws Exception {
        File file2 = file.getParentFile();
        if (null != file2 && !file2.exists()) {
            file2.mkdirs();
        }
        try {
            this.fileOutput = new FileOutputStream(file);
            this.objectOutput = new ObjectOutputStream(this.fileOutput);
            this.objectOutput.writeObject(object);
            this.objectOutput.flush();
            this.objectOutput.reset();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw exception;
        }
        finally {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
            if (this.objectOutput != null) {
                this.objectOutput.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadObject(File file) {
        try {
            Object object;
            int n;
            if (!file.exists() && 0 == (n = file.createNewFile())) {
                Object var3_4 = null;
                return var3_4;
            }
            this.fileInput = new FileInputStream(file);
            n = this.fileInput.available();
            if (n == 0) {
                this.fileInput.close();
                Object var3_5 = null;
                return var3_5;
            }
            this.objectInput = new ObjectInputStream(this.fileInput);
            Object object2 = object = this.objectInput.readObject();
            return object2;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            Object var3_7 = null;
            return var3_7;
        }
        finally {
            try {
                if (this.objectInput != null) {
                    this.objectInput.close();
                }
                if (this.fileInput != null) {
                    this.fileInput.close();
                }
                if (this.fileOutput != null) {
                    this.fileOutput.close();
                }
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }
}

