/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.pagingtree.client.PagingTree;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class SortableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    static URL sortableIconURL = SortableHeaderRenderer.class.getResource("sortable.gif");
    private static ImageIcon sortableIcon = new ImageIcon(sortableIconURL);
    static URL ascIconURL = SortableHeaderRenderer.class.getResource("ascend.gif");
    private static ImageIcon ascIcon = new ImageIcon(ascIconURL);
    static URL dscIconURL = SortableHeaderRenderer.class.getResource("descend.gif");
    private static ImageIcon dscIcon = new ImageIcon(dscIconURL);
    private PagingTree tree = null;
    private String name = null;
    private boolean ascent = false;

    public SortableHeaderRenderer(PagingTree pagingTree, String string, boolean bl) {
        this.tree = pagingTree;
        this.name = string;
        this.ascent = bl;
        this.setHorizontalAlignment(0);
        this.setIconTextGap(5);
        this.setHorizontalTextPosition(2);
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        this.setBorder(border);
    }

    public void setAscend(boolean bl) {
        this.ascent = bl;
    }

    public boolean isAscent() {
        return this.ascent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }
        this.setText(object == null ? "" : object.toString());
        if (this.tree != null && ResourceUtil.areEquals(this.tree.getSortedColumnName(), this.name)) {
            this.setIcon(this.ascent ? ascIcon : dscIcon);
        } else {
            this.setIcon(sortableIcon);
        }
        return this;
    }
}

