/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.templates.pagingtree.client.PagingTreeSequencedEvent;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

class SequencedEventProcessor {
    private static IviewLogger logger = IviewLogger.getLogger(SequencedEventProcessor.class, "IVIEW");
    private static SequencedEventProcessor instance = null;
    private List<PagingTreeSequencedEvent> eventList = new ArrayList<PagingTreeSequencedEvent>();
    private PagingTreeEventDispatchThread dispatcherThread = null;
    private static int dispatchThreadCounter = 0;

    private SequencedEventProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SequencedEventProcessor getInstance() {
        if (null != instance) return instance;
        Class<SequencedEventProcessor> clazz = SequencedEventProcessor.class;
        synchronized (SequencedEventProcessor.class) {
            if (null != instance) return instance;
            instance = new SequencedEventProcessor();
            logger.trace("Instance creation successfull");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvent(PagingTreeSequencedEvent pagingTreeSequencedEvent) {
        List<PagingTreeSequencedEvent> list = this.eventList;
        synchronized (list) {
            this.eventList.add(pagingTreeSequencedEvent);
            logger.trace("Event scheduled id = " + pagingTreeSequencedEvent.getEventID());
            if (null == this.dispatcherThread || !this.dispatcherThread.isRunning()) {
                this.dispatcherThread = new PagingTreeEventDispatchThread(this.eventList);
                this.dispatcherThread.setName("PagingTreeEventDispatchThread-" + ++dispatchThreadCounter);
                this.dispatcherThread.start();
                logger.trace("PagingTreeEventDispatchThread is created = " + this.dispatcherThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFinished() {
        List<PagingTreeSequencedEvent> list = this.eventList;
        synchronized (list) {
            this.eventList.notifyAll();
        }
    }

    private class PagingTreeEventDispatchThread
    extends Thread {
        private List<PagingTreeSequencedEvent> innerEventList;
        private boolean running = true;

        public PagingTreeEventDispatchThread(List<PagingTreeSequencedEvent> list) {
            this.innerEventList = list;
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<PagingTreeSequencedEvent> list = this.innerEventList;
            synchronized (list) {
                while (this.innerEventList.size() > 0) {
                    PagingTreeSequencedEvent pagingTreeSequencedEvent = this.innerEventList.remove(0);
                    logger.trace("Disptching event id = " + pagingTreeSequencedEvent.getEventID());
                    SwingUtilities.invokeLater(pagingTreeSequencedEvent);
                    while (pagingTreeSequencedEvent.getState() != PagingTreeSequencedEvent.State.TERMINATED) {
                        try {
                            this.innerEventList.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            logger.trace("Exception in posting event : " + interruptedException);
                        }
                    }
                }
                this.running = false;
            }
        }
    }
}

