/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.pagingtree.client.IPrintSaveData;
import com.swimap.iview.templates.pagingtree.client.PagingTree;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogTemplate;
import com.swimap.iview.util.ProgressHandler;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SaveAndPrintTreeTask
implements Runnable {
    private static IviewLogger logger = IviewLogger.getLogger(SaveAndPrintTreeTask.class, "IVIEW");
    private final Component parent;
    private final String title;
    private ProgressDialogTemplate blockDialog = null;
    private String[] tableHeaders = null;
    private int startRow;
    private int endRow;
    private final String fileName;
    private final String fileType;
    private final String userName;
    private final String summary;
    private static final int MAX_REC_COUNT_PERFILE = 65536;
    private int maxRecordsCountPerFile = 65536;
    private final int printOrSave;
    public static final int OPERATION_PRINT = 1;
    public static final int OPERATION_SAVE = 2;
    private TablePrintable tablePrintable = null;
    protected TablePrintable emptytablePrintabel = null;
    private volatile boolean isSuccess = true;
    private SaveAndPrintParameters _saveAndPrintParameters = null;
    private final PagingTree pagingtree;
    private boolean _isOn = false;
    private List<TreeViewNode> previousNodes = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/PagingTree/Res");
    private ProgressHandler handler = ProgressHandler.getInstance();
    private JProgressBar progressBar = null;
    private IPrintSaveData printSaveData = null;

    public SaveAndPrintTreeTask(Component component, String string, int n, int n2, String string2, String string3, String string4, PagingTree pagingTree, String string5, int n3) {
        this.parent = component;
        this.title = string;
        this.startRow = n;
        this.endRow = n2;
        this.fileName = string2;
        this.fileType = string3;
        this.userName = string4 == null ? "" : string4;
        this.pagingtree = pagingTree;
        this.printOrSave = n3;
        this.summary = string5;
    }

    public boolean startTask() {
        int n;
        if (this._isOn) {
            return true;
        }
        int[] nArray = this.getColumns();
        int n2 = nArray.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)this.pagingtree.getColumn(nArray[n]).getHeaderValue();
        }
        this.tableHeaders = stringArray;
        n = this.startOperation(n2);
        if (!this._isOn || n <= 0) {
            return false;
        }
        String string = this.printOrSave == 1 ? res.getString("Printing") : res.getString("Saving");
        this.blockDialog = this.createBlockDialog(this.parent, string);
        Thread thread = new Thread((Runnable)this, "PagingTree Print Thread");
        thread.start();
        if (null == this.blockDialog && this.printOrSave == 2) {
            this.handler.showProgress();
            return this.isSuccess;
        }
        ScreenToolKit.centerLocateToScreen(this.blockDialog);
        if (null != this.blockDialog) {
            this.blockDialog.setVisible(true);
        }
        return this.isSuccess;
    }

    private int startOperation(int n) {
        Vector vector = new Vector(2);
        int n2 = this.endRow - this.startRow;
        SaveAndPrintParameters saveAndPrintParameters = this.getSaveAndPrintParameters();
        if (this.printOrSave == 1) {
            this.tablePrintable = saveAndPrintParameters.createTablePrintable(this.tableHeaders, vector, n2, false);
            if (n == 1) {
                this.tablePrintable.setNormalSave(true);
            }
            this._isOn = saveAndPrintParameters.getPrintRequestAttributeSet() != null ? PrintSupportor.print(FrameworkUtilities.getMainFrame(), this.tablePrintable, this.tablePrintable.getPageCount(), saveAndPrintParameters.getPrintRequestAttributeSet()) : PrintSupportor.print(FrameworkUtilities.getMainFrame(), this.tablePrintable, this.tablePrintable.getPageCount());
        } else {
            PropertyChangeListener[] propertyChangeListenerArray;
            this.tablePrintable = saveAndPrintParameters.createTablePrintable(this.tableHeaders, vector, n2, true);
            if (this.emptytablePrintabel != null && null != (propertyChangeListenerArray = this.emptytablePrintabel.getPropertyChangeListeners())) {
                for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                    this.tablePrintable.addPropertyChangeListener(propertyChangeListenerArray[i]);
                }
            }
            if (n == 1) {
                this.tablePrintable.setNormalSave(true);
            }
            int n3 = saveAndPrintParameters.getHtmlPerColWidth();
            this.tablePrintable.setHtmlPerColWidth(n3);
            this.tablePrintable.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
            if (null != this.fileType && 0 != this.fileType.length()) {
                String string = saveAndPrintParameters.getUserEncoding();
                this._isOn = PrintSupportor.saveToFileNoCheck(FrameworkUtilities.getMainFrame(), this.fileName, this.tablePrintable, this.fileType, string);
            }
        }
        return n2;
    }

    void setTablePrintable(TablePrintable tablePrintable) {
        this.emptytablePrintabel = tablePrintable;
    }

    public SaveAndPrintParameters getSaveAndPrintParameters() {
        if (this._saveAndPrintParameters == null) {
            return new SaveAndPrintParameters(this.pagingtree, this.parent, this.startRow, this.endRow, this.title, this.userName, this.summary, "", false);
        }
        return this._saveAndPrintParameters;
    }

    public TablePrintable getTablePrintable() {
        this.emptytablePrintabel = this.tablePrintable;
        if (this.emptytablePrintabel == null) {
            this.emptytablePrintabel = new TablePrintable(new String[0], new Vector());
        }
        return this.emptytablePrintabel;
    }

    private ProgressDialogTemplate createBlockDialog(Component component, String string) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window == null && component instanceof Window) {
            window = (Window)component;
        }
        IStop iStop = new IStop(){

            @Override
            public void stop() {
                SaveAndPrintTreeTask.this.isSuccess = false;
                if (SaveAndPrintTreeTask.this.tablePrintable != null) {
                    SaveAndPrintTreeTask.this.tablePrintable.setDeleteFileFlag(true);
                    SaveAndPrintTreeTask.this.tablePrintable.setSaveCanceled(true);
                }
                SaveAndPrintTreeTask.this.stopTask();
            }
        };
        if (this.printOrSave == 2) {
            this.handler.setProcess(window);
            this.progressBar = new JProgressBar();
            this.handler.addProgress(this.progressBar, iStop);
            return null;
        }
        this.blockDialog = window instanceof Frame ? new ProgressDialogTemplate((JFrame)window, string, "", null) : new ProgressDialogTemplate((JDialog)window, string, "", null);
        this.blockDialog.setStop(iStop);
        return this.blockDialog;
    }

    public void stopTask() {
        if (this.tablePrintable != null && !this.isSuccess) {
            this.tablePrintable.setDataOver(true);
        }
        this.tablePrintable = null;
        this._isOn = false;
        if (this.printOrSave == 2) {
            this.handler.removeProgress(this.progressBar);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SaveAndPrintTreeTask.this.blockDialog != null) {
                    SaveAndPrintTreeTask.this.blockDialog.dispose();
                    SaveAndPrintTreeTask.this.blockDialog = null;
                }
            }
        });
        if (this.pagingtree != null) {
            this.pagingtree.clearPrintInfo();
        }
    }

    private void cancelTask() {
        if (this.tablePrintable != null) {
            this.tablePrintable.setDataOver(true);
        }
        this._isOn = false;
        this.isSuccess = false;
        if (this.tablePrintable != null) {
            this.tablePrintable.setDeleteFileFlag(true);
        }
        if (this.pagingtree != null) {
            this.pagingtree.clearPrintInfo();
        }
        this.printSaveData = null;
    }

    @Override
    public void run() {
        this._isOn = true;
        this.isSuccess = true;
        this.previousNodes = new ArrayList<TreeViewNode>(10);
        int n = this.pagingtree.getPageSize();
        final int n2 = this.endRow - this.startRow;
        Collection<TreeViewNode> collection = null;
        int n3 = this.startRow / n;
        int n4 = (this.endRow - 1) / n;
        int n5 = n3;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SaveAndPrintTreeTask.this.printOrSave == 2 && SaveAndPrintTreeTask.this.progressBar != null) {
                    SaveAndPrintTreeTask.this.progressBar.setStringPainted(true);
                    SaveAndPrintTreeTask.this.progressBar.setMinimum(0);
                    SaveAndPrintTreeTask.this.progressBar.setMaximum(n2);
                    SaveAndPrintTreeTask.this.progressBar.setValue(0);
                } else if (SaveAndPrintTreeTask.this.blockDialog != null) {
                    SaveAndPrintTreeTask.this.blockDialog.getProgressBar().setStringPainted(true);
                    SaveAndPrintTreeTask.this.blockDialog.getProgressBar().setMinimum(0);
                    SaveAndPrintTreeTask.this.blockDialog.getProgressBar().setMaximum(n2);
                    SaveAndPrintTreeTask.this.blockDialog.setCurrentValue(0);
                }
            }
        });
        int n6 = 0;
        int n7 = 0;
        int[] nArray = this.getColumns();
        if (0 == nArray.length) {
            this.cancelTask();
            logger.trace("No valid columns are there to print");
        }
        while (n5 <= n4 && this._isOn && !this.tablePrintable.isOver()) {
            n6 = n5 == n3 ? this.startRow : n5 * n;
            n7 = n5 == n4 ? this.endRow - n6 : n;
            logger.debug("The rows queried: " + n6 + " to: " + (n6 + n7 - 1));
            collection = this.pagingtree.loadPrintPage(n6, n7);
            if (null == collection) {
                this.cancelTask();
            } else {
                Collection<TreeViewNode> collection2;
                if (null != this.printSaveData && null != (collection2 = this.printSaveData.getSaveAndPrintData((List<TreeViewNode>)collection))) {
                    collection = collection2;
                }
                collection2 = this.getUnitData((List<TreeViewNode>)collection, nArray);
                final int n8 = collection2.size();
                try {
                    this.tablePrintable.append(collection2, true);
                }
                catch (PrinterException printerException) {
                    this.cancelTask();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SaveAndPrintTreeTask.this.printOrSave == 2 && SaveAndPrintTreeTask.this.progressBar != null) {
                            SaveAndPrintTreeTask.this.progressBar.setValue(SaveAndPrintTreeTask.this.progressBar.getValue() + n8);
                        } else if (null != SaveAndPrintTreeTask.this.blockDialog) {
                            SaveAndPrintTreeTask.this.blockDialog.incrementValue(n8);
                        }
                    }
                });
            }
            collection = null;
            ++n5;
        }
        this.stopTask();
    }

    private int[] getColumns() {
        int n3;
        int[] nArray = null;
        int n2 = this.pagingtree.getModel().getColumnCount();
        if (null != this.printSaveData) {
            nArray = this.printSaveData.getVisibleColumnsIndex();
        }
        if (null == nArray || nArray.length == 0) {
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        ArrayList<Integer> arrayList = null;
        for (int n3 : nArray) {
            if (n3 < 0 || n3 >= n2) continue;
            if (null == arrayList) {
                arrayList = new ArrayList<Integer>(n2);
            }
            arrayList.add(n3);
        }
        if (null == arrayList) {
            return new int[0];
        }
        Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
        nArray = new int[integerArray.length];
        int n4 = 0;
        Integer[] integerArray2 = integerArray;
        n3 = integerArray2.length;
        for (int i = 0; i < n3; ++i) {
            int n5;
            nArray[n4] = n5 = integerArray2[i].intValue();
            ++n4;
        }
        return nArray;
    }

    private Collection getUnitData(List<TreeViewNode> list, int[] nArray) {
        LinkedList linkedList = new LinkedList();
        int n = nArray.length;
        int n2 = list.size();
        ArrayList<String> arrayList = null;
        TreeViewNode treeViewNode = null;
        StringBuilder stringBuilder = null;
        String string = null;
        for (int i = 0; i < n2; ++i) {
            arrayList = new ArrayList<String>(n);
            treeViewNode = list.get(i);
            if (null == treeViewNode) continue;
            this.findPreviousNode(treeViewNode);
            string = null;
            for (int j = 0; j < n; ++j) {
                if (0 == nArray[j]) {
                    stringBuilder = new StringBuilder(16);
                    for (TreeViewNode treeViewNode2 : this.previousNodes) {
                        if (null == treeViewNode2 || treeViewNode2.getLabel().length() <= 0) continue;
                        stringBuilder.append("( ");
                        stringBuilder.append(treeViewNode2.getLabel());
                        stringBuilder.append(" ) ");
                    }
                    string = stringBuilder.toString();
                } else {
                    string = treeViewNode.get(nArray[j] - 1);
                }
                if (null != string) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add("");
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    private void findPreviousNode(TreeViewNode treeViewNode) {
        int n = 0;
        TreeViewNode treeViewNode2 = null;
        int n2 = 0;
        if (null != this.previousNodes && this.previousNodes.size() > 0 && (n2 = (treeViewNode2 = this.previousNodes.get(n = this.previousNodes.size() - 1)).getLevel() - treeViewNode.getLevel()) >= 0) {
            for (int i = 0; i <= n2; ++i) {
                if (this.previousNodes.isEmpty()) continue;
                this.previousNodes.remove(n - i);
            }
        }
        if (null != this.previousNodes) {
            this.previousNodes.add(treeViewNode);
        }
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    public void setSaveAndPrintParameters(SaveAndPrintParameters saveAndPrintParameters) {
        this._saveAndPrintParameters = saveAndPrintParameters;
    }

    public boolean isOn() {
        return this._isOn;
    }

    public void setPagingTreeData(IPrintSaveData iPrintSaveData) {
        this.printSaveData = iPrintSaveData;
    }

    public String getFileType() {
        return this.fileType;
    }
}

