/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.templates.pagingtree.client.ITreeChangeCallBacks;
import com.swimap.iview.templates.pagingtree.client.ITreeChangeListener;
import com.swimap.iview.templates.pagingtree.client.ITreeDeleteCallBacks;
import com.swimap.iview.templates.pagingtree.client.ITreeServiceFactory;
import com.swimap.iview.templates.pagingtree.client.NeedGet;
import com.swimap.iview.templates.pagingtree.client.PageMapIndex;
import com.swimap.iview.templates.pagingtree.client.PagingTree;
import com.swimap.iview.templates.pagingtree.client.PagingTreeOperations;
import com.swimap.iview.templates.pagingtree.client.ServiceInitializationException;
import com.swimap.iview.templates.pagingtree.client.TreeChangeEvent;
import com.swimap.iview.templates.pagingtree.csi.ITreeService;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import com.swimap.iview.templates.utils.UITask;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class PagingTreeModel
extends AbstractTableModel
implements ITreeChangeListener {
    private static IviewLogger logger = IviewLogger.getLogger(PagingTreeModel.class, "IVIEW");
    private static final int DEFAULT_PAGESIZE = 200;
    private int pageSize = 200;
    private int extendSize = 200;
    private ITreeServiceFactory serviceFactory = null;
    private String providerName = null;
    private ITreeService service = null;
    private PageMapIndex pmi = new PageMapIndex(0, 0);
    private int startRow = 0;
    private int firstShowRow = 0;
    private int lastShowRow = 0;
    private boolean var_treeWidthUpdated = false;
    private int treeWidth = 0;
    private List<TreeViewNode> page = new ArrayList<TreeViewNode>(10);
    private DefaultTableColumnModel columnModel = null;
    private int intExpandLevel = 0;
    private PagingTree tree = null;
    private Properties props = null;
    private boolean createSreviceFailed = false;
    protected List<ITreeChangeCallBacks> treeChangeCallBackListeners = null;
    private List<ITreeDeleteCallBacks> treeDeleteCallBackListeners = null;
    private boolean isNeedDefaultSelection = true;
    boolean opened = false;

    PagingTreeModel(PagingTree pagingTree, ITreeServiceFactory iTreeServiceFactory, String string, int n, boolean bl, Properties properties) {
        this.tree = pagingTree;
        this.serviceFactory = iTreeServiceFactory;
        this.providerName = string;
        this.intExpandLevel = n;
        this.props = properties;
        if (bl) {
            this.initModel();
        }
    }

    synchronized void initModel() {
        if (this.opened) {
            return;
        }
        this.opened = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagingTreeModel.this.open();
            }
        });
    }

    private void open() {
        new UITask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                try {
                    logger.debug("Going to create tree service : " + PagingTreeModel.this.providerName + " Tree is :" + PagingTreeModel.this.tree.hashCode());
                    PagingTreeModel.this.service = PagingTreeModel.this.serviceFactory.createTreeService(PagingTreeModel.this.providerName, PagingTreeModel.this.intExpandLevel, PagingTreeModel.this, PagingTreeModel.this.props);
                }
                catch (Exception exception) {
                    PagingTreeModel.this.createSreviceFailed = true;
                    PagingTreeModel.this.opened = false;
                    logger.debug("Creation of tree service failed:" + PagingTreeModel.this.service + " Tree is :" + PagingTreeModel.this.tree.hashCode(), exception);
                    PagingTreeModel pagingTreeModel = PagingTreeModel.this;
                    synchronized (pagingTreeModel) {
                        PagingTreeModel.this.notifyAll();
                    }
                    PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, exception);
                    throw exception;
                }
                PageMapIndex pageMapIndex = PagingTreeModel.this.pmi;
                synchronized (pageMapIndex) {
                    PagingTreeModel.this.doReLoadPage(PagingTreeModel.this.startRow, PagingTreeModel.this.pageSize, false);
                }
                PagingTreeModel.this.updateTreeWidthLater();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        PagingTreeModel.this.fireTableDataChanged();
                        PagingTreeModel.this.tree.fireTreeInitialized();
                        PagingTreeModel.this.tree.getJScrollPane().getViewport().doLayout();
                        PagingTreeModel pagingTreeModel = PagingTreeModel.this;
                        synchronized (pagingTreeModel) {
                            logger.trace("NotifyAll as the service initialized :" + PagingTreeModel.this.service + " Tree is :" + PagingTreeModel.this.tree.hashCode());
                            PagingTreeModel.this.notifyAll();
                        }
                        this.disposeDialog();
                    }
                });
                return null;
            }
        }.executeSilently();
    }

    public long getServiceId() {
        try {
            if (null != this.service) {
                return this.service.getId();
            }
            return -1L;
        }
        catch (Throwable throwable) {
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_ID, throwable);
            return -1L;
        }
    }

    void setColumnModel(DefaultTableColumnModel defaultTableColumnModel) {
        this.columnModel = defaultTableColumnModel;
    }

    public void setColumnNames(String ... stringArray) {
        TableColumn tableColumn;
        if (null == this.columnModel) {
            this.columnModel = new DefaultTableColumnModel();
        } else {
            tableColumn = null;
            int n = this.columnModel.getColumnCount();
            while (0 != n) {
                tableColumn = this.columnModel.getColumn(0);
                this.columnModel.removeColumn(tableColumn);
                n = this.columnModel.getColumnCount();
            }
        }
        this.columnModel.setColumnMargin(0);
        tableColumn = null;
        for (String string : stringArray) {
            tableColumn = new TableColumn();
            tableColumn.setHeaderValue(string);
            this.columnModel.addColumn(tableColumn);
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public boolean hasColumnModel() {
        return this.columnModel != null;
    }

    @Override
    public int getColumnCount() {
        if (this.hasColumnModel()) {
            return this.columnModel.getColumnCount();
        }
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.pmi.getRowCount();
    }

    void scrollTo(int n, int n2) {
        int n3 = n2;
        if (null == this.service) {
            return;
        }
        try {
            this.loadPageFrom(this.startRow, n, n3);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            logger.trace(string, exception);
        }
    }

    private boolean computeStartRowAndPageClip(int n, int n2, int n3, NeedGet needGet) {
        if (-1 == n3) {
            n3 = this.pmi.getRowCount() - 1;
        }
        this.firstShowRow = n2;
        this.lastShowRow = n3;
        int n4 = 0;
        int n5 = 0;
        if (!(n2 < n || n3 >= n + this.page.size())) {
            return false;
        }
        n4 = n2 - this.extendSize / 2;
        n5 = n3 + this.extendSize / 2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 >= this.pmi.getRowCount()) {
            n5 = this.pmi.getRowCount() - 1;
        }
        int n6 = 0;
        n6 = n4 < n ? n4 : n5 - (this.pageSize - 1);
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.pageSize > this.pmi.getRowCount() && (n6 = this.pmi.getRowCount() - this.pageSize) < 0) {
            n6 = 0;
        }
        int n7 = 0;
        int n8 = n6;
        int n9 = n;
        int n10 = n6;
        if (n10 < n9) {
            n7 = n9 - n10;
            if (n10 + n7 + this.page.size() < n5) {
                n7 = n5 - n10;
            }
        } else if (n10 - n9 > this.page.size()) {
            n8 = n10;
            n7 = this.pageSize;
        } else {
            n8 = n9 + this.page.size();
            n7 = this.pageSize - (n8 - n10);
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n7 > this.pageSize) {
            n7 = this.pageSize;
        }
        if (n8 + n7 > this.pmi.getRowCount()) {
            n7 = this.pmi.getRowCount() - n8;
        }
        needGet.setGetsize(n7);
        needGet.setRealstart(n8);
        needGet.setStart(n10);
        logger.debug("start row:" + n10 + " number of rows to fetch:" + n7 + " first row number in fetched rows:" + n8);
        return true;
    }

    private void loadPageFrom(final int n, final int n2, final int n3) {
        logger.debug("loading the tree data startRow: " + n + " firstRow: " + n2 + " scrollToLastRow: " + n3 + " tree: " + this.tree.hashCode());
        new UITask<List<TreeViewNode>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TreeViewNode> call() throws Exception {
                PageMapIndex pageMapIndex = PagingTreeModel.this.pmi;
                synchronized (pageMapIndex) {
                    NeedGet needGet = new NeedGet();
                    if (PagingTreeModel.this.computeStartRowAndPageClip(n, n2, n3, needGet)) {
                        int n5 = needGet.getRealstart();
                        int n22 = needGet.getGetsize();
                        int n32 = PagingTreeModel.this.startRow;
                        int n4 = n32 + PagingTreeModel.this.page.size();
                        List list = PagingTreeModel.this.page;
                        List list2 = PagingTreeModel.this.justDoLoadPage(n5, n22, true);
                        if (list2 != null) {
                            PagingTreeModel.this.mergePage(needGet, list2, list, n32, n4);
                        } else if (n5 == PagingTreeModel.this.startRow && n22 != 0) {
                            logger.trace("Page data inconsistant with DS. Merging overlapping pages NeedGet = [" + needGet.getStart() + ", " + needGet.getRealstart() + ", " + needGet.getGetsize() + "] old page start = " + n32 + " old page end = " + n4);
                            PagingTreeModel.this.mergePage(needGet, PagingTreeModel.this.page, list, n32, n4);
                        }
                    }
                    return null;
                }
            }
        }.executeSilently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergePage(NeedGet needGet, List<TreeViewNode> list, List<TreeViewNode> list2, int n, int n2) {
        int n3 = needGet.getStart();
        int n4 = needGet.getRealstart();
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
            int n5 = n4;
            int n6 = n4 + list.size();
            for (int i = n3; i < n3 + this.pageSize; ++i) {
                if (i >= n && i < n2) {
                    arrayList.add(i - n3, list2.get(i - n));
                    continue;
                }
                if (i < n5 || i >= n6) break;
                arrayList.add(i - n3, list.get(i - n5));
            }
            this.page = arrayList;
            this.startRow = n3;
            if (!this.hasColumnModel()) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PagingTreeModel.this.tree.updateUI();
                        }
                    });
                } else {
                    this.tree.updateUI();
                }
            }
        }
    }

    protected void collapseNode(int n, int n2) {
        ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
        int n3 = this.startRow;
        int n4 = n + 1 - n3;
        int n5 = n2;
        if (n + 1 < n3) {
            if (n3 - (n + 1) > n2) {
                n3 -= n2;
                n5 = 0;
                n4 = 0;
            } else {
                n3 -= n2 - (n3 - (n + 1));
                n5 = n2 - (n3 - (n + 1));
                n4 = 0;
            }
        }
        if (n4 > this.page.size()) {
            return;
        }
        arrayList.addAll(this.page);
        for (int i = 0; i < n5; ++i) {
            if (n4 >= arrayList.size()) continue;
            arrayList.remove(n4);
        }
        if (n - n3 >= 0 && n - n3 < arrayList.size()) {
            ((TreeViewNode)arrayList.get(n - n3)).setExpanded(false);
        }
        this.startRow = n3;
        this.pmi.addRowCount(n2 * -1);
        try {
            if (arrayList.size() < this.pageSize) {
                arrayList.addAll(this.service.loadPage(this.startRow + arrayList.size(), this.pageSize - arrayList.size(), new PageMapIndex()));
            }
        }
        catch (Throwable throwable) {
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, throwable);
            logger.debug("Exception while quering the nodes which are not in page but included in pmi row count. Exception: " + throwable);
        }
        this.page = arrayList;
    }

    protected void expandNode(int n, List<TreeViewNode> list) {
        this.page.addAll(n, list);
        if (this.page.size() > this.pageSize) {
            List<TreeViewNode> list2 = this.page.subList(this.pageSize, this.page.size());
            list2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPage(int n, List<TreeViewNode> list) {
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
            int n2 = this.startRow;
            if (n < n2) {
                this.startRow = n2 += list.size();
                this.pmi.addRowCount(list.size());
                return;
            }
            int n3 = n - n2;
            if (n3 > this.page.size()) {
                this.pmi.addRowCount(list.size());
                return;
            }
            arrayList.addAll(this.page);
            arrayList.addAll(n3, list);
            this.page = arrayList;
            this.pmi.addRowCount(list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePage(int n, int n2) {
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
            int n3 = this.startRow;
            int n4 = n - n3;
            int n5 = n2;
            if (n < n3) {
                if (n3 - n > n2) {
                    n3 -= n2;
                    n5 = 0;
                    n4 = 0;
                } else {
                    n3 -= n2 - (n3 - n);
                    n5 = n2 - (n3 - n);
                    n4 = 0;
                }
            }
            if (n4 > this.page.size()) {
                this.pmi.addRowCount(-1 * n2);
                return;
            }
            arrayList.addAll(this.page);
            for (int i = 0; i < n5; ++i) {
                if (n4 >= arrayList.size()) continue;
                arrayList.remove(n4);
            }
            this.page = arrayList;
            this.startRow = n3;
            this.pmi.addRowCount(-1 * n2);
        }
    }

    private List<TreeViewNode> justDoLoadPage(int n, int n2, boolean bl) throws Exception {
        PageMapIndex pageMapIndex = new PageMapIndex();
        List<TreeViewNode> list = null;
        if (n2 == 0) {
            return null;
        }
        try {
            list = this.service.loadPage(n, n2, pageMapIndex);
        }
        catch (Throwable throwable) {
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, throwable);
            list = new ArrayList<TreeViewNode>(0);
        }
        if (bl) {
            if (!this.pmi.compare(pageMapIndex)) {
                if (list.size() > this.extendSize || list.size() == pageMapIndex.getRowCount()) {
                    this.pmi.copy(pageMapIndex);
                    this.page = list;
                    this.startRow = n;
                    this.freshTable();
                } else {
                    int n3 = this.pageSize;
                    if (n3 + n > pageMapIndex.getRowCount()) {
                        n3 = pageMapIndex.getRowCount() - n;
                    }
                    this.doReLoadPage(n, n3, true);
                }
                return null;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.tree.updateUI();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.tree.updateUI();
                    }
                });
            }
        }
        return list;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return TreeViewNode.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return 0 == this.tree.getJTable().convertColumnIndexToView(n2);
    }

    public TreeViewNode getViewNode(int n) {
        return (TreeViewNode)this.getValueAt(n, 0);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getPageIndex(n);
        if (-1 != n3) {
            return this.page.get(n3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPageIndex(int n) {
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            int n2 = n - this.startRow;
            if (null != this.page && n2 >= 0 && n2 < this.page.size()) {
                return n2;
            }
        }
        return -1;
    }

    public int changeExpandState(final int n) {
        int n2 = 0;
        Integer n3 = (Integer)new UITask<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                PagingTreeModel.this.checkInit("changeExpandState");
                PageMapIndex pageMapIndex = PagingTreeModel.this.pmi;
                synchronized (pageMapIndex) {
                    PageMapIndex pageMapIndex2 = new PageMapIndex();
                    int n11 = 0;
                    try {
                        n11 = PagingTreeModel.this.service.changeExpandState(n, pageMapIndex2);
                    }
                    catch (Throwable throwable) {
                        logger.error(throwable.getMessage(), throwable);
                        PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.CHANGE_EXPAND_STATE, throwable);
                    }
                    if (PagingTreeModel.this.pmi.getSerialNumber() != pageMapIndex2.getSerialNumber()) {
                        int n2;
                        logger.debug("PMI with iview is different from DS hence reloading the page");
                        int[] nArray = PagingTreeModel.this.tree.getSelectedRows();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        String[] stringArray = null;
                        int n3 = 0;
                        for (int n4 : nArray) {
                            int n5 = n4 - PagingTreeModel.this.startRow;
                            if (n5 >= PagingTreeModel.this.page.size() || n5 < 0) continue;
                            arrayList.add(((TreeViewNode)PagingTreeModel.this.page.get(n5)).getKey());
                            ++n3;
                        }
                        stringArray = new String[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            stringArray[n2] = (String)arrayList.get(n2);
                        }
                        n2 = PagingTreeModel.this.firstShowRow - PagingTreeModel.this.extendSize / 2;
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        PagingTreeModel.this.doReLoadPage(n2, PagingTreeModel.this.pageSize, false);
                        if (null != stringArray) {
                            PagingTreeModel.this.tree.setSelectedKeys(false, stringArray);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PagingTreeModel.this.fireTableDataChanged();
                                PagingTreeModel.this.tree.updateUI();
                            }
                        });
                        return 0;
                    }
                    if (n11 > 0) {
                        PagingTreeModel.this.pmi.addRowCount(n11);
                        if (n < PagingTreeModel.this.startRow) {
                            PagingTreeModel.this.startRow += n11;
                            return n11;
                        }
                        int n6 = PagingTreeModel.this.startRow + PagingTreeModel.this.page.size() - 1;
                        if (n > n6) {
                            return n11;
                        }
                        int n7 = n11;
                        int n8 = PagingTreeModel.this.page.size() > PagingTreeModel.this.pageSize ? PagingTreeModel.this.page.size() : PagingTreeModel.this.pageSize;
                        int n9 = n8 - (n + 1 - PagingTreeModel.this.startRow);
                        if (n7 > n9) {
                            n7 = n9;
                        }
                        logger.debug("startRow=" + PagingTreeModel.this.startRow + " actualFetchSize=" + n7);
                        List list = PagingTreeModel.this.justDoLoadPage(n + 1, n7, false);
                        int n10 = n + 1 - PagingTreeModel.this.startRow;
                        ((TreeViewNode)PagingTreeModel.this.page.get(n10 - 1)).setExpanded(true);
                        if (null != list) {
                            PagingTreeModel.this.expandNode(n10, list);
                            PagingTreeModel.this.updateTreeWidthLater(list.toArray(new TreeViewNode[list.size()]));
                        }
                    } else if (n11 < 0) {
                        PagingTreeModel.this.collapseNode(n, n11 * -1);
                        PagingTreeModel.this.dataNotEnough(false);
                    } else {
                        final TreeViewNode treeViewNode = PagingTreeModel.this.getViewNode(n);
                        if (null != treeViewNode) {
                            treeViewNode.setExpanded(!treeViewNode.isExpanded());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PagingTreeModel.this.tree.getCellRenderer().getTreeNodeWidth(treeViewNode);
                                }
                            });
                        }
                    }
                    logger.debug("ChangeExpandState for the Row :" + n + "ChangeCount :" + n11 + "Page size is :" + PagingTreeModel.this.page.size() + "Row count is :" + PagingTreeModel.this.pmi + " Tree is :" + PagingTreeModel.this.tree.hashCode());
                    return n11;
                }
            }
        }.executeSilently();
        if (null != n3) {
            n2 = n3;
        }
        this.tree.getJTable().getSelectionModel().setValueIsAdjusting(true);
        if (n2 > 0) {
            this.fireTableRowsInserted(n + 1, n + n2);
        } else if (n2 < 0) {
            this.fireTableRowsDeleted(n + 1, n - n2);
        }
        return n2;
    }

    public List<String> getKeys(final int[] nArray) {
        if (null == this.service && this.createSreviceFailed) {
            throw new ServiceInitializationException("Loading failed! Please contact the Administrator.");
        }
        return (List)new UITask<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                PagingTreeModel.this.checkInit("getKeys");
                try {
                    return PagingTreeModel.this.service.getKeys(nArray);
                }
                catch (Throwable throwable) {
                    PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_KEYS, throwable);
                    return null;
                }
            }
        }.executeSilently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getRowKeys(int[] nArray) {
        List<String> list = new ArrayList<String>(nArray.length);
        boolean bl = false;
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= this.startRow || nArray[i] >= this.startRow + this.page.size()) {
                    bl = true;
                    break;
                }
                list.add(this.page.get(nArray[i] - this.startRow).getKey());
            }
        }
        if (bl) {
            list = this.getKeys(nArray);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey(int n) {
        if (n < 0) {
            return null;
        }
        Object object = this.pmi;
        synchronized (object) {
            if (n > this.startRow && n < this.startRow + this.page.size()) {
                return this.page.get(n - this.startRow).getKey();
            }
        }
        object = this.getKeys(new int[]{n});
        if (null != object && !object.isEmpty()) {
            return (String)object.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.createSreviceFailed = true;
        PagingTreeModel pagingTreeModel = this;
        synchronized (pagingTreeModel) {
            if (null == this.service) {
                logger.trace("NotifyAll as the service already closed :" + this.service + " Tree is :" + this.tree.hashCode());
                this.notifyAll();
                this.page = null;
                return;
            }
        }
        this.serviceFactory.removeTreeService(this.service);
        new UITask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                try {
                    PagingTreeModel.this.service.close();
                }
                catch (Throwable throwable) {
                    PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.CLOSE, throwable);
                    return null;
                }
                PagingTreeModel.this.service = null;
                PagingTreeModel pagingTreeModel = PagingTreeModel.this;
                synchronized (pagingTreeModel) {
                    logger.trace("NotifyAll as the service closed :" + PagingTreeModel.this.service + " Tree is :" + PagingTreeModel.this.tree.hashCode());
                    PagingTreeModel.this.notifyAll();
                }
                PagingTreeModel.this.page = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.disposeDialog();
                    }
                });
                return null;
            }
        }.executeSilently();
    }

    public int expandToKey(String string) throws Exception {
        boolean[] blArray = new boolean[]{false};
        int n = this.loadByKey(string, blArray);
        if (blArray[0]) {
            this.fireTableDataChanged();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParentRow(final int n) {
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            if (n > this.startRow && n < this.startRow + this.page.size()) {
                int n2 = this.page.get(n - this.startRow).getLevel() - 1;
                for (int i = n; i >= this.startRow; --i) {
                    if (this.page.get(i - this.startRow).getLevel() != n2) continue;
                    return i;
                }
            }
        }
        int n3 = (Integer)new UITask<Integer>(){

            @Override
            public Integer call() throws Exception {
                try {
                    return PagingTreeModel.this.service.getParentRow(n);
                }
                catch (Throwable throwable) {
                    PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_ROW, throwable);
                    return null;
                }
            }
        }.executeSilently();
        return n3;
    }

    public int doSort(final int n, final String string, final boolean bl) {
        return (Integer)new UITask<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                String string2 = PagingTreeModel.this.getKey(n);
                PagingTreeModel.this.checkInit("doSort");
                PageMapIndex pageMapIndex = PagingTreeModel.this.pmi;
                synchronized (pageMapIndex) {
                    try {
                        PagingTreeModel.this.service.sort(string, bl);
                    }
                    catch (Throwable throwable) {
                        PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.SORT, throwable);
                        return null;
                    }
                    int n2 = PagingTreeModel.this.firstShowRow - 100;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    PagingTreeModel.this.doReLoadPage(n2, PagingTreeModel.this.pageSize, true);
                }
                if (null != string2) {
                    return PagingTreeModel.this.loadByKey(string2, null);
                }
                return 0;
            }
        }.executeSilently();
    }

    private void update() {
        logger.debug("updating the Tree: " + this.tree.hashCode());
        new UITask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                PageMapIndex pageMapIndex = PagingTreeModel.this.pmi;
                synchronized (pageMapIndex) {
                    int n = PagingTreeModel.this.firstShowRow - PagingTreeModel.this.extendSize / 2;
                    if (n < 0) {
                        n = 0;
                    }
                    PagingTreeModel.this.doReLoadPage(n, PagingTreeModel.this.pageSize, true);
                }
                return null;
            }
        }.executeSilently();
    }

    public void updateViewNode(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
        if (treeViewNode.getKey().equals(treeViewNode2.getKey())) {
            treeViewNode2.setAttributes(treeViewNode.getAttributes());
            treeViewNode2.setExpanded(treeViewNode.isExpanded());
            treeViewNode2.setLabel(treeViewNode.getLabel());
            treeViewNode2.setLevel(treeViewNode.getLevel());
            treeViewNode2.setLeaf(treeViewNode.isLeaf());
        } else {
            logger.error("dataDirty src " + treeViewNode + " dest" + treeViewNode2);
            this.dataDirty();
        }
    }

    public void updateViewNodeStatus(String string, TreeViewNode treeViewNode, int[] nArray) {
        treeViewNode.setStatus(string, nArray);
    }

    private void dataDirty() {
        logger.error("PageTreeEvent date dirty " + this.pmi);
        this.pmi.setSerialNumber(0);
    }

    private void update(TreeViewNode[] treeViewNodeArray, int[] nArray) {
        int[] nArray2 = nArray;
        TreeViewNode[] treeViewNodeArray2 = treeViewNodeArray;
        int n = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            n = nArray2[i];
            if (n < this.startRow || n - this.startRow >= this.page.size()) continue;
            this.updateViewNode(treeViewNodeArray2[i], this.page.get(n - this.startRow));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagingTreeModel.this.tree.updateUI();
            }
        });
    }

    private void updateAdd(TreeViewNode[] treeViewNodeArray, int[] nArray) {
        ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
        arrayList.addAll(this.page);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
        for (int n4 : nArray) {
            arrayList2.add(n4);
        }
        int n = this.startRow;
        Collections.sort(arrayList2);
        int n2 = arrayList2.size();
        int n3 = 0;
        for (int n4 = 0; n4 < n2; ++n4) {
            if ((Integer)arrayList2.get(n4) < n) {
                ++n;
                continue;
            }
            if ((Integer)arrayList2.get(n4) - n > arrayList.size()) continue;
            n3 = this.getIndex(nArray, (Integer)arrayList2.get(n4));
            if (n3 >= 0 && n3 < treeViewNodeArray.length) {
                arrayList.add((Integer)arrayList2.get(n4) - n, treeViewNodeArray[n3]);
                continue;
            }
            logger.error("error data:" + Arrays.toString(treeViewNodeArray) + " rows:" + nArray);
        }
        this.page = arrayList;
        this.startRow = n;
    }

    public int getIndex(int[] nArray, int n) {
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return n2;
    }

    private void updateDelete(int[] nArray) {
        ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>();
        arrayList.addAll(this.page);
        int n = this.startRow;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) {
                --n;
                continue;
            }
            if (nArray[i] - n >= arrayList.size()) continue;
            arrayList.remove(nArray[i] - n);
        }
        this.page = arrayList;
        this.startRow = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodesAdded(TreeViewNode[] treeViewNodeArray, int[] nArray, PageMapIndex pageMapIndex) {
        boolean bl = false;
        Object object = this.pmi;
        synchronized (object) {
            if (this.pmi.canUpgrade(pageMapIndex)) {
                this.updateAdd(treeViewNodeArray, nArray);
                logger.debug("PageTreeEvent Tree nodes are added oldpmi[" + this.pmi + "]newpmi[" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
                this.pmi.copy(pageMapIndex);
                bl = true;
            } else {
                logger.debug("PageTreeEvent Tree nodes are added not ok oldpmi[" + this.pmi + "]newpmi[" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
            }
        }
        if (bl) {
            object = "";
            this.updateTreeWidthLater(treeViewNodeArray);
            for (int n : nArray) {
                boolean bl2;
                if (logger.isTraceEnabled()) {
                    object = (String)object + ' ' + n;
                }
                if (bl2 = this.tree.getJTable().getSelectionModel().isSelectedIndex(n)) {
                    int n2 = this.tree.getJTable().getSelectionModel().getSelectionMode();
                    this.tree.getJTable().getSelectionModel().setSelectionMode(0);
                    this.fireTableRowsInserted(n, n);
                    this.tree.getJTable().getSelectionModel().setSelectionMode(n2);
                    continue;
                }
                this.fireTableRowsInserted(n, n);
            }
            logger.debug("Added nodes are : " + (String)object);
        }
    }

    protected void updateTreeWidth(TreeViewNode[] treeViewNodeArray) {
        int n = 0;
        int n2 = treeViewNodeArray.length;
        PagingTree.CellRenderer cellRenderer = this.tree.getCellRenderer();
        TreeViewNode treeViewNode = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            treeViewNode = treeViewNodeArray[i];
            n3 = cellRenderer.getTreeNodeWidth(treeViewNode);
            if (n3 <= n) continue;
            n = n3;
        }
        if (this.treeWidth < n) {
            this.updateTreeWidth(n);
        }
    }

    private void updateTreeWidthLater(final TreeViewNode[] treeViewNodeArray) {
        if (!this.hasColumnModel()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.updateTreeWidth(treeViewNodeArray);
                    }
                });
            } else {
                this.updateTreeWidth(treeViewNodeArray);
            }
        }
    }

    private void updateTreeWidthLater() {
        if (!this.hasColumnModel()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.updateTreeWidth(PagingTreeModel.this.page);
                    }
                });
            } else {
                this.updateTreeWidth(this.page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodesRemoved(int[] nArray, PageMapIndex pageMapIndex) {
        PageMapIndex pageMapIndex2 = this.pmi;
        synchronized (pageMapIndex2) {
            if (this.pmi.canUpgrade(pageMapIndex)) {
                Integer n = null;
                this.fireTreeNodesWillDelete(nArray);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                for (int n2 : nArray) {
                    arrayList.add(n2);
                }
                int[] nArray2 = this.tree.getSelectedRows();
                int n3 = 0;
                for (int n4 : nArray2) {
                    arrayList2.add(n4 - n3);
                    ++n3;
                }
                Collections.sort(arrayList);
                if (!arrayList2.isEmpty() && arrayList.containsAll(arrayList2)) {
                    n = (Integer)arrayList.get(0) - 1;
                }
                this.updateDelete(nArray);
                logger.debug("PageTreeEvent Tree nodes removed oldpmi[" + this.pmi + "]newpmi[" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
                this.pmi.copy(pageMapIndex);
                if (this.lastShowRow >= this.pmi.getRowCount()) {
                    logger.debug("Out-of-range lastShowRow=" + this.lastShowRow);
                    this.lastShowRow = this.pmi.getRowCount();
                    logger.debug("Updated lastShowRow=" + this.lastShowRow);
                }
                this.tree.getJTable().getSelectionModel().setValueIsAdjusting(true);
                final int[] nArray3 = nArray;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        for (int n : nArray3) {
                            PagingTreeModel.this.fireTableRowsDeleted(n, n);
                        }
                    }
                };
                SwingUtilities.invokeLater(thread);
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    logger.debug("interruptd when waiting for fire table rows to complete ", interruptedException);
                }
                if (null != n) {
                    this.tree.getJTable().getSelectionModel().setValueIsAdjusting(false);
                    if (this.isNeedDefaultSelection) {
                        this.tree.setSelectedRow(n);
                    }
                }
                this.fireTreeNodesDeleted(nArray);
                this.tree.getJTable().getSelectionModel().setValueIsAdjusting(false);
            } else {
                logger.debug("PageTreeEvent Tree nodes removed not ok oldpmi[" + this.pmi + "]newpmi[" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
            }
        }
        this.dataNotEnough(false);
    }

    public void dataNotEnough() {
        this.dataNotEnough(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataNotEnough(boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            if (this.startRow > this.firstShowRow || this.startRow + this.page.size() < this.lastShowRow) {
                bl2 = true;
                n = this.firstShowRow;
                n2 = this.lastShowRow;
            }
        }
        if (bl2) {
            logger.debug("get data from first row: " + n + " last row: " + n2);
            this.scrollTo(n, n2);
            if (bl) {
                this.freshTable();
            } else if (!this.hasColumnModel()) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PagingTreeModel.this.updateTreeWidth(PagingTreeModel.this.page);
                            PagingTreeModel.this.tree.updateUI();
                        }
                    });
                } else {
                    this.updateTreeWidth(this.page);
                    this.tree.updateUI();
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.tree.updateUI();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.tree.updateUI();
                    }
                });
            }
        }
    }

    private void updateStatus(String string, List<int[]> list, int[] nArray) {
        int[] nArray2 = nArray;
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            n = nArray2[i];
            if (n < this.startRow || n - this.startRow >= this.page.size()) continue;
            this.updateViewNodeStatus(string, this.page.get(n - this.startRow), list.get(i));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagingTreeModel.this.tree.updateUI();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodesStatusUpdated(String string, List<int[]> list, int[] nArray, PageMapIndex pageMapIndex) {
        logger.debug("updating the node status of tree: " + this.tree.hashCode());
        boolean bl = false;
        PageMapIndex pageMapIndex2 = this.pmi;
        synchronized (pageMapIndex2) {
            if (this.pmi.canUpgrade(pageMapIndex)) {
                this.updateStatus(string, list, nArray);
                this.pmi.copy(pageMapIndex);
                bl = true;
            } else {
                logger.debug("PageTreeEvent treeNodesStatusUpdated not ok oldpmi[" + this.pmi + "]newpmi:" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
            }
        }
        if (bl) {
            for (Object object : (PageMapIndex)nArray) {
                this.fireTableRowsUpdated((int)object, (int)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodesUpdated(TreeViewNode[] treeViewNodeArray, int[] nArray, PageMapIndex pageMapIndex) {
        boolean bl = false;
        PageMapIndex pageMapIndex2 = this.pmi;
        synchronized (pageMapIndex2) {
            if (this.pmi.needToReload(pageMapIndex)) {
                logger.debug("DS pmi" + pageMapIndex + " is greater than " + this.pmi + " hence need to reload the page");
                try {
                    this.doReLoadPage(this.startRow, this.pageSize, false);
                }
                catch (Exception exception) {
                    logger.error("Exception in reload : " + exception);
                }
            } else if (pageMapIndex.getSerialNumber() == this.pmi.getSerialNumber() + 1) {
                this.update(treeViewNodeArray, nArray);
                logger.debug("Tree nodes updated new pmi = " + pageMapIndex + " old pmi = " + this.pmi + " tree = " + this.tree.hashCode());
                this.pmi.copy(pageMapIndex);
                bl = true;
            } else if (pageMapIndex.getSerialNumber() == this.pmi.getSerialNumber()) {
                this.update(treeViewNodeArray, nArray);
                logger.debug("Tree nodes updated new pmi = " + pageMapIndex + " old pmi = " + this.pmi + " tree = " + this.tree.hashCode());
                bl = true;
            } else {
                logger.debug("PageTreeEvent Tree nodes not updated oldpmi[" + this.pmi + "]newpmi:" + pageMapIndex + "] Tree is :" + this.tree.hashCode());
            }
        }
        if (bl) {
            this.updateTreeWidthLater(treeViewNodeArray);
            for (Object object : (PageMapIndex)nArray) {
                this.fireTableRowsUpdated((int)object, (int)object);
            }
        }
    }

    @Override
    public void treeNodeReloaded(int n, PageMapIndex pageMapIndex) {
        this.fireTreeWillReload();
        this.tree.getJTable().clearSelection();
        this.update();
        logger.debug("Tree nodes reloaded oldpmi[" + this.pmi + "]newpmi[" + pageMapIndex + "] Tree is :" + this.tree.hashCode() + "Row is :" + n);
        this.fireTableDataChanged();
        this.fireTreeReloaded();
    }

    private void freshTable() {
        logger.debug("updating table for tree: " + this.tree.hashCode());
        if (!this.hasColumnModel()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.updateTreeWidth(PagingTreeModel.this.page);
                        PagingTreeModel.this.fireTableDataChanged();
                        PagingTreeModel.this.tree.updateUI();
                    }
                });
            } else {
                this.updateTreeWidth(this.page);
                this.fireTableDataChanged();
                this.tree.updateUI();
            }
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.fireTableDataChanged();
            this.tree.updateUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagingTreeModel.this.fireTableDataChanged();
                    PagingTreeModel.this.tree.updateUI();
                }
            });
        }
    }

    private List<TreeViewNode> doReLoadPage(int n, int n2, boolean bl) throws Exception {
        logger.debug("reloading the page, start = " + n + " size = " + n2 + " for the Tree: " + this.tree.hashCode());
        if (n >= this.pmi.getRowCount()) {
            logger.debug("Reset the start row :" + this.pmi.getRowCount() + " Old startRow is : " + n);
            n = this.pmi.getRowCount() - this.pageSize;
            if (n < 0) {
                n = 0;
            }
            this.startRow = n;
        }
        PageMapIndex pageMapIndex = new PageMapIndex();
        List<TreeViewNode> list = null;
        try {
            list = this.service.loadPage(n, n2, pageMapIndex);
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, throwable);
            return this.page;
        }
        this.pmi.copy(pageMapIndex);
        final List<TreeViewNode> list2 = list;
        this.page = list2;
        this.startRow = n;
        logger.debug("Start Row is :" + n + this.pmi + "Page Size is :" + list2.size() + " Tree is :" + this.tree.hashCode());
        if (bl) {
            if (!this.hasColumnModel()) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PagingTreeModel.this.updateTreeWidth(list2);
                            PagingTreeModel.this.fireTableDataChanged();
                            PagingTreeModel.this.tree.updateUI();
                        }
                    });
                } else {
                    this.updateTreeWidth(list2);
                    this.fireTableDataChanged();
                    this.tree.updateUI();
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableDataChanged();
                this.tree.updateUI();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.fireTableDataChanged();
                        PagingTreeModel.this.tree.updateUI();
                    }
                });
            }
        }
        return list2;
    }

    boolean isTreeWidthUpdated() {
        return this.var_treeWidthUpdated;
    }

    int getTreeWidth() {
        return this.treeWidth;
    }

    void setTreeWidthState(boolean bl) {
        this.var_treeWidthUpdated = bl;
    }

    protected void updateTreeWidth(List<TreeViewNode> list) {
        int n = 0;
        if (null == list) {
            logger.trace("page is null ");
            return;
        }
        int n2 = list.size();
        PagingTree.CellRenderer cellRenderer = this.tree.getCellRenderer();
        TreeViewNode treeViewNode = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            treeViewNode = list.get(i);
            n3 = cellRenderer.getTreeNodeWidth(treeViewNode);
            if (n3 <= n) continue;
            n = n3;
        }
        this.updateTreeWidth(n);
    }

    private void updateTreeWidth(int n) {
        if (this.treeWidth != n) {
            this.treeWidth = n;
            this.var_treeWidthUpdated = true;
            if (!this.hasColumnModel()) {
                this.tree.getJTable().getColumnModel().getColumn(0).setPreferredWidth(n);
            }
        }
    }

    protected void setPageSize(int n) {
        if (200 <= n) {
            this.pageSize = n;
        }
    }

    void refresh(final int n) {
        logger.debug("refreshing the row: " + n + " for Tree: " + this.tree.hashCode());
        new UITask<Integer>(){

            @Override
            public Integer call() throws Exception {
                try {
                    PagingTreeModel.this.service.refresh(n);
                }
                catch (Throwable throwable) {
                    logger.error(throwable.getMessage(), throwable);
                    PagingTreeModel.this.tree.getExceptionHandler().catchException(PagingTreeOperations.REFRESH, throwable);
                }
                return null;
            }
        }.executeSilently();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TreeViewNode> getNodes(int[] nArray) {
        if (null != this.service) {
            ArrayList<TreeViewNode> arrayList = new ArrayList<TreeViewNode>(10);
            boolean bl = true;
            PageMapIndex pageMapIndex = this.pmi;
            synchronized (pageMapIndex) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < this.startRow || nArray[i] >= this.startRow + this.page.size()) {
                        bl = false;
                        break;
                    }
                    arrayList.add(i, this.page.get(nArray[i] - this.startRow));
                }
            }
            if (!bl) {
                try {
                    logger.trace("Getting Node From DS Currently Service :" + this.service);
                    return this.service.getViewNodes(nArray);
                }
                catch (Throwable throwable) {
                    String string = throwable.getMessage();
                    logger.trace(string, throwable);
                    this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_VIEW_NODES, throwable);
                    return null;
                }
            }
            logger.trace("Getting Node From current page.");
            return arrayList;
        }
        logger.trace("Currently Service :" + this.service);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeViewNode getNode(int n) {
        Object object = this.pmi;
        synchronized (object) {
            if (n < 0) {
                return null;
            }
            if (n >= this.startRow && n < this.startRow + this.page.size()) {
                return this.page.get(n - this.startRow);
            }
        }
        object = this.getNodes(new int[]{n});
        if (null != object && !object.isEmpty()) {
            return (TreeViewNode)object.get(0);
        }
        return null;
    }

    private void fireTreeWillReload() {
        if (null == this.treeChangeCallBackListeners) {
            return;
        }
        TreeChangeEvent treeChangeEvent = new TreeChangeEvent(this, 1);
        for (ITreeChangeCallBacks iTreeChangeCallBacks : this.treeChangeCallBackListeners) {
            iTreeChangeCallBacks.treeWillReload(treeChangeEvent);
        }
    }

    private void fireTreeReloaded() {
        if (null == this.treeChangeCallBackListeners) {
            return;
        }
        TreeChangeEvent treeChangeEvent = new TreeChangeEvent(this, 1);
        for (ITreeChangeCallBacks iTreeChangeCallBacks : this.treeChangeCallBackListeners) {
            iTreeChangeCallBacks.treeReloaded(treeChangeEvent);
        }
    }

    private void fireTreeNodesWillDelete(int[] nArray) {
        if (null == this.treeDeleteCallBackListeners) {
            return;
        }
        TreeChangeEvent treeChangeEvent = new TreeChangeEvent(this, 2);
        for (ITreeDeleteCallBacks iTreeDeleteCallBacks : this.treeDeleteCallBackListeners) {
            iTreeDeleteCallBacks.treeNodesWillDelete(treeChangeEvent, nArray);
        }
    }

    private void fireTreeNodesDeleted(int[] nArray) {
        if (null == this.treeDeleteCallBackListeners) {
            return;
        }
        TreeChangeEvent treeChangeEvent = new TreeChangeEvent(this, 2);
        for (ITreeDeleteCallBacks iTreeDeleteCallBacks : this.treeDeleteCallBackListeners) {
            iTreeDeleteCallBacks.treeNodesDeleted(treeChangeEvent, nArray);
        }
    }

    public void enableSelectionWhileDelete(boolean bl) {
        this.isNeedDefaultSelection = bl;
    }

    public void addTreeDeleteCallBackListener(ITreeDeleteCallBacks iTreeDeleteCallBacks) {
        if (null == iTreeDeleteCallBacks) {
            return;
        }
        if (null == this.treeDeleteCallBackListeners) {
            this.treeDeleteCallBackListeners = new ArrayList<ITreeDeleteCallBacks>(1);
        }
        this.treeDeleteCallBackListeners.add(iTreeDeleteCallBacks);
    }

    public void removeTreeDeleteCallBackListener(ITreeDeleteCallBacks iTreeDeleteCallBacks) {
        if (null == iTreeDeleteCallBacks || null == this.treeDeleteCallBackListeners) {
            return;
        }
        this.treeDeleteCallBackListeners.remove(iTreeDeleteCallBacks);
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected int getStartRow() {
        return this.startRow;
    }

    protected int initPrint() {
        if (null != this.service) {
            try {
                return this.service.initPrint();
            }
            catch (Throwable throwable) {
                logger.trace("Service unable to init the print " + throwable);
                this.tree.getExceptionHandler().catchException(PagingTreeOperations.PRINT, throwable);
            }
        }
        return -1;
    }

    protected List<TreeViewNode> loadPrintPage(int n, int n2) {
        if (null != this.service) {
            try {
                return this.service.loadPrintPage(n, n2);
            }
            catch (Throwable throwable) {
                logger.trace("Service unable to init the print " + throwable);
                this.tree.getExceptionHandler().catchException(PagingTreeOperations.PRINT, throwable);
            }
        }
        return null;
    }

    protected void clearPrintInfo() {
        if (null != this.service) {
            try {
                this.service.clearPrintInfo();
            }
            catch (Throwable throwable) {
                logger.trace("Exception thrown by service when tried to  close print info " + throwable);
                this.tree.getExceptionHandler().catchException(PagingTreeOperations.PRINT, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showFirstChild(int n, boolean bl) throws Exception {
        this.checkInit("showFirstChild");
        PageMapIndex pageMapIndex = new PageMapIndex();
        int n2 = 0;
        try {
            n2 = this.service.showFirstChild(n, bl, pageMapIndex);
        }
        catch (Throwable throwable) {
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.SHOW_FIRST_CHILD, throwable);
            n2 = -1;
        }
        PageMapIndex pageMapIndex2 = this.pmi;
        synchronized (pageMapIndex2) {
            logger.trace("showFirstChild LeafRow is " + n2);
            if (-1 < n2 && !this.pmi.compare(pageMapIndex)) {
                if (this.startRow > this.pmi.getRowCount()) {
                    logger.trace("Wrong start row :" + this.startRow);
                    this.startRow = n;
                }
                this.doReLoadPage(this.startRow, this.pageSize, true);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    int[] loadByKeys(String[] stringArray, boolean[] blArray, boolean bl) throws Exception {
        this.checkInit("loadByKeys");
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            int[] nArray = new int[stringArray.length];
            boolean bl2 = false;
            if (null != this.page && !this.page.isEmpty()) {
                void object;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(stringArray[i], i);
                }
                TreeViewNode treeViewNode = null;
                int n = -1;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = -1;
                }
                Integer n2 = 0;
                int n3 = this.page.size();
                boolean i = false;
                while (object < n3) {
                    treeViewNode = this.page.get((int)object);
                    n2 = (Integer)hashMap.get(treeViewNode.getKey());
                    if (n2 != null) {
                        n = n2;
                        nArray[n] = this.startRow + object;
                    }
                    ++object;
                }
                for (int n4 : nArray) {
                    if (n4 != -1) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && bl) {
                    PageMapIndex pageMapIndex2 = new PageMapIndex();
                    try {
                        nArray = this.service.loadByKeys(stringArray, pageMapIndex2);
                    }
                    catch (Throwable throwable) {
                        this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, throwable);
                        return null;
                    }
                    if (!this.pmi.compare(pageMapIndex2)) {
                        int n5 = this.firstShowRow - 100;
                        if (n5 < 0) {
                            n5 = 0;
                        }
                        this.doReLoadPage(n5, this.extendSize, false);
                        this.updateTreeNode();
                        if (null != blArray) {
                            blArray[0] = true;
                        }
                    }
                }
                return nArray;
            }
        }
        return null;
    }

    public int[] loadByKeys(String[] stringArray, boolean[] blArray) throws Exception {
        return this.loadByKeys(stringArray, blArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit(String string) throws InterruptedException {
        PagingTreeModel pagingTreeModel = this;
        synchronized (pagingTreeModel) {
            if (null == this.service) {
                if (this.createSreviceFailed) {
                    throw new ServiceInitializationException("Loading failed! Please contact the Administrator.");
                }
                logger.trace("Model is waiting at " + string + "...." + " Tree is :" + this.tree.hashCode());
                this.wait(20000L);
                if (null == this.service) {
                    throw new ServiceInitializationException("Loading failed! Please contact the Administrator.");
                }
                logger.trace("Notified the thread at " + string + " Tree is :" + this.tree.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadByKey(String string, boolean[] blArray) throws Exception {
        int n = -1;
        if (string == null) {
            return n;
        }
        this.checkInit("loadByKey");
        PageMapIndex pageMapIndex = this.pmi;
        synchronized (pageMapIndex) {
            if (null != this.page && !this.page.isEmpty()) {
                TreeViewNode treeViewNode = null;
                int n2 = this.page.size();
                for (int i = 0; i < n2; ++i) {
                    treeViewNode = this.page.get(i);
                    if (!string.equals(treeViewNode.getKey())) continue;
                    n = this.startRow + i;
                    return n;
                }
                PageMapIndex pageMapIndex2 = new PageMapIndex();
                try {
                    n = this.service.loadByKey(string, pageMapIndex2);
                }
                catch (Throwable throwable) {
                    this.tree.getExceptionHandler().catchException(PagingTreeOperations.LOAD_PAGE, throwable);
                    return -1;
                }
                if (!this.pmi.compare(pageMapIndex2)) {
                    int n3 = 0;
                    n3 = blArray == null ? this.firstShowRow - 100 : n - 100;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    this.doReLoadPage(n3, this.extendSize, true);
                    if (null != blArray) {
                        blArray[0] = true;
                    }
                }
                return n;
            }
        }
        return n;
    }

    public String getNextMatch(String string, int n) {
        if (null != this.service) {
            int n2;
            boolean bl = false;
            String string2 = null;
            String string3 = string.toUpperCase();
            if (n >= this.startRow && n < this.startRow + this.page.size()) {
                TreeViewNode treeViewNode = this.page.get(n2);
                int n3 = this.page.size();
                for (n2 = n - this.startRow; n2 < n3; ++n2) {
                    treeViewNode = this.page.get(n2);
                    if (!treeViewNode.getLabel().toUpperCase().startsWith(string3)) continue;
                    string2 = treeViewNode.getKey();
                    bl = true;
                    break;
                }
                if (!bl) {
                    n2 += this.startRow;
                }
            } else if (n2 <= 0) {
                n2 = n;
            }
            if (!bl) {
                try {
                    logger.trace("Getting Node From DS Currently Service :" + this.service + " startIndex = " + n2);
                    return this.service.getNextMatch(string, n2);
                }
                catch (Throwable throwable) {
                    String string4 = throwable.getMessage();
                    logger.trace(string4, throwable);
                    this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_NEXT_MATCH, throwable);
                    return null;
                }
            }
            logger.trace("Getting Node From current page.");
            return string2;
        }
        logger.trace("Currently Service :" + this.service);
        return null;
    }

    private void updateTreeNode() {
        if (!this.hasColumnModel()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTreeModel.this.updateTreeWidth(PagingTreeModel.this.page);
                        PagingTreeModel.this.tree.updateUI();
                    }
                });
            } else {
                this.updateTreeWidth(this.page);
                this.tree.updateUI();
            }
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.fireTableDataChanged();
            this.tree.updateUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagingTreeModel.this.fireTableDataChanged();
                    PagingTreeModel.this.tree.updateUI();
                }
            });
        }
    }

    int getServiceRowCount() {
        try {
            return this.service.getRowCount();
        }
        catch (Exception exception) {
            logger.debug("Exception in getting row count from service : " + this.service + " exception = " + exception);
            this.tree.getExceptionHandler().catchException(PagingTreeOperations.GET_ROW, exception);
            return -1;
        }
    }
}

