/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.pagingtree.client.BaseCellEditor;
import com.swimap.iview.templates.pagingtree.client.DefaultTreeExceptionHandler;
import com.swimap.iview.templates.pagingtree.client.DefaultTreeNodeRenderer;
import com.swimap.iview.templates.pagingtree.client.DragEvent;
import com.swimap.iview.templates.pagingtree.client.IContextMenuProvider;
import com.swimap.iview.templates.pagingtree.client.IPrintSaveData;
import com.swimap.iview.templates.pagingtree.client.ITreeChangeCallBacks;
import com.swimap.iview.templates.pagingtree.client.ITreeDeleteCallBacks;
import com.swimap.iview.templates.pagingtree.client.ITreeDragListener;
import com.swimap.iview.templates.pagingtree.client.ITreeExceptionHandler;
import com.swimap.iview.templates.pagingtree.client.ITreeExpansionListener;
import com.swimap.iview.templates.pagingtree.client.ITreeInitListener;
import com.swimap.iview.templates.pagingtree.client.ITreeNodeRenderer;
import com.swimap.iview.templates.pagingtree.client.ITreeSelectionChangeListener;
import com.swimap.iview.templates.pagingtree.client.ITreeSelectionListener;
import com.swimap.iview.templates.pagingtree.client.ITreeServiceFactory;
import com.swimap.iview.templates.pagingtree.client.KeyNavigationHandler;
import com.swimap.iview.templates.pagingtree.client.PagingTreeExpansionEvent;
import com.swimap.iview.templates.pagingtree.client.PagingTreeModel;
import com.swimap.iview.templates.pagingtree.client.PagingTreeSequencedEvent;
import com.swimap.iview.templates.pagingtree.client.SaveAndPrintTreeTask;
import com.swimap.iview.templates.pagingtree.client.SequencedEventProcessor;
import com.swimap.iview.templates.pagingtree.client.SortableHeaderRenderer;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import com.swimap.iview.templates.print.PreViewDataSource;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.templates.utils.UITask;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PagingTree
extends JPanel {
    private static List<PagingTree> activeInstances = new ArrayList<PagingTree>(1);
    private PagingTreeModel model = null;
    private JTable table = null;
    private volatile int clearInfoCount = 0;
    private JScrollPane scrollPane = null;
    private CellRenderer renderer = null;
    private CellEditor editor = null;
    private IContextMenuProvider contextMenuProvider = null;
    private boolean autoDispose = true;
    private ITreeNodeRenderer nodeRenderer = new DefaultTreeNodeRenderer();
    private List<ITreeSelectionChangeListener> selectionListeners = null;
    private List<ActionListener> actionListeners = null;
    private int sortedColumn = -1;
    private String sortedColumnName = null;
    private List<ITreeInitListener> initListeners = null;
    private boolean toolTipEnabled = true;
    private static final int AUTOSCROLL_MARGIN = 12;
    private List<TreeViewNode> selectedNodes = null;
    private int[] selectedRows = null;
    private List<ITreeDragListener> dragListeners = null;
    private TreeViewNode targetNode = null;
    private int parentRow = -1;
    private List<ITreeSelectionListener> selectionNodeListeners = null;
    private boolean allSelection = true;
    private boolean isRootVisible = true;
    private boolean insideTree = true;
    private static IviewLogger logger;
    private boolean isDrawLine = false;
    private static final int LEFT_INDENT = 5;
    private static final int LEVEL_INDENT = 24;
    private int rowCountConst = 0;
    private List<ITreeExpansionListener> expansionListeners = null;
    private boolean totleRecordsPosition = false;
    private SaveAndPrintTreeTask saveAndPrintTask = null;
    private SaveAndPrintTreeTask emptysaveTask = null;
    public static final int MAX_REC_COUNT_PERFILE = 20000;
    public static final int MAX_XLSX_REC_COUNT_PERFILE = 500000;
    private int maxRecordsCountPerFile = -1;
    private int htmlPerColWidth = 0;
    private TablePrintable previewTablePrintable = null;
    private String title = "";
    private String summary = "";
    private String userName = "";
    private PrintRequestAttributeSet printRequestAttributeSet = null;
    List<TreeViewNode> previousNodes = new ArrayList<TreeViewNode>(1);
    private boolean addKeyListener = false;
    private volatile int parallelScrollCount = 0;
    private ITreeExceptionHandler exceptionHandler = new DefaultTreeExceptionHandler();
    private boolean isCopyEnable = true;
    private Action copyAction = null;
    private PropertyChangeListener[] printablePropChangeListeners = null;
    private Action expandAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PagingTree.this.table.getSelectedRow();
            if (-1 == n) {
                return;
            }
            PagingTree.this.scrollToRow(n);
            TreeViewNode treeViewNode = (TreeViewNode)PagingTree.this.model.getValueAt(n, 0);
            if (null == treeViewNode || treeViewNode.isLeaf()) {
                return;
            }
            PagingTree.this.setNodeState(treeViewNode, n);
        }
    };
    private Action collapseAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PagingTree.this.table.getSelectedRow();
            if (-1 == n) {
                return;
            }
            PagingTree.this.scrollToRow(n);
            TreeViewNode treeViewNode = (TreeViewNode)PagingTree.this.model.getValueAt(n, 0);
            if (null == treeViewNode) {
                return;
            }
            if (!treeViewNode.isLeaf() && treeViewNode.isExpanded()) {
                PagingTree.this.changeExpandState(n);
            } else if (n > 0) {
                int n2 = PagingTree.this.model.getParentRow(n);
                if (!PagingTree.this.isRootVisible && n2 == 0) {
                    return;
                }
                PagingTree.this.setSelectedRow(n2);
                PagingTree.this.scrollToRow(n2);
            }
        }
    };
    private Action spaceAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PagingTree.this.table.getSelectedRow();
            if (-1 == n) {
                return;
            }
            PagingTree.this.scrollToRow(n);
            PagingTree.this.fireActionEvent();
        }
    };
    private Action entryAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PagingTree.this.table.getSelectedRow();
            if (-1 == n) {
                return;
            }
            PagingTree.this.scrollToRow(n);
            TreeViewNode treeViewNode = (TreeViewNode)PagingTree.this.model.getValueAt(n, 0);
            if (null == treeViewNode) {
                return;
            }
            if (treeViewNode.isLeaf()) {
                PagingTree.this.fireActionEvent();
            } else {
                PagingTree.this.changeExpandState(n);
            }
        }
    };
    ThreadLocal<Long> start = new ThreadLocal();
    private transient MouseListener doubleClickListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getClickCount() % 2 == 0 && 1 == mouseEvent.getButton() && PagingTree.this.getCellRenderer().isInNodeRect(point)) {
                int n = PagingTree.this.table.rowAtPoint(point);
                if (-1 == n) {
                    return;
                }
                PagingTree.this.scrollToRow(n);
                TreeViewNode treeViewNode = (TreeViewNode)PagingTree.this.model.getValueAt(n, 0);
                if (null == treeViewNode) {
                    return;
                }
                if (!treeViewNode.isLeaf()) {
                    PagingTree.this.changeExpandState(n);
                }
                PagingTree.this.fireActionEvent();
            }
        }
    };

    public PagingTree(ITreeServiceFactory iTreeServiceFactory, String string, int n) {
        this(iTreeServiceFactory, string, n, true, null);
    }

    public PagingTree(ITreeServiceFactory iTreeServiceFactory, String string, int n, boolean bl) {
        this(iTreeServiceFactory, string, n, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagingTree(ITreeServiceFactory iTreeServiceFactory, String string, int n, boolean bl, Properties properties) {
        super(new BorderLayout());
        Object object;
        if (null != properties && null != (object = properties.getProperty("isEnableFind")) && ((String)object).equalsIgnoreCase("true")) {
            this.addKeyListener = true;
        }
        this.createTable();
        this.model = new PagingTreeModel(this, iTreeServiceFactory, string, n, bl, properties);
        this.table.setModel(this.model);
        this.createScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.table.addMouseListener(this.doubleClickListener);
        object = activeInstances;
        synchronized (object) {
            activeInstances.add(this);
        }
    }

    public PagingTreeModel getModel() {
        return this.model;
    }

    public void setTreeNodeRenderer(ITreeNodeRenderer iTreeNodeRenderer) {
        if (null != iTreeNodeRenderer) {
            this.nodeRenderer = iTreeNodeRenderer;
        }
    }

    public void setColumnNames(String ... stringArray) {
        if (null != stringArray) {
            this.table.setAutoResizeMode(0);
            this.model.setColumnNames(stringArray);
            JTableHeader jTableHeader = new JTableHeader();
            jTableHeader.setReorderingAllowed(false);
            this.table.setTableHeader(jTableHeader);
            TableColumnModel tableColumnModel = this.model.getColumnModel();
            this.table.setColumnModel(tableColumnModel);
            if (jTableHeader.getColumnModel() != tableColumnModel) {
                jTableHeader.setColumnModel(tableColumnModel);
            }
            jTableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = PagingTree.this.table.columnAtPoint(point);
                    PagingTree.this.sortByColumn(n);
                }
            });
        }
    }

    public void addSortableColumn(int n, String string, boolean bl) {
        TableColumn tableColumn = this.getColumn(n);
        if (null != tableColumn) {
            tableColumn.setHeaderRenderer(new SortableHeaderRenderer(this, string, bl));
        }
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public String getSortedColumnName() {
        return this.sortedColumnName;
    }

    public void sortByColumn(int n) {
        TableCellRenderer tableCellRenderer;
        if (n < 0) {
            return;
        }
        TableColumn tableColumn = this.getColumn(n);
        if (null != tableColumn && (tableCellRenderer = tableColumn.getHeaderRenderer()) instanceof SortableHeaderRenderer) {
            SortableHeaderRenderer sortableHeaderRenderer = (SortableHeaderRenderer)tableCellRenderer;
            boolean bl = !sortableHeaderRenderer.isAscent();
            String string = sortableHeaderRenderer.getName();
            this.sortBy(string, bl);
        }
    }

    protected int getSortColumn(String string) {
        int n = this.model.getColumnCount();
        TableColumn tableColumn = null;
        for (int i = 0; i < n; ++i) {
            SortableHeaderRenderer sortableHeaderRenderer;
            tableColumn = this.getColumn(i);
            if (null == tableColumn || !(tableColumn.getHeaderRenderer() instanceof SortableHeaderRenderer) || !ResourceUtil.areEquals((sortableHeaderRenderer = (SortableHeaderRenderer)tableColumn.getHeaderRenderer()).getName(), string)) continue;
            return i;
        }
        return -1;
    }

    public void sortBy(String string, boolean bl) {
        int n;
        boolean bl2 = this.table.getSelectedRowCount() > 0;
        List<String> list = this.getSelectedKeys();
        String[] stringArray = list.toArray(new String[0]);
        int n2 = n = bl2 ? this.table.getSelectedRow() : 0;
        if (null != this.model) {
            int n3 = this.model.doSort(n, string, bl);
            if (bl2) {
                this.setSelectedKeys(stringArray);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTree.this.table.updateUI();
                    }
                });
            }
            this.sortedColumn = this.getSortColumn(string);
            this.sortedColumnName = string;
            if (-1 != this.sortedColumn) {
                this.scrollToEntry(n3, this.sortedColumn);
                TableColumn tableColumn = this.getColumn(this.sortedColumn);
                SortableHeaderRenderer sortableHeaderRenderer = (SortableHeaderRenderer)tableColumn.getHeaderRenderer();
                sortableHeaderRenderer.setAscend(bl);
                JTableHeader jTableHeader = this.table.getTableHeader();
                if (null != jTableHeader) {
                    jTableHeader.repaint();
                }
            }
            this.table.revalidate();
        }
    }

    public void setColumnWidths(int ... nArray) {
        TableColumn tableColumn = null;
        for (int i = 0; i < nArray.length; ++i) {
            tableColumn = this.getColumn(i);
            if (null == tableColumn) continue;
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    public void setTableColumnModel(DefaultTableColumnModel defaultTableColumnModel) {
        this.table.setColumnModel(defaultTableColumnModel);
        this.model.setColumnModel(defaultTableColumnModel);
    }

    public int[] getColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (null == tableColumnModel) {
            return new int[0];
        }
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth();
        }
        return nArray;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
        this.scrollPane.setEnabled(bl);
    }

    public TableColumnModel getColumnModel() {
        return this.table.getColumnModel();
    }

    public TableColumn getColumn(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (null != tableColumnModel) {
            try {
                return tableColumnModel.getColumn(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.trace("Specified column index not existed in PagingTree column model: Actual size:" + tableColumnModel.getColumnCount() + " index:" + n);
            }
        }
        return null;
    }

    protected CellRenderer getCellRenderer() {
        if (null == this.renderer) {
            this.renderer = new CellRenderer();
        }
        return this.renderer;
    }

    private CellEditor getCellEditor() {
        if (null == this.editor) {
            this.editor = new CellEditor();
        }
        return this.editor;
    }

    private void createTable() {
        this.table = new ScrollTable(){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (PagingTree.this.isDrawLine && !PagingTree.this.model.hasColumnModel()) {
                    Color color = graphics.getColor();
                    Color color2 = UIManager.getColor("Tree.hash");
                    graphics.setColor(color2);
                    int n = this.getRowHeight();
                    int[] nArray = new int[50];
                    int n2 = PagingTree.this.model.getStartRow();
                    boolean bl = false;
                    int n3 = PagingTree.this.model.getPageSize();
                    TreeViewNode treeViewNode = null;
                    for (int i = n2; i < n2 + n3; ++i) {
                        bl = false;
                        if (i == 0 || null == (treeViewNode = PagingTree.this.model.getViewNode(i))) continue;
                        int n4 = treeViewNode.getLevel();
                        TreeViewNode treeViewNode2 = PagingTree.this.model.getViewNode(i - 1);
                        if (null != treeViewNode2) {
                            bl = PagingTree.this.insertIntoLevelRowList(graphics, nArray, n4, i, n);
                        }
                        PagingTree.this.drawLConnector(graphics, treeViewNode, i, n, bl);
                    }
                    PagingTree.this.handleStartEndRow(graphics, n2, nArray, n);
                    graphics.setColor(color);
                }
            }

            @Override
            public void setRowHeight(int n, int n2) {
                try {
                    if (n == 0) {
                        Class<?> clazz = this.getClass().getSuperclass().getSuperclass();
                        Method method = clazz.getDeclaredMethod("getRowModel", null);
                        method.setAccessible(true);
                        SizeSequence sizeSequence = (SizeSequence)method.invoke((Object)this, (Object[])null);
                        if (n2 < 0) {
                            throw new IllegalArgumentException("New row height less than 0");
                        }
                        sizeSequence.setSize(n, n2);
                        this.resizeAndRepaint();
                    } else {
                        super.setRowHeight(n, n2);
                    }
                }
                catch (Exception exception) {
                    super.setRowHeight(n, n2);
                }
            }

            @Override
            public Rectangle getCellRect(int n, int n2, boolean bl) {
                Rectangle rectangle = super.getCellRect(n, n2, bl);
                if (null != PagingTree.this.model && !PagingTree.this.isRootVisible && this.getRowCount() - 1 == n && PagingTree.this.model.hasColumnModel()) {
                    rectangle.y = this.getRowHeight() * (n - 1);
                }
                return rectangle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearSelection() {
                PagingTree pagingTree = PagingTree.this;
                synchronized (pagingTree) {
                    super.clearSelection();
                    logger.debug("Tree selection cleared");
                }
            }
        };
        this.table.setUI(new FixedTableUI());
        this.table.setName("Pagingtree_Table");
        this.table.setAutoResizeMode(0);
        CellRenderer cellRenderer = this.getCellRenderer();
        this.table.setDefaultRenderer(TreeViewNode.class, cellRenderer);
        CellEditor cellEditor = this.getCellEditor();
        this.table.setDefaultEditor(TreeViewNode.class, cellEditor);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setTableHeader(null);
        this.initInputMap();
        this.initActionMap();
    }

    private void initInputMap() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.table.getInputMap().put(keyStroke, "entryPressed");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(32, 0);
        this.table.getInputMap().put(keyStroke2, "spacePressed");
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(39, 0);
        this.table.getInputMap().put(keyStroke3, "rightKeyPressed");
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(37, 0);
        this.table.getInputMap().put(keyStroke4, "leftKeyPressed");
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(9, 0);
        this.table.getInputMap().put(keyStroke5, "selectNextRowCell");
        if (this.addKeyListener) {
            KeyNavigationHandler keyNavigationHandler = new KeyNavigationHandler(this);
            this.table.addKeyListener(keyNavigationHandler);
        }
    }

    private void initActionMap() {
        this.table.getActionMap().put("rightKeyPressed", this.expandAction);
        this.table.getActionMap().put("leftKeyPressed", this.collapseAction);
        this.table.getActionMap().put("entryPressed", this.entryAction);
        this.table.getActionMap().put("spacePressed", this.spaceAction);
    }

    public void setContextMenuProvider(IContextMenuProvider iContextMenuProvider) {
        this.contextMenuProvider = iContextMenuProvider;
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PagingTree.this.handleContextMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PagingTree.this.handleContextMenu(mouseEvent);
            }
        });
    }

    private void cancelCellEditing() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (null != tableCellEditor) {
            tableCellEditor.cancelCellEditing();
        }
    }

    private void handleContextMenu(MouseEvent mouseEvent) {
        if (this.isValidateMouseEvent(mouseEvent)) {
            JPopupMenu jPopupMenu = this.contextMenuProvider.getContextMenu(this);
            if (null == jPopupMenu) {
                return;
            }
            this.cancelCellEditing();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            jPopupMenu.show(this.table, n, n2);
        }
    }

    private boolean isValidateMouseEvent(MouseEvent mouseEvent) {
        if (null == this.contextMenuProvider) {
            return false;
        }
        if (!mouseEvent.isPopupTrigger()) {
            return false;
        }
        Point point = mouseEvent.getPoint();
        if (!this.getCellRenderer().isInNodeRect(point)) {
            return false;
        }
        Point point2 = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point2);
        if (n < 0 && n >= this.table.getRowCount()) {
            return false;
        }
        if (!this.table.isRowSelected(n)) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        return true;
    }

    private void beforeScroll(Rectangle rectangle) {
        this.perfBegin();
        Rectangle rectangle2 = this.table.getVisibleRect();
        if (rectangle2.contains(rectangle)) {
            return;
        }
        if (rectangle.y < rectangle2.y) {
            int n = this.table.rowAtPoint(new Point(0, rectangle.y));
            int n2 = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle2.height));
            this.modelScrollTo(n, n2);
        } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            int n = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle.height - rectangle2.height));
            int n3 = this.table.rowAtPoint(new Point(0, rectangle.y));
            this.modelScrollTo(n, n3);
        }
        this.outWaste("beforeScroll Rectangle waste:");
    }

    private void modelScrollTo(int n, int n2) {
        if (null != this.model) {
            this.model.scrollTo(n, n2);
        }
    }

    public void scrollToRow(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        ((ScrollTable)this.table).performScrollingToRect(rectangle);
    }

    private void scrollToEntry(int n, int n2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        this.table.scrollRectToVisible(rectangle);
    }

    private void createScrollPane() {
        this.scrollPane = new JScrollPane(this.table);
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(){

            @Override
            protected void fireStateChanged() {
                if (!this.getValueIsAdjusting() && 0 >= PagingTree.this.parallelScrollCount) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.checkScroll();
                        }
                    });
                }
            }

            private void checkScroll() {
                PagingTree.this.beforeScroll(this);
                super.fireStateChanged();
                PagingTree.this.scrollPane.getVerticalScrollBar().revalidate();
            }
        };
        this.scrollPane.getVerticalScrollBar().setModel(defaultBoundedRangeModel);
        Color color = this.table.getBackground();
        this.scrollPane.getViewport().setBackground(color);
    }

    private void beforeScroll(DefaultBoundedRangeModel defaultBoundedRangeModel) {
        this.perfBegin();
        int n = defaultBoundedRangeModel.getValue();
        int n2 = n + defaultBoundedRangeModel.getExtent();
        int n3 = this.table.rowAtPoint(new Point(0, n));
        int n4 = this.table.rowAtPoint(new Point(0, n2));
        if (null != this.model && n3 >= 0) {
            this.model.scrollTo(n3, n4);
        }
        this.outWaste("beforeScroll DefaultBoundedRangeModel waste:");
    }

    public void addSelectionChangeListener(ITreeSelectionChangeListener iTreeSelectionChangeListener) {
        if (null == iTreeSelectionChangeListener) {
            return;
        }
        if (null == this.selectionListeners) {
            this.selectionListeners = new ArrayList<ITreeSelectionChangeListener>(1);
            ListSelectionListener listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        PagingTree.this.fireSelectionChanged();
                    }
                }
            };
            this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
        }
        this.selectionListeners.add(iTreeSelectionChangeListener);
    }

    protected void fireSelectionChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (null == this.selectionListeners) {
                return;
            }
            for (ITreeSelectionChangeListener iTreeSelectionChangeListener : this.selectionListeners) {
                try {
                    iTreeSelectionChangeListener.treeSelectionChanged(this);
                }
                catch (Exception exception) {
                    logger.trace("FireSelectionChanged thrown from Business Module :" + exception);
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagingTree.this.fireSelectionChanged();
                }
            });
        }
    }

    public void removeSelectionChangeListener(ITreeSelectionChangeListener iTreeSelectionChangeListener) {
        if (null == iTreeSelectionChangeListener || null == this.selectionListeners) {
            return;
        }
        this.selectionListeners.remove(iTreeSelectionChangeListener);
    }

    public List<String> getSelectedKeys() {
        int[] nArray = this.table.getSelectedRows();
        if (null != this.model) {
            return this.model.getKeys(nArray);
        }
        return null;
    }

    public String getSelectedKey() {
        if (0 == this.getSelectedCount()) {
            return null;
        }
        int n = this.table.getSelectedRow();
        if (null != this.model) {
            return this.model.getKey(n);
        }
        return null;
    }

    public int getSelectedCount() {
        return this.table.getSelectedRowCount();
    }

    public void setSelectionMode(int n) {
        this.table.setSelectionMode(n);
    }

    public JTable getJTable() {
        return this.table;
    }

    public JScrollPane getJScrollPane() {
        return this.scrollPane;
    }

    public synchronized void changeExpandState(int n) {
        Object object;
        int n2;
        int n3;
        int n4 = this.model.getRowCount();
        logger.trace("ChangeExpandState start for row : " + n + "Model count :" + n4);
        if (n < 0 || n >= n4) {
            logger.trace("The row count is not valid.");
        }
        if (n >= (n3 = this.model.getServiceRowCount())) {
            logger.debug("Requested change expand state is not correct, service row count = " + n3);
            return;
        }
        if (!this.isRootVisible && n == 0) {
            ++n;
        }
        if ((n2 = this.model.changeExpandState(n)) > 0) {
            object = (DefaultBoundedRangeModel)this.scrollPane.getVerticalScrollBar().getModel();
            int n5 = ((DefaultBoundedRangeModel)object).getValue();
            int n6 = this.table.rowAtPoint(new Point(0, n5));
            int n7 = n5 + ((DefaultBoundedRangeModel)object).getExtent();
            int n8 = this.table.rowAtPoint(new Point(0, n7));
            int n9 = n8 - n6;
            if (n6 != n) {
                if (n9 <= n2) {
                    this.scrollToRow(n + n9 - 1);
                } else {
                    this.scrollToRow(n + n2);
                }
            }
            this.fireTreeExpanded(n);
        } else if (n2 < 0) {
            this.fireTreeCollapsed(n);
        }
        if (n2 > 0 && this.table.isRowSelected(n + 1)) {
            object = this.table.getSelectionModel();
            object.setValueIsAdjusting(true);
            object.removeSelectionInterval(n + 1, n + n2);
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
        logger.trace("ChangeExpandState end for count : " + n2);
    }

    public long getServiceId() {
        return this.model.getServiceId();
    }

    public void setAutoDispose(boolean bl) {
        this.autoDispose = bl;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        logger.trace("Disposing the services...Start : " + activeInstances.size());
        PagingTree pagingTree = this;
        synchronized (pagingTree) {
            if (null != this.model) {
                this.model.close();
                this.model = null;
                activeInstances.remove(this);
                this.copyAction = null;
            }
        }
        logger.trace("Disposing the services...End");
    }

    private void setNodeState(TreeViewNode treeViewNode, int n) {
        if (!treeViewNode.isExpanded()) {
            this.changeExpandState(n);
        } else {
            TreeViewNode treeViewNode2;
            int n2 = n + 1;
            if (n2 < this.table.getRowCount() && (treeViewNode2 = (TreeViewNode)this.model.getValueAt(n2, 0)).getLevel() > treeViewNode.getLevel()) {
                this.setSelectedRow(n2);
                this.scrollToRow(n2);
            }
        }
    }

    public boolean scrollToNode(final String string, final boolean bl) {
        boolean bl2 = (Boolean)new UITask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    PagingTree.this.parallelScrollCount++;
                    PagingTree.this.perfBegin();
                    int n = PagingTree.this.model.expandToKey(string);
                    if (-1 != n) {
                        if (bl) {
                            PagingTree.this.setSelectedRow(n);
                        }
                        PagingTree.this.scrollToRow(n);
                        Boolean bl2 = true;
                        return bl2;
                    }
                    PagingTree.this.outWaste("scrollToNode waste:");
                    Boolean bl3 = false;
                    return bl3;
                }
                catch (Throwable throwable) {
                    logger.error("Exception that could have disabled scroll on PagingTree", throwable);
                    Boolean bl4 = false;
                    return bl4;
                }
                finally {
                    PagingTree.this.parallelScrollCount--;
                }
            }
        }.executeSilently();
        if (0 != this.parallelScrollCount) {
            logger.trace("Scroll will be ignored. parallelScrollCount = " + this.parallelScrollCount);
        }
        return bl2;
    }

    public void setSelectedRow(int n) {
        logger.debug("setSelectedRow:" + n);
        if (n >= this.table.getRowCount()) {
            logger.debug("row index is >= total number of pages, hence no selection done!");
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }

    public void perfBegin() {
        this.start.set(System.currentTimeMillis());
    }

    public void outWaste(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug("PerfTest " + string + (System.currentTimeMillis() - this.start.get()));
        }
    }

    void setSelectedKeys(final boolean bl, final String ... stringArray) {
        this.perfBegin();
        logger.debug("setSelectedKeys:" + (null == stringArray ? "null" : Arrays.asList(stringArray)));
        final boolean[] blArray = new boolean[]{false};
        int[] nArray = (int[])new UITask<int[]>(){

            @Override
            public int[] call() throws Exception {
                try {
                    return PagingTree.this.model.loadByKeys(stringArray, blArray, bl);
                }
                catch (Exception exception) {
                    logger.trace("Exception during loadByKeys:" + stringArray.length, exception);
                    return null;
                }
            }
        }.executeSilently(true);
        this.checkNodesAtRowsCorrespondsToKeys(bl, stringArray, blArray, nArray);
        this.table.getSelectionModel().clearSelection();
        this.getJTable().getSelectionModel().setValueIsAdjusting(true);
        if (blArray[0]) {
            this.model.fireTableDataChanged();
        }
        if (null != nArray && nArray.length > 0) {
            int n = nArray.length;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            this.fireNodesSelected();
            for (int i = 0; i < n; ++i) {
                if (i == n - 1) {
                    this.getJTable().getSelectionModel().setValueIsAdjusting(false);
                }
                this.table.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
                arrayList.add(nArray[i]);
            }
            if (null != stringArray) {
                logger.trace("Keys count = " + stringArray.length + " Rows Selected = " + arrayList);
            }
        } else {
            this.getJTable().getSelectionModel().setValueIsAdjusting(false);
        }
        nArray = null;
        this.outWaste("setSelectedKeys waste:");
    }

    private void checkNodesAtRowsCorrespondsToKeys(final boolean bl, final String[] stringArray, final boolean[] blArray, int[] nArray) {
        logger.debug("Begin tree node verification for selection");
        if (null == nArray || nArray.length == 0) {
            return;
        }
        int n = 0;
        List<String> list = this.model.getRowKeys(nArray);
        for (int n2 : nArray) {
            if (-1 != n2 && null != stringArray[n] && !stringArray[n].equals(list.get(n))) {
                logger.error("Node at row = " + n2 + " does not match with key = " + stringArray[n]);
                nArray = (int[])new UITask<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        try {
                            return PagingTree.this.model.loadByKeys(stringArray, blArray, bl);
                        }
                        catch (Exception exception) {
                            logger.trace("Exception during loadByKeys in checkNodesAtRowsCorrespondsToKeys:" + stringArray.length, exception);
                            return null;
                        }
                    }
                }.executeSilently(true);
                break;
            }
            ++n;
        }
        logger.debug("End tree node verification for selection");
    }

    public void setSelectedKeys(String ... stringArray) {
        this.setSelectedKeys(true, stringArray);
    }

    public int getFirstVisibleRow() {
        Point point = this.table.getVisibleRect().getLocation();
        return this.table.rowAtPoint(point);
    }

    public void addActionListener(ActionListener actionListener) {
        if (null == actionListener) {
            return;
        }
        if (null == this.actionListeners) {
            this.actionListeners = new ArrayList<ActionListener>(5);
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (null == actionListener || null == this.actionListeners) {
            return;
        }
        this.actionListeners.remove(actionListener);
    }

    private void fireActionEvent() {
        if (null == this.actionListeners) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 0, "open");
        for (ActionListener actionListener : this.actionListeners) {
            try {
                actionListener.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                logger.trace("FireActionEvent thrown from Business Module :" + exception);
            }
        }
    }

    public final void initTableData() {
        this.perfBegin();
        this.model.initModel();
        this.outWaste("initTableData waste:");
    }

    public void setPageSize(int n) {
        this.model.setPageSize(n);
    }

    public int getPageSize() {
        return this.model.getPageSize();
    }

    public List<TreeViewNode> getSelectedNodes() {
        if (this.getSelectedCount() == 0) {
            return null;
        }
        int[] nArray = this.table.getSelectedRows();
        return this.model.getNodes(nArray);
    }

    public TreeViewNode getSelectedNode() {
        int n = this.table.getSelectedRow();
        return this.model.getNode(n);
    }

    public void refresh(int n) {
        this.model.refresh(n);
    }

    protected void fireTreeInitialized() {
        if (null == this.initListeners) {
            return;
        }
        for (ITreeInitListener iTreeInitListener : this.initListeners) {
            try {
                iTreeInitListener.treeInitialized(this);
            }
            catch (Exception exception) {
                logger.trace("FireTreeInitialized thrown from Business Module :" + exception);
            }
        }
    }

    public void addInitListener(ITreeInitListener iTreeInitListener) {
        if (null == iTreeInitListener) {
            return;
        }
        if (null == this.initListeners) {
            this.initListeners = new ArrayList<ITreeInitListener>(1);
        }
        this.initListeners.add(iTreeInitListener);
    }

    public void removeInitListener(ITreeInitListener iTreeInitListener) {
        if (null == iTreeInitListener || null == this.initListeners) {
            return;
        }
        this.initListeners.remove(iTreeInitListener);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public void addModelListener(TableModelListener tableModelListener) {
        this.table.getModel().addTableModelListener(tableModelListener);
    }

    public void removeModelListener(TableModelListener tableModelListener) {
        this.table.getModel().removeTableModelListener(tableModelListener);
    }

    public void enableToolTip(boolean bl) {
        this.toolTipEnabled = bl;
    }

    private void initDragDrop() {
        int n = 2;
        DragSource dragSource = DragSource.getDefaultDragSource();
        TreeDragGestureListener treeDragGestureListener = new TreeDragGestureListener();
        dragSource.createDefaultDragGestureRecognizer(this.table, n, treeDragGestureListener);
        DropTarget dropTarget = new DropTarget(this.table, new DTListener());
        dropTarget.setDefaultActions(n);
    }

    public boolean isInNodeRect(Point point) {
        return this.getCellRenderer().isInNodeRect(point);
    }

    private boolean isDropAcceptable() {
        int n = -1;
        int n2 = 0;
        for (int n3 : this.selectedRows) {
            n2 = this.model.getParentRow(n3);
            if (n2 != n && -1 != n) {
                return false;
            }
            n = n2;
        }
        this.parentRow = n;
        return true;
    }

    protected void fireDataDragged() {
        TreeViewNode treeViewNode = this.model.getNode(this.parentRow);
        if (null == this.dragListeners) {
            return;
        }
        DragEvent dragEvent = new DragEvent(treeViewNode, this.targetNode, this.selectedNodes);
        for (ITreeDragListener iTreeDragListener : this.dragListeners) {
            try {
                iTreeDragListener.dragOccured(dragEvent);
            }
            catch (Exception exception) {
                logger.trace("FireDataDragged made exception byBusinessModule :" + exception);
            }
        }
        this.table.clearSelection();
    }

    public void addDraggListener(ITreeDragListener iTreeDragListener) {
        if (null == iTreeDragListener) {
            return;
        }
        if (null == this.dragListeners) {
            this.dragListeners = new ArrayList<ITreeDragListener>(1);
        }
        this.dragListeners.add(iTreeDragListener);
    }

    public void removeDraggListener(ITreeDragListener iTreeDragListener) {
        if (null == iTreeDragListener || null == this.dragListeners) {
            return;
        }
        this.dragListeners.remove(iTreeDragListener);
    }

    public void setDragEnabled(boolean bl) {
        this.table.setDragEnabled(bl);
        if (bl) {
            this.initDragDrop();
        }
    }

    protected void fireNodesSelected() {
        if (null == this.selectionNodeListeners) {
            return;
        }
        for (ITreeSelectionListener iTreeSelectionListener : this.selectionNodeListeners) {
            try {
                iTreeSelectionListener.treeNodeSelected(this);
            }
            catch (Exception exception) {
                logger.trace("FireNodesSelected thrown from Business Module :" + exception);
            }
        }
    }

    public void addSelectionListener(ITreeSelectionListener iTreeSelectionListener) {
        if (null == iTreeSelectionListener) {
            return;
        }
        if (null == this.selectionNodeListeners) {
            this.selectionNodeListeners = new ArrayList<ITreeSelectionListener>(1);
        }
        this.selectionNodeListeners.add(iTreeSelectionListener);
    }

    public void removeSelectionListener(ITreeSelectionListener iTreeSelectionListener) {
        if (null == iTreeSelectionListener || null == this.selectionNodeListeners) {
            return;
        }
        this.selectionNodeListeners.remove(iTreeSelectionListener);
    }

    public void enableAllSelection(boolean bl) {
        this.allSelection = bl;
    }

    public void setRootVisible(boolean bl) {
        if (this.isRootVisible == bl) {
            return;
        }
        this.isRootVisible = bl;
        if (!this.isRootVisible) {
            this.rowCountConst = 1;
            this.table.setRowHeight(0, 0);
        } else {
            this.rowCountConst = 0;
            int n = this.table.getRowHeight();
            this.table.setRowHeight(0, n);
        }
    }

    boolean isFitInColumn(Component component, int n) {
        int n2 = component.getPreferredSize().width;
        return n2 > this.table.getColumnModel().getColumn(n).getPreferredWidth();
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public boolean getDragEnabled() {
        return this.table.getDragEnabled();
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public boolean isRootVisible() {
        return this.isRootVisible;
    }

    public boolean isSelectionEmpty() {
        return this.table.getSelectionModel().isSelectionEmpty();
    }

    public boolean isRowSelected(int n) {
        return this.table.isRowSelected(n);
    }

    public void setRowHeight(int n) {
        this.table.setRowHeight(n);
    }

    public boolean isCollapsed(int n) {
        TreeViewNode treeViewNode = this.model.getNode(n);
        return !treeViewNode.isExpanded();
    }

    public boolean isExpanded(int n) {
        TreeViewNode treeViewNode = this.model.getNode(n);
        return treeViewNode.isExpanded();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.table.getPreferredScrollableViewportSize();
    }

    public void addTreeChangeCallBackListener(ITreeChangeCallBacks iTreeChangeCallBacks) {
        if (null == iTreeChangeCallBacks) {
            return;
        }
        if (null == this.model.treeChangeCallBackListeners) {
            this.model.treeChangeCallBackListeners = new ArrayList<ITreeChangeCallBacks>(1);
        }
        this.model.treeChangeCallBackListeners.add(iTreeChangeCallBacks);
    }

    public void removeTreeChangeCallBackListener(ITreeChangeCallBacks iTreeChangeCallBacks) {
        if (null == iTreeChangeCallBacks || null == this.model.treeChangeCallBackListeners) {
            return;
        }
        this.model.treeChangeCallBackListeners.remove(iTreeChangeCallBacks);
    }

    public void addTreeDeleteCallBackListener(ITreeDeleteCallBacks iTreeDeleteCallBacks) {
        this.model.addTreeDeleteCallBackListener(iTreeDeleteCallBacks);
    }

    public void removeTreeDeleteCallBackListener(ITreeDeleteCallBacks iTreeDeleteCallBacks) {
        this.model.removeTreeDeleteCallBackListener(iTreeDeleteCallBacks);
    }

    public void enableSelectionWhileDelete(boolean bl) {
        this.model.enableSelectionWhileDelete(bl);
    }

    public void enableDrawLine(boolean bl) {
        this.isDrawLine = bl;
    }

    public boolean isEnableDrawLine() {
        return this.isDrawLine;
    }

    private void drawLConnector(Graphics graphics, TreeViewNode treeViewNode, int n, int n2, boolean bl) {
        int n3 = this.getIndent(treeViewNode);
        if (treeViewNode.isLeaf()) {
            graphics.drawLine(n3 - 20, (n - this.rowCountConst + 1) * n2 - n2 / 2, n3 + 8, (n - this.rowCountConst + 1) * n2 - n2 / 2);
        } else {
            graphics.drawLine(n3 - 20, (n - this.rowCountConst + 1) * n2 - n2 / 2, n3, (n - this.rowCountConst + 1) * n2 - n2 / 2);
        }
        if (bl) {
            graphics.drawLine(n3 - 20, (n - this.rowCountConst) * n2 - (n2 / 2 - 4), n3 - 20, (n - this.rowCountConst) * n2 + n2 / 2);
        } else {
            graphics.drawLine(n3 - 20, (n - this.rowCountConst) * n2 - n2 / 2, n3 - 20, (n - this.rowCountConst) * n2 + n2 / 2);
        }
        int n4 = treeViewNode.getLevel();
        if (n4 > 1) {
            int n5 = 0;
            for (int i = n4 - 1; i > 0; --i) {
                n5 = n3 - (22 * (i + 1) + 2 * (i - 1));
                graphics.drawLine(n5, (n - this.rowCountConst) * n2 - n2 / 2, n5, (n - this.rowCountConst) * n2 + n2 / 2);
            }
        }
    }

    private boolean insertIntoLevelRowList(Graphics graphics, int[] nArray, int n, int n2, int n3) {
        int n4 = this.model.getViewNode(n2 - 1).getLevel();
        boolean bl = false;
        int n5 = n - n4;
        if (n5 > 0) {
            nArray[n] = n2;
            bl = true;
        } else if (n5 < -1) {
            int n6 = n4;
            for (int i = Math.abs(n5) - 1; i > 0; --i) {
                this.rubVerticalLine(graphics, nArray[n6], n2 - 1, n3);
                --n6;
            }
        } else if (n5 == -1 && this.model.getParentRow(nArray[n4]) != this.model.getParentRow(n2 - 1)) {
            nArray[n] = n2;
        }
        return bl;
    }

    private void handleStartEndRow(Graphics graphics, int n, int[] nArray, int n2) {
        if (!this.isRootVisible && n == 0) {
            Color color = graphics.getColor();
            graphics.setColor(this.table.getBackground());
            int n3 = this.getIndent(this.model.getViewNode(n + 1));
            graphics.drawLine(n3 - 20, n * n2 - (n2 / 2 - 4), n3 - 20, n * n2 + n2 / 2 - 1);
            graphics.setColor(color);
        }
        this.handleEndRow(graphics, n, nArray, n2);
    }

    private void handleEndRow(Graphics graphics, int n, int[] nArray, int n2) {
        int n3 = this.getRowCount() - 1;
        if (n3 >= n && n3 < n + this.model.getPageSize()) {
            int n4 = this.model.getViewNode(n3).getLevel();
            while (n4 - 1 > 0) {
                this.rubVerticalLine(graphics, nArray[n4], n3, n2);
                --n4;
            }
        }
    }

    private int getIndent(TreeViewNode treeViewNode) {
        if (this.isDrawLine && !this.model.hasColumnModel()) {
            return 5 + treeViewNode.getLevel() * 24;
        }
        return 5 + treeViewNode.getLevel() * 16;
    }

    private void rubVerticalLine(Graphics graphics, int n, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(this.table.getBackground());
        int n4 = 0;
        TreeViewNode treeViewNode = this.model.getViewNode(n);
        if (null != treeViewNode) {
            n4 = treeViewNode.getLevel();
        } else {
            n = this.model.getStartRow();
            n4 = this.model.getViewNode(n).getLevel();
        }
        this.drawConnector(graphics, n, n2, n4, n3);
        graphics.setColor(color);
    }

    private void drawConnector(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        for (int i = n; i <= n2; ++i) {
            n7 = n3 - this.model.getViewNode(i).getLevel();
            if (n7 != 0) {
                if (n7 > 0) {
                    while (n7 != 0) {
                        --n5;
                        --n3;
                        --n7;
                    }
                } else {
                    while (n7 != 0) {
                        ++n5;
                        ++n3;
                        ++n7;
                    }
                }
            }
            n6 = this.getIndent(this.model.getViewNode(i)) - (22 * (n5 + 1) + 2 * (n5 - 1));
            graphics.drawLine(n6, (i - this.rowCountConst) * n4 - n4 / 2 + 1, n6, (i - this.rowCountConst) * n4 + n4 / 2 + 1);
        }
    }

    private void fireTreeExpanded(int n) {
        if (null == this.expansionListeners || this.expansionListeners.isEmpty()) {
            return;
        }
        for (ITreeExpansionListener iTreeExpansionListener : this.expansionListeners) {
            if (null == iTreeExpansionListener) continue;
            iTreeExpansionListener.treeExpanded(new PagingTreeExpansionEvent(this, n));
        }
    }

    private void fireTreeCollapsed(int n) {
        if (null == this.expansionListeners || this.expansionListeners.isEmpty()) {
            return;
        }
        for (ITreeExpansionListener iTreeExpansionListener : this.expansionListeners) {
            if (null == iTreeExpansionListener) continue;
            iTreeExpansionListener.treeCollapsed(new PagingTreeExpansionEvent(this, n));
        }
    }

    public void addTreeExpansionListener(ITreeExpansionListener iTreeExpansionListener) {
        if (null == iTreeExpansionListener) {
            return;
        }
        if (null == this.expansionListeners) {
            this.expansionListeners = new ArrayList<ITreeExpansionListener>(10);
        }
        this.expansionListeners.add(iTreeExpansionListener);
    }

    public void removeTreeExpansionListener(ITreeExpansionListener iTreeExpansionListener) {
        if (null == iTreeExpansionListener || null == this.expansionListeners) {
            return;
        }
        this.expansionListeners.remove(iTreeExpansionListener);
        if (this.expansionListeners.isEmpty()) {
            this.expansionListeners = null;
        }
    }

    public boolean printTree(Component component, String string, String string2, String string3) {
        return this.printTree(component, string, string2, string3, null, null);
    }

    public boolean printTree(Component component, String string, String string2, String string3, IPrintSaveData iPrintSaveData) {
        return this.printTree(component, string, string2, string3, null, iPrintSaveData);
    }

    public boolean printTree(Component component, String string, String string2, String string3, PrintRequestAttributeSet printRequestAttributeSet) {
        return this.printTree(component, string, string2, string3, printRequestAttributeSet, null);
    }

    public boolean printTree(Component component, String string, String string2, String string3, PrintRequestAttributeSet printRequestAttributeSet, IPrintSaveData iPrintSaveData) {
        int n = 0;
        if (!this.isRootVisible()) {
            n = 1;
        }
        ++this.clearInfoCount;
        int n2 = this.initPrint();
        if (n2 < 0) {
            return false;
        }
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, component, n, n2, string, string3, string2, "", false);
        saveAndPrintParameters.setPrintRequestAttributeSet(printRequestAttributeSet);
        if (null != iPrintSaveData) {
            saveAndPrintParameters.setPagingTreeData(iPrintSaveData);
        }
        return this.printTree(saveAndPrintParameters);
    }

    private boolean printTree(SaveAndPrintParameters saveAndPrintParameters) {
        if (!saveAndPrintParameters.hasSetTotleRecordsPosition()) {
            saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        }
        this.saveAndPrintTask = saveAndPrintParameters.initTreePrintTask();
        if (this.saveAndPrintTask == null) {
            return false;
        }
        this.setMaxRowCount(false);
        this.saveAndPrintTask.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        return this.saveAndPrintTask.startTask();
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    protected List<TreeViewNode> loadPrintPage(int n, int n2) {
        return this.model.loadPrintPage(n, n2);
    }

    public int initPrint() {
        return this.model.initPrint();
    }

    protected void clearPrintInfo() {
        if (this.clearInfoCount > 0) {
            --this.clearInfoCount;
        }
        if (null != this.model) {
            if (this.clearInfoCount == 0) {
                this.model.clearPrintInfo();
                logger.trace("print information cleared");
            }
        } else {
            logger.trace("model is null");
        }
    }

    public boolean saveTree(Component component, String string, String string2, String string3, String string4) {
        return this.saveTree(component, string, false, string2, string3, string4);
    }

    public boolean saveTree(Component component, String string, String string2, String string3, String string4, IPrintSaveData iPrintSaveData) {
        return this.saveTree(component, string, false, string2, string3, string4, iPrintSaveData);
    }

    public boolean saveTree(Component component, String string, boolean bl, String string2, String string3, String string4) {
        return this.saveTree(component, string, bl, string2, string3, string4, null);
    }

    public boolean saveTree(Component component, String string, boolean bl, String string2, String string3, String string4, IPrintSaveData iPrintSaveData) {
        int n = 0;
        if (!this.isRootVisible()) {
            n = 1;
        }
        ++this.clearInfoCount;
        int n2 = this.initPrint();
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, component, n, n2, string2, string4, string3, string, bl);
        if (null != iPrintSaveData) {
            saveAndPrintParameters.setPagingTreeData(iPrintSaveData);
        }
        saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        return this.saveTree(saveAndPrintParameters);
    }

    private boolean saveTree(SaveAndPrintParameters saveAndPrintParameters) {
        if (!saveAndPrintParameters.hasSetTotleRecordsPosition()) {
            saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        }
        if (saveAndPrintParameters.getHtmlPerColWidth() == 0) {
            saveAndPrintParameters.setHtmlPerColWidth(this.htmlPerColWidth);
        }
        this.saveAndPrintTask = saveAndPrintParameters.initTreeSaveTask();
        if (this.saveAndPrintTask == null) {
            return false;
        }
        this.setMaxRowCount(true);
        saveAndPrintParameters.setPrintablePropChangeListeners(this.printablePropChangeListeners);
        this.saveAndPrintTask.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        if (null != this.emptysaveTask) {
            this.saveAndPrintTask.emptytablePrintabel = this.emptysaveTask.emptytablePrintabel;
        }
        return this.saveAndPrintTask.startTask();
    }

    public SaveAndPrintTreeTask getsaveAndPrintTreeTask() {
        this.emptysaveTask = this.saveAndPrintTask;
        if (this.emptysaveTask == null) {
            this.emptysaveTask = new SaveAndPrintTreeTask(this.getParent(), this.title, 0, this.table.getRowCount(), "", "", this.userName, this, this.summary, 0);
        }
        return this.emptysaveTask;
    }

    public void setPrintablePropChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        this.printablePropChangeListeners = propertyChangeListenerArray;
    }

    private void setMaxRowCount(boolean bl) {
        if (-1 == this.maxRecordsCountPerFile) {
            this.maxRecordsCountPerFile = bl && null != this.saveAndPrintTask.getFileType() && this.saveAndPrintTask.getFileType().equals("xlsx") ? 500000 : 20000;
        }
    }

    public void previewTree(JFrame jFrame, String string, String string2, String string3) {
        this.previewTree(jFrame, string, string2, string3, null, null);
    }

    public void previewTree(JFrame jFrame, String string, String string2, String string3, PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        this.title = string;
        this.summary = string2;
        this.userName = string3;
        this.printRequestAttributeSet = printRequestAttributeSet;
        int n = this.getModel().getColumnCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = null;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.getColumn(i).getHeaderValue();
        }
        stringArray2 = stringArray;
        Vector vector = new Vector(2);
        TablePrintable tablePrintable = new TablePrintable(string, string3, string2, stringArray2, this.getColumnWidths(), vector, this.initPrint(), false);
        tablePrintable.setPagedPreView(true);
        this.previousNodes = new ArrayList<TreeViewNode>(10);
        tablePrintable.setPreViewDataSource(new DataSource());
        tablePrintable.setTotleRecordsPosition(this.totleRecordsPosition);
        if (n == 1) {
            tablePrintable.setNormalSave(true);
        }
        this.previewTablePrintable = tablePrintable;
        PrintSupportor.preview(jFrame, tablePrintable, tablePrintable.getPageCount(), pageFormat, printRequestAttributeSet);
        this.previewTablePrintable = null;
    }

    private Collection getUnitData(List<TreeViewNode> list) {
        LinkedList linkedList = new LinkedList();
        int n = this.model.getColumnCount();
        int n2 = list.size();
        ArrayList<String> arrayList = null;
        TreeViewNode treeViewNode = null;
        int n3 = 0;
        TreeViewNode treeViewNode2 = null;
        int n4 = 0;
        StringBuffer stringBuffer = null;
        String string = null;
        for (int i = 0; i < n2; ++i) {
            int n5;
            arrayList = new ArrayList<String>(n);
            treeViewNode = list.get(i);
            if (null == treeViewNode) continue;
            if (null != this.previousNodes && this.previousNodes.size() > 0 && (n4 = (treeViewNode2 = this.previousNodes.get(n3 = this.previousNodes.size() - 1)).getLevel() - treeViewNode.getLevel()) >= 0) {
                for (n5 = 0; n5 <= n4; ++n5) {
                    if (this.previousNodes.isEmpty()) continue;
                    this.previousNodes.remove(n3 - n5);
                }
            }
            if (null != this.previousNodes) {
                this.previousNodes.add(treeViewNode);
            }
            string = null;
            for (n5 = 0; n5 < n; ++n5) {
                if (n5 == 0) {
                    stringBuffer = new StringBuffer(16);
                    for (TreeViewNode treeViewNode3 : this.previousNodes) {
                        if (null == treeViewNode3) continue;
                        stringBuffer.append("( ");
                        stringBuffer.append(treeViewNode3.getLabel());
                        stringBuffer.append(" ) ");
                    }
                    string = stringBuffer.toString();
                } else {
                    string = treeViewNode.get(n5 - 1);
                }
                if (null != string) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add("");
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    public void closePreviewDialog() {
        if (null != this.previewTablePrintable) {
            PrintSupportor.closePreviewDialog(this.previewTablePrintable.getFormatCalculator());
        } else {
            logger.debug("preview Table Printable is null.");
        }
    }

    public void showFirstChild(final int n, final boolean bl) {
        new UITask<Integer>(){

            @Override
            public Integer call() throws Exception {
                int n4;
                int n2 = PagingTree.this.model.getRowCount();
                int n3 = n;
                if (n < 0 || n >= n2) {
                    logger.trace("The row count is not valid.");
                }
                if (!PagingTree.this.isRootVisible && n == 0) {
                    n3 = n + 1;
                }
                if (-1 < (n4 = PagingTree.this.model.showFirstChild(n3, bl))) {
                    PagingTree.this.setSelectedRow(n4);
                    PagingTree.this.scrollToRow(n4);
                }
                return null;
            }
        }.executeSilently();
    }

    public void removeDefaultKeyNavigationListener() {
        KeyListener[] keyListenerArray = this.table.getKeyListeners();
        for (int i = 0; i < keyListenerArray.length; ++i) {
            if (!(keyListenerArray[i] instanceof KeyNavigationHandler)) continue;
            this.table.removeKeyListener(keyListenerArray[i]);
        }
    }

    public void addKeyNavigationListener(KeyListener keyListener) {
        this.table.addKeyListener(keyListener);
    }

    public void removeKeyNavigationListener(KeyListener keyListener) {
        this.table.removeKeyListener(keyListener);
    }

    public void setExceptionHandler(ITreeExceptionHandler iTreeExceptionHandler) {
        this.exceptionHandler = iTreeExceptionHandler;
    }

    public ITreeExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setCopyEnable(boolean bl) {
        if (this.isCopyEnable == bl) {
            return;
        }
        this.isCopyEnable = bl;
        logger.trace("Enable state of CTRL copy = " + this.isCopyEnable + " on tree = " + this.hashCode());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 128, false);
        Object object = this.table.getInputMap(1).get(keyStroke);
        ActionMap actionMap = this.table.getActionMap();
        if (null == actionMap) {
            logger.error("Could not change enable state since actionMap is null on tree = " + this.hashCode());
            return;
        }
        if (!this.isCopyEnable) {
            this.copyAction = actionMap.get(object);
            actionMap.put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
        } else {
            actionMap.put(object, this.copyAction);
        }
    }

    public boolean isCopyEnable() {
        return this.isCopyEnable;
    }

    static /* synthetic */ int[] access$2602(PagingTree pagingTree, int[] nArray) {
        pagingTree.selectedRows = nArray;
        return nArray;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = activeInstances;
                synchronized (list) {
                    for (PagingTree pagingTree : activeInstances) {
                        pagingTree.model.close();
                    }
                }
            }
        });
        logger = IviewLogger.getLogger(PagingTree.class, "IVIEW");
    }

    private final class DataSource
    implements PreViewDataSource {
        private DataSource() {
        }

        @Override
        public Collection getPreviewPageData(int n, int n2) {
            List<TreeViewNode> list = PagingTree.this.loadPrintPage(n, n2);
            Collection collection = PagingTree.this.getUnitData(list);
            return collection;
        }

        @Override
        public void print() {
            SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(PagingTree.this, (Component)PagingTree.this.getParent(), 0, PagingTree.this.initPrint(), PagingTree.this.title, PagingTree.this.userName, PagingTree.this.summary, "", false);
            saveAndPrintParameters.setPrintRequestAttributeSet(PagingTree.this.printRequestAttributeSet);
            saveAndPrintParameters.setTotleRecordsPosition(PagingTree.this.totleRecordsPosition);
            PagingTree.this.printTree(saveAndPrintParameters);
        }
    }

    private class FixedTableUI
    extends BasicTableUI {
        private BasicTableUI.MouseInputHandler handler = new BasicTableUI.MouseInputHandler(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!mouseEvent.isShiftDown()) {
                    PagingTree.this.insideTree = false;
                }
                super.mouseDragged(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PagingTree.this.insideTree = true;
                super.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PagingTree.this.insideTree = true;
                super.mouseReleased(mouseEvent);
            }
        };

        private FixedTableUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return this.handler;
        }
    }

    class ScrollTable
    extends JTable
    implements Autoscroll {
        ScrollTable() {
        }

        @Override
        public void autoscroll(Point point) {
            Rectangle rectangle = this.getBounds();
            int n = this.rowAtPoint(point);
            if (n < 0) {
                return;
            }
            if (point.y + rectangle.y <= 12) {
                if (n > 0) {
                    --n;
                }
            } else if (n < this.getRowCount() - 1) {
                ++n;
            }
            Rectangle rectangle2 = PagingTree.this.table.getCellRect(n, 0, true);
            this.scrollRectToVisible(rectangle2);
        }

        @Override
        public Insets getAutoscrollInsets() {
            int n = this.getHeight();
            int n2 = this.getWidth();
            return new Insets(n, n2, n, n2);
        }

        private void performScrollingToRect(final Rectangle rectangle) {
            PagingTreeSequencedEvent pagingTreeSequencedEvent = new PagingTreeSequencedEvent(new Runnable(){

                @Override
                public void run() {
                    PagingTree.this.beforeScroll(rectangle);
                    ScrollTable.this.superScrollRectToVisible(rectangle);
                }
            });
            SequencedEventProcessor.getInstance().scheduleEvent(pagingTreeSequencedEvent);
        }

        private void superScrollRectToVisible(Rectangle rectangle) {
            super.scrollRectToVisible(rectangle);
        }

        @Override
        public void scrollRectToVisible(final Rectangle rectangle) {
            if (SwingUtilities.isEventDispatchThread()) {
                PagingTree.this.beforeScroll(rectangle);
                super.scrollRectToVisible(rectangle);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScrollTable.this.scrollRectToVisible(rectangle);
                    }
                });
            }
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown() && bl && !PagingTree.this.allSelection) {
                return false;
            }
            if (!PagingTree.this.isRootVisible && keyEvent.getKeyCode() == 36 && keyEvent.isControlDown() && bl) {
                if (PagingTree.this.table.getRowCount() > 1) {
                    PagingTree.this.table.getSelectionModel().setSelectionInterval(1, 1);
                }
                return false;
            }
            if (!PagingTree.this.isRootVisible && keyEvent.getKeyCode() == 38 && bl) {
                int n2 = PagingTree.this.table.getSelectedRow();
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                if (PagingTree.this.table.getSelectedRow() == 0) {
                    PagingTree.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                }
                return bl2;
            }
            if (!PagingTree.this.isCopyEnable && keyStroke.equals(KeyStroke.getKeyStroke(67, 128))) {
                keyEvent.consume();
                return true;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public int getRowHeight(int n) {
            if (n == 0 && !PagingTree.this.isRootVisible) {
                this.setRowHeight(0, 0);
                return 0;
            }
            return super.getRowHeight(n);
        }

        @Override
        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (!PagingTree.this.insideTree) {
                if (PagingTree.this.table.getDragEnabled()) {
                    super.changeSelection(n, n2, true, true);
                }
            } else {
                super.changeSelection(n, n2, bl, bl2);
            }
        }

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setMaxLineNumber(10);
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            if (null == this.getToolTipText(mouseEvent)) {
                return null;
            }
            Point point = new Point();
            point.x = mouseEvent.getPoint().x + 20;
            point.y = mouseEvent.getPoint().y + 10;
            return point;
        }
    }

    private class DTListener
    implements DropTargetListener {
        private DTListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!PagingTree.this.isDropAcceptable()) {
                dropTargetDropEvent.rejectDrop();
            } else {
                Point point = dropTargetDropEvent.getLocation();
                int n = PagingTree.this.table.rowAtPoint(point);
                PagingTree.this.targetNode = PagingTree.this.model.getNode(n);
                PagingTree.this.fireDataDragged();
            }
            dropTargetDropEvent.dropComplete(true);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class TreeDragGestureListener
    implements DragGestureListener {
        private TreeDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            int n = PagingTree.this.getSelectedRow();
            if (-1 == n) {
                return;
            }
            if (2 == dragGestureEvent.getDragAction()) {
                PagingTree.this.selectedNodes = PagingTree.this.getSelectedNodes();
                PagingTree.access$2602(PagingTree.this, PagingTree.this.getSelectedRows());
            }
        }
    }

    class CellEditor
    extends BaseCellEditor
    implements TableCellEditor {
        private boolean inHandle = false;
        private CellRenderer editCellRenderer = new CellRenderer();

        CellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (this.inHandle) {
                PagingTree.this.changeExpandState(n);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CellEditor.this.cancelCellEditing();
                }
            });
            return this.editCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            this.inHandle = false;
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                Point point = mouseEvent.getPoint();
                int n = PagingTree.this.table.rowAtPoint(point);
                int n2 = PagingTree.this.table.columnAtPoint(point);
                return this.isCheckForEditibility(n, n2, point);
            }
            return false;
        }

        private boolean isCheckForEditibility(int n, int n2, Point point) {
            if (0 != n2) {
                return false;
            }
            Object object = PagingTree.this.table.getValueAt(n, n2);
            if (object instanceof TreeViewNode) {
                TreeViewNode treeViewNode = (TreeViewNode)object;
                int n3 = PagingTree.this.getIndent(treeViewNode);
                Rectangle rectangle = PagingTree.this.table.getCellRect(n, n2, false);
                Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
                Icon icon = treeViewNode.isExpanded() ? this.editCellRenderer.expandedIcon : this.editCellRenderer.collapsedIcon;
                int n4 = PagingTree.this.table.getRowHeight(n);
                int n5 = (n4 - icon.getIconHeight()) / 2;
                if (!treeViewNode.isLeaf() && point2.x >= n3 && point2.x <= n3 + icon.getIconWidth() && point2.y >= n5 && point2.y <= n5 + icon.getIconHeight()) {
                    this.inHandle = true;
                    return true;
                }
                if (!this.editCellRenderer.isInNodeRect(point)) {
                    return false;
                }
            }
            return false;
        }
    }

    class CellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final int H_GAP = 5;
        private static final int HGAP = 5;
        private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        private Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        private int icnWidth = this.collapsedIcon.getIconWidth();
        private int icnHght = this.collapsedIcon.getIconHeight();
        private Dimension iconSize = new Dimension(this.icnWidth, this.icnHght);
        private JLabel handle = new JLabel();
        private Point labelLocation = null;
        private int borderWidth = 6;

        CellRenderer() {
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            this.setBorder(border);
            this.setLayout(new BorderLayout(5, 0));
            Color color = PagingTree.this.table.getBackground();
            this.setBackground(color);
            int n = PagingTree.this.table.getRowHeight();
            this.setSize(0, n);
            this.handle.setBackground(color);
            this.add((Component)this.handle, "West");
        }

        boolean isInNodeRect(Point point) {
            int n = PagingTree.this.table.columnAtPoint(point);
            if (n != 0) {
                return true;
            }
            int n2 = PagingTree.this.table.rowAtPoint(point);
            TreeViewNode treeViewNode = PagingTree.this.model.getViewNode(n2);
            if (null != treeViewNode) {
                this.renderTreeNode(treeViewNode, false, false, n2);
                return this.isInCell(point.x);
            }
            return false;
        }

        private boolean isInCell(int n) {
            Component component = this.getComponent(1);
            Point point = component.getLocation();
            Dimension dimension = component.getMaximumSize();
            return n >= point.x && n <= point.x + dimension.width;
        }

        public Point getLabelLocation(int n, int n2) {
            Point point = PagingTree.this.table.getCellRect(n, n2, true).getLocation();
            if (n2 == 0) {
                point.x += this.labelLocation.x;
                point.y += this.labelLocation.y;
            }
            return point;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (null == object) {
                return null;
            }
            TreeViewNode treeViewNode = (TreeViewNode)object;
            if (0 != n2) {
                Component component = PagingTree.this.nodeRenderer.getTableCellComponent(PagingTree.this, treeViewNode, n, n2, bl, bl2);
                JLabel jLabel = (JLabel)PagingTree.this.nodeRenderer.getLabelComponent();
                if (PagingTree.this.toolTipEnabled) {
                    if (PagingTree.this.isFitInColumn(component, n2)) {
                        String string = jLabel.getText();
                        jLabel.setToolTipText(string);
                    } else {
                        jLabel.setToolTipText(null);
                    }
                }
                return component;
            }
            return this.renderTreeNodeTable(treeViewNode, bl, bl2, n, n2);
        }

        private Component renderTreeNodeTable(TreeViewNode treeViewNode, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderTreeNode(treeViewNode, bl, bl2, n);
            if (!PagingTree.this.model.hasColumnModel()) {
                if (PagingTree.this.model.isTreeWidthUpdated()) {
                    PagingTree.this.model.setTreeWidthState(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = PagingTree.this.model.getTreeWidth();
                            PagingTree.this.table.getColumnModel().getColumn(0).setPreferredWidth(n);
                        }
                    });
                }
                if (this.getPreferredSize().width > PagingTree.this.getJTable().getColumnModel().getColumn(0).getPreferredWidth()) {
                    PagingTree.this.getJTable().getColumnModel().getColumn(0).setPreferredWidth(this.getPreferredSize().width);
                }
            }
            if (PagingTree.this.toolTipEnabled) {
                if (this.isNotFitInColumn(component, n2)) {
                    JLabel jLabel = (JLabel)PagingTree.this.nodeRenderer.getLabelComponent();
                    String string = jLabel.getText();
                    this.setToolTipText(string);
                } else {
                    this.setToolTipText(null);
                }
            }
            return this;
        }

        boolean isNotFitInColumn(Component component, int n) {
            if (this.getPreferredSize().width > PagingTree.this.table.getColumnModel().getColumn(n).getPreferredWidth()) {
                return true;
            }
            Rectangle rectangle = PagingTree.this.table.getVisibleRect();
            int n2 = component.getLocation().x;
            int n3 = component.getPreferredSize().width;
            return n2 < rectangle.x || n2 + n3 > rectangle.x + rectangle.width;
        }

        Component renderTreeNode(TreeViewNode treeViewNode, boolean bl, boolean bl2, int n) {
            int n2 = PagingTree.this.getIndent(treeViewNode);
            Border border = BorderFactory.createEmptyBorder(0, n2, 0, 0);
            this.setBorder(border);
            if (treeViewNode.isLeaf()) {
                this.handle.setIcon(null);
                this.handle.setPreferredSize(this.iconSize);
            } else {
                boolean bl3 = treeViewNode.isExpanded();
                this.handle.setIcon(bl3 ? this.expandedIcon : this.collapsedIcon);
            }
            Component component = null;
            if (null != PagingTree.this.model) {
                boolean bl4 = PagingTree.this.model.hasColumnModel();
                component = PagingTree.this.nodeRenderer.getTreeCellComponent(PagingTree.this, treeViewNode, n, bl, bl2, bl4);
            } else {
                component = PagingTree.this.nodeRenderer.getTreeCellComponent(PagingTree.this, treeViewNode, n, bl, bl2, true);
            }
            this.add(component, "Center");
            this.validateTree();
            this.labelLocation = PagingTree.this.nodeRenderer.getLabelComponent().getLocation();
            this.labelLocation.x += component.getLocation().x;
            this.labelLocation.y += component.getLocation().y;
            return component;
        }

        int getTreeNodeWidth(TreeViewNode treeViewNode) {
            if (null == treeViewNode) {
                return 0;
            }
            Component component = this.renderTreeNode(treeViewNode, false, false, 0);
            int n = this.getPreferredSize().width;
            if (component instanceof DefaultTreeNodeRenderer) {
                Component component2;
                DefaultTreeNodeRenderer defaultTreeNodeRenderer = (DefaultTreeNodeRenderer)component;
                JLabel jLabel = defaultTreeNodeRenderer.iconLabel;
                if (jLabel.getIcon() == null && (component2 = defaultTreeNodeRenderer.getLabelComponent()) instanceof JLabel) {
                    JLabel jLabel2 = (JLabel)component2;
                    n = jLabel2.getFontMetrics(jLabel2.getFont()).stringWidth(jLabel2.getText()) + this.labelLocation.x + this.borderWidth;
                }
            }
            return n;
        }
    }
}

