/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

public class PageMapIndex {
    private int rowCount = 0;
    private int serialNumber = -1;

    public PageMapIndex() {
    }

    public PageMapIndex(int n, int n2) {
        this.rowCount = n;
        this.serialNumber = n2;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void addRowCount(int n) {
        this.rowCount += n;
        if (this.rowCount < 0) {
            this.rowCount = 0;
        }
    }

    public void setRowCount(int n) {
        this.rowCount = n;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public void copy(PageMapIndex pageMapIndex) {
        this.setRowCount(pageMapIndex.getRowCount());
        this.setSerialNumber(pageMapIndex.getSerialNumber());
    }

    public boolean canUpgrade(PageMapIndex pageMapIndex) {
        return pageMapIndex.serialNumber > this.serialNumber;
    }

    public boolean compare(PageMapIndex pageMapIndex) {
        if (this.rowCount != pageMapIndex.rowCount) {
            return false;
        }
        return this.serialNumber == pageMapIndex.serialNumber;
    }

    public String toString() {
        return "rowCount:" + this.rowCount + " serialNumber:" + this.serialNumber;
    }

    public boolean needToReload(PageMapIndex pageMapIndex) {
        return pageMapIndex.serialNumber > this.serialNumber + 1;
    }
}

