/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.templates.pagingtree.client.PagingTree;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

class KeyNavigationHandler
implements KeyListener {
    private final long TIME_FACTOR = 1000L;
    private String typedString = "";
    private PagingTree tree = null;
    private String prefix = "";
    private long lastTime = 0L;

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isNavigationKey(keyEvent)) {
            this.prefix = "";
            this.typedString = "";
            this.lastTime = 0L;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.tree != null && this.tree.getModel().getRowCount() > 0 && this.tree.getJTable().hasFocus() && this.tree.isEnabled()) {
            String string;
            if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || this.isNavigationKey(keyEvent)) {
                return;
            }
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            int n = this.tree.getSelectedRow();
            int n2 = n++;
            if (l - this.lastTime < 1000L) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n2;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n;
                ++n2;
                this.prefix = this.typedString = "" + c;
            }
            this.lastTime = l;
            if (n2 < 0 || n2 >= this.tree.getModel().getRowCount()) {
                n = 0;
                n2 = 0;
            }
            if ((string = this.tree.getModel().getNextMatch(this.prefix, n2)) != null) {
                this.tree.setSelectedKeys(string);
                this.ensureRowsAreVisible(this.tree.getSelectedRow());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean isNavigationKey(KeyEvent keyEvent) {
        InputMap inputMap = this.tree.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        return inputMap != null && inputMap.get(keyStroke) != null;
    }

    private void ensureRowsAreVisible(int n) {
        this.tree.scrollToRow(n);
    }

    KeyNavigationHandler(PagingTree pagingTree) {
        this.tree = pagingTree;
    }
}

