/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.iview.templates.pagingtree.client.ITreeNodeRenderer;
import com.swimap.iview.templates.pagingtree.client.PagingTree;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class DefaultTreeNodeRenderer
extends JPanel
implements ITreeNodeRenderer {
    protected Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    protected Icon openIcon = UIManager.getIcon("Tree.openIcon");
    protected Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    protected JLabel iconLabel;
    protected JLabel textLabel;
    protected Component labelComponent = null;
    protected Point labelLocation = null;
    protected static final Point ZEROPOINT = new Point(0, 0);
    protected String displayName = null;
    protected DefaultTableCellRenderer tableCellRenderer = null;

    public DefaultTreeNodeRenderer() {
        this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        this.openIcon = UIManager.getIcon("Tree.openIcon");
        this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        this.setLayout(new BoxLayout(this, 0));
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.setBorder(border);
        this.setOpaque(true);
        this.iconLabel = new JLabel();
        this.textLabel = new JLabel();
        this.iconLabel.setOpaque(true);
        this.textLabel.setOpaque(true);
        Border border2 = BorderFactory.createEmptyBorder(0, 2, 0, 4);
        this.textLabel.setBorder(border2);
    }

    protected void addTreeCellComponents() {
        this.add(this.iconLabel);
        this.add(3, (Component)this.textLabel);
    }

    protected Component add(int n, Component component) {
        Component component2 = Box.createRigidArea(new Dimension(n, 0));
        this.add(component2);
        return this.add(component);
    }

    protected Icon getIcon(TreeViewNode treeViewNode) {
        if (treeViewNode.isLeaf()) {
            return this.leafIcon;
        }
        if (treeViewNode.isExpanded()) {
            return this.openIcon;
        }
        return this.closedIcon;
    }

    @Override
    public Component getTreeCellComponent(PagingTree pagingTree, TreeViewNode treeViewNode, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Color color = pagingTree.getJTable().getBackground();
        Color color2 = pagingTree.getJTable().getForeground();
        this.setBackground(color);
        this.iconLabel.setBackground(color);
        Icon icon = this.getIcon(treeViewNode);
        this.iconLabel.setIcon(icon);
        Font font = pagingTree.getJTable().getFont();
        this.textLabel.setFont(font);
        if (bl) {
            object = pagingTree.getJTable().getSelectionForeground();
            Color color3 = pagingTree.getJTable().getSelectionBackground();
            this.textLabel.setForeground((Color)object);
            this.textLabel.setBackground(color3);
        } else {
            this.textLabel.setForeground(color2);
            this.textLabel.setBackground(color);
        }
        if (null != this.displayName) {
            this.textLabel.setText(this.displayName);
        } else {
            object = treeViewNode.getLabel();
            this.textLabel.setText((String)object);
        }
        if (bl3) {
            this.textLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        }
        this.removeAll();
        if (this.getComponentCount() == 0) {
            this.addTreeCellComponents();
        }
        this.validateTree();
        this.labelComponent = this.textLabel;
        return this;
    }

    @Override
    public Component getTableCellComponent(PagingTree pagingTree, TreeViewNode treeViewNode, int n, int n2, boolean bl, boolean bl2) {
        Component component;
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = new DefaultTableCellRenderer();
        }
        int n3 = this.getColumnAlignment(n2);
        this.tableCellRenderer.setHorizontalAlignment(n3);
        JTable jTable = pagingTree.getJTable();
        Object object = this.getTableCellValue(treeViewNode, n2);
        this.labelComponent = component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        return component;
    }

    protected Object getTableCellValue(TreeViewNode treeViewNode, int n) {
        return treeViewNode.get(n - 1);
    }

    protected int getColumnAlignment(int n) {
        return 2;
    }

    @Override
    public Component getLabelComponent() {
        return this.labelComponent;
    }
}

