/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagedtable;

import com.swimap.iview.templates.filtertree.FilterTreeCell;
import com.swimap.iview.templates.filtertree.FilterTreeTemplate;
import com.swimap.iview.templates.pagedtable.ColumnInfo;
import com.swimap.iview.templates.pagedtable.PagedTable;
import com.swimap.iview.templates.pagedtable.PagedTableModel;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ShowColumnSetDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(ShowColumnSetDialog.class, "IVIEW");
    private PagedTable table = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private FilterTreeTemplate columnTree = new FilterTreeTemplate();
    private DefaultMutableTreeNode columnTreeRootNode = null;
    private JPanel buttonPanel = new JPanel();
    private static final int UNABLE_CLICK_COUNT = 100;

    public ShowColumnSetDialog(PagedTable pagedTable, JFrame jFrame) {
        super((Frame)jFrame, true);
        this.table = pagedTable;
        this.setDefaultCloseOperation(2);
        this.columnTreeRootNode = new DefaultMutableTreeNode(new FilterTreeCell(PagedTable.res.getString("Select_Column_Name")));
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.setSize(380, 380);
    }

    public boolean isModified() {
        return true;
    }

    private void jbInit() throws Exception {
        this.columnTree.setShowsRootHandles(false);
        this.columnTree.setToggleClickCount(100);
        this.setTitle(PagedTable.res.getString("ShowColumnSetDialog_Title"));
        this.okButton = new JButton(PagedTable.res.getString("okButton"));
        this.cancelButton = new JButton(PagedTable.res.getString("cancelButton"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.columnTree);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), null), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.setListdata(((PagedTableModel)this.table.getModel()).allColumnInfoList);
        this.buttonPanel.setLayout(new FlowLayout(1, 30, 5));
        Dimension dimension = new Dimension(80, 21);
        this.okButton.setMaximumSize(dimension);
        this.okButton.setMinimumSize(dimension);
        this.okButton.setPreferredSize(dimension);
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowColumnSetDialog.this.okButton_mouseClicked(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowColumnSetDialog.this.canelButton_mouseClicked(actionEvent);
            }
        });
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ShowColumnSetDialog.this.okButton.requestFocus();
            }
        });
    }

    public void setListdata(ArrayList arrayList) {
        this.columnTreeRootNode.removeAllChildren();
        if (arrayList == null) {
            return;
        }
        FilterTreeCell filterTreeCell = null;
        int n = 0;
        boolean bl = false;
        ColumnInfo columnInfo = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            columnInfo = (ColumnInfo)arrayList.get(i);
            if (i == 0 && ((PagedTableModel)this.table.getModel()).isShowRowNOColumn()) continue;
            bl = columnInfo.getVisible();
            n = 0;
            n = bl ? 1 : 0;
            filterTreeCell = new FilterTreeCell(columnInfo.getColumnName(), n);
            defaultMutableTreeNode = new DefaultMutableTreeNode(filterTreeCell);
            this.columnTreeRootNode.add(defaultMutableTreeNode);
            if (!bl) continue;
            FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
        }
        ((DefaultTreeModel)this.columnTree.getModel()).setRoot(this.columnTreeRootNode);
    }

    private void okButton_mouseClicked(ActionEvent actionEvent) {
        if (((FilterTreeCell)this.columnTreeRootNode.getUserObject()).getState() == 0) {
            OptionPane.showMessageDialog(this, PagedTable.res.getString("ShowColumnSetDialog_noselect"));
            return;
        }
        int n = this.columnTreeRootNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        FilterTreeCell filterTreeCell = null;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.columnTreeRootNode.getChildAt(i);
            filterTreeCell = (FilterTreeCell)defaultMutableTreeNode.getUserObject();
            boolean bl = false;
            bl = filterTreeCell.getState() != 0;
            blArray[i] = bl;
        }
        boolean[] blArray2 = null;
        if (((PagedTableModel)this.table.getModel()).isShowRowNOColumn()) {
            blArray2 = new boolean[n + 1];
            System.arraycopy(blArray, 0, blArray2, 1, n);
            blArray2[0] = true;
        } else {
            blArray2 = blArray;
        }
        this.table.setColumnShowingEnable(blArray2);
        ((PagedTableModel)this.table.getModel()).writeConfigFile();
        this.dispose();
    }

    private void canelButton_mouseClicked(ActionEvent actionEvent) {
        this.dispose();
    }
}

