/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagedtable;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.pagedtable.PagedTable;
import com.swimap.iview.templates.pagedtable.PagedTableModel;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogTemplate;
import com.swimap.iview.util.ProgressHandler;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SaveAndPrintInmTableTask
implements Runnable {
    private static IviewLogger logger = IviewLogger.getLogger(SaveAndPrintInmTableTask.class, "IVIEW");
    private static long LOCK_TIME = 10000L;
    private Component parent = null;
    public boolean isOn = false;
    private PagedTable table = null;
    private final String title;
    private ProgressDialogTemplate blockDialog = null;
    private JProgressBar progressBar = null;
    private String[] tableHeaders = null;
    private int startRow;
    private int endRow;
    private final String fileName;
    private final String fileType;
    private final String userName;
    private final String summary;
    private static final int MAX_REC_COUNT_PERFILE = 0x100000;
    private int maxRecordsCountPerFile = 0x100000;
    private int printOrSave = 0;
    public static final int OPERATION_PRINT = 1;
    public static final int OPERATION_SAVE = 2;
    private TablePrintable tablePrintable = null;
    private volatile boolean isSuccess = true;
    private static final int ONE_SEC = 1000;
    private SaveAndPrintParameters _saveAndPrintParameters = null;
    private int[] rows = null;
    private boolean isNonContiguousSave = false;
    private int[] srows = null;
    private int[] erows = null;
    private boolean isOpenFileEnable = false;
    private ProgressHandler handler = ProgressHandler.getInstance();
    String userEncoding = null;

    public SaveAndPrintInmTableTask(Component component, String string, int n, int n2, String string2, String string3, String string4, PagedTable pagedTable, String string5, int n3) {
        this.parent = component;
        this.title = string;
        this.startRow = n;
        this.endRow = n2;
        this.fileName = string2;
        this.fileType = string3;
        this.userName = string4 == null ? "" : string4;
        this.table = pagedTable;
        this.printOrSave = n3;
        this.summary = string5;
        logger.trace("The PagedTable saving type is contiguous.");
    }

    public SaveAndPrintInmTableTask(Component component, String string, int[] nArray, String string2, String string3, String string4, PagedTable pagedTable, String string5, int n) {
        if (null == nArray) {
            throw new IllegalArgumentException("rows argument cannot be null");
        }
        this.parent = component;
        this.title = string;
        this.rows = nArray;
        this.startRow = 0;
        this.endRow = 0;
        this.fileName = string2;
        this.fileType = string3;
        this.userName = string4 == null ? "" : string4;
        this.table = pagedTable;
        this.printOrSave = n;
        this.summary = string5;
        this.isNonContiguousSave = true;
        logger.trace("The PagedTable saving type is non-contiguous.");
    }

    public boolean startTask() {
        if (this.isOn) {
            return true;
        }
        int n = this.table.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.table.getColumnName(i);
        }
        if (((PagedTableModel)this.table.getModel()).isShowRowNOColumn()) {
            this.tableHeaders = new String[n - 1];
            System.arraycopy(stringArray, 1, this.tableHeaders, 0, n - 1);
        } else {
            this.tableHeaders = stringArray;
        }
        Vector vector = new Vector(2);
        int n2 = this.isNonContiguousSave ? this.rows.length : this.endRow - this.startRow;
        SaveAndPrintParameters saveAndPrintParameters = this.getSaveAndPrintParameters();
        this.tablePrintable = this.printOrSave == 1 ? saveAndPrintParameters.createTablePrintable(this.tableHeaders, vector, n2, false) : saveAndPrintParameters.createTablePrintable(this.tableHeaders, vector, n2, true);
        if (n2 <= 0) {
            return false;
        }
        SyncCommand syncCommand = new SyncCommand(){

            @Override
            public Object call() throws Exception {
                SaveAndPrintInmTableTask.this.runTask();
                return null;
            }
        };
        if (this.printOrSave == 1) {
            syncCommand.startCall();
        } else {
            syncCommand.startCall(null, false);
        }
        return this.isSuccess;
    }

    private boolean isPrintOrSave() {
        SaveAndPrintParameters saveAndPrintParameters = this.getSaveAndPrintParameters();
        if (this.printOrSave == 1) {
            this.isOn = saveAndPrintParameters.getPrintRequestAttributeSet() != null ? PrintSupportor.print(FrameworkUtilities.getMainFrame(), this.tablePrintable, this.tablePrintable.getPageCount(), saveAndPrintParameters.getPrintRequestAttributeSet()) : PrintSupportor.print(FrameworkUtilities.getMainFrame(), this.tablePrintable, this.tablePrintable.getPageCount());
        } else {
            int n = saveAndPrintParameters.getHtmlPerColWidth();
            this.tablePrintable.setHtmlPerColWidth(n);
            this.tablePrintable.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
            this.tablePrintable.setOpenFileEnable(this.isOpenFileEnable);
            if (null != this.fileType && 0 != this.fileType.length() && PrintSupportor.checkFileAccessabilty(FrameworkUtilities.getMainFrame(), this.fileName)) {
                this.isOn = PrintSupportor.saveToFileNoCheck(FrameworkUtilities.getMainFrame(), this.fileName, this.tablePrintable, this.fileType, this.getUserEncoding());
            }
        }
        if (!this.isOn) {
            this.isSuccess = false;
            return false;
        }
        String string = this.printOrSave == 1 ? PagedTable.res.getString("Printing") : PagedTable.res.getString("Saving");
        this.blockDialog = this.createBlockDialog(this.parent, string);
        return true;
    }

    private void cancelTask() {
        if (null != this.tablePrintable && !this.isSuccess) {
            this.tablePrintable.setDataOver(true);
        }
        this.tablePrintable = null;
        this.isOn = false;
        if (this.printOrSave == 2) {
            this.handler.removeProgress(this.progressBar);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SaveAndPrintInmTableTask.this.blockDialog != null) {
                        SaveAndPrintInmTableTask.this.blockDialog.removeAll();
                        SaveAndPrintInmTableTask.this.blockDialog.dispose();
                        SaveAndPrintInmTableTask.this.blockDialog = null;
                    }
                }
            });
        }
    }

    public void cancel_exception() {
        if (this.tablePrintable != null) {
            this.isSuccess = false;
            this.tablePrintable.setDataOver(true);
            this.tablePrintable.setSaveCanceled(true);
            this.tablePrintable.setDeleteFileFlag(true);
            this.tablePrintable.setSaveState("save canceled");
        }
        this.cancelTask();
    }

    @Override
    public void run() {
        logger.debug("This api is added for backward compatability");
    }

    private void runTask() {
        int n;
        if (((PagedTableModel)this.table.getModel()).getRowCount() == 0) {
            this.isSuccess = false;
            this.cancel_exception();
            return;
        }
        this.isOn = true;
        this.isSuccess = true;
        int n2 = ((PagedTableModel)this.table.getModel()).getPageSize();
        if (this.isNonContiguousSave) {
            n = this.rows.length;
            this.normalizeRows(this.rows);
        } else {
            n = this.endRow - this.startRow;
        }
        Vector vector = new Vector(n2);
        int n3 = this.startRow / n2;
        int n4 = (this.endRow - 1) / n2;
        int n5 = n3;
        int n6 = 0;
        boolean bl = true;
        int n7 = 0;
        while (n5 <= n4 && this.isOn && !this.tablePrintable.isOver() || this.isNonContiguousSave && this.isOn && !this.tablePrintable.isOver()) {
            block32: {
                try {
                    int n8;
                    int n9;
                    if (this.isNonContiguousSave) {
                        n9 = n5 == n3 ? this.startRow : n5 * n2 + this.startRow % n2;
                        int n10 = n8 = n5 == n4 ? this.endRow - n9 : n2;
                        if (n9 + n8 > this.endRow) {
                            n8 = this.endRow - n9;
                            n5 = n4 + 1;
                        }
                    } else {
                        n9 = n5 == n3 ? this.startRow : n5 * n2;
                        n8 = n5 == n4 ? this.endRow - n9 : n2;
                    }
                    logger.debug("The rows queried: " + n9 + " to: " + (n9 + n8 - 1));
                    vector = ((PagedTableModel)this.table.getModel()).getSaveAndPrintPageData(n9, n8);
                    if (vector == null) {
                        if (this.tablePrintable != null) {
                            this.tablePrintable.setSaveCanceled(true);
                            this.tablePrintable.setDataOver(true);
                        }
                        this.isOn = false;
                        this.isSuccess = false;
                        if (this.tablePrintable != null) {
                            this.tablePrintable.setDeleteFileFlag(true);
                            this.tablePrintable.setSaveState("save canceled");
                        }
                    } else {
                        if (bl) {
                            bl = false;
                            if (!this.isPrintOrSave()) {
                                logger.debug("saving/priting service is not available");
                                this.cancel_exception();
                                continue;
                            }
                            if (this.printOrSave == 2 && this.progressBar != null) {
                                this.progressBar.setStringPainted(true);
                                this.progressBar.setMinimum(0);
                                this.progressBar.setMaximum(n);
                                this.progressBar.setValue(0);
                            } else if (this.blockDialog != null) {
                                this.blockDialog.getProgressBar().setStringPainted(true);
                                this.blockDialog.getProgressBar().setMinimum(0);
                                this.blockDialog.getProgressBar().setMaximum(n);
                                this.blockDialog.setCurrentValue(0);
                            }
                            if (null == this.blockDialog && this.printOrSave == 2) {
                                this.handler.showProgress();
                            } else {
                                ScreenToolKit.centerLocateToScreen(this.blockDialog);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SaveAndPrintInmTableTask.this.blockDialog.show();
                                    }
                                });
                            }
                        }
                        Collection collection = this.getUnitData(vector);
                        n7 = collection.size();
                        if (null != this.tablePrintable) {
                            this.tablePrintable.append(collection, true);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                    if (this.tablePrintable != null) {
                        this.tablePrintable.setSaveCanceled(true);
                    }
                    this.isOn = false;
                    this.isSuccess = false;
                    if (this.tablePrintable == null) break block32;
                    this.tablePrintable.setDeleteFileFlag(true);
                    this.tablePrintable.setSaveState("save canceled");
                }
            }
            vector = null;
            if (this.isNonContiguousSave && ++n5 > n4) {
                if (n6 < this.srows.length - 1) {
                    this.startRow = this.srows[++n6];
                    this.endRow = this.erows[n6] + 1;
                    n3 = this.startRow / n2;
                    n4 = (this.endRow - 1) / n2;
                    n5 = n3;
                } else {
                    this.isNonContiguousSave = false;
                }
            }
            try {
                if (n < 1000) {
                    Thread.sleep(500L);
                } else if (n < 5000) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException);
            }
            if (!this.isSuccess) continue;
            final int n11 = n7;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SaveAndPrintInmTableTask.this.printOrSave == 2 && SaveAndPrintInmTableTask.this.progressBar != null) {
                        SaveAndPrintInmTableTask.this.progressBar.setValue(SaveAndPrintInmTableTask.this.progressBar.getValue() + n11);
                    } else if (null != SaveAndPrintInmTableTask.this.blockDialog) {
                        SaveAndPrintInmTableTask.this.blockDialog.incrementValue(n11);
                    }
                }
            });
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            logger.trace(interruptedException);
        }
        this.stopTask();
    }

    public TablePrintable getTablePrintable() {
        return this.tablePrintable;
    }

    private Collection getUnitData(Vector vector) {
        LinkedList linkedList = new LinkedList();
        int n = this.table.getColumnCount();
        int n2 = vector.size();
        ArrayList<String> arrayList = null;
        Vector vector2 = null;
        for (int i = 0; i < n2; ++i) {
            arrayList = new ArrayList<String>(n);
            vector2 = (Vector)vector.get(i);
            if (null == vector2) continue;
            Object e = null;
            for (int j = 0; j < n; ++j) {
                int n3 = this.table.convertColumnIndexToModel(j);
                if (((PagedTableModel)this.table.getModel()).isShowRowNOColumn()) {
                    if (j == 0) continue;
                    e = vector2.get(n3 - 1);
                } else {
                    e = vector2.get(n3);
                }
                if (null != e) {
                    arrayList.add((String)e);
                    continue;
                }
                arrayList.add("");
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    private ProgressDialogTemplate createBlockDialog(Component component, String string) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window == null && component instanceof Window) {
            window = (Window)component;
        }
        IStop iStop = new IStop(){

            @Override
            public void stop() {
                SaveAndPrintInmTableTask.this.isSuccess = false;
                if (SaveAndPrintInmTableTask.this.tablePrintable != null) {
                    SaveAndPrintInmTableTask.this.tablePrintable.setDeleteFileFlag(true);
                    SaveAndPrintInmTableTask.this.tablePrintable.setSaveCanceled(true);
                }
                SaveAndPrintInmTableTask.this.stopTask();
            }
        };
        if (this.printOrSave == 2) {
            this.handler.setProcess(window);
            this.progressBar = new JProgressBar();
            this.handler.addProgress(this.progressBar, iStop);
            return null;
        }
        this.blockDialog = window instanceof Frame ? new ProgressDialogTemplate((JFrame)window, string, "", null) : new ProgressDialogTemplate((JDialog)window, string, "", null);
        this.blockDialog.setStop(iStop);
        return this.blockDialog;
    }

    public void stopTask() {
        logger.debug("stopping the save and print task");
        this.cancelTask();
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    public void setSaveAndPrintParameters(SaveAndPrintParameters saveAndPrintParameters) {
        this._saveAndPrintParameters = saveAndPrintParameters;
    }

    public SaveAndPrintParameters getSaveAndPrintParameters() {
        if (this._saveAndPrintParameters == null) {
            return new SaveAndPrintParameters(this.table, this.parent, this.startRow, this.endRow, this.title, this.userName, this.summary, "", false);
        }
        return this._saveAndPrintParameters;
    }

    private void normalizeRows(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = i;
            int n4 = n2;
            while (n3 < nArray.length - 1 && n4 == nArray[n3 + 1] - 1) {
                n4 = nArray[++n3];
            }
            nArray2[n] = nArray[i];
            nArray3[n] = nArray[n3];
            ++n;
            i = n3;
        }
        this.srows = new int[n];
        this.erows = new int[n];
        System.arraycopy(nArray2, 0, this.srows, 0, n);
        System.arraycopy(nArray3, 0, this.erows, 0, n);
        this.startRow = this.srows[0];
        this.endRow = this.erows[0] + 1;
    }

    public void setOpenFileEnable(boolean bl) {
        this.isOpenFileEnable = bl;
    }

    public void setUserEncoding(String string) {
        this.userEncoding = string;
    }

    public String getUserEncoding() {
        return this.userEncoding;
    }

    public String getFileType() {
        return this.fileType;
    }
}

