/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagedtable;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.basictable.DefaultSortElements;
import com.swimap.iview.templates.basictable.SortElements;
import com.swimap.iview.templates.basictable.SortPair;
import com.swimap.iview.templates.basictable.TableActions;
import com.swimap.iview.templates.basictable.TableActionsImpl;
import com.swimap.iview.templates.basictable.filter.DefaultFilterElement;
import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Filterable;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.templates.pagedtable.ColumnInfo;
import com.swimap.iview.templates.pagedtable.PagedTable;
import com.swimap.iview.templates.pagedtable.XMLFileNotValidException;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PagedTableModel
implements TableModel,
Filterable {
    private static IviewLogger logger = IviewLogger.getLogger(PagedTableModel.class, "IVIEW");
    private PagedTable pagedTable = null;
    public static final int DEFAULT_PAGESIZE = 100;
    public static final int DEFAULT_COLUNM_COUNT = 1;
    public static final int DATA_NOT_AVAILABLE = 0;
    protected EventListenerList listenerList = new EventListenerList();
    private final int COLLECTION_SIZE = 16;
    public ArrayList allColumnInfoList = new ArrayList(20);
    private String columnInfoFile = null;
    private boolean requestHasSent = false;
    private Hashtable pageIndexTable = new Hashtable(20);
    private LinkedList pageIndexList = new LinkedList();
    public static final int MAXIMUM_PAGE_COUNT = 10;
    private static final int MINIMUN_PAGE_COUNT = 3;
    private int pageCount = 10;
    private int rowCount = 0;
    private CommStyleInfo commStyleInfo = null;
    private static final String ROOT = "columnconfig";
    private static final String RESOURCE = "resourcebundle";
    private static final String RESOURCE_BUNDLE_NAME = "resourcebundlename";
    private static final String ALLCOLUMN = "allcolumn";
    private static final String COLUMNNAME = "columnname";
    private static final String SQLCOLUMNNAME = "sqlcolumnname";
    private static final String VISIBLE = "visible";
    private static final String SORTABLE = "sortable";
    private static final String WIDTH = "width";
    public static final int DEFAULT_COLUMN_WIDTH = 60;
    public static final int DEFAULT_COLUNM_ID = 999;
    private ColumnInfo rownoColoum = new ColumnInfo(999, "", "", true, false, 60);
    private boolean showRowNo = false;
    boolean hasInit = false;
    private TableActionsImpl actions = new TableActionsImpl();
    private boolean multiColSorting = false;
    private Map<Integer, List<Object>> colValuesMap = null;
    private Map<Integer, List<Object>> addedColValuesMap = null;
    private boolean flg = false;

    public PagedTableModel(Vector vector) {
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.allColumnInfoList.add(vector.get(i));
            }
        }
    }

    public PagedTableModel(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.allColumnInfoList.add(objectArray[i]);
        }
    }

    public PagedTableModel(String string) throws XMLFileNotValidException {
        this.columnInfoFile = string;
        this.readConfigFile(string);
    }

    public PagedTableModel(CommStyleInfo commStyleInfo) throws XMLFileNotValidException {
        this.commStyleInfo = commStyleInfo;
        this.readConfigFile(commStyleInfo);
    }

    public void setShowRowNOColumn(boolean bl) {
        this.showRowNo = bl;
        if (bl && -1 == this.allColumnInfoList.indexOf(this.rownoColoum)) {
            this.allColumnInfoList.add(0, this.rownoColoum);
        }
    }

    public boolean isShowRowNOColumn() {
        return this.showRowNo;
    }

    public void setBufPageCount(int n) {
        if (n < 3) {
            n = 3;
        }
        this.pageCount = n;
    }

    public int getBufPageCount() {
        return this.pageCount;
    }

    public ColumnInfo getColumnInfo(int n) {
        if (n > -1 && n < this.allColumnInfoList.size()) {
            return (ColumnInfo)this.allColumnInfoList.get(n);
        }
        return null;
    }

    public boolean[] getColunmShowing() {
        boolean[] blArray = null;
        if (!this.hasInit || this.pagedTable == null) {
            blArray = new boolean[this.allColumnInfoList.size()];
            int n = this.allColumnInfoList.size();
            for (int i = 0; i < n; ++i) {
                blArray[i] = ((ColumnInfo)this.allColumnInfoList.get(i)).getVisible();
            }
        } else {
            blArray = this.pagedTable.getShowingColumn();
        }
        return blArray;
    }

    protected void sortLog(int n, boolean bl) {
        this.initializeData(n, bl, true);
    }

    private void initializeData(int n, final boolean bl, final boolean bl2) {
        final int n2 = n;
        try {
            SyncCommand syncCommand = new SyncCommand(){

                @Override
                public Object call() throws Exception {
                    Object object;
                    PagedTableModel.this.requestHasSent = false;
                    if (bl2) {
                        object = ((ColumnInfo)PagedTableModel.this.allColumnInfoList.get(n2)).getSqlColumnName();
                        PagedTableModel.this.rowCount = PagedTableModel.this.initDataBuff((String)object, bl);
                    } else {
                        PagedTableModel.this.rowCount = PagedTableModel.this.initDataBuff();
                    }
                    object = PagedTableModel.this.getPageData(0, PagedTableModel.this.getPageSize() > PagedTableModel.this.getRowCount() ? PagedTableModel.this.getRowCount() : PagedTableModel.this.getPageSize());
                    PagedTableModel.this.pageIndexTable.clear();
                    PagedTableModel.this.pageIndexList.clear();
                    PagedTableModel.this.storeRecord(0, (Vector)object);
                    PagedTableModel.this.requestHasSent = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PagedTableModel.this.fireTableChanged();
                        }
                    });
                    return null;
                }
            };
            syncCommand.startCall();
            if (syncCommand.getException() != null) {
                throw syncCommand.getException();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public boolean writeConfigFile() {
        if (this.commStyleInfo == null) {
            return false;
        }
        AreaDescContainer areaDescContainer = this.commStyleInfo.getAreaDescContainer(ROOT);
        if (null == areaDescContainer) {
            logger.trace("Error:InmPagedTable getColumnInfo " + this.columnInfoFile + " is inValid,did not contain ColumnConfig area");
            return false;
        }
        DescContainer descContainer = areaDescContainer.getDescContainer(ALLCOLUMN);
        if (null == descContainer) {
            logger.trace("Error:InmPagedTable getColumnInfo " + this.columnInfoFile + " is inValid,did not contain ColumnConfig area");
            return false;
        }
        int n = descContainer.getSubDescCount();
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer2 = descContainer.getDescContainer(i);
            if (null == descContainer2) continue;
            boolean bl = false;
            bl = this.showRowNo ? ((ColumnInfo)this.allColumnInfoList.get(i + 1)).getVisible() : ((ColumnInfo)this.allColumnInfoList.get(i)).getVisible();
            descContainer2.setParasItem(VISIBLE, bl ? "true" : "false");
        }
        CommStyleManager.getInstance().writeToUser(this.commStyleInfo);
        return true;
    }

    private void readConfigFile(String string) throws XMLFileNotValidException {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        this.commStyleInfo = commStyleManager.getCommonStyleFile(string);
        this.readConfigFile(this.commStyleInfo);
    }

    private void readConfigFile(CommStyleInfo commStyleInfo) throws XMLFileNotValidException {
        DescContainer descContainer;
        if (commStyleInfo == null || !commStyleInfo.isValid()) {
            String string = commStyleInfo == null ? "" : commStyleInfo.getFileName();
            String string2 = "Error:PagedTableModel getColumnInfo " + string + " is inValid";
            throw new XMLFileNotValidException(string2);
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(ROOT);
        if (null == areaDescContainer) {
            String string = "Error:PagedTableModel getColumnInfo " + commStyleInfo.getFileName() + " is inValid,did not contain ColumnConfig area";
            throw new XMLFileNotValidException(string);
        }
        ResourceBundle resourceBundle = null;
        DescContainer descContainer2 = areaDescContainer.getDescContainer(RESOURCE);
        if (null != descContainer2) {
            try {
                resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile(descContainer2.getParasItemValue(RESOURCE_BUNDLE_NAME));
            }
            catch (Exception exception) {
                resourceBundle = null;
            }
        }
        if (null == (descContainer = areaDescContainer.getDescContainer(ALLCOLUMN))) {
            String string = "Error:PagedTableModel getColumnInfo " + commStyleInfo.getFileName() + " is inValid,did not contain AllColumnID area";
            throw new XMLFileNotValidException(string);
        }
        int n = descContainer.getSubDescCount();
        int n2 = 0;
        String string = null;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        ColumnInfo columnInfo = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer3 = descContainer.getDescContainer(i);
            if (null == descContainer3) continue;
            string3 = descContainer3.getDescName();
            string4 = descContainer3.getParasItemValue(COLUMNNAME);
            string5 = descContainer3.getParasItemValue(SQLCOLUMNNAME);
            string6 = descContainer3.getParasItemValue(VISIBLE);
            string7 = descContainer3.getParasItemValue(SORTABLE);
            string8 = descContainer3.getParasItemValue(WIDTH);
            string9 = null;
            if (resourceBundle != null) {
                try {
                    string9 = resourceBundle.getString(string4);
                }
                catch (Exception exception) {
                    string9 = null;
                }
            }
            if (string9 == null) {
                string9 = string4;
            }
            try {
                n2 = new Integer(string3);
                string = string5;
                n3 = new Integer(string8);
                bl = string6.toLowerCase().endsWith("true");
                bl2 = string7.toLowerCase().endsWith("true");
                columnInfo = new ColumnInfo(n2, string9, string, bl, bl2, n3);
                this.allColumnInfoList.add(columnInfo);
                continue;
            }
            catch (Exception exception) {
                throw new XMLFileNotValidException(exception.getMessage());
            }
        }
    }

    protected Vector getPageData(int n, int n2) {
        return new Vector(2);
    }

    protected Vector getSaveAndPrintPageData(int n, int n2) {
        return new Vector(2);
    }

    protected int initDataBuff(String string, boolean bl) {
        this.addSortingConfiguration(string, bl);
        return this.initDataBuff();
    }

    private int initDataBuff() {
        DefaultFilterElement defaultFilterElement = (DefaultFilterElement)this.actions.getActionElement(FilterElement.class);
        if (null != defaultFilterElement) {
            this.actions.putActionElement(FilterElement.class, (FilterElement)defaultFilterElement.clone());
        }
        return this.initDataBuff(this.actions);
    }

    protected int initDataBuff(TableActions tableActions) {
        return 0;
    }

    private void addSortingConfiguration(String string, boolean bl) {
        if (null == string || 0 == string.length()) {
            return;
        }
        SortElements sortElements = this.actions.getActionElement(SortElements.class);
        if (null == sortElements) {
            sortElements = new DefaultSortElements();
            this.actions.putActionElement(SortElements.class, sortElements);
        } else if (!this.multiColSorting) {
            ((DefaultSortElements)sortElements).clear();
        }
        ((DefaultSortElements)sortElements).add(new SortPair(this.getIndexOfSQLCol(string), bl));
    }

    private int getIndexOfSQLCol(String string) {
        String string2 = null;
        int n = this.allColumnInfoList.size();
        for (int i = 0; i < n; ++i) {
            string2 = ((ColumnInfo)this.allColumnInfoList.get(i)).getSqlColumnName();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void setFilter(FilterElement filterElement) {
        FilterElement filterElement2 = this.actions.getActionElement(FilterElement.class);
        if (null == filterElement2 && null == filterElement) {
            return;
        }
        if (null == filterElement) {
            this.actions.remove(FilterElement.class);
        } else {
            this.actions.putActionElement(FilterElement.class, filterElement);
        }
        if (null != filterElement2 && filterElement2.equals(filterElement)) {
            return;
        }
        this.initializeData(-1, false, false);
    }

    @Override
    public final FilterElement getFilter() {
        DefaultFilterElement defaultFilterElement = (DefaultFilterElement)this.actions.getActionElement(FilterElement.class);
        return defaultFilterElement != null ? (FilterElement)defaultFilterElement.clone() : null;
    }

    @Override
    public final boolean isColumnFilterable(int n) {
        if (n < 0 || n >= this.allColumnInfoList.size()) {
            logger.debug("Column index = " + n + " is not valid. Column list size = " + this.allColumnInfoList.size());
            return false;
        }
        ColumnInfo columnInfo = (ColumnInfo)this.allColumnInfoList.get(n);
        return columnInfo.isFilterable();
    }

    @Override
    public final boolean isMultiValueSelectionEnabled(int n) {
        ColumnInfo columnInfo = (ColumnInfo)this.allColumnInfoList.get(n);
        return columnInfo.isMultiValueSelectionEnabled();
    }

    @Override
    public final boolean isColumnFiltered(int n) {
        FilterElement filterElement = this.actions.getActionElement(FilterElement.class);
        if (null == filterElement) {
            return false;
        }
        return ((DefaultFilterElement)filterElement).isColumnExist(n);
    }

    @Override
    public final List<Object> getAddedColumnValueList(int n) {
        if (null == this.addedColValuesMap) {
            this.addedColValuesMap = new HashMap<Integer, List<Object>>(16);
        }
        if (!this.addedColValuesMap.containsKey(n)) {
            this.addedColValuesMap.put(n, new ArrayList(16));
        }
        return this.addedColValuesMap.get(n);
    }

    public final List<Object> getFilterColumnValues(int n) {
        final ArrayList<Object> arrayList = new ArrayList<Object>(16);
        if (null == this.colValuesMap) {
            this.colValuesMap = new HashMap<Integer, List<Object>>(16);
        }
        if (this.colValuesMap.containsKey(n)) {
            return this.colValuesMap.get(n);
        }
        final int n2 = n;
        SyncCommand syncCommand = new SyncCommand(){

            @Override
            public Object call() {
                String string = ((ColumnInfo)PagedTableModel.this.allColumnInfoList.get(n2)).getSqlColumnName();
                List<Object> list = PagedTableModel.this.getFilterColValues(string);
                if (null != list) {
                    LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(list);
                    arrayList.addAll(linkedHashSet);
                }
                PagedTableModel.this.colValuesMap.put(n2, arrayList);
                return null;
            }
        };
        syncCommand.startCall();
        return arrayList;
    }

    @Override
    public List<Operators.Operator> getFilterOperatorList(int n) {
        return Arrays.asList(Operators.Operator.values());
    }

    protected List<Object> getFilterColValues(String string) {
        return new ArrayList<Object>(2);
    }

    public void initModel(String string, boolean bl) {
        this.clearPageTable();
        this.rowCount = this.initDataBuff(string, bl);
        Vector vector = this.getPageData(0, this.getPageSize() > this.getRowCount() ? this.getRowCount() : this.getPageSize());
        this.storeRecord(0, vector);
        this.requestHasSent = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagedTableModel.this.fireTableChanged();
                    }
                });
            }
        });
    }

    protected Hashtable getBufData() {
        return this.pageIndexTable;
    }

    public void clearPageTable() {
        this.rowCount = 0;
        this.requestHasSent = false;
        this.pageIndexTable.clear();
        this.pageIndexList.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagedTableModel.this.fireTableChanged();
            }
        });
    }

    public void setPagedTable(PagedTable pagedTable) {
        this.pagedTable = pagedTable;
    }

    protected int getPageSize() {
        return 100;
    }

    protected int getMaxPage() {
        return this.getRowCount() / this.getPageSize() + 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        int n3;
        int n4;
        if (this.showRowNo && n2 == 0) {
            return Integer.toString(n);
        }
        int n5 = n / this.getPageSize();
        Vector vector = (Vector)this.pageIndexTable.get(n5);
        if ((vector == null || vector.size() == 0) && !this.flg && this.requestHasSent) {
            this.flg = true;
            n4 = 0;
            n3 = 0;
            if (!this.pageIndexTable.containsKey(n5) && !this.pageIndexTable.containsKey(n5 + 1)) {
                n4 = n5 * this.getPageSize();
                if (n4 + (n3 = this.getPageSize() * 2) > this.getRowCount()) {
                    n3 = this.getRowCount() - n4;
                }
                object = this.getPageData(n4, n3);
                this.storeRecPageIndex(n5, (Vector)object);
            } else {
                n4 = n5 * this.getPageSize();
                if (n4 + (n3 = this.getPageSize()) > this.getRowCount()) {
                    n3 = this.getRowCount() - n4;
                }
                object = this.getPageData(n4, n3);
                this.storeRecord(n5, (Vector)object);
            }
            vector = (Vector)this.pageIndexTable.get(n5);
            this.flg = false;
        }
        n4 = n - n5 * this.getPageSize();
        n3 = n2;
        if (this.showRowNo) {
            --n3;
        }
        if (vector != null && vector.size() > n4) {
            object = ((Vector)vector.elementAt(n4)).elementAt(n3);
            return object;
        }
        return "";
    }

    private void storeRecPageIndex(int n, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n2 = n;
        int n3 = this.getPageSize();
        int n4 = vector.size() / this.getPageSize();
        int n5 = 0;
        if (1 == vector.size()) {
            for (int i = 0; i < 2; ++i) {
                this.storeRecord(n2 + i, vector);
            }
            return;
        }
        if (vector.size() < this.getPageSize()) {
            this.storeRecord(n2, vector);
            return;
        }
        for (int i = 0; i < n4; ++i) {
            Vector vector2 = new Vector(50);
            while (n5 < n3) {
                vector2.add(vector.get(n5));
                ++n5;
            }
            this.storeRecord(n2, vector2);
            n3 += this.getPageSize();
            ++n2;
        }
        if (vector.size() > n5) {
            int n6 = vector.size();
            Vector vector3 = new Vector(50);
            while (n5 < n6) {
                vector3.add(vector.get(n5));
                ++n5;
            }
            this.storeRecord(n2, vector3);
        }
    }

    private void storeRecord(int n, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        if (this.pageIndexList.size() >= this.pageCount) {
            int n2 = (Integer)this.pageIndexList.getFirst();
            if (!this.pageIsShowing(n2)) {
                this.pageIndexTable.remove(this.pageIndexList.removeFirst());
            } else {
                this.pageIndexTable.remove(this.pageIndexList.remove(2));
            }
        }
        Integer n3 = n;
        this.pageIndexList.addLast(n3);
        this.pageIndexTable.put(n3, vector);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PagedTableModel.this.fireTableChanged();
            }
        });
    }

    private boolean pageIsShowing(int n) {
        int n2 = n * this.getPageSize();
        int n3 = n2 + this.getPageSize();
        int n4 = this.pagedTable.getCurrentRow();
        return n2 <= n4 && n3 >= n4;
    }

    @Override
    public int getColumnCount() {
        return this.allColumnInfoList.size();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public Vector getRowdata(int n) {
        int n2 = n / this.getPageSize();
        Vector vector = (Vector)this.pageIndexTable.get(n2);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n3 = n - n2 * this.getPageSize();
        Vector vector2 = (Vector)vector.elementAt(n3);
        return vector2;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public void fireTableChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, this.getRowCount() - 1, -1);
        this.fireTableChanged(tableModelEvent);
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    @Override
    public String getColumnName(int n) {
        ColumnInfo columnInfo = (ColumnInfo)this.allColumnInfoList.get(n);
        if (columnInfo != null) {
            return columnInfo.getColumnName();
        }
        return "";
    }
}

