/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagedtable;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.basictable.ColumnInformation;
import com.swimap.iview.templates.beans.SortableTableHeaderRenderer;
import com.swimap.iview.templates.beans.TableColumnSortable;
import com.swimap.iview.templates.pagedtable.ColumnInfo;
import com.swimap.iview.templates.pagedtable.InmTable;
import com.swimap.iview.templates.pagedtable.PageTableScrollPane;
import com.swimap.iview.templates.pagedtable.PagedTableModel;
import com.swimap.iview.templates.pagedtable.SaveAndPrintInmTableTask;
import com.swimap.iview.templates.print.PreViewDataSource;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PagedTable
extends InmTable
implements TableColumnSortable {
    private static IviewLogger logger = IviewLogger.getLogger(PagedTable.class, "IVIEW");
    public static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/pagedtable/Res");
    private PagedTableModel tableModel = null;
    protected PageTableScrollPane scrollPane = null;
    private SaveAndPrintInmTableTask saveAndPrintTask = null;
    public static final int ASCENDING_SORT = 1;
    public static final int DESCENDING_SORT = -1;
    public static final int NONE_SORT = 0;
    private int sortStatus = 0;
    private int sortedColumn = 0;
    public static final int MAX_XLSX_REC_COUNT_PERFILE = 500000;
    public static final int MAX_REC_COUNT_PERFILE = 20000;
    private static String COLUMN_SORTED = "columnSorted";
    private static String IS_DESCENDING = "isDescending";
    private int maxRecordsCountPerFile = -1;
    private boolean sortable = true;
    private int clickCount = 1;
    private static final int ROW_NO_PREFERRED_WIDTH = 65;
    private String title = "";
    private String summary = "";
    private String userName = "";
    private PrintRequestAttributeSet printRequestAttributeSet = null;
    private boolean totleRecordsPosition = false;
    private TablePrintable previewTablePrintable = null;
    private int[] printColumnWidths = null;
    private boolean useActualWidthsForPrint = false;
    private int htmlPerColWidth = 0;
    private static final String SAVE_SETTING_DESC = "savesetting";
    private static final String PARA_ISOPENFILE = "isOpenFile";
    private boolean isOpenFileEnable = false;

    public PagedTable(PagedTableModel pagedTableModel) {
        this(pagedTableModel, true);
    }

    public PagedTable(PagedTableModel pagedTableModel, boolean bl) {
        super(pagedTableModel);
        this.tableModel = pagedTableModel;
        this.setDoubleBuffered(true);
        this.setModel(pagedTableModel);
        pagedTableModel.setPagedTable(this);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new SortableTableHeaderRenderer());
        this.setAutoResizeMode(2);
        if (pagedTableModel.getColunmShowing() != null && pagedTableModel.getColunmShowing().length > 0) {
            this.setColumnShowingEnable(pagedTableModel.getColunmShowing(), true);
            this.tableModel.hasInit = true;
        }
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl = PagedTable.this.handleHeaderMouseClick(mouseEvent);
                if (bl) {
                    return;
                }
                if (0 != (mouseEvent.getModifiers() & 0x10) && PagedTable.this.getResizingColumn(mouseEvent) == null && PagedTable.this.sortable && mouseEvent.getClickCount() == PagedTable.this.clickCount) {
                    PagedTable.this.columnSelected(mouseEvent);
                    PagedTable.this.setColumnInformation();
                }
            }
        });
        if (bl) {
            this.readConfigFile();
        }
    }

    public void viewChanged(ChangeEvent changeEvent, JViewport jViewport) {
        if (jViewport != null) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            point.y = boundedRangeModel.getValue();
            jViewport.setViewPosition(point);
        }
    }

    public void setSortingColumn(int n) {
        this.sortedColumn = n;
    }

    public void setShowConfig(boolean bl) {
        this.setCustomizable(bl);
    }

    public boolean isShowConfig() {
        return this.isCustomizable();
    }

    public void rollUpOneRow() {
        JScrollBar jScrollBar = this.getScrollPane().getInmVerticalScrollBar();
        if (jScrollBar.getValue() - this.getScrollPane().getscrollIncrement() >= jScrollBar.getMinimum()) {
            jScrollBar.setValue(jScrollBar.getValue() - this.getScrollPane().getscrollIncrement());
        } else {
            jScrollBar.setValue(jScrollBar.getMinimum());
        }
    }

    public void rollDownOneRow() {
        JScrollBar jScrollBar = this.getScrollPane().getInmVerticalScrollBar();
        if (jScrollBar.getValue() + this.getScrollPane().getscrollIncrement() <= jScrollBar.getMaximum()) {
            jScrollBar.setValue(jScrollBar.getValue() + this.getScrollPane().getscrollIncrement());
        }
    }

    public void scrollToRow(int n) {
        this.getScrollPane().scrollToRow(n);
    }

    public SaveAndPrintInmTableTask getSaveAndPrintTask() {
        return this.saveAndPrintTask;
    }

    private void columnSelected(MouseEvent mouseEvent) {
        int n = this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 < 0) {
            logger.trace("Error:InmPagedTable columnSelected column index < 0" + String.valueOf(n));
            return;
        }
        ColumnInfo columnInfo = this.tableModel.getColumnInfo(n2);
        if (columnInfo == null) {
            logger.trace("Error: InmPagedTable columnSelected(): columnInfo == null");
            return;
        }
        if (!columnInfo.getSortable()) {
            return;
        }
        if (this.sortedColumn == n2) {
            if (this.sortStatus == 1) {
                this.sortStatus = -1;
            } else if (this.sortStatus == -1) {
                this.sortStatus = 1;
            } else if (this.sortStatus == 0) {
                this.sortStatus = 1;
            }
        } else {
            this.sortedColumn = n2;
            this.sortStatus = 1;
        }
        if (this.tableModel.getRowCount() != 0) {
            this.tableModel.sortLog(n2, this.sortStatus == 1);
        }
        this.getTableHeader().repaint();
    }

    @Override
    public boolean isColumnSortable(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        ColumnInfo columnInfo = this.tableModel.getColumnInfo(n2);
        if (columnInfo == null) {
            logger.trace("Error:InmPagedTable isColumnSortable() columnInfo = null, column id is: " + String.valueOf(n));
            return false;
        }
        return columnInfo.getSortable();
    }

    @Override
    protected int getPreferredWidthForContent(TableColumn tableColumn) {
        int n = 0;
        int n2 = tableColumn.getModelIndex();
        int n3 = this.convertColumnIndexToView(n2);
        if (this.tableModel.isShowRowNOColumn()) {
            if (n2 == 0) {
                return 65;
            }
            --n2;
        }
        TableCellRenderer tableCellRenderer = null;
        Object object = null;
        Component component = null;
        int n4 = 0;
        Iterator iterator = this.getBufIndex().iterator();
        while (iterator.hasNext()) {
            n4 = (Integer)iterator.next();
            tableCellRenderer = this.getCellRenderer(n4, n3);
            object = this.getValueAt(n4, n3);
            component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n4, n3);
            n = Math.max(component.getPreferredSize().width, n);
        }
        return n + 15;
    }

    public void setColumnSortable(Object object, boolean bl) {
        ColumnInfo columnInfo = this.getColumnInfo(object);
        if (columnInfo == null) {
            logger.debug("columnInfo is null.");
            return;
        }
        columnInfo.setSortable(bl);
        this.getTableHeader().repaint();
    }

    private ColumnInfo getColumnInfo(Object object) {
        TableColumn tableColumn = this.getColumn(object);
        int n = tableColumn.getModelIndex();
        return this.tableModel.getColumnInfo(n);
    }

    public void setColumnSortable(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.setColumnSortable(objectArray[i], bl);
        }
    }

    public void setSortableClickCount(int n) {
        this.clickCount = n;
    }

    public void setSortable(boolean bl) {
        if (this.sortable == bl) {
            return;
        }
        this.sortable = bl;
        this.getTableHeader().repaint();
    }

    @Override
    public boolean getSortable() {
        return this.sortable;
    }

    @Override
    public int getColumnState(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 == this.sortedColumn) {
            return this.sortStatus;
        }
        return 0;
    }

    public void setSortingStatus(int n) {
        this.sortStatus = n;
        this.getTableHeader().repaint();
    }

    public boolean[] getShowingColumn() {
        Hashtable hashtable = this.getColInfos();
        Vector vector = this.getKeys();
        boolean[] blArray = new boolean[hashtable.size()];
        int n = hashtable.size();
        for (int i = 0; i < n; ++i) {
            ColumnInformation columnInformation = (ColumnInformation)hashtable.get(vector.get(i));
            blArray[i] = columnInformation.getState() != 3 && columnInformation.getState() != 1;
        }
        return blArray;
    }

    public Vector getBufData() {
        Hashtable hashtable = this.tableModel.getBufData();
        Vector vector = new Vector(100);
        Enumeration enumeration = hashtable.keys();
        Object[] objectArray = new Object[hashtable.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = enumeration.nextElement();
            ++n;
        }
        Arrays.sort(objectArray);
        Vector vector2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            vector2 = (Vector)hashtable.get(objectArray[i]);
            int n2 = vector2.size();
            for (int j = 0; j < n2; ++j) {
                vector.add(vector2.get(j));
            }
        }
        return vector;
    }

    public void previewTable(JFrame jFrame, String string, String string2, String string3) {
        this.previewTable(jFrame, string, string2, string3, null, null);
    }

    public void previewTable(JFrame jFrame, String string, String string2, String string3, PageFormat pageFormat, PrintRequestAttributeSet printRequestAttributeSet) {
        this.title = string;
        this.summary = string2;
        this.userName = string3;
        this.printRequestAttributeSet = printRequestAttributeSet;
        int n = this.getColumnCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = null;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getColumnName(i);
        }
        if (this.tableModel.isShowRowNOColumn()) {
            stringArray2 = new String[n - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, n - 1);
        } else {
            stringArray2 = stringArray;
        }
        Vector vector = new Vector(2);
        TablePrintable tablePrintable = new TablePrintable(string, string3, string2, stringArray2, this.getPrintPreviewColumnWidths(), vector, this.getRowCount(), false);
        tablePrintable.setPagedPreView(true);
        tablePrintable.setPreViewDataSource(new DataSource());
        tablePrintable.setTotleRecordsPosition(this.totleRecordsPosition);
        this.previewTablePrintable = tablePrintable;
        PrintSupportor.preview(jFrame, tablePrintable, tablePrintable.getPageCount(), pageFormat, printRequestAttributeSet);
        this.previewTablePrintable = null;
    }

    Collection getUnitData(Vector vector) {
        LinkedList linkedList = new LinkedList();
        int n = this.getColumnCount();
        int n2 = vector.size();
        ArrayList<String> arrayList = null;
        Vector vector2 = null;
        for (int i = 0; i < n2; ++i) {
            arrayList = new ArrayList<String>(n);
            vector2 = (Vector)vector.get(i);
            if (null == vector2) continue;
            Object object = null;
            for (int j = 0; j < n; ++j) {
                int n3 = this.convertColumnIndexToModel(j);
                if (((PagedTableModel)this.getModel()).isShowRowNOColumn()) {
                    if (j == 0) continue;
                    object = vector2.get(n3 - 1);
                } else {
                    object = vector2.get(n3);
                }
                if (null != object) {
                    arrayList.add(object.toString());
                    continue;
                }
                arrayList.add("");
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    public void setColumnShowingEnable(boolean[] blArray) {
        this.setColumnShowingEnable(blArray, false);
    }

    private final void setColumnShowingEnable(boolean[] blArray, boolean bl) {
        Object object;
        this.hasResizeColWidth = true;
        if (blArray == null || blArray.length == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (0 != tableColumnModel.getColumnCount()) {
            object = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)object);
        }
        object = new SortableTableHeaderRenderer();
        Hashtable hashtable = this.getColInfos();
        Vector vector = this.getKeys();
        Hashtable hashtable2 = this.getColumns();
        ColumnInformation columnInformation = null;
        ColumnInfo columnInfo = null;
        for (int i = 0; i < blArray.length; ++i) {
            columnInformation = (ColumnInformation)hashtable.get(vector.get(i));
            columnInfo = (ColumnInfo)this.tableModel.allColumnInfoList.get(i);
            if (blArray[i]) {
                if (i == 0 && this.tableModel.isShowRowNOColumn()) {
                    columnInformation.setState(2);
                } else {
                    columnInformation.setState(0);
                }
            } else {
                columnInformation.setState(1);
            }
            if (bl) {
                ((TableColumn)hashtable2.get(vector.get(i))).setPreferredWidth(columnInfo.getColumnWidth());
                columnInformation.setColWidth(columnInfo.getColumnWidth());
            }
            if (columnInfo.getSortable()) {
                ((TableColumn)hashtable2.get(vector.get(i))).setHeaderRenderer((TableCellRenderer)object);
            }
            if (blArray[i]) {
                tableColumnModel.addColumn((TableColumn)hashtable2.get(vector.get(i)));
            }
            columnInfo.setVisible(blArray[i]);
        }
    }

    public void setTableScrollPane(PageTableScrollPane pageTableScrollPane) {
        this.scrollPane = pageTableScrollPane;
    }

    public int getCurrentRow() {
        return this.scrollPane.getCurrentRow();
    }

    public PageTableScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean saveTable(Component component, String string, String string2, String string3, String string4, String string5, int n, int n2) {
        return this.saveTable(component, string, true, string3, string4, string5, n, n2);
    }

    public boolean saveTable(Component component, String string, String string2, String string3, String string4, int n, int n2) {
        return this.saveTable(component, string, false, string2, string3, string4, n, n2);
    }

    public boolean saveTable(Component component, String string, boolean bl, String string2, String string3, String string4, int n, int n2) {
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, component, n, n2, string2, string4, string3, string, bl);
        saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        return this.saveTable(saveAndPrintParameters);
    }

    public boolean saveTable(SaveAndPrintParameters saveAndPrintParameters) {
        if (!saveAndPrintParameters.hasSetTotleRecordsPosition()) {
            saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        }
        if (saveAndPrintParameters.getHtmlPerColWidth() == 0) {
            saveAndPrintParameters.setHtmlPerColWidth(this.htmlPerColWidth);
        }
        this.saveAndPrintTask = saveAndPrintParameters.initPagSaveTask();
        if (this.saveAndPrintTask == null) {
            return false;
        }
        this.setMaxRowCount(true);
        this.saveAndPrintTask.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        this.saveAndPrintTask.setOpenFileEnable(this.isOpenFileEnable);
        return this.saveAndPrintTask.startTask();
    }

    public boolean printTable(Component component, String string, String string2, String string3, int n, int n2, PrintRequestAttributeSet printRequestAttributeSet) {
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, component, n, n2, string, string3, string2, "", false);
        saveAndPrintParameters.setPrintRequestAttributeSet(printRequestAttributeSet);
        saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        return this.printTable(saveAndPrintParameters);
    }

    public boolean printTable(Component component, String string, String string2, String string3, int n, int n2) {
        return this.printTable(component, string, string2, string3, n, n2, null);
    }

    public boolean printTable(SaveAndPrintParameters saveAndPrintParameters) {
        if (!saveAndPrintParameters.hasSetTotleRecordsPosition()) {
            saveAndPrintParameters.setTotleRecordsPosition(this.totleRecordsPosition);
        }
        this.saveAndPrintTask = saveAndPrintParameters.initPagPrintTask();
        if (this.saveAndPrintTask == null) {
            return false;
        }
        this.setMaxRowCount(false);
        this.saveAndPrintTask.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        return this.saveAndPrintTask.startTask();
    }

    private void setMaxRowCount(boolean bl) {
        if (-1 == this.maxRecordsCountPerFile) {
            this.maxRecordsCountPerFile = bl && null != this.saveAndPrintTask.getFileType() && this.saveAndPrintTask.getFileType().equals("xlsx") ? 500000 : 20000;
        }
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    public void closePreviewDialog() {
        if (null != this.previewTablePrintable) {
            PrintSupportor.closePreviewDialog(this.previewTablePrintable.getFormatCalculator());
        } else {
            logger.debug("preview Table Printable is null.");
        }
    }

    private List getBufIndex() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Hashtable hashtable = this.tableModel.getBufData();
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        Integer n2 = null;
        Object var6_6 = null;
        while (enumeration.hasMoreElements()) {
            var6_6 = enumeration.nextElement();
            n = ((Vector)hashtable.get(var6_6)).size();
            for (int i = 0; i < n; ++i) {
                n2 = (Integer)var6_6 * this.tableModel.getPageSize() + i;
                linkedList.add(n2);
            }
        }
        return linkedList;
    }

    public void setTotleRecordsPosition(boolean bl) {
        this.totleRecordsPosition = bl;
    }

    public void setPrintPreviewColumnWidths(int[] nArray) {
        this.printColumnWidths = nArray;
    }

    public int[] getPrintPreviewColumnWidths() {
        if (this.useActualWidthsForPrint) {
            this.initColWidthFromTable();
        }
        return this.printColumnWidths;
    }

    public void setUseActualWidthsForPrint(boolean bl) {
        this.printColumnWidths = null;
        this.useActualWidthsForPrint = bl;
    }

    public void initColWidthFromTable() {
        int n = this.getColumnCount();
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.printColumnWidths = new int[n];
        TableColumn tableColumn = null;
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            this.printColumnWidths[i] = tableColumn.getWidth();
        }
    }

    public int getSortingColumn() {
        return this.sortedColumn;
    }

    public void setHtmlPerColWidth(int n) {
        this.htmlPerColWidth = n;
    }

    private void readConfigFile() {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/templates/pagedtablesetting");
        if (null != commStyleInfo) {
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(SAVE_SETTING_DESC);
            this.isOpenFileEnable = Boolean.valueOf(descContainer.getParasItemValue(PARA_ISOPENFILE));
        }
    }

    public void enableOpenFile(boolean bl) {
        this.isOpenFileEnable = bl;
    }

    public boolean isOpenFileEnabled() {
        return this.isOpenFileEnable;
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
        PageTableScrollPane.res = null;
    }

    public void setColumnFilterable(Object object, boolean bl) {
        ColumnInfo columnInfo = this.getColumnInfo(object);
        if (columnInfo == null) {
            logger.debug("columnInfo is null.");
            return;
        }
        columnInfo.setFilterable(bl);
        this.getTableHeader().repaint();
    }

    public void setMultiValueSelectionEnabled(Object[] objectArray, boolean bl) {
        ColumnInfo columnInfo = null;
        for (Object object : objectArray) {
            columnInfo = this.getColumnInfo(object);
            if (columnInfo == null) {
                logger.debug("columnInfo is null.");
                return;
            }
            columnInfo.setMultiValueSelectionEnabled(bl);
        }
    }

    @Override
    protected void constructColInfoDescContainer(DescContainer descContainer, ColumnInformation columnInformation) {
        super.constructColInfoDescContainer(descContainer, columnInformation);
        boolean bl = columnInformation.isColumnSorted();
        boolean bl2 = columnInformation.isDescending();
        descContainer.setParasItem(COLUMN_SORTED, Boolean.toString(bl), true);
        descContainer.setParasItem(IS_DESCENDING, Boolean.toString(bl2), true);
    }

    @Override
    protected ColumnInformation constructColumnInformation(Object object, String string, int n, int n2, int n3, DescContainer descContainer) {
        String string2 = "false";
        String string3 = "false";
        if (null != descContainer) {
            string2 = descContainer.getParasItemValue(COLUMN_SORTED);
            string3 = descContainer.getParasItemValue(IS_DESCENDING);
        }
        return new ColumnInformation(object, string, n, n2, n3, Boolean.parseBoolean(string2), Boolean.parseBoolean(string3));
    }

    void setColumnInformation() {
        Hashtable hashtable = this.getColInfos();
        Collection collection = hashtable.values();
        Iterator iterator = collection.iterator();
        int n = this.getSortingColumn();
        if (-1 == (n = this.convertColumnIndexToView(n))) {
            return;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        Object object = tableColumn.getIdentifier();
        this.setColumnInformation(hashtable, iterator, object);
    }

    private void setColumnInformation(Hashtable hashtable, Iterator iterator, Object object) {
        ColumnInformation columnInformation = (ColumnInformation)hashtable.get(object);
        boolean bl = iterator.hasNext();
        ColumnInformation columnInformation2 = null;
        while (bl) {
            columnInformation2 = (ColumnInformation)iterator.next();
            columnInformation2.setColumnSorted(false);
            bl = iterator.hasNext();
        }
        columnInformation.setColumnSorted(true);
        if (this.sortStatus == 1) {
            columnInformation.setDescending(false);
        } else {
            columnInformation.setDescending(true);
        }
    }

    @Override
    protected Hashtable getColInfos() {
        return super.getColInfos();
    }

    @Override
    protected void updateTable(ColumnInformation[] columnInformationArray) {
        super.updateTable(columnInformationArray);
        Vector vector = this.getKeys();
        Hashtable hashtable = this.getColInfos();
        ColumnInformation columnInformation = null;
        boolean bl = true;
        boolean[] blArray = new boolean[vector.size()];
        PagedTableModel pagedTableModel = (PagedTableModel)this.getModel();
        for (int i = 0; i < blArray.length; ++i) {
            Object object;
            columnInformation = (ColumnInformation)hashtable.get(vector.get(i));
            if (vector.size() == pagedTableModel.getColumnCount()) {
                object = (ColumnInfo)pagedTableModel.allColumnInfoList.get(i);
                ((ColumnInfo)object).setColumnName(columnInformation.getColName());
                pagedTableModel.allColumnInfoList.set(i, object);
            }
            if (null == columnInformation.getIdentifier() || !columnInformation.isColumnSorted()) continue;
            object = this.getColumn(columnInformation.getIdentifier());
            int n = ((TableColumn)object).getModelIndex();
            if (n < 0) {
                logger.trace("Error:InmPagedTable columnSelected column index < 0" + String.valueOf(n));
                return;
            }
            this.setSortingColumn(n);
            if (columnInformation.isDescending()) {
                this.sortStatus = -1;
                bl = false;
            } else {
                this.sortStatus = 1;
            }
            if (0 != this.tableModel.getRowCount()) {
                this.tableModel.sortLog(n, bl);
            }
            this.revalidate();
            this.getTableHeader().repaint();
            this.repaint();
        }
    }

    private final class DataSource
    implements PreViewDataSource {
        private DataSource() {
        }

        @Override
        public Collection getPreviewPageData(int n, int n2) {
            if (PagedTable.this.getModel() instanceof PagedTableModel) {
                Vector vector = ((PagedTableModel)PagedTable.this.getModel()).getSaveAndPrintPageData(n, n2);
                Collection collection = PagedTable.this.getUnitData(vector);
                return collection;
            }
            return null;
        }

        @Override
        public void print() {
            SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(PagedTable.this, (Component)PagedTable.this.getParent(), 1, PagedTable.this.getRowCount(), PagedTable.this.title, PagedTable.this.userName, PagedTable.this.summary, "", false);
            saveAndPrintParameters.setPrintRequestAttributeSet(PagedTable.this.printRequestAttributeSet);
            saveAndPrintParameters.setTotleRecordsPosition(PagedTable.this.totleRecordsPosition);
            PagedTable.this.printTable(saveAndPrintParameters);
        }
    }
}

