/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagedtable;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.pagedtable.InmToolTipPanel;
import com.swimap.iview.templates.pagedtable.PagedTable;
import com.swimap.iview.templates.pagedtable.PagedTableModel;
import com.swimap.iview.templates.pagedtable.SwimapScrollPaneUI;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ScrollPaneUI;

public class PageTableScrollPane
extends JScrollPane
implements TableModelListener,
MouseWheelListener {
    protected static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/pagedtable/Res");
    private static final int DEFAULT_INTIAL_DELAY = 200;
    protected PagedTable pagedTable = null;
    protected InmToolTipPanel tooltipPanel = null;
    private int tipXPos = 0;
    private int tipYPos = 0;
    private int scrollIncrement = 6;
    private Component lastFocusComp = null;
    private long wait_time = 200L;
    private boolean isMouseDragEvent = false;
    private Timer timer = null;
    public static int prevousRow = 0;

    public PageTableScrollPane(PagedTable pagedTable) {
        this.pagedTable = pagedTable;
        this.initialize();
    }

    public PageTableScrollPane(PagedTableModel pagedTableModel) {
        this.pagedTable = new PagedTable(pagedTableModel);
        this.initialize();
    }

    private void initialize() {
        this.pagedTable.getModel().addTableModelListener(this);
        this.pagedTable.addMouseWheelListener(this);
        this.pagedTable.setTableScrollPane(this);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        this.setDoubleBuffered(true);
        this.getViewport().add(this.pagedTable);
        this.tooltipPanel = new InmToolTipPanel(this.getVerticalScrollBar());
        this.tooltipPanel.setVisible(false);
        this.getVerticalScrollBar().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PageTableScrollPane.this.hideTip();
            }
        });
        this.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (PageTableScrollPane.this.getVerticalScrollBar() != component) {
                    PageTableScrollPane.this.storeLastFocus(component);
                }
                mouseEvent.getComponent().requestFocus();
                PageTableScrollPane.this.showTip();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PageTableScrollPane.this.hideTip();
                if (null != PageTableScrollPane.this.lastFocusComp) {
                    PageTableScrollPane.this.lastFocusComp.requestFocus();
                    PageTableScrollPane.this.lastFocusComp = null;
                }
            }
        });
        this.getVerticalScrollBar().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                mouseEvent.getComponent().requestFocus();
                PageTableScrollPane.this.showTip();
                if (PageTableScrollPane.this.isMouseDragEvent) {
                    if (null != PageTableScrollPane.this.timer) {
                        PageTableScrollPane.this.timer.cancel();
                        PageTableScrollPane.this.timer = null;
                    }
                    PageTableScrollPane.this.timer = new Timer();
                    PageTableScrollPane.this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (PageTableScrollPane.this.getVerticalScrollBar().getValueIsAdjusting()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Point point = PageTableScrollPane.this.getViewport().getViewPosition();
                                        point.y = PageTableScrollPane.this.getVerticalScrollBar().getValue();
                                        PageTableScrollPane.this.getViewport().setViewPosition(point);
                                        PageTableScrollPane.this.getViewport().invalidate();
                                        PageTableScrollPane.this.getViewport().repaint();
                                    }
                                });
                            }
                        }
                    }, PageTableScrollPane.this.wait_time);
                }
            }
        });
    }

    private void storeLastFocus(Component component) {
        this.lastFocusComp = component;
    }

    private void showTip() {
        if (!this.getVerticalScrollBar().isEnabled() || 0 == this.pagedTable.getRowCount() || this.getVerticalScrollBar().getMaximum() == this.getVerticalScrollBar().getVisibleAmount()) {
            return;
        }
        this.refreshTipText(this.getVerticalScrollBar().getValue());
        this.tooltipPanel.show(this.tipXPos, this.tipYPos);
    }

    private void hideTip() {
        if (this.tooltipPanel.isVisible()) {
            this.tooltipPanel.setVisible(false);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = this.getVerticalScrollBar().getValue();
        n = mouseWheelEvent.getWheelRotation() > 0 ? (n += this.scrollIncrement) : (n -= this.scrollIncrement);
        this.srollToPosition(n);
    }

    public void setScrollIncrement(int n) {
        this.scrollIncrement = n;
    }

    public int getscrollIncrement() {
        return this.scrollIncrement;
    }

    private void refreshTipText(int n) {
        if (this.getVerticalScrollBar().isEnabled() && this.getVerticalScrollBar().getMaximum() > this.getVerticalScrollBar().getVisibleAmount()) {
            float f = (float)n / (float)(this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getVisibleAmount());
            int n2 = (int)((float)this.pagedTable.getRowCount() * f) + 1;
            if (this.pagedTable.getRowCount() < n2) {
                n2 = this.pagedTable.getRowCount();
            }
            JToolTip jToolTip = new JToolTip();
            String string = MessageFormat.format(res.getString("NO_TOTAL_KEY"), String.valueOf(n2), String.valueOf(this.pagedTable.getRowCount()));
            jToolTip.setTipText(string);
            this.tooltipPanel.addTip(jToolTip);
            this.tooltipPanel.setVisible(this.tooltipPanel.isVisible());
        }
    }

    public int getCurrentRow() {
        float f = (float)this.getVerticalScrollBar().getValue() / (float)(this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getVisibleAmount());
        int n = (int)((float)this.pagedTable.getRowCount() * f);
        return n;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.pagedTable.revalidate();
        this.pagedTable.repaint();
    }

    public JScrollBar getInmVerticalScrollBar() {
        return this.getVerticalScrollBar();
    }

    public void srollToPosition(int n) {
        this.getVerticalScrollBar().setValue(n);
    }

    public void scrollToRow(int n) {
        float f = (float)n / (float)this.pagedTable.getRowCount();
        int n2 = (int)((float)this.getVerticalScrollBar().getMaximum() * f);
        this.getVerticalScrollBar().setValue(n2);
    }

    @Override
    public void updateUI() {
        this.setUI((ScrollPaneUI)SwimapScrollPaneUI.createUI(this));
    }

    public void setRefreshTime(long l) {
        if (l > 0L) {
            this.isMouseDragEvent = true;
            this.wait_time = l;
        }
    }
}

