/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.multitaskdialog;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.util.log.IviewLogger;

public final class ProgressTaskParameter {
    private static IviewLogger logger = IviewLogger.getLogger(ProgressTaskParameter.class, "IVIEW");
    private static ProgressTaskParameter instance = null;
    private ProgressTaskSettingStyleInfo parameters;
    private boolean autoRemoveTask;
    private boolean showTip;

    public static ProgressTaskParameter getInstance() {
        if (instance == null) {
            instance = new ProgressTaskParameter();
        }
        return instance;
    }

    private ProgressTaskParameter() {
        this.getCommstyleInfo();
    }

    private void getCommstyleInfo() {
        this.parameters = new ProgressTaskSettingStyleInfo();
        this.autoRemoveTask = this.parameters.getAutoRemoveTaskValue();
        this.showTip = this.parameters.getShowTipValue();
    }

    public boolean isAutoRemoveTask() {
        return this.autoRemoveTask;
    }

    public void setAutoRemoveTask(boolean bl) {
        this.autoRemoveTask = bl;
    }

    public boolean isShowTip() {
        return this.showTip;
    }

    public void setShowTip(boolean bl) {
        this.showTip = bl;
    }

    public void saveTaskParamter() {
        this.parameters.setAutoRemoveTaskValue(this.autoRemoveTask);
        this.parameters.setShowTipValue(this.showTip);
        this.parameters.save();
    }

    private class ProgressTaskSettingStyleInfo {
        private final String AUTOREMOVE_PARANAME = "autoRemoveTask";
        private final String SHOWTIP_PARANAME = "showTip";
        private final String SETTING_FILEPATH = "conf/common/ProgressTaskSetting";
        private DescContainer settingDescCon = null;
        private CommStyleInfo settingStyleInfo = null;

        private ProgressTaskSettingStyleInfo() {
            this.update();
        }

        private void update() {
            try {
                this.settingStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/common/ProgressTaskSetting");
                if (null == this.settingStyleInfo) {
                    logger.trace("conf/common/ProgressTaskSettingxml is not exist!or can t loaded ");
                } else {
                    AreaDescContainer areaDescContainer = this.settingStyleInfo.getAreaDescContainer("ProgressTaskSettings");
                    this.settingDescCon = areaDescContainer.getDescContainer("TaskSetting");
                }
            }
            catch (Exception exception) {
                logger.trace("Exception in getting area desc ");
            }
        }

        private void save() {
            try {
                CommStyleManager.getInstance().writeToUser(this.settingStyleInfo, "conf/common/ProgressTaskSetting");
            }
            catch (Exception exception) {
                logger.trace("exception while savingprogressTaskparameter commstyleInfo");
            }
        }

        void setAutoRemoveTaskValue(boolean bl) {
            this.setParaValue("autoRemoveTask", bl);
        }

        boolean getAutoRemoveTaskValue() {
            return this.getParaValue("autoRemoveTask", false);
        }

        void setShowTipValue(boolean bl) {
            this.setParaValue("showTip", bl);
        }

        boolean getShowTipValue() {
            return this.getParaValue("showTip", false);
        }

        private boolean setParaValue(String string, boolean bl) {
            if (this.settingDescCon != null) {
                return this.settingDescCon.setParasItem(string, Boolean.toString(bl));
            }
            return false;
        }

        private boolean getParaValue(String string, boolean bl) {
            String string2;
            boolean bl2 = bl;
            if (null != this.settingDescCon && (string2 = this.settingDescCon.getParasItemValue(string)) != null) {
                bl2 = Boolean.valueOf(string2);
            }
            return bl2;
        }
    }
}

