/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.multitaskdialog;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.multitaskdialog.ExecutorManager;
import com.swimap.iview.templates.multitaskdialog.ITaskDo;
import com.swimap.iview.templates.multitaskdialog.ITaskInfo;
import com.swimap.iview.templates.multitaskdialog.MultiTaskProgressDialog;
import com.swimap.iview.util.ProgressHandler;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class ProgressTaskMgr {
    private static IviewLogger logger = IviewLogger.getLogger(ProgressTaskMgr.class, "IVIEW");
    private ProgressHandler handler = ProgressHandler.getInstance();
    private static ProgressTaskMgr instance = null;
    private ArrayList<ITaskInfo> taskList = new ArrayList(10);
    private ExecutorManager executorManager = new ExecutorManager(ProgressTaskMgr.getCorePoolSize());
    protected MultiTaskProgressDialog taskDialog = new MultiTaskProgressDialog(FrameworkUtilities.getMainFrame());

    static int getCorePoolSize() {
        int n = Runtime.getRuntime().availableProcessors();
        return 2 * n + 1;
    }

    public static synchronized ProgressTaskMgr getInstance() {
        if (instance == null) {
            ProgressTaskMgr.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        instance = new ProgressTaskMgr();
    }

    public static synchronized void freeInstance() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    private ProgressTaskMgr() {
        this.handler.setMultiTaskProcess(this.taskDialog);
    }

    public void dispose() {
        if (this.executorManager != null) {
            this.executorManager.dispose();
            this.taskDialog.dispose();
            this.taskDialog = null;
            this.executorManager = null;
        }
    }

    public void showDialog() {
        this.handler.hideProgressBar();
        ScreenToolKit.centerLocateToScreen(this.taskDialog);
        if (ScreenToolKit.getFullScreenFlg()) {
            this.taskDialog.setAlwaysOnTop(true);
        } else {
            this.taskDialog.setAlwaysOnTop(false);
        }
        this.taskDialog.setVisible(true);
    }

    public static void showDialogInFullScreen() {
        ProgressTaskMgr.getInstance().showDialog();
    }

    public void addTask(ITaskInfo iTaskInfo, ITaskDo iTaskDo) {
        this.addTask(iTaskInfo, iTaskDo, null);
    }

    public void addTask(ITaskInfo iTaskInfo, ITaskDo iTaskDo, Action[] actionArray) {
        this.addTask(iTaskInfo, iTaskDo, actionArray, null);
    }

    public void addTask(ITaskInfo iTaskInfo, ITaskDo iTaskDo, Action[] actionArray, String string) {
        if (null == iTaskInfo || null == iTaskDo) {
            logger.trace("The taskInfo and task do  can not be null.");
            return;
        }
        this.taskDialog.addProgressTask(iTaskInfo, iTaskDo, actionArray);
        ProgressTaskWapper progressTaskWapper = new ProgressTaskWapper(iTaskInfo, iTaskDo);
        this.executorManager.addTask(progressTaskWapper, string);
        this.taskList.add(iTaskInfo);
        if (!this.taskDialog.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressTaskMgr.this.showDialog();
                }
            });
        }
    }

    void removeTaskFromList(ITaskInfo iTaskInfo) {
        if (null != iTaskInfo) {
            this.taskList.remove(iTaskInfo);
        }
    }

    public void checkAllTaskDone() {
        boolean bl = true;
        int n = this.taskList.size();
        ITaskInfo iTaskInfo = null;
        for (int i = 0; i < n; ++i) {
            iTaskInfo = this.taskList.get(i);
            if (iTaskInfo.getStatus().equals((Object)ITaskInfo.TaskStatus.Finished) || iTaskInfo.getStatus().equals((Object)ITaskInfo.TaskStatus.Failed) || iTaskInfo.getStatus().equals((Object)ITaskInfo.TaskStatus.Canceled)) continue;
            bl = false;
        }
        if (bl) {
            this.handler.hideProgressBar();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressTaskMgr.this.handler.exitAfterProgressFinish();
                }
            });
            this.taskDialog.getBackgroudButton().setEnabled(false);
        }
    }

    public MultiTaskProgressDialog getMultitaskDialog() {
        return this.taskDialog;
    }

    class ProgressTaskWapper
    implements Runnable {
        private ITaskInfo taskInfo;
        private ITaskDo taskDo;

        ProgressTaskWapper(ITaskInfo iTaskInfo, ITaskDo iTaskDo) {
            this.taskInfo = iTaskInfo;
            this.taskDo = iTaskDo;
        }

        @Override
        public void run() {
            this.taskInfo.setStatus(ITaskInfo.TaskStatus.Running);
            ITaskDo.Result result = null;
            try {
                result = this.taskDo.run();
                this.taskInfo.setCurrentMsg(result.getMessage());
            }
            catch (Exception exception) {
                logger.trace("Error happened in executing the task " + this.taskInfo.getTaskName());
                this.taskInfo.setStatus(ITaskInfo.TaskStatus.Failed);
            }
            if (this.taskInfo.getStatus() == ITaskInfo.TaskStatus.Canceling) {
                this.taskInfo.setStatus(ITaskInfo.TaskStatus.Canceled);
            } else if (this.taskInfo.getStatus() == ITaskInfo.TaskStatus.Failed) {
                this.taskInfo.setStatus(ITaskInfo.TaskStatus.Failed);
            } else if (null != result && result.isSucess()) {
                this.taskInfo.setStatus(ITaskInfo.TaskStatus.Finished);
            } else {
                this.taskInfo.setStatus(ITaskInfo.TaskStatus.Failed);
            }
            ProgressTaskMgr.this.taskDialog.fireTaskFinished(this.taskInfo);
            ProgressTaskMgr.this.checkAllTaskDone();
        }
    }
}

