/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.multitaskdialog;

import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.multitaskdialog.ITaskDo;
import com.swimap.iview.templates.multitaskdialog.ITaskInfo;
import com.swimap.iview.templates.multitaskdialog.ProgressTaskInfo;
import com.swimap.iview.templates.multitaskdialog.ProgressTaskMgr;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class MultiTaskProgressPanel
extends JPanel
implements PropertyChangeListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/MultiTaskProgressPanel/Res");
    private static IviewLogger logger = IviewLogger.getLogger(MultiTaskProgressPanel.class, "IVIEW");
    private static final long serialVersionUID = 1L;
    private JLabel topLabel = null;
    private JProgressBar progressBar = null;
    private JButton buttonRemove = null;
    private JButton buttonCancel = null;
    private JPanel jPanelBottom = null;
    private JLabel bottomLable = null;
    private JPanel customButtonPanel = null;
    private ITaskInfo taskInfo = null;
    private ITaskDo taskDo = null;
    private boolean existCustomDo = false;
    private ActionListener cancelActionListener = null;
    private ActionListener removeActionListener = null;

    MultiTaskProgressPanel(ITaskInfo iTaskInfo, ITaskDo iTaskDo, Action[] actionArray) {
        if (iTaskInfo instanceof ProgressTaskInfo) {
            ProgressTaskInfo progressTaskInfo = (ProgressTaskInfo)iTaskInfo;
            this.progressBar = progressTaskInfo.getProgressbar();
        }
        this.initialize();
        this.setProgressTask(iTaskInfo);
        this.setTaskDo(iTaskDo);
        this.setCustomActions(actionArray);
    }

    private void setProgressTask(ITaskInfo iTaskInfo) {
        if (iTaskInfo == this.taskInfo) {
            return;
        }
        if (iTaskInfo != null) {
            iTaskInfo.removePropertyChangeListener(this);
        }
        this.taskInfo = iTaskInfo;
        if (iTaskInfo != null) {
            this.refreshView();
            iTaskInfo.addPropertyChangeListener(this);
        }
    }

    private void setTaskDo(ITaskDo iTaskDo) {
        this.taskDo = iTaskDo;
    }

    private void setCustomActions(Action[] actionArray) {
        if (actionArray == null || actionArray.length == 0) {
            this.existCustomDo = false;
            return;
        }
        this.existCustomDo = true;
        Dimension dimension = null;
        String string = null;
        this.getCustomButtonPanel().removeAll();
        for (int i = 0; i < actionArray.length; ++i) {
            final Action action = actionArray[i];
            string = action.getValue("Name").toString();
            final JLabel jLabel = new JLabel("<html><u>" + string + "</u></html>");
            jLabel.setPreferredSize(dimension);
            jLabel.setOpaque(false);
            jLabel.setName("MultitaskPanel.custom label" + string);
            jLabel.setFont(jLabel.getFont().deriveFont(12));
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 0, action.getValue("Name").toString());
                    mouseEvent.consume();
                    action.actionPerformed(actionEvent);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                    jLabel.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setFont(jLabel.getFont().deriveFont(0));
                    jLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            this.getCustomButtonPanel().add(jLabel);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 12, 3, 0);
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 12, 6, 0);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(6, 0, 3, 10);
        gridBagConstraints3.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 4, 6, 12);
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints5.gridy = 2;
        this.topLabel = new JLabel();
        this.topLabel.setText("Task Name");
        this.topLabel.setName("Multitaskprogresspanel.topLabel");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topLabel, gridBagConstraints);
        this.add((Component)this.getProgressBar(), gridBagConstraints2);
        this.add((Component)this.getButtonRemove(), gridBagConstraints3);
        this.add((Component)this.getButtonCancel(), gridBagConstraints4);
        this.add((Component)this.getBottomPanel(), gridBagConstraints5);
    }

    private JProgressBar getProgressBar() {
        if (null == this.progressBar) {
            this.progressBar = new JProgressBar(0, 100);
        }
        return this.progressBar;
    }

    private JButton getButtonRemove() {
        if (null == this.buttonRemove) {
            this.buttonRemove = new ToolBarButton();
            ImageIcon imageIcon = new ImageIcon(MultiTaskProgressPanel.class.getResource("cancel.gif"));
            this.buttonRemove.setIcon(imageIcon);
            this.buttonRemove.setName("MultitaskProgressPanel.removebutton");
            this.buttonRemove.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            this.buttonRemove.setOpaque(false);
            this.removeActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiTaskProgressPanel.this.removeFromParent();
                    ProgressTaskMgr.getInstance().getMultitaskDialog().checkClearBtnDisable();
                }
            };
            this.buttonRemove.addActionListener(this.removeActionListener);
        }
        return this.buttonRemove;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new ToolBarButton();
            this.buttonCancel.setName("MultitaskProgressPanel.cancelbutton");
            ImageIcon imageIcon = new ImageIcon(MultiTaskProgressPanel.class.getResource("stop.gif"));
            this.buttonCancel.setIcon(imageIcon);
            this.buttonCancel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            this.buttonCancel.setOpaque(false);
            this.cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultiTaskProgressPanel.this.cancelTask();
                }
            };
            this.buttonCancel.addActionListener(this.cancelActionListener);
        }
        return this.buttonCancel;
    }

    private JPanel getBottomPanel() {
        if (this.jPanelBottom == null) {
            this.bottomLable = new JLabel();
            this.bottomLable.setText("Progress Message");
            this.bottomLable.setName("Multitaskprogresspanel.bottomlabel");
            this.jPanelBottom = new JPanel();
            this.jPanelBottom.setLayout(new BorderLayout());
            this.jPanelBottom.setName("Multitaskprogresspanel.bottompanel");
            this.jPanelBottom.setOpaque(false);
            this.jPanelBottom.setBorder(BorderFactory.createEmptyBorder(0, 12, 4, 0));
            this.jPanelBottom.add((Component)this.bottomLable, "West");
            this.jPanelBottom.add((Component)this.getCustomButtonPanel(), "Center");
        }
        return this.jPanelBottom;
    }

    private JPanel getCustomButtonPanel() {
        if (this.customButtonPanel == null) {
            this.customButtonPanel = new JPanel();
            this.customButtonPanel.setLayout(new FlowLayout(2, 14, 0));
            this.customButtonPanel.setOpaque(false);
            this.customButtonPanel.setName("Multitaskprogresspanel.CustomButtonPanel");
        }
        return this.customButtonPanel;
    }

    private void refreshView() {
        Object object;
        this.getProgressBar().setValue(this.taskInfo.getPrecent());
        String string = this.taskInfo.getCurrentMsg();
        if (null == string) {
            string = "";
        }
        if (null != string && string.length() > 24) {
            object = string;
            string = string.substring(0, 24) + "...";
            this.bottomLable.setToolTipText((String)object);
        }
        this.bottomLable.setText(string);
        object = null;
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (this.taskInfo.getStatus()) {
            case Waiting: {
                string2 = "(" + res.getString("Waiting_Msg") + ")";
                object = new ImageIcon(MultiTaskProgressPanel.class.getResource("waiting.gif"));
                bl2 = true;
                break;
            }
            case Running: {
                bl2 = true;
                bl3 = true;
                break;
            }
            case Finished: {
                bl = true;
                bl4 = true;
                break;
            }
            case Failed: {
                string2 = " (" + res.getString("Failed_Msg") + ")";
                this.topLabel.setForeground(Color.RED);
                this.bottomLable.setForeground(Color.RED);
                bl = true;
                break;
            }
            case Canceling: {
                bl2 = true;
                this.getButtonCancel().setEnabled(false);
                string2 = " (" + res.getString("CanCeling_MSg") + ")";
                break;
            }
            case Canceled: {
                string2 = " (" + res.getString("Canceled_Msg") + ")";
                bl = true;
            }
        }
        String string3 = this.taskInfo.getTaskName();
        if (null == string3) {
            string3 = "";
        }
        if (string3.length() > 24) {
            String string4 = string3;
            string3 = string3.substring(0, 24) + "...";
            this.topLabel.setToolTipText(string4);
        }
        this.topLabel.setText(string3 + string2);
        this.topLabel.setIcon((Icon)object);
        this.getButtonRemove().setVisible(bl);
        this.getButtonCancel().setVisible(bl2);
        this.getProgressBar().setVisible(bl3);
        this.getCustomButtonPanel().setVisible(bl4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ITaskInfo && this.taskInfo == object) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.refreshView();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiTaskProgressPanel.this.refreshView();
                    }
                });
            }
        }
    }

    boolean isRemoveEnabled() {
        return !this.getButtonCancel().isVisible();
    }

    void removeFromParent() {
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        container.remove(this);
        this.buttonRemove.removeActionListener(this.removeActionListener);
        this.buttonCancel.removeActionListener(this.cancelActionListener);
        this.taskInfo.removePropertyChangeListener(this);
        this.customButtonPanel.removeAll();
        this.jPanelBottom.removeAll();
        this.removeAll();
        ProgressTaskMgr progressTaskMgr = ProgressTaskMgr.getInstance();
        progressTaskMgr.removeTaskFromList(this.taskInfo);
        this.progressBar = null;
        this.taskInfo = null;
        if (container instanceof JComponent) {
            ((JComponent)container).revalidate();
        } else {
            container.validate();
        }
    }

    private void cancelTask() {
        this.taskInfo.setStatus(ITaskInfo.TaskStatus.Canceling);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    MultiTaskProgressPanel.this.taskDo.cancel();
                }
                catch (Exception exception) {
                    logger.trace("Exception in caceling task ");
                }
            }
        };
        thread.setName("The taskDo Cancel Thread");
        thread.start();
    }

    JButton cancelRef() {
        return this.getButtonCancel();
    }

    JButton removeRef() {
        return this.getButtonRemove();
    }
}

