/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.multitaskdialog;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.multitaskdialog.ITaskDo;
import com.swimap.iview.templates.multitaskdialog.ITaskFinish;
import com.swimap.iview.templates.multitaskdialog.ITaskInfo;
import com.swimap.iview.templates.multitaskdialog.MultiTaskProgressPanel;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MultiTaskProgressDialog
extends JDialog {
    private static final Color COLOR_ROW0 = new Color(230, 230, 230);
    private JPanel dialogPanel = null;
    private JPanel bottomPanel = null;
    private JScrollPane mainScrollPane = null;
    private JButton clearButton = null;
    private JButton backgroudButton = null;
    private JPanel taskPanel = null;
    private JPanel mainPanel = null;
    private List<ITaskFinish> listnerList = null;
    private static Color eDIT_BACKGROUND = Color.white;
    static final KeyStroke ESCAPE_KEYSTROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/progressdialog/resources/Res");
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiTaskProgressDialog.this.setVisible(false);
        }
    };

    public MultiTaskProgressDialog(Frame frame) {
        super(frame);
        this.setTitle(res.getString("ProgressDailogTitle"));
        this.createDialog();
    }

    public MultiTaskProgressDialog(Frame frame, String string) {
        super(frame, string);
        this.setTitle(string);
        this.createDialog();
    }

    protected void addProgressTask(ITaskInfo iTaskInfo, ITaskDo iTaskDo, Action[] actionArray) {
        MultiTaskProgressPanel multiTaskProgressPanel = new MultiTaskProgressPanel(iTaskInfo, iTaskDo, actionArray);
        this.getTaskPanel().add((Component)multiTaskProgressPanel, 0);
    }

    private void createDialog() {
        this.setSize(500, 375);
        this.setContentPane(this.dialogContentPane());
        this.setModal(true);
        ScreenToolKit.centerLocateToScreen(this);
        this.setResizable(false);
        this.getRootPane().getInputMap().put(ESCAPE_KEYSTROKE, "escapePressed");
        this.getRootPane().getActionMap().put("escapePressed", this.escapeAction);
    }

    private void initActionMap(JComponent jComponent) {
        jComponent.getInputMap(2).put(ESCAPE_KEYSTROKE, "escapePressed");
        jComponent.getActionMap().put("escapePressed", this.escapeAction);
    }

    private JPanel dialogContentPane() {
        if (this.dialogPanel == null) {
            this.dialogPanel = new JPanel();
            this.dialogPanel.setName("MultitaskProgressDailog.contentPanel");
            this.dialogPanel.setLayout(new BorderLayout());
            this.dialogPanel.add((Component)this.getMainScrollPane(), "Center");
            this.dialogPanel.add((Component)this.getBottomPanel(), "South");
        }
        return this.dialogPanel;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            FlowLayout flowLayout = new FlowLayout(2);
            flowLayout.setHgap(6);
            flowLayout.setVgap(12);
            this.bottomPanel = new JPanel();
            this.bottomPanel.setName("MultitaskprogressDailog.bootomPanel");
            this.bottomPanel.setBorder(new EmptyBorder(0, 0, 0, 6));
            this.bottomPanel.setLayout(flowLayout);
            this.bottomPanel.add((Component)this.getClearButton(), null);
            this.bottomPanel.add((Component)this.getBackgroudButton(), null);
        }
        return this.bottomPanel;
    }

    private JScrollPane getMainScrollPane() {
        if (this.mainScrollPane == null) {
            this.mainScrollPane = new JScrollPane(20, 31);
            this.mainScrollPane.setName("multitaskprogressDailog.mainscrollPane");
            Border border = BorderFactory.createEmptyBorder(12, 12, 0, 12);
            Border border2 = this.mainScrollPane.getBorder();
            this.mainScrollPane.setBorder(BorderFactory.createCompoundBorder(border, border2));
            this.mainScrollPane.setViewportView(this.getMainPanel());
        }
        return this.mainScrollPane;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton(res.getString("clearList.text"));
            this.clearButton.setName("MultiTaskProgressDialog.clearListButton");
            this.clearButton.setPreferredSize(new Dimension(110, 21));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    for (Component component : MultiTaskProgressDialog.this.getTaskPanel().getComponents()) {
                        MultiTaskProgressPanel multiTaskProgressPanel;
                        if (!(component instanceof MultiTaskProgressPanel) || !(multiTaskProgressPanel = (MultiTaskProgressPanel)component).isRemoveEnabled()) continue;
                        multiTaskProgressPanel.removeFromParent();
                        bl = true;
                    }
                    if (bl) {
                        MultiTaskProgressDialog.this.mainScrollPane.revalidate();
                        MultiTaskProgressDialog.this.clearButton.setEnabled(false);
                    }
                }
            });
            this.initActionMap(this.clearButton);
            this.clearButton.setEnabled(false);
        }
        return this.clearButton;
    }

    public JButton getBackgroudButton() {
        if (this.backgroudButton == null) {
            this.backgroudButton = new JButton(res.getString("backGroundbutton.text"));
            this.backgroudButton.setName("MultaskProgressDialog.backgroundButton");
            this.backgroudButton.setPreferredSize(new Dimension(110, 21));
            this.backgroudButton.setEnabled(false);
            this.initActionMap(this.backgroudButton);
        }
        return this.backgroudButton;
    }

    private JPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new JPanel();
            this.taskPanel.setLayout(new BoxLayout(this.getTaskPanel(), 1));
            this.taskPanel.setName("MultitaskprogresDilaog.taskPanel");
            this.taskPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    this.resetChildrenBackground();
                }

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    if (!MultiTaskProgressDialog.this.backgroudButton.isEnabled()) {
                        MultiTaskProgressDialog.this.backgroudButton.setEnabled(true);
                    }
                    MultiTaskProgressDialog.this.backgroudButton.requestFocus();
                    this.resetChildrenBackground();
                }

                private void resetChildrenBackground() {
                    int n = MultiTaskProgressDialog.this.getTaskPanel().getComponentCount();
                    Component component = null;
                    Color color = null;
                    for (int i = 0; i < n; ++i) {
                        component = MultiTaskProgressDialog.this.getTaskPanel().getComponent(i);
                        Color color2 = color = i % 2 == 0 ? COLOR_ROW0 : eDIT_BACKGROUND;
                        if (component.getBackground() == color) continue;
                        component.setBackground(color);
                    }
                    if (n == 0) {
                        MultiTaskProgressDialog.this.backgroudButton.setEnabled(false);
                        MultiTaskProgressDialog.this.clearButton.setEnabled(false);
                    }
                }
            });
        }
        return this.taskPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setName("MultitaskProgressDialog.mainpanel");
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getTaskPanel(), "North");
            this.mainPanel.setBackground(eDIT_BACKGROUND);
        }
        return this.mainPanel;
    }

    public void addProgressFinishedListener(ITaskFinish iTaskFinish) {
        this.getTaskPanel().getComponentCount();
        if (null == this.listnerList) {
            this.listnerList = new ArrayList<ITaskFinish>(10);
        }
        this.listnerList.add(iTaskFinish);
    }

    public void removeProgressFinishedListener(ITaskFinish iTaskFinish) {
        if (null != this.listnerList) {
            this.listnerList.remove(iTaskFinish);
        }
    }

    public void fireTaskFinished(ITaskInfo iTaskInfo) {
        if (!this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(true);
        }
        this.clearButton.requestFocus();
        if (null != this.listnerList) {
            for (ITaskFinish iTaskFinish : this.listnerList) {
                iTaskFinish.taskFinished(iTaskInfo);
            }
        }
    }

    public void clearAllTasks() {
        for (Component component : this.getTaskPanel().getComponents()) {
            MultiTaskProgressPanel multiTaskProgressPanel;
            if (!(component instanceof MultiTaskProgressPanel) || !(multiTaskProgressPanel = (MultiTaskProgressPanel)component).cancelRef().isVisible()) continue;
            multiTaskProgressPanel.cancelRef().doClick();
        }
    }

    protected void checkClearBtnDisable() {
        boolean bl = true;
        for (Component component : this.getTaskPanel().getComponents()) {
            MultiTaskProgressPanel multiTaskProgressPanel;
            if (!(component instanceof MultiTaskProgressPanel) || !(multiTaskProgressPanel = (MultiTaskProgressPanel)component).removeRef().isVisible()) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.clearButton.setEnabled(false);
        }
    }
}

