/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.multitaskdialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorManager {
    protected ExecutorService threadPool;
    protected Map<String, List<RunnableWrapper>> waitingListByKey;

    public ExecutorManager(int n) {
        this.threadPool = Executors.newFixedThreadPool(n);
        this.waitingListByKey = new HashMap<String, List<RunnableWrapper>>(10);
    }

    public void dispose() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
            this.threadPool = null;
        }
    }

    public void addTask(Runnable runnable) {
        this.addTask(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable runnable, String string) {
        if (string == null) {
            this.threadPool.submit(runnable);
            return;
        }
        Map<String, List<RunnableWrapper>> map = this.waitingListByKey;
        synchronized (map) {
            List<RunnableWrapper> list = this.waitingListByKey.get(string);
            RunnableWrapper runnableWrapper = new RunnableWrapper(runnable, string);
            if (list == null) {
                list = new ArrayList<RunnableWrapper>(10);
                list.add(runnableWrapper);
                this.waitingListByKey.put(string, list);
                this.threadPool.submit(runnableWrapper);
            } else {
                list.add(runnableWrapper);
            }
        }
    }

    private class RunnableWrapper
    implements Runnable {
        private Runnable task;
        private String key;

        RunnableWrapper(Runnable runnable, String string) {
            this.task = runnable;
            this.key = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.task.run();
            }
            finally {
                Map<String, List<RunnableWrapper>> map = ExecutorManager.this.waitingListByKey;
                synchronized (map) {
                    List<RunnableWrapper> list = ExecutorManager.this.waitingListByKey.get(this.key);
                    list.remove(this);
                    if (list.size() == 0) {
                        ExecutorManager.this.waitingListByKey.remove(this.key);
                    } else {
                        ExecutorManager.this.threadPool.submit(list.get(0));
                    }
                }
            }
        }
    }
}

