/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertreetable;

import com.swimap.iview.framework.lookandfeel.SwimapTableUI;
import com.swimap.iview.templates.beans.SortableTableHeaderRenderer;
import com.swimap.iview.templates.filtertreetable.EmptyTreeTableModel;
import com.swimap.iview.templates.filtertreetable.FilterTreeTable;
import com.swimap.iview.templates.filtertreetable.TreeIconRenderer;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.templates.filtertreetable.TreeTableModelAdapter;
import com.swimap.iview.templates.treepropertyform.NewTreeColumnRenderer;
import com.swimap.iview.util.Parameter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTableView
extends FilterTreeTable {
    private static IviewLogger logger = IviewLogger.getLogger(TreeTableView.class, "IVIEW");
    private int view = 0;
    public static final int TREE = 0;
    public static final int TABLE = 1;
    private boolean isSortable = false;
    private boolean showRootHandle = true;
    protected TreeIconRenderer iconRenderer = null;
    private TableCellRenderer treeRenderer = null;
    private static final int SWITCHICON_WIDTH = 19;
    private Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
    private DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = object;
            if (object instanceof TreePath) {
                object2 = ((TreePath)object).getLastPathComponent();
            }
            Component component = super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
            return component;
        }
    };

    public TreeTableView() {
        this(new EmptyTreeTableModel());
    }

    public TreeTableView(TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.setView(0);
        this.setRootVisible(false);
        this.initDefaultRenders();
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseListener(this.createTableHeaderMouseListener());
    }

    private void initDefaultRenders() {
        this.treeRenderer = new TreeColumnRender(this, (TreeTableModel)super.getTreeModel());
        this.setDefaultRenderer(Parameter.class, this.treeRenderer);
    }

    protected MouseAdapter createTableHeaderMouseListener() {
        return new TreeTableViewHeaderMouseAdapter(this);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            int n;
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (n = tableColumnModel.getColumnCount(); n > 0; --n) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            n = tableModel.getColumnCount();
            TableColumn tableColumn = null;
            SwitchIconRender switchIconRender = null;
            for (int i = 0; i < n; ++i) {
                tableColumn = new TableColumn(i);
                this.addColumn(tableColumn);
                switchIconRender = new SwitchIconRender();
                tableColumn.setHeaderRenderer(switchIconRender);
            }
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = null;
        if (this.isTreeColumn(n2)) {
            if (this.getView() == 0) {
                Class<?> clazz = this.getColumnClass(n2);
                tableCellRenderer = this.getDefaultRenderer(clazz);
            } else {
                tableCellRenderer = this.tableRenderer;
            }
        } else {
            tableCellRenderer = super.getCellRenderer(n, n2);
        }
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = null;
        tableCellEditor = this.getView() == 0 && this.isTreeColumn(n2) ? this.getDefaultEditor(TreePath.class) : super.getCellEditor(n, n2);
        return tableCellEditor;
    }

    private boolean isTreeColumn(int n) {
        return n == 0;
    }

    private boolean isPointOverSwitch(Point point) {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        boolean bl = enumeration.hasMoreElements();
        TableColumn tableColumn = null;
        int n2 = 0;
        while (bl) {
            tableColumn = enumeration.nextElement();
            n2 = tableColumn.getWidth();
            if (n + n2 > point.x) {
                return point.x - n <= 19 && tableColumn.getHeaderRenderer() instanceof SwitchIconRender;
            }
            n += n2;
        }
        return false;
    }

    public void setTreeIconRenderer(TreeIconRenderer treeIconRenderer) {
        this.iconRenderer = treeIconRenderer;
    }

    public TreeIconRenderer getTreeIconRender() {
        return this.iconRenderer;
    }

    public void setSortable(boolean bl) {
        this.isSortable = bl;
        int n = this.getModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.setColumnSortable(i, bl);
        }
    }

    @Override
    public void setColumnSortable(int n, boolean bl) {
        logger.debug("For column " + n + " has sorting set to " + bl);
        super.setColumnSortable(n, bl);
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setHeaderRenderer(new SwitchIconRender());
        this.getTableHeader().repaint();
    }

    private void stopCellEditing() {
        if (!this.isEditing()) {
            return;
        }
        int n = this.getEditingRow();
        int n2 = this.getEditingColumn();
        this.getCellEditor(n, n2).stopCellEditing();
    }

    private void toggleState(int n) {
        this.stopCellEditing();
        if (this.getTree().isExpanded(this.getPathForRow(n))) {
            this.getTree().collapseRow(n);
        } else {
            this.getTree().expandRow(n);
        }
    }

    public int getNodeIndent(TreePath treePath) {
        int n = treePath.getPath().length;
        if (!this.isRootVisible()) {
            --n;
        }
        if (!this.getShowsRootHandles()) {
            --n;
        }
        return n * this.getLevelIndent();
    }

    public int getLevelIndent() {
        int n = (Integer)UIManager.get("Tree.leftChildIndent");
        int n2 = (Integer)UIManager.get("Tree.rightChildIndent");
        return n + n2;
    }

    public void setView(int n) {
        if (n != 0 && n != 1) {
            logger.trace("View Can be 0 or 1");
        }
        if (this.view != n) {
            if (n == 1) {
                this.saveExpandedState();
                this.expandAllNodes();
            } else {
                this.collapseAllNodes();
                this.restoreExpandedState();
            }
            this.view = n;
        }
        this.stopCellEditing();
        this.getTableHeader().repaint();
        this.repaint();
    }

    @Override
    protected void initListeners() {
    }

    @Override
    public void updateUI() {
        this.setUI(new TreeTableUI());
    }

    private boolean processClickInTreeColumn(MouseEvent mouseEvent, int n, int n2, Point point, int n3, TreeTableView treeTableView) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        if (treeTableView.getView() != 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        TreePath treePath = ((TreeTableModelAdapter)treeTableView.getModel()).treePathForRow(n);
        Object object = treePath.getLastPathComponent();
        if (object != null && treeTableView.getTreeModel().isLeaf(object)) {
            return false;
        }
        int n4 = treePath.getPathCount();
        boolean bl = false;
        bl = this.isPointInControlBox(point, n, n2, n3, n4, treeTableView);
        if (bl) {
            treeTableView.toggleState(n);
            mouseEvent.consume();
        } else if (mouseEvent.getClickCount() == 2) {
            treeTableView.toggleState(n);
            mouseEvent.consume();
        } else {
            return false;
        }
        return true;
    }

    private boolean isPointInControlBox(Point point, int n, int n2, int n3, int n4, TreeTableView treeTableView) {
        --n4;
        if (!treeTableView.getShowsRootHandles()) {
            --n4;
        }
        if (!treeTableView.isRootVisible()) {
            --n4;
        }
        int n5 = treeTableView.getLevelIndent();
        int n6 = n3 / 2 - this.expandedIcon.getIconHeight() / 2;
        int n7 = n5 / 2 + n4 * n5 - this.expandedIcon.getIconWidth() / 2;
        if (treeTableView instanceof TreeTableView) {
            if (n2 != 0) {
                return false;
            }
            point.y -= n * treeTableView.getRowHeight();
        }
        boolean bl = point.x >= n7 && point.x < n7 + this.expandedIcon.getIconWidth();
        boolean bl2 = point.y >= n6 && point.y < n6 + this.expandedIcon.getIconHeight();
        return bl && bl2;
    }

    public int getView() {
        return this.view;
    }

    protected TreePath getPathForRow(int n) {
        return ((TreeTableModelAdapter)super.getModel()).treePathForRow(n);
    }

    protected int getRowForpath(TreePath treePath) {
        return ((TreeTableModelAdapter)super.getModel()).getRowForpath(treePath);
    }

    protected TreeModel getTreeTableModel() {
        return super.getTreeModel();
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        super.setModel(treeTableModel);
        if (this.treeRenderer != null) {
            ((TreeColumnRender)this.treeRenderer).setModel(treeTableModel);
        }
    }

    public void setShowsRootHandles(boolean bl) {
        this.showRootHandle = bl;
    }

    public boolean getShowsRootHandles() {
        return this.showRootHandle;
    }

    public boolean isExpanded(int n) {
        return super.getTree().isExpanded(n);
    }

    class TreeTableViewHeaderMouseAdapter
    extends MouseAdapter {
        private final TreeTableView table;

        TreeTableViewHeaderMouseAdapter(TreeTableView treeTableView2) {
            this.table = treeTableView2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && !mouseEvent.isPopupTrigger()) {
                int n = TreeTableView.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                if (this.table.isPointOverSwitch(mouseEvent.getPoint())) {
                    if (this.table.getView() == 0) {
                        this.table.setView(1);
                    } else {
                        this.table.setView(0);
                    }
                } else if (this.table.isSortable) {
                    this.table.sort(n);
                }
            }
        }
    }

    class TreeColumnRender
    extends NewTreeColumnRenderer {
        public TreeColumnRender(FilterTreeTable filterTreeTable, TreeTableModel treeTableModel) {
            super(filterTreeTable, treeTableModel);
        }

        void setModel(TreeTableModel treeTableModel) {
            this.tableModel = treeTableModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return component;
        }
    }

    private static class SwitchIconRender
    extends SortableTableHeaderRenderer {
        private JLabel iconLabel = new JLabel();
        private JPanel topPanel = new JPanel(new BorderLayout());
        private JLabel swicthLabel = new JLabel();
        private static final ImageIcon TREE_ICON = new ImageIcon(TreeTableView.class.getResource("tree_icon.png"));
        private static final ImageIcon TABLE_ICON = new ImageIcon(TreeTableView.class.getResource("table_icon.png"));

        SwitchIconRender() {
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.iconLabel.setHorizontalTextPosition(2);
            this.iconLabel.setName("TreePropertyTableHeaderRenderer_iconLabel");
            this.swicthLabel.setPreferredSize(new Dimension(TREE_ICON.getIconWidth(), TREE_ICON.getIconHeight() + 2));
            this.swicthLabel.setMinimumSize(new Dimension(TREE_ICON.getIconWidth(), TREE_ICON.getIconHeight() + 10));
            LookAndFeel.installBorder(this.topPanel, "TableHeader.cellBorder");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (!((TreeTableView)jTable).isSortable) {
                this.topPanel.removeAll();
                this.iconLabel.setText(object.toString());
                this.topPanel.add((Component)this.iconLabel, "Center");
                Insets insets = this.topPanel.getInsets();
                insets.top = 1;
                insets.bottom = 0;
            } else {
                this.topPanel = (JPanel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (((TreeTableView)jTable).getView() == 0) {
                this.swicthLabel.setIcon(TREE_ICON);
            } else {
                this.swicthLabel.setIcon(TABLE_ICON);
            }
            if (n == -1 && n2 == 0) {
                this.topPanel.add((Component)this.swicthLabel, "West");
            }
            return this.topPanel;
        }
    }

    protected class TreeTableUI
    extends SwimapTableUI {
        protected TreeTableUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        protected class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            protected boolean clickHandle;

            protected TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
                this.clickHandle = false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                Point point = mouseEvent.getPoint();
                int n2 = TreeTableUI.this.table.rowAtPoint(point);
                if (!TreeTableView.this.processClickInTreeColumn(mouseEvent, n2, n = TreeTableUI.this.table.columnAtPoint(point), point, TreeTableUI.this.table.getRowHeight(), (TreeTableView)TreeTableUI.this.table)) {
                    this.clickHandle = false;
                    super.mousePressed(mouseEvent);
                } else {
                    this.clickHandle = true;
                    TreeTableUI.this.table.removeEditor();
                }
            }
        }
    }
}

