/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertreetable;

import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.Parameter;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private TreeTableModel treeTableModel;
    private JTree tree;
    private TreeExpansionListener expansionListener = null;
    private TreeModelListener modelListener = null;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        this.treeTableModel = treeTableModel;
        this.tree = jTree;
        this.addListeners();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.getColumnClass(n2).equals(TreeTableModel.class)) {
            return this.nodeForRow(n);
        }
        if (this.getColumnClass(n2).equals(Parameter.class)) {
            return this.treePathForRow(n);
        }
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    protected Object nodeForRow(int n) {
        return this.tree.getPathForRow(n).getLastPathComponent();
    }

    public TreePath treePathForRow(int n) {
        return this.tree.getPathForRow(n);
    }

    public int getRowForpath(TreePath treePath) {
        return this.tree.getRowForPath(treePath);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    private void addListeners() {
        this.treeTableModel.addTreeModelListener(this.getTreeModelListener());
        this.tree.addTreeExpansionListener(this.getTreeExpansionListener());
    }

    void removeListeners() {
        this.tree.removeTreeExpansionListener(this.getTreeExpansionListener());
        this.treeTableModel.removeTreeModelListener(this.getTreeModelListener());
    }

    private TreeExpansionListener getTreeExpansionListener() {
        if (this.expansionListener == null) {
            this.expansionListener = new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            };
        }
        return this.expansionListener;
    }

    private TreeModelListener getTreeModelListener() {
        if (null == this.modelListener) {
            this.modelListener = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            };
        }
        return this.modelListener;
    }
}

