/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertreetable;

import com.swimap.iview.templates.beans.SortableTableHeaderRenderer;
import com.swimap.iview.templates.beans.TableColumnSortable;
import com.swimap.iview.templates.filtertree.FilterTreeTemplate;
import com.swimap.iview.templates.filtertree.NodeCheckChangeEvent;
import com.swimap.iview.templates.filtertree.NodeCheckChangeListener;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.templates.filtertreetable.TreeTableModelAdapter;
import com.swimap.iview.templates.filtertreetable.TreeTableView;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterTreeTable
extends JTable
implements TableColumnSortable {
    private static IviewLogger logger = IviewLogger.getLogger(FilterTreeTable.class, "IVIEW");
    public static final int ASCENDING_SORT = 1;
    public static final int DESCENDING_SORT = -1;
    public static final int NONE_SORT = 0;
    protected TreeTableCellRenderer rendererTree = null;
    protected TreeTableSelectionModel selectionModel = null;
    private TreeTableModel treeTableModel = null;
    private List expandedPaths = null;
    private TreePath[] selectionPaths;
    private int sortStatus = 0;
    private int sortedColumn = 0;
    private int clickCount = 1;
    private TreeTableModelAdapter treeTableModelAdapter = null;

    public FilterTreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
        super.setRowHeight(this.rendererTree.getRowHeight());
        this.selectionModel = new TreeTableSelectionModel();
        this.rendererTree.setSelectionModel(this.selectionModel);
        this.setSelectionModel(this.selectionModel.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.rendererTree);
        this.setDefaultRenderer(Object.class, new FocusLessCellRenderer());
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setSelectionMode(0);
        this.rendererTree.getSelectionModel().setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.setColumnSortable(i, treeTableModel.isColumnSortable(i));
        }
        this.initListeners();
    }

    protected void setModel(TreeTableModel treeTableModel) {
        this.initTree(treeTableModel);
        if (null != this.treeTableModelAdapter) {
            this.treeTableModelAdapter.removeListeners();
        }
        this.treeTableModelAdapter = new TreeTableModelAdapter(treeTableModel, this.rendererTree);
        super.setModel(this.treeTableModelAdapter);
        this.treeTableModel = treeTableModel;
    }

    protected void initTree(TreeTableModel treeTableModel) {
        if (null == this.rendererTree) {
            this.rendererTree = new TreeTableCellRenderer(treeTableModel);
        }
        this.rendererTree.setModel(treeTableModel);
    }

    protected void initListeners() {
        final ActionListener actionListener = this.rendererTree.getActionForKeyStroke(KeyStroke.getKeyStroke(37, 0));
        final ActionListener actionListener2 = this.rendererTree.getActionForKeyStroke(KeyStroke.getKeyStroke(39, 0));
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "none");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "none");
        Object object = inputMap.get(KeyStroke.getKeyStroke("pressed ENTER"));
        inputMap.put(KeyStroke.getKeyStroke("pressed TAB"), object);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 37 && keyEvent.getModifiers() == 0) {
                    ActionEvent actionEvent = new ActionEvent(FilterTreeTable.this.rendererTree, 1001, "");
                    actionListener.actionPerformed(actionEvent);
                } else if (keyEvent.getKeyCode() == 39) {
                    ActionEvent actionEvent = new ActionEvent(FilterTreeTable.this.rendererTree, 1001, "");
                    actionListener2.actionPerformed(actionEvent);
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && FilterTreeTable.this.getResizingColumn(mouseEvent) == null && mouseEvent.getClickCount() == FilterTreeTable.this.clickCount) {
                    FilterTreeTable.this.columnSelected(mouseEvent);
                }
            }
        });
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        if (!bl) {
            return;
        }
        if (null == this.rendererTree) {
            return;
        }
        if (bl) {
            super.setRowSelectionAllowed(true);
            this.rendererTree.setSelectionModel(this.selectionModel);
            this.setSelectionModel(this.selectionModel.getListSelectionModel());
        } else {
            super.setRowSelectionAllowed(false);
            this.rendererTree.setSelectionModel(null);
        }
    }

    public void setColumnSortable(int n, boolean bl) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        if (null == tableColumn) {
            logger.debug("The given index does not map to a valid column: " + n);
            return;
        }
        if (bl) {
            tableColumn.setHeaderRenderer(new SortableTableHeaderRenderer());
        } else {
            tableColumn.setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
        }
        logger.debug("For column " + n + " has sorting set to " + bl);
        this.getTableHeader().repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (null != this.rendererTree) {
            this.rendererTree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setRowHeightExternally(int n) {
        super.setRowHeight(n);
    }

    @Override
    public void setRowHeight(int n) {
    }

    protected JTree getTree() {
        return this.rendererTree;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.getColumnClass(n2) == TreeTableModel.class) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        return bl;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this.rendererTree.dispatchEvent(keyEvent);
    }

    private TableColumn getResizingColumn(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            throw new IllegalArgumentException("e is null.");
        }
        Point point = mouseEvent.getPoint();
        int n = this.getTableHeader().columnAtPoint(point);
        if (n == -1) {
            return null;
        }
        JTableHeader jTableHeader = this.getTableHeader();
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = 0;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n3 = point.x < n2 ? n - 1 : n;
        } else {
            int n4 = n3 = point.x < n2 ? n : n - 1;
        }
        if (n3 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n3);
    }

    private void columnSelected(MouseEvent mouseEvent) {
        int n = this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 < 0) {
            logger.trace("FilterTreeTable columnSelected column index < 0" + String.valueOf(n));
            return;
        }
        if (!this.treeTableModel.isColumnSortable(n2)) {
            return;
        }
        this.sort(n);
    }

    protected void sort(int n) {
        if (this.sortedColumn == n) {
            if (this.sortStatus == 1) {
                this.sortStatus = -1;
            } else if (this.sortStatus == -1) {
                this.sortStatus = 1;
            } else if (this.sortStatus == 0) {
                this.sortStatus = 1;
            }
        } else {
            this.sortedColumn = n;
            this.sortStatus = 1;
        }
        this.saveSelection();
        this.saveExpandedState();
        this.treeTableModel.setColumnSorted(n, this.sortStatus == 1);
        this.restoreExpandedState();
        this.restoreSelections();
        this.getTableHeader().repaint();
    }

    @Override
    public int getColumnState(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        if (n2 == this.sortedColumn) {
            return this.sortStatus;
        }
        return 0;
    }

    public void setSortingColumn(int n, boolean bl) {
        this.sortedColumn = n;
        this.sortStatus = bl ? 1 : -1;
        this.saveSelection();
        this.saveExpandedState();
        this.treeTableModel.setColumnSorted(n, bl);
        this.restoreExpandedState();
        this.restoreSelections();
        this.getTableHeader().repaint();
    }

    public int getSortingColumn() {
        return this.sortedColumn;
    }

    @Override
    public boolean isColumnSortable(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        return this.treeTableModel.isColumnSortable(n2);
    }

    public void setSortableClickCount(int n) {
        this.clickCount = n;
        logger.debug("The sort click count is set to " + n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (null == this.rendererTree) {
            return;
        }
        TreePath[] treePathArray = this.rendererTree.getSelectionModel().getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            n = this.rendererTree.getRowForPath(treePathArray[i]);
            this.getSelectionModel().addSelectionInterval(n, n);
        }
        this.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
    }

    public void setRootVisible(boolean bl) {
        if (null != this.rendererTree) {
            this.rendererTree.setRootVisible(bl);
            this.repaint();
        }
    }

    public boolean isRootVisible() {
        if (null != this.rendererTree) {
            return this.rendererTree.isRootVisible();
        }
        return false;
    }

    public TreeModel getTreeModel() {
        return this.rendererTree.getModel();
    }

    public void refreshDown(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (null == defaultMutableTreeNode) {
            throw new IllegalArgumentException("node cannot be null");
        }
        FilterTreeTemplate.refreshDown(defaultMutableTreeNode, n, n2);
        this.repaint();
    }

    public void refreshUp(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (null == defaultMutableTreeNode) {
            throw new IllegalArgumentException("node cannot be null");
        }
        FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
        this.repaint();
    }

    public void addNodeCheckChangeListener(NodeCheckChangeListener nodeCheckChangeListener) {
        this.rendererTree.addNodeCheckChangeListener(nodeCheckChangeListener);
    }

    public void removeNodeCheckChangeListener(NodeCheckChangeListener nodeCheckChangeListener) {
        this.rendererTree.removeNodeCheckChangeListener(nodeCheckChangeListener);
    }

    public void expandPath(TreePath treePath) {
        this.rendererTree.expandPath(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.rendererTree.collapsePath(treePath);
    }

    public void expandAllNodes() {
        this.rendererTree.expandAllNodes();
    }

    public void collapseAllNodes() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.rendererTree.collapseRow(i);
        }
    }

    private void expandCollapseAll(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandCollapseAll(treePath2, bl);
            }
        }
        if (bl) {
            this.rendererTree.expandPath(treePath);
        } else {
            this.rendererTree.collapsePath(treePath);
        }
    }

    protected void saveExpandedState() {
        this.expandedPaths = new ArrayList();
        TreePath treePath = new TreePath(this.treeTableModel.getRoot());
        Enumeration<TreePath> enumeration = this.rendererTree.getExpandedDescendants(treePath);
        while (enumeration != null && enumeration.hasMoreElements()) {
            this.expandedPaths.add(enumeration.nextElement());
        }
    }

    protected void restoreExpandedState() {
        TreePath treePath2 = null;
        for (TreePath treePath2 : this.expandedPaths) {
            this.rendererTree.expandPath(treePath2);
        }
    }

    protected void saveSelection() {
        this.selectionPaths = this.rendererTree.getSelectionPaths();
    }

    protected void restoreSelections() {
        this.rendererTree.setSelectionPaths(this.selectionPaths);
    }

    class TreeTableSelectionModel
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public TreeTableSelectionModel() {
            ListSelectionListener listSelectionListener = this.createListSelectionListener();
            this.getListSelectionModel().addListSelectionListener(listSelectionListener);
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (this.updatingListSelectionModel) {
                return;
            }
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TreeTableSelectionModel.this.updateSelectedPathsFromSelectedRows();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (this.updatingListSelectionModel) {
                return;
            }
            this.updatingListSelectionModel = true;
            try {
                if (!(FilterTreeTable.this instanceof TreeTableView) && this.listSelectionModel.isSelectionEmpty()) {
                    super.resetRowSelection();
                } else {
                    if (!FilterTreeTable.this.getRowSelectionAllowed()) {
                        return;
                    }
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                    for (int i = n; i <= n2; ++i) {
                        TreePath treePath;
                        if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = FilterTreeTable.this.rendererTree.getPathForRow(i)) == null) continue;
                        arrayList.add(treePath);
                    }
                    this.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                    this.leadRow = this.leadIndex;
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    protected class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableEditorField());
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (null == eventObject || !(eventObject instanceof MouseEvent)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
                for (int i = FilterTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (TreeTableModel.class != FilterTreeTable.this.getColumnClass(i)) continue;
                    SwingUtilities.convertMouseEvent(FilterTreeTable.this, mouseEvent, FilterTreeTable.this.rendererTree);
                    MouseEvent mouseEvent2 = new MouseEvent(FilterTreeTable.this.rendererTree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - FilterTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    FilterTreeTable.this.rendererTree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            if (mouseEvent.getClickCount() >= 2) {
                return false;
            }
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            JTree jTree = FilterTreeTable.this.getTree();
            int n3 = jTree.isRootVisible() ? n : n - 1;
            int n4 = jTree.getRowBounds((int)n3).x;
            TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                Object object2 = jTree.getPathForRow(n3).getLastPathComponent();
                Icon icon = null;
                icon = jTree.getModel().isLeaf(object2) ? ((DefaultTreeCellRenderer)treeCellRenderer).getLeafIcon() : (FilterTreeTable.this.rendererTree.isExpanded(n3) ? ((DefaultTreeCellRenderer)treeCellRenderer).getOpenIcon() : ((DefaultTreeCellRenderer)treeCellRenderer).getClosedIcon());
                if (null != icon) {
                    n4 += ((DefaultTreeCellRenderer)treeCellRenderer).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableEditorField)this.getComponent()).offset = n4;
            return component;
        }
    }

    static class TreeTableEditorField
    extends JTextField {
        int offset = 0;

        TreeTableEditorField() {
        }

        @Override
        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, this.offset);
            super.reshape(n5, n2, n3 - (n5 - n), n4);
        }
    }

    public class FocusLessCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    protected class TreeTableCellRenderer
    extends FilterTreeTemplate
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super.setModel(treeModel);
            super.putClientProperty("JTree.lineStyle", "None");
            super.addNodeCheckChangeListener(new NodeCheckChangeListener(){

                @Override
                public void nodeCheckChanged(NodeCheckChangeEvent nodeCheckChangeEvent) {
                    FilterTreeTable.this.repaint();
                }
            });
            super.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("rowHeight".equals(propertyChangeEvent.getPropertyName())) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        FilterTreeTable.this.setRowHeight(n);
                    }
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (!(treeCellRenderer instanceof DefaultTreeCellRenderer)) {
                return;
            }
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }

        @Override
        public void setRowHeight(int n) {
            if (n <= 0) {
                return;
            }
            super.setRowHeight(n);
            if (FilterTreeTable.this != null && FilterTreeTable.this.getRowHeight() != n) {
                FilterTreeTable.this.setRowHeight(this.getRowHeight());
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, FilterTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle = FilterTreeTable.this.getCellRect(this.visibleRow, 0, false);
            graphics.translate(0, -rectangle.y);
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, rectangle.y, this.getWidth(), rectangle.height);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = null;
            Color color2 = null;
            if (bl && jTable.getRowSelectionAllowed()) {
                color = jTable.getSelectionBackground();
                color2 = jTable.getSelectionForeground();
            } else {
                color = jTable.getBackground();
                color2 = jTable.getForeground();
            }
            bl2 = false;
            this.highlightBorder = null;
            if (bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            } else if (FilterTreeTable.this.realEditingRow() == n && FilterTreeTable.this.getEditingColumn() == n2) {
                color = UIManager.getColor("Table.focusCellBackground");
                color2 = UIManager.getColor("Table.focusCellForeground");
            }
            this.visibleRow = n;
            this.setBackground(color);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (bl) {
                    defaultTreeCellRenderer.setTextSelectionColor(color2);
                    defaultTreeCellRenderer.setBackgroundSelectionColor(color);
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(color2);
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(color);
                }
            }
            return this;
        }
    }
}

