/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertree;

import com.swimap.iview.templates.filtertree.FilterTreeCell;
import com.swimap.iview.templates.filtertree.FilterTreeCellRenderer;
import com.swimap.iview.templates.filtertree.FilterTreeEventHandler;
import com.swimap.iview.templates.filtertree.NodeCheckChangeEvent;
import com.swimap.iview.templates.filtertree.NodeCheckChangeListener;
import com.swimap.iview.templates.tree.ITreeStyleInterface;
import com.swimap.iview.templates.tree.TreeTemplate;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterTreeTemplate
extends TreeTemplate {
    protected String keyString = "SPACE";
    protected String actionMapKey = "SPACE";
    private boolean multiSelectable = true;
    public static final int RADIO_SELECT_NONE = 0;
    public static final int RADIO_SELECT_FIRST = 1;
    public static final int RADIO_SELECT_LAST = -1;
    public static final int NOTIFY_PARENT_NODE = 0;
    public static final int NOTIFY_SUPERIOR_NODE = 1;
    protected FilterTreeCellRenderer cellRenderer = new FilterTreeCellRenderer();
    private static final int DEFAULT_ROW_HIGHT = 20;
    private boolean linkageFlag = false;
    private int notifyPolicy = 0;
    protected AbstractAction action = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };

    public FilterTreeTemplate(ITreeStyleInterface iTreeStyleInterface) throws Exception {
        super(iTreeStyleInterface);
        this.setTreeEventHandler(new FilterTreeEventHandler(this));
        this.setCellRenderer(this.cellRenderer);
        this.setShowsRootHandles(true);
        this.setRowHeight(20);
        this.setKeyDefaultAction(KeyStroke.getKeyStroke(this.keyString), this.actionMapKey, this.action);
    }

    public FilterTreeTemplate() {
        this.setTreeEventHandler(new FilterTreeEventHandler(this));
        this.setCellRenderer(this.cellRenderer);
        this.setShowsRootHandles(true);
        this.setRowHeight(20);
        this.setKeyDefaultAction(KeyStroke.getKeyStroke(this.keyString), this.actionMapKey, this.action);
    }

    public static void refreshDown(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        FilterTreeTemplate.refreshDown(defaultMutableTreeNode, n, 1);
    }

    public static void refreshDown(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (n == 2) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FilterTreeCell) {
            FilterTreeCell filterTreeCell = (FilterTreeCell)object;
            int n3 = defaultMutableTreeNode.getChildCount();
            if (filterTreeCell.isRadio() && n3 >= 2 && n == 1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                switch (n2) {
                    case -1: {
                        boolean bl = false;
                        for (int i = n3 - 1; i >= 0; --i) {
                            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                            if (defaultMutableTreeNode2 != null && !bl && !((FilterTreeCell)defaultMutableTreeNode2.getUserObject()).isHideCheckbox()) {
                                FilterTreeTemplate.refreshDown(defaultMutableTreeNode2, n, n2);
                                bl = true;
                                continue;
                            }
                            FilterTreeTemplate.refreshDown(defaultMutableTreeNode2, 0, n2);
                        }
                        filterTreeCell.changeState(2);
                        FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
                        break;
                    }
                    case 0: {
                        for (int i = 0; i < n3; ++i) {
                            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                            if (defaultMutableTreeNode2 == null) continue;
                            FilterTreeTemplate.refreshDown(defaultMutableTreeNode2, 0, n2);
                        }
                        filterTreeCell.changeState(0);
                        FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
                        break;
                    }
                    default: {
                        boolean bl = false;
                        for (int i = 0; i < n3; ++i) {
                            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                            if (defaultMutableTreeNode2 != null && !bl && !((FilterTreeCell)defaultMutableTreeNode2.getUserObject()).isHideCheckbox()) {
                                FilterTreeTemplate.refreshDown(defaultMutableTreeNode2, n, n2);
                                bl = true;
                                continue;
                            }
                            FilterTreeTemplate.refreshDown(defaultMutableTreeNode2, 0, n2);
                        }
                        filterTreeCell.changeState(2);
                        FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
                        break;
                    }
                }
            } else {
                filterTreeCell.changeState(n);
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                for (int i = 0; i < n3; ++i) {
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    if (defaultMutableTreeNode3 == null) continue;
                    FilterTreeTemplate.refreshDown(defaultMutableTreeNode3, n, n2);
                }
            }
        }
    }

    public static void refreshUp(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 != null && (object = defaultMutableTreeNode2.getUserObject()) instanceof FilterTreeCell) {
            FilterTreeCell filterTreeCell = (FilterTreeCell)object;
            int n = defaultMutableTreeNode2.getChildCount();
            if (filterTreeCell.isRadio() && (((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getState() == 1 || ((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getState() == 2)) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                    if (defaultMutableTreeNode3 == defaultMutableTreeNode || defaultMutableTreeNode3 == null || !((object2 = defaultMutableTreeNode3.getUserObject()) instanceof FilterTreeCell)) continue;
                    FilterTreeTemplate.refreshDown(defaultMutableTreeNode3, 0);
                }
            }
            int n2 = -1;
            DefaultMutableTreeNode defaultMutableTreeNode4 = null;
            for (int i = 0; i < n; ++i) {
                Object object3;
                defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                int n3 = -1;
                if (defaultMutableTreeNode4 != null && (object3 = defaultMutableTreeNode4.getUserObject()) instanceof FilterTreeCell) {
                    FilterTreeCell filterTreeCell2 = (FilterTreeCell)object3;
                    n3 = filterTreeCell2.getState();
                }
                if (n3 == -1) break;
                if (n2 == -1) {
                    n2 = n3;
                    continue;
                }
                if (2 != n3 && n2 == n3) continue;
                n2 = 2;
                break;
            }
            if (n2 != -1) {
                filterTreeCell.changeState(n2);
            }
            FilterTreeTemplate.refreshUp(defaultMutableTreeNode2);
        }
    }

    public void addNodeCheckChangeListener(NodeCheckChangeListener nodeCheckChangeListener) {
        this.listenerList.add(NodeCheckChangeListener.class, nodeCheckChangeListener);
    }

    public void removeNodeCheckChangeListener(NodeCheckChangeListener nodeCheckChangeListener) {
        this.listenerList.remove(NodeCheckChangeListener.class, nodeCheckChangeListener);
    }

    public void fireNodeCheckChanged(TreePath treePath, FilterTreeCell filterTreeCell, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        NodeCheckChangeEvent nodeCheckChangeEvent = null;
        nodeCheckChangeEvent = new NodeCheckChangeEvent(this, treePath, filterTreeCell, n, n2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeCheckChangeListener.class) continue;
            ((NodeCheckChangeListener)objectArray[i + 1]).nodeCheckChanged(nodeCheckChangeEvent);
        }
    }

    public static TreeNode getAllUnCheckedNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell) {
            return FilterTreeTemplate.unCheckedTreeNode(defaultMutableTreeNode);
        }
        return null;
    }

    public static DefaultMutableTreeNode unCheckedTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        TreeNode treeNode = null;
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell && ((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getState() != 1) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                Object object;
                treeNode = enumeration.nextElement();
                if (!(treeNode instanceof DefaultMutableTreeNode) || !((object = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof FilterTreeCell) || ((FilterTreeCell)object).getState() == 1 || (defaultMutableTreeNode3 = FilterTreeTemplate.unCheckedTreeNode((DefaultMutableTreeNode)treeNode)) == null) continue;
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        return defaultMutableTreeNode2;
    }

    public static TreeNode getAllCheckedNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell) {
            return FilterTreeTemplate.checkedTreeNode(defaultMutableTreeNode);
        }
        return null;
    }

    public static DefaultMutableTreeNode checkedTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell && ((FilterTreeCell)defaultMutableTreeNode.getUserObject()).getState() != 0) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                Object object;
                TreeNode treeNode = enumeration.nextElement();
                if (!(treeNode instanceof DefaultMutableTreeNode) || !((object = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof FilterTreeCell) || ((FilterTreeCell)object).getState() == 0 || (defaultMutableTreeNode3 = FilterTreeTemplate.checkedTreeNode((DefaultMutableTreeNode)treeNode)) == null) continue;
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        return defaultMutableTreeNode2;
    }

    public TreeNode getAllUnCheckedNodes() {
        return FilterTreeTemplate.getAllUnCheckedNodes((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    public TreeNode getAllCheckedNodes() {
        return FilterTreeTemplate.getAllCheckedNodes((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    public void setNoneSelectIcon(Icon icon) {
        this.cellRenderer.setNoneSelectIcon(icon);
    }

    public void setAllSelectIcon(Icon icon) {
        this.cellRenderer.setAllSelectIcon(icon);
    }

    public void setPartSelectIcon(Icon icon) {
        this.cellRenderer.setPartSelectIcon(icon);
    }

    public void setUncheckableLeafIcon(Icon icon) {
        this.cellRenderer.setLeafIcon(icon);
    }

    public void setUncheckableOpenedIcon(Icon icon) {
        this.cellRenderer.setOpenIcon(icon);
    }

    public void setUncheckableClosedIcon(Icon icon) {
        this.cellRenderer.setClosedIcon(icon);
    }

    public void setKeyDefaultAction(KeyStroke keyStroke, Object object, Action action) {
        this.getInputMap().put(keyStroke, object);
        this.getActionMap().put(object, action);
    }

    public void setMultiSelectable(boolean bl) {
        this.multiSelectable = bl;
    }

    public void setLinkageFlag(boolean bl) {
        this.linkageFlag = bl;
    }

    public boolean getMultiSelectable() {
        return this.multiSelectable;
    }

    public boolean isLinkageFlag() {
        return this.linkageFlag;
    }

    public void setNodeEditable(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        FilterTreeCell filterTreeCell;
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell && (filterTreeCell = (FilterTreeCell)defaultMutableTreeNode.getUserObject()).isEditable() != bl) {
            filterTreeCell.setEditable(bl);
            this.validate();
            this.repaint();
        }
    }

    public boolean getNodeEditable(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof FilterTreeCell) {
            FilterTreeCell filterTreeCell = (FilterTreeCell)defaultMutableTreeNode.getUserObject();
            return filterTreeCell.isEditable();
        }
        return false;
    }

    public void setNotifyPolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("policy must be one of the 'NOTIFY_SUPERIOR_NODE' or 'NOTIFY_PARENT_NODE'.");
        }
        this.notifyPolicy = n;
    }

    public int getNotifyPolicy() {
        return this.notifyPolicy;
    }
}

