/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertree;

import com.swimap.iview.templates.filtertree.FilterTreeCell;
import com.swimap.iview.templates.filtertree.FilterTreeTemplate;
import com.swimap.iview.templates.filtertree.FilterTreeTemplateEx;
import com.swimap.iview.templates.tree.ITreeEventHandler;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterTreeEventHandler
implements ITreeEventHandler {
    private static final int COUNT_CAN_NOT_REACH = 1000;
    private FilterTreeTemplate eventHandlerOwner = null;
    private static final int DEFAULT_ROW_HIGHT = 20;
    private static final int NODE_NOT_CRITERION = 3;
    private int oriClickCount = 0;

    public FilterTreeEventHandler(FilterTreeTemplate filterTreeTemplate) {
        this.setHandlerOwner(filterTreeTemplate);
    }

    private void setHandlerOwner(FilterTreeTemplate filterTreeTemplate) {
        this.eventHandlerOwner = filterTreeTemplate;
        this.oriClickCount = this.eventHandlerOwner.getToggleClickCount();
    }

    @Override
    public void keyAction(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            if (!this.eventHandlerOwner.isEnabled()) {
                return;
            }
            TreePath[] treePathArray = this.eventHandlerOwner.getSelectionPaths();
            this.setTreeNodetoggleSelection(treePathArray);
        }
    }

    @Override
    public void mousePressedAction(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.filterMousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseEnteredAction(MouseEvent mouseEvent) {
    }

    @Override
    public void treeWillExpandAction(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeSelectionAction(TreeSelectionEvent treeSelectionEvent) {
    }

    @Override
    public void mouseClickedAction(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleasedAction(MouseEvent mouseEvent) {
    }

    public void filterMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            return;
        }
        int n = this.eventHandlerOwner.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        int n2 = this.eventHandlerOwner.getRowForLocation(mouseEvent.getX() - 20, mouseEvent.getY());
        if (!this.eventHandlerOwner.isEnabled()) {
            return;
        }
        if (n == n2) {
            this.eventHandlerOwner.setToggleClickCount(this.oriClickCount);
            return;
        }
        this.eventHandlerOwner.setToggleClickCount(1000);
        if (mouseEvent.getClickCount() >= 2) {
            mouseEvent.consume();
            return;
        }
        TreePath[] treePathArray = new TreePath[]{this.eventHandlerOwner.getPathForRow(n)};
        this.setTreeNodetoggleSelection(treePathArray);
    }

    public void setTreeNodetoggleSelection(TreePath[] treePathArray) {
        int n;
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        Vector<TreePath> vector = new Vector<TreePath>(10);
        for (n = 0; n < treePathArray.length; ++n) {
            if (treePathArray[n] == null) continue;
            vector.add(treePathArray[n]);
        }
        if (vector.size() < 1) {
            return;
        }
        n = 0;
        int n2 = 0;
        Object object = null;
        TreeNode treeNode = null;
        FilterTreeCell filterTreeCell = null;
        vector.toArray(treePathArray);
        n = this.getMultNodeState(treePathArray, n);
        for (int i = 0; i < treePathArray.length; ++i) {
            boolean bl = true;
            if (this.eventHandlerOwner.getNotifyPolicy() == 0) {
                bl = !vector.contains(treePathArray[i].getParentPath());
            } else if (this.eventHandlerOwner.getNotifyPolicy() == 1) {
                boolean bl2 = bl = !this.containParent(vector, treePathArray[i]);
            }
            if (!bl && !(this.eventHandlerOwner instanceof FilterTreeTemplateEx) || !((treeNode = (TreeNode)treePathArray[i].getLastPathComponent()) instanceof DefaultMutableTreeNode) || !((object = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof FilterTreeCell)) continue;
            filterTreeCell = (FilterTreeCell)object;
            if (!filterTreeCell.isEditable()) {
                return;
            }
            if (filterTreeCell.isHideCheckbox()) continue;
            n2 = filterTreeCell.getState();
            if (n == 3) {
                filterTreeCell.changeState();
            } else {
                filterTreeCell.changeState(n);
            }
            if (!(this.eventHandlerOwner instanceof FilterTreeTemplateEx)) {
                FilterTreeTemplate.refreshDown((DefaultMutableTreeNode)treeNode, filterTreeCell.getState(), 1);
                FilterTreeTemplate.refreshUp((DefaultMutableTreeNode)treeNode);
            }
            this.eventHandlerOwner.fireNodeCheckChanged(treePathArray[i], filterTreeCell, filterTreeCell.getState(), n2);
        }
        this.eventHandlerOwner.validate();
        this.eventHandlerOwner.repaint();
    }

    private boolean containParent(Vector vector, TreePath treePath) {
        for (TreePath treePath2 = treePath.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
            if (!vector.contains(treePath2)) continue;
            return true;
        }
        return false;
    }

    private int getNodeState(TreeNode treeNode) {
        FilterTreeCell filterTreeCell;
        Object object;
        if (treeNode instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof FilterTreeCell && (filterTreeCell = (FilterTreeCell)object).isEditable() && !filterTreeCell.isHideCheckbox()) {
            return filterTreeCell.getState();
        }
        return 3;
    }

    private int getMultNodeState(TreePath[] treePathArray, int n) {
        TreeNode treeNode = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            treeNode = (TreeNode)treePathArray[i].getLastPathComponent();
            if (n == this.getNodeState(treeNode)) continue;
            return n;
        }
        if (n == 2 || n == 1) {
            n = 0;
        } else if (n == 0) {
            n = 1;
        }
        return n;
    }
}

