/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertree;

import com.swimap.iview.templates.filtertree.FilterTreeCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FilterTreeCellRenderer
extends DefaultTreeCellRenderer {
    private JCheckBox checkBox = new JCheckBox();
    private JLabel label = new JLabel();
    private JLabel labelForUserIcon = new JLabel();
    private JPanel panel = new JPanel();
    private Icon noneSelectIcon = this.createImageIcon("none.gif");
    private Icon allSelectIcon = this.createImageIcon("all.gif");
    private Icon partSelectIcon = this.createImageIcon("part.gif");
    private Icon noneSelectIcon_notEditable = this.createImageIcon("none_n.gif");
    private Icon allSelectIcon_notEditable = this.createImageIcon("all_n.gif");
    private Icon partSelectIcon_notEditable = this.createImageIcon("part_n.gif");
    protected Icon closedIcon = this.createImageIcon("closed.gif");
    protected Icon leafIcon = this.createImageIcon("leaf.gif");
    protected Icon openedIcon = this.createImageIcon("opened.gif");
    protected Insets in = new Insets(0, 0, 0, 3);

    public FilterTreeCellRenderer() {
        this.setLeafIcon(this.leafIcon);
        this.setClosedIcon(this.closedIcon);
        this.setOpenIcon(this.openedIcon);
        this.panel.setLayout(new FlowLayout(0, 0, 0));
        this.panel.setBackground(this.getBackgroundNonSelectionColor());
        this.checkBox.setPreferredSize(new Dimension(20, 20));
        this.checkBox.setBorderPainted(false);
        this.checkBox.setBackground(this.getBackgroundNonSelectionColor());
        this.labelForUserIcon.setOpaque(true);
        this.labelForUserIcon.setBackground(this.getBackgroundNonSelectionColor());
        this.label.setOpaque(true);
        this.label.setBackground(this.getBackgroundNonSelectionColor());
        this.panel.setBackground(this.getBackgroundNonSelectionColor());
        this.panel.add(this.checkBox);
        this.panel.add(this.labelForUserIcon);
        this.panel.add(this.label);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof FilterTreeCell) {
            Component component;
            FilterTreeCell filterTreeCell = (FilterTreeCell)object2;
            this.label.setText(filterTreeCell.getFilterObject() == null ? "" : filterTreeCell.getFilterObject().toString());
            int n2 = filterTreeCell.getState();
            Icon icon = filterTreeCell.getUserIcon(bl2, bl3, jTree.isEnabled());
            this.labelForUserIcon.setIcon(icon);
            if (null != this.labelForUserIcon.getIcon()) {
                this.labelForUserIcon.setBorder(BorderFactory.createEmptyBorder(this.in.top, this.in.left, this.in.bottom, this.in.right));
            } else {
                this.labelForUserIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            }
            switch (n2) {
                case 0: {
                    this.checkBox.setSelected(false);
                    if (filterTreeCell.isEditable()) {
                        this.checkBox.setIcon(this.noneSelectIcon);
                        break;
                    }
                    this.checkBox.setIcon(this.noneSelectIcon_notEditable);
                    break;
                }
                case 2: {
                    this.checkBox.setSelected(false);
                    if (filterTreeCell.isEditable()) {
                        this.checkBox.setIcon(this.partSelectIcon);
                        break;
                    }
                    this.checkBox.setIcon(this.partSelectIcon_notEditable);
                    break;
                }
                case 1: {
                    this.checkBox.setSelected(true);
                    if (filterTreeCell.isEditable()) {
                        this.checkBox.setIcon(this.allSelectIcon);
                        break;
                    }
                    this.checkBox.setIcon(this.allSelectIcon_notEditable);
                    break;
                }
            }
            this.label.setEnabled(jTree.isEnabled());
            if (!bl) {
                bl = filterTreeCell.getSelectedState();
            }
            this.setCellColor(filterTreeCell, bl);
            this.panel.setToolTipText(filterTreeCell.getToolTipText());
            int n3 = this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
            int n4 = 20;
            if (null != icon) {
                n4 = Math.max(20, icon.getIconHeight());
            }
            this.label.setPreferredSize(new Dimension(n3, n4));
            if (!filterTreeCell.isHideCheckbox()) {
                return this.panel;
            }
            if (filterTreeCell.getUncheckableLeafIcon() != null) {
                this.setLeafIcon(filterTreeCell.getUncheckableLeafIcon());
            }
            if (filterTreeCell.getUncheckableOpenedIcon() != null) {
                this.setOpenIcon(filterTreeCell.getUncheckableOpenedIcon());
            }
            if (filterTreeCell.getUncheckableClosedIcon() != null) {
                this.setClosedIcon(filterTreeCell.getUncheckableClosedIcon());
            }
            if ((component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4)) instanceof JLabel) {
                ((JLabel)component).setToolTipText(filterTreeCell.getToolTipText());
            }
            return component;
        }
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public void setNoneSelectIcon(Icon icon) {
        this.noneSelectIcon = icon;
    }

    public void setAllSelectIcon(Icon icon) {
        this.allSelectIcon = icon;
    }

    public void setPartSelectIcon(Icon icon) {
        this.partSelectIcon = icon;
    }

    private void setCellColor(FilterTreeCell filterTreeCell, boolean bl) {
        if (bl) {
            this.label.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.label.setBackground(this.getBackgroundNonSelectionColor());
        }
        if (!filterTreeCell.isEditable()) {
            this.label.setForeground(Color.gray);
        } else if (bl) {
            if (filterTreeCell.getSelectionForeColor() != null) {
                this.label.setForeground(filterTreeCell.getSelectionForeColor());
            } else {
                this.label.setForeground(this.getTextSelectionColor());
            }
        } else if (filterTreeCell.getForeColor() != null) {
            this.label.setForeground(filterTreeCell.getForeColor());
        } else {
            this.label.setForeground(this.getTextNonSelectionColor());
        }
    }

    private ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            uRL = FilterTreeCellRenderer.class.getResource(string);
        }
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        return null;
    }
}

