/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.filtertree;

import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import javax.swing.Icon;

public class FilterTreeCell
implements Cloneable {
    private static IviewLogger logger = IviewLogger.getLogger(FilterTreeCell.class, "IVIEW");
    public static final int NONE_SELECT = 0;
    public static final int ALL_SELECT = 1;
    public static final int PART_SELECT = 2;
    private int iState = 0;
    private boolean bSelectedState = false;
    private boolean bHideCheckbox = false;
    private Object filterObject = null;
    private String toolTipText = null;
    private Icon uncheckableLeafIcon = null;
    private Icon uncheckableOpenedIcon = null;
    private Icon uncheckableClosedIcon = null;
    private boolean bChildrenSingleSelect = false;
    private Color foreColor = null;
    private Color selectionForeColor = null;
    private boolean isEditable = true;

    public void setHideCheckbox(boolean bl) {
        this.bHideCheckbox = bl;
    }

    public boolean isHideCheckbox() {
        return this.bHideCheckbox;
    }

    public FilterTreeCell(Object object, int n, boolean bl, boolean bl2, boolean bl3, String string) {
        this(object, n, bl, bl2, bl3, string, null);
    }

    public FilterTreeCell(Object object, int n, boolean bl, boolean bl2, boolean bl3, String string, Color color) {
        this.iState = n;
        this.filterObject = object;
        this.setHideCheckbox(bl);
        this.setRadio(bl2);
        this.isEditable = bl3;
        this.toolTipText = string;
        this.foreColor = color;
    }

    public FilterTreeCell(Object object, int n, boolean bl, boolean bl2, boolean bl3) {
        this(object, n, bl, bl2, bl3, null);
    }

    public FilterTreeCell(Object object, int n, boolean bl, boolean bl2) {
        this(object, n, bl, bl2, true);
    }

    public FilterTreeCell(Object object, int n, boolean bl) {
        this(object, n, bl, false, true);
    }

    public FilterTreeCell(Object object, int n) {
        this(object, n, false, false, true);
    }

    public FilterTreeCell(Object object) {
        this(object, 0, false, false, true);
    }

    public FilterTreeCell() {
        this("", 0, false, false, true);
    }

    public void setForeColor(Color color) {
        if (color != null) {
            this.foreColor = color;
        }
    }

    public void setSelectionForeColor(Color color) {
        if (color != null) {
            this.selectionForeColor = color;
        }
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getSelectionForeColor() {
        return this.selectionForeColor;
    }

    public void setRadio(boolean bl) {
        this.bChildrenSingleSelect = bl;
    }

    public boolean isRadio() {
        return this.bChildrenSingleSelect;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(Object object) {
        this.filterObject = object;
    }

    public String toString() {
        return this.filterObject.toString();
    }

    public void changeState() {
        if (this.iState == 2 || this.iState == 1) {
            this.changeState(0);
        } else if (0 == this.iState) {
            this.changeState(1);
        }
    }

    public void changeState(int n) {
        if (this.iState == n) {
            return;
        }
        this.iState = n;
        this.processChange();
    }

    public void processChange() {
    }

    public int getState() {
        return this.iState;
    }

    public void setSelectedState(boolean bl) {
        this.bSelectedState = bl;
    }

    public boolean getSelectedState() {
        return this.bSelectedState;
    }

    public void fireStateChanged() {
    }

    public Object clone() {
        FilterTreeCell filterTreeCell = null;
        try {
            filterTreeCell = (FilterTreeCell)super.clone();
            filterTreeCell.changeState(this.getState());
            filterTreeCell.setHideCheckbox(this.isHideCheckbox());
            filterTreeCell.setRadio(this.isRadio());
            filterTreeCell.setEditable(this.isEditable());
            filterTreeCell.setToolTipText(this.toolTipText);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return filterTreeCell;
    }

    public Icon getUncheckableLeafIcon() {
        return this.uncheckableLeafIcon;
    }

    public void setUncheckableLeafIcon(Icon icon) {
        this.uncheckableLeafIcon = icon;
    }

    public Icon getUncheckableOpenedIcon() {
        return this.uncheckableOpenedIcon;
    }

    public void setUncheckableOpenedIcon(Icon icon) {
        this.uncheckableOpenedIcon = icon;
    }

    public Icon getUncheckableClosedIcon() {
        return this.uncheckableClosedIcon;
    }

    public void setUncheckableClosedIcon(Icon icon) {
        this.uncheckableClosedIcon = icon;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    protected Icon getUserIcon(boolean bl, boolean bl2, boolean bl3) {
        return null;
    }
}

