/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean bSameRowHeight = false;
    private static final String PROP_TABLE_ROW_HEIGHT = "_table_row_height_";
    private static final int DEFAULT_HEIGHT = 22;
    private FontMetrics fontMetrics = null;
    private int rowHeight = 0;
    private boolean showToolTip = false;
    private Color unselectedForeground = null;
    private Color unselectedBackground = null;

    public TextAreaCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        String string = System.getProperty("java.version");
        if (string.indexOf("1.5") != -1 || string.indexOf("1.4") != -1) {
            this.getDocument().putProperty("i18n", Boolean.TRUE);
        }
    }

    public void setShowToolTip(boolean bl) {
        this.showToolTip = bl;
    }

    public void setSameRowHeight(boolean bl) {
        this.bSameRowHeight = bl;
    }

    public boolean isSameRowHeight() {
        return this.bSameRowHeight;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.invalidate();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        if (this.showToolTip) {
            if (object == null || object.toString().length() == 0) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(object.toString());
            }
        }
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setValue(object);
        if (this.fontMetrics == null) {
            this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(jTable.getFont());
            this.rowHeight = this.fontMetrics.getHeight();
        }
        int n3 = jTable.getColumnModel().getColumn(n2).getWidth() - 3;
        int n4 = this.getPreferredHeight(object == null ? "" : object.toString(), n3);
        HashMap<RowColumn, Integer> hashMap = (HashMap<RowColumn, Integer>)jTable.getClientProperty(PROP_TABLE_ROW_HEIGHT);
        if (hashMap == null) {
            hashMap = new HashMap<RowColumn, Integer>(10);
            jTable.putClientProperty(PROP_TABLE_ROW_HEIGHT, hashMap);
        }
        hashMap.put(new RowColumn(n, n2), n4);
        int n5 = jTable.getRowHeight(n);
        int n6 = 22;
        for (int i = jTable.getColumnCount() - 1; i >= 0; --i) {
            Object v = hashMap.get(new RowColumn(n, i));
            if (v == null) continue;
            n6 = Math.max(n6, (Integer)v);
        }
        if (n6 != n5) {
            if (this.bSameRowHeight) {
                jTable.setRowHeight(n6);
            } else {
                jTable.setRowHeight(n, n6);
            }
        }
        boolean bl3 = (color = this.getBackground()) != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
        this.setOpaque(!bl3);
        return this;
    }

    private int getPreferredHeight(String string, int n) {
        string = string.replaceAll("\r", "");
        int n2 = 0;
        while (string.indexOf("\n\n") != -1) {
            string = string.replaceFirst("\n\n", "\n");
            ++n2;
        }
        if (string.startsWith("\n")) {
            ++n2;
        }
        if (string.endsWith("\n")) {
            ++n2;
        }
        int n3 = this.fontMetrics.stringWidth("-");
        int n4 = 0;
        if (n < n3) {
            n = n3;
        }
        n4 = n3 <= 0 ? 1 : n / n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n5 = this.fontMetrics.stringWidth(string2);
            while (n5 > n && string2.length() > 1) {
                int n6;
                int n7;
                int n8 = string2.length() > n4 ? n4 : 0;
                int n9 = 0;
                boolean bl = false;
                for (n7 = this.fontMetrics.stringWidth(string2.substring(0, n8 + n9)); n7 > n && n8 + n9 > 1; n7 -= this.fontMetrics.charWidth(string2.charAt(n8 + --n9))) {
                    bl = true;
                }
                if (!bl) {
                    n9 = 0;
                    while (n7 < n) {
                        n7 += this.fontMetrics.charWidth(string2.charAt(n8 + n9));
                        ++n9;
                    }
                }
                if (n7 > n && n8 + n9 > 1) {
                    n7 -= this.fontMetrics.charWidth(string2.charAt(n8 + --n9));
                }
                ++n2;
                if (string2.charAt(n8 + n9) != ' ' && (n6 = string2.substring(0, n8 + n9).lastIndexOf(" ")) != -1) {
                    n5 -= this.fontMetrics.stringWidth(string2.substring(0, n6 + 1));
                    string2 = string2.substring(n6 + 1);
                    continue;
                }
                string2 = string2.substring(n8 + n9);
                n5 -= n7;
            }
            if (string2.length() <= 0) continue;
            ++n2;
        }
        return (n2 > 0 ? n2 : 1) * this.rowHeight;
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    private class RowColumn {
        private int row = -1;
        private int column = -1;

        public RowColumn(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int hashCode() {
            return this.row * this.column;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RowColumn)) {
                return false;
            }
            RowColumn rowColumn = (RowColumn)object;
            return this.row == rowColumn.row && this.column == rowColumn.column;
        }
    }
}

