/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.extendedtable.BasicImplementation;
import com.swimap.iview.templates.extendedtable.ICustomObject;
import com.swimap.iview.templates.extendedtable.ObjectCreator;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.log.IviewLogger;
import java.text.Collator;
import java.util.Date;

public class TableSorter {
    private static IviewLogger logger = IviewLogger.getLogger(TableSorter.class, "IVIEW");
    private SortableTableModel model = null;
    private int unSortRows = 0;
    private int lastUnSortRows = 0;
    private static Collator myCollator = Collator.getInstance(ResourceMng.getInstance().getLocale());

    public TableSorter(SortableTableModel sortableTableModel) {
        this.model = sortableTableModel;
    }

    public void sort(int n, boolean bl) {
        int n2 = this.model.getRowCount();
        int n3 = this.getValidateRowNum(this.unSortRows);
        int n4 = this.getValidateRowNum(n2 - this.lastUnSortRows - 1);
        if (n4 <= n3) {
            return;
        }
        this.sortArithmatic(n, bl, n3, n4);
    }

    private void sortArithmatic(int n, boolean bl, int n2, int n3) {
        int[] nArray = this.model.getIndexes();
        for (int i = n2 + 1; i <= n3; ++i) {
            int n4;
            int n5 = n2;
            int n6 = i;
            while (n5 < n6) {
                n4 = (n5 + n6) / 2;
                if (bl) {
                    if (this.compareRowsByColumn(i, n4, n) <= 0) {
                        n5 = n4 + 1;
                        continue;
                    }
                    n6 = n4;
                    continue;
                }
                if (this.compareRowsByColumn(i, n4, n) >= 0) {
                    n5 = n4 + 1;
                    continue;
                }
                n6 = n4;
            }
            for (n4 = i; n4 > n5; --n4) {
                int n7 = nArray[n4 - 1];
                nArray[n4 - 1] = nArray[n4];
                nArray[n4] = n7;
            }
        }
    }

    private int compareRowsByColumn(int n, int n2, int n3) {
        try {
            Object object = this.model.getValueAt(n, n3);
            Object object2 = this.model.getValueAt(n2, n3);
            return TableSorter.compareTwoValues(object, object2);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return 0;
        }
    }

    public static int compareTwoValues(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Number && object2 instanceof Number) {
            Number number;
            double d;
            Number number2 = (Number)object;
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)object2).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Date && object2 instanceof Date) {
            Date date;
            long l;
            Date date2 = (Date)object;
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)object2).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            myCollator.setStrength(1);
            int n = myCollator.compare(string, string2);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)object;
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        if (object instanceof Comparable && object.getClass() == object2.getClass()) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2);
        }
        if (object2 instanceof Comparable && object.getClass() != object2.getClass()) {
            try {
                Object object3 = null;
                Object object4 = null;
                if (object.getClass().equals(String.class)) {
                    object3 = ObjectCreator.getImpl(object2.getClass());
                    if (object3 != null && object3 instanceof BasicImplementation) {
                        ((BasicImplementation)object3).setKeyImpl(object2);
                        object4 = ((BasicImplementation)object3).getObject((String)object);
                        return TableSorter.compareTwoValues(object4, object2);
                    }
                    object4 = ((ICustomObject)object3).getObject((String)object);
                }
                Comparable comparable = (Comparable)object4;
                return comparable.compareTo(object2);
            }
            catch (Exception exception) {
                String string = object.toString();
                String string3 = object2.toString();
                myCollator.setStrength(1);
                int n = myCollator.compare(string, string3);
                if (n < 0) {
                    return -1;
                }
                if (n > 0) {
                    return 1;
                }
                return 0;
            }
        }
        String string = object.toString();
        String string4 = object2.toString();
        myCollator.setStrength(1);
        int n = myCollator.compare(string, string4);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    protected void setUnSortRows(int n) {
        this.unSortRows = n;
    }

    protected void setLastUnSortRows(int n) {
        this.lastUnSortRows = n;
    }

    private int getValidateRowNum(int n) {
        int n2 = n;
        int n3 = this.model.getRowCount();
        n2 = Math.max(0, n2);
        n2 = Math.min(n2, n3 - 1);
        return n2;
    }
}

