/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.extendedtable.TableSorter;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;

final class TableFilterAdapter {
    private static final int INITIAL_CAPACITY = 16;
    private Vector<Vector<Object>> backupDataVector = new Vector(16);
    private final SortableTableModel model;
    private FilterElement previousFilter = null;
    private static final int MAX_COL_VALUE_COUNT = 500;

    TableFilterAdapter(SortableTableModel sortableTableModel) {
        this.model = sortableTableModel;
    }

    public void filterDataVector(FilterElement filterElement) {
        this.previousFilter = filterElement;
        this.applyFilterOnDataVector(filterElement);
    }

    public void applyFilterOnDataVector(FilterElement filterElement) {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(16);
        Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>(16);
        Vector<Vector> vector3 = this.model.getDataVector();
        boolean bl = false;
        Vector<Object> vector4 = null;
        int n = vector3.size();
        while (n > 0) {
            vector4 = vector3.remove(0);
            bl = this.isFilterSatisfied(vector4, filterElement);
            if (bl) {
                vector.add(vector4);
            } else {
                vector2.add(vector4);
            }
            n = vector3.size();
        }
        if (this.backupDataVector != null) {
            n = this.backupDataVector.size();
            while (n > 0) {
                vector4 = this.backupDataVector.remove(0);
                bl = this.isFilterSatisfied(vector4, filterElement);
                if (bl) {
                    vector.add(vector4);
                } else {
                    vector2.add(vector4);
                }
                n = this.backupDataVector.size();
            }
        }
        this.backupDataVector = vector2;
        this.model.setFilteredDataVector(vector);
    }

    private boolean isFilterSatisfied(Vector<Object> vector, FilterElement filterElement) {
        if (null == filterElement) {
            return true;
        }
        if (filterElement.isCondition()) {
            return this.evaluateCond(filterElement, vector);
        }
        if (filterElement.getChildCount() > 0) {
            boolean bl = this.isFilterSatisfied(vector, filterElement.getChildAt(0));
            int n = filterElement.getChildCount();
            for (int i = 1; i < n; ++i) {
                bl = this.evaluateGroupCond(filterElement.getGroupOperator(), bl, this.isFilterSatisfied(vector, filterElement.getChildAt(i)));
            }
            return bl;
        }
        return true;
    }

    private boolean evaluateGroupCond(Operators.GroupOperator groupOperator, boolean bl, boolean bl2) {
        switch (groupOperator) {
            case GROUP_OP_AND: {
                return bl && bl2;
            }
            case GROUP_OP_OR: {
                return bl || bl2;
            }
        }
        return false;
    }

    private boolean evaluateCond(FilterElement filterElement, Vector<?> vector) {
        int n = filterElement.getColumnIndex();
        Object object = filterElement.getCondValue();
        Object obj = vector.get(n);
        int n2 = 0;
        Operators.Operator operator = filterElement.getCondOperator();
        switch (operator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_EQUALS: {
                n2 = TableSorter.compareTwoValues(object, obj);
                return this.evaluateComparisonCond(operator, n2);
            }
        }
        switch (operator) {
            case BEGINS_WITH: {
                return obj.toString().toUpperCase().startsWith(object.toString().toUpperCase());
            }
            case NOT_BEGINS_WITH: {
                return !obj.toString().toUpperCase().startsWith(object.toString().toUpperCase());
            }
            case ENDS_WITH: {
                return obj.toString().toUpperCase().endsWith(object.toString().toUpperCase());
            }
            case NOT_ENDS_WITH: {
                return !obj.toString().toUpperCase().endsWith(object.toString().toUpperCase());
            }
            case CONTAINS: {
                return obj.toString().toUpperCase().contains(object.toString().toUpperCase());
            }
            case NOT_CONTAINS: {
                return !obj.toString().toUpperCase().contains(object.toString().toUpperCase());
            }
            case EXIST_IN: {
                if (!(object instanceof Object[])) break;
                return this.isValueExistIn((Object[])object, obj);
            }
            case NOT_EXIST_IN: {
                if (!(object instanceof Object[])) break;
                return !this.isValueExistIn((Object[])object, obj);
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean evaluateComparisonCond(Operators.Operator operator, int n) {
        switch (operator) {
            case EQUALS: {
                return n == 0;
            }
            case NOT_EQUALS: {
                return n != 0;
            }
            case GREATER_THAN: {
                return n < 0;
            }
            case GREATER_THAN_EQUALS: {
                return n <= 0;
            }
            case LESS_THAN: {
                return n > 0;
            }
            case LESS_THAN_EQUALS: {
                return n >= 0;
            }
        }
        return false;
    }

    private boolean isValueExistIn(Object[] objectArray, Object object) {
        for (Object object2 : objectArray) {
            if (TableSorter.compareTwoValues(object2, object) != 0) continue;
            return true;
        }
        return false;
    }

    public Collection<Object> getFilterColumnValues(int n) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new ColumnValueComparator());
        int n2 = this.model.getRowCount();
        for (int i = 0; i < n2; ++i) {
            treeSet.add(this.model.getValueAt(i, n));
            if (treeSet.size() == 500) break;
        }
        return treeSet;
    }

    public Vector<Vector<Object>> getBackupDataVector() {
        return this.backupDataVector;
    }

    private static class ColumnValueComparator
    implements Comparator<Object> {
        private ColumnValueComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return TableSorter.compareTwoValues(object, object2);
        }
    }
}

